/*
    GQ -- a GTK-based LDAP client
    Copyright (C) 1998-2001 Bert Vermeulen

    This program is released under the Gnu General Public License with
    the additional exemption that compiling, linking, and/or using
    OpenSSL is allowed.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <signal.h>

#ifdef MEMDEBUG
#  include "debug.h"
#  ifdef HAVE_MCHECK
#    include <mcheck.h>
#  endif /* HAVE_MCHECK */
#endif /* MEMDEBUG */

#include <gtk/gtk.h>

#include <string.h>

#include "gq.h"
#include "i18n.h"
#include "mainwin.h"
#include "configfile.h"
#include "syntax.h"
#include "encode.h"

GdkFont *big_fixed;
static void sigpipehandler(int sig);

int main(int argc, char *argv[])
{
#ifdef MEMDEBUG
#  ifdef HAVE_MCHECK
     mcheck(NULL);
#  endif /* HAVE_MCHECK */
#endif /* MEMDEBUG */

#if ENABLE_NLS
     setlocale(LC_ALL, "");
     textdomain(PACKAGE);

#  if HAVE_LANGINFO_CODESET
     {
	  char *codeset = nl_langinfo(CODESET);
	  if (codeset) {
	       /* PS: rule out ANSI* explicitly - I hope this is
		  generically enough */
	       if (strncmp(codeset, "ANSI", 4) != 0) {
		    /* nl_langinfo uses a static buffer - thus duplicate the 
		       codeset to use before it gets overwritten */
		    gq_codeset = g_strdup(codeset);
	       }
	  }
     }
#  endif /* HAVE_LANGINFO_CODESET */
#endif

     bindtextdomain(PACKAGE, LOCALEDIR);
     /* I think the following will be required for gtk 2 (Isn't UTF-8
        the standard for widget texts there? - this will allow to have
        the messages in UTF-8) */
/*       bind_textdomain_codeset(PACKAGE, LDAP_CODESET); */

     gtk_set_locale();
     gtk_init(&argc, &argv);

     init_config();

     setup_fonts();
     create_mainwin();
     init_syntaxes();
     g_log_set_always_fatal (G_LOG_LEVEL_CRITICAL);

#ifdef MEMDEBUG
#  ifdef HAVE_MALLINFO
     init_memstat_timer();
#  endif /* HAVE_MALLINFO */
#endif /* MEMDEBUG */

     /* Avoids getting killed if an LDAP server we are connected to
        goes down (restarted?) I do not like this solution, as it is
        not very clean IMHO (though it has been proposed on the
        OpenLDAP mailing list) */
     signal(SIGPIPE, sigpipehandler);
     gtk_main ();

     gtk_exit(0);
     return(0);
}

static void sigpipehandler(int sig) 
{
     struct ldapserver *server;
     
/*       printf("Catched sigpipe\n"); */
     for(server = config.ldapservers ; server ; server = server->next) {
	  server->server_down++;
     }
     /* reinstall signal handler [make sure we work on BSD] */ 
     signal(SIGPIPE, sigpipehandler);
}

void setup_fonts(void)
{

     big_fixed = gdk_font_load(FONT_BIG_FIXED);

}

/* 
   Local Variables:
   c-basic-offset: 5
   End:
 */
