/*
    GQ -- a GTK-based LDAP client
    Copyright (C) 1998-2001 Bert Vermeulen

    This file (dt_entry.h) is
    Copyright (C) 2002 by Peter Stamfest and Bert Vermeulen

    This program is released under the Gnu General Public License with
    the additional exemption that compiling, linking, and/or using
    OpenSSL is allowed.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

/* $Id: dt_entry.h,v 1.4 2002/04/08 06:19:56 stamfest Exp $ */

#ifndef DT_ENTRY_H_INCLUDED
#define DT_ENTRY_H_INCLUDED

#include "formfill.h"
#include "syntax.h"


typedef struct _dt_entry_handler {
     display_type_handler dt_handler;

     GByteArray* (*encode)(const char *val, int len);
     GByteArray* (*decode)(const char *val, int len);
} dt_entry_handler;
#define DT_ENTRY(objpointer) ((dt_entry_handler*)(objpointer))

display_type_handler *dt_entry_get_handler();

/* Methods, only to be used by subclasses */
GtkWidget *dt_entry_get_widget(struct formfill *form, GByteArray *data,
			       GtkSignalFunc *activatefunc,
			       GHashTable *hash);
GByteArray *dt_entry_get_data(struct formfill *form, GtkWidget *widget);
void dt_entry_set_data(struct formfill *form, GByteArray *data,
		       GtkWidget *widget);

GByteArray *encode_utf8(const char *val, int len);
GByteArray *decode_utf8(const char *val, int len);

#endif

/* 
   Local Variables:
   c-basic-offset: 5
   End:
 */
