/*
    GQ -- a GTK-based LDAP client
    Copyright (C) 1998-2001 Bert Vermeulen

    This program is released under the Gnu General Public License with
    the additional exemption that compiling, linking, and/or using
    OpenSSL is allowed.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

/* $Id: mainwin.h,v 1.10 2002/06/13 10:03:33 stamfest Exp $ */

#ifndef GQ_MAINWIN_H_INCLUDED
#define GQ_MAINWIN_H_INCLUDED


#include "config.h"
#include <gtk/gtk.h>

#define PACKAGEVERSION  PACKAGE " " VERSION
#define about_blurb     "The gentleman's LDAP client" \
                        "\n\n(C) 1998-2002 Bert Vermeulen <bert@biot.com>" \
                        "\nand" \
                        "\n(C) 2002 Peter Stamfest <peter@stamfest.at>" \
			"\n\nhttp://biot.com/gq/"

#define SEARCH_MODE       1
#define BROWSE_MODE       2
#define SCHEMA_MODE       3

extern GList *tablist;
extern GtkWidget *mainwin;
extern GtkWidget *statusbar;

void fill_serverlist_combo(GtkWidget *combo);
void cleanup(void);
void gq_exit(GtkWidget *widget, gpointer *data);
void create_mainwin(void);
void new_modetab(int mode);
void switchpage_refocus(GtkNotebook *notebook, GtkNotebookPage *page,
			int pagenum, gpointer data);
void cleanup_all_tabs(void);
void close_current_tab(void);
void cleanup_tab(GHashTable *hash);
void update_serverlist(void);
void create_license_window(void);
void close_license_window(GtkWidget *widget);
GtkWidget *create_about_window(void);
gboolean ctrl_b_hack(GtkWidget *widget, GdkEventKey *event, gpointer obj);


#endif


/* 
   Local Variables:
   c-basic-offset: 5
   End:
 */
