/*
    GQ -- a GTK-based LDAP client
    Copyright (C) 1998-2001 Bert Vermeulen

    This program is released under the Gnu General Public License with
    the additional exemption that compiling, linking, and/or using
    OpenSSL is allowed.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

/* $Id: formfill.h,v 1.16 2002/06/11 21:15:25 stamfest Exp $ */

#ifndef GQ_FORMFILL_H_INLCUDED
#define GQ_FORMFILL_H_INLCUDED

#include <ldap_schema.h>

#include "config.h"		/* pull in HAVE_* defines */
#include "common.h"		

#define DISPLAYTYPE_DN          1
#define DISPLAYTYPE_ENTRY	2
#define DISPLAYTYPE_TEXT	3
#define DISPLAYTYPE_PASSWORD	4
#define DISPLAYTYPE_BINARY	5

#ifdef HAVE_PIXBUF
#  define DISPLAYTYPE_JPEG	6
#else  /* HAVE_PIXBUF */
#  define DISPLAYTYPE_JPEG	DISPLAYTYPE_BINARY
#endif  /* HAVE_PIXBUF */

#define DISPLAYTYPE_OC		7
#ifdef HAVE_LIBCRYPTO
#  define DISPLAYTYPE_CERT	8
#  define DISPLAYTYPE_CRL	9
#else 
#  define DISPLAYTYPE_CERT	DISPLAYTYPE_BINARY
#  define DISPLAYTYPE_CRL	DISPLAYTYPE_BINARY
#endif

#define FLAG_NOT_IN_SCHEMA      0x01
#define FLAG_MUST_IN_SCHEMA	0x02
/* The FLAG_DEL_ME is used to mark form entries not compatible with
   the schema of the object */
#define FLAG_DEL_ME		0x04
/* Used to suppress the "more" button for single valued attributes */
#define FLAG_SINGLE_VALUE	0x08

/* actually, we do not really need the following FLAG_* values, we
   only use them as tokens in dt_password.c right now */
#define FLAG_ENCODE_CRYPT	0x10
#define FLAG_ENCODE_MD5		0x20
#define FLAG_ENCODE_SHA		0x40
#define FLAG_ENCODE_SMD5	0x30
#define FLAG_ENCODE_SSHA	0x50

#define ENCODING_MASK           ( FLAG_ENCODE_CRYPT | FLAG_ENCODE_MD5 | FLAG_ENCODE_SHA )

/* forward decls to avoid circular inclusion problems */
struct _display_type_handler;
struct syntax_handler;

struct formfill {
     char attrname[MAX_ATTR_LEN];
     int num_inputfields;
     int displaytype;
     struct _display_type_handler *dt_handler;
     int flags;
     GList *values;
     struct syntax_handler *syntax;
     
     GtkWidget *label;
     GtkWidget *vbox;
     GtkWidget *morebutton;
     GList *widgetList;
};


struct formfill *new_formfill(void);
void free_formlist(GList *formlist);
void free_formfill(struct formfill *form);
void free_formfill_values(struct formfill *form);
GList *formlist_append(GList *formlist, struct formfill *form);
GList *formlist_from_entry(struct ldapserver *server, char *dn, int ocvalues_only);
GList *dup_formlist(GList *formlist);
void dump_hash(GHashTable *hash);
void dump_formlist(GList *formlist);
struct formfill *lookup_attribute(GList *formlist, char *attr);
struct formfill *lookup_attribute_using_schema(GList *formlist, char *attr,
					       struct server_schema *schema,
					       LDAPAttributeType **attrtype);
int find_displaytype(struct ldapserver *server, struct formfill *form);
void set_displaytype(struct ldapserver *server, struct formfill *form);

char *attr_strip(const char *attr);

#endif /* GQ_FORMFILL_H_INLCUDED */

/* 
   Local Variables:
   c-basic-offset: 5
   End:
 */
