/*
    GQ -- a GTK-based LDAP client
    Copyright (C) 1998-2001 Bert Vermeulen

    This file (dt_text.c) is
    Copyright (C) 2002 by Peter Stamfest and Bert Vermeulen

    This program is released under the Gnu General Public License with
    the additional exemption that compiling, linking, and/or using
    OpenSSL is allowed.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

/* $Id: dt_text.c,v 1.4 2002/04/08 06:19:56 stamfest Exp $ */

#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>

#include <glib.h>
#include <gdk/gdk.h>
#include <gtk/gtk.h>

#include <config.h>

#include "common.h"
#include "util.h"
#include "errorchain.h"
#include "formfill.h"
#include "input.h"
#include "tinput.h"
#include "browse.h"
#include "encode.h"
#include "ldif.h" /* for b64_decode */
#include "syntax.h"
#include "dt_text.h"

static dt_text_handler dt_text_handler_vtab = {
     {
	  dt_text_get_widget,
	  dt_entry_get_data,		/* reuse method from dt_entry */
	  dt_text_set_data,		
	  bervalLDAPMod			/* reuse method from dt_entry */
     },
     decode_utf8, /* encode method */	/* reuse method from dt_entry */
     encode_utf8, /* decode method */	/* reuse method from dt_entry */
};

display_type_handler *dt_text_get_handler() {
     return (display_type_handler *) &dt_text_handler_vtab;
}

GtkWidget *dt_text_get_widget(struct formfill *form, GByteArray *data,
			      GtkSignalFunc *activatefunc,
			      GHashTable *hash) 
{
    GtkWidget *inputbox;

    inputbox = gtk_text_new(NULL, NULL);
    gtk_text_set_editable(GTK_TEXT(inputbox), TRUE);
    if(data) {
	GByteArray *encoded = DT_TEXT(form->dt_handler)->encode(data->data, data->len);
	
	gtk_text_freeze(GTK_TEXT(inputbox));
	gtk_text_set_point(GTK_TEXT(inputbox), 0);
	gtk_text_insert(GTK_TEXT(inputbox), NULL, NULL, NULL, encoded->data, -1);
	gtk_text_thaw(GTK_TEXT(inputbox));
	
	g_byte_array_free(encoded, TRUE);
    }

    return inputbox;
}

void dt_text_set_data(struct formfill *form, GByteArray *data,
		      GtkWidget *widget) 
{
     gtk_text_freeze(GTK_TEXT(widget));
     gtk_text_set_point(GTK_TEXT(widget), 0);
     gtk_text_forward_delete(GTK_TEXT(widget), 
			     gtk_text_get_length(GTK_TEXT(widget)));
     if(data) {
	  GByteArray *encoded = DT_TEXT(form->dt_handler)->encode(data->data, data->len);
	  
	  gtk_text_set_point(GTK_TEXT(widget), 0);
	  gtk_text_insert(GTK_TEXT(widget), NULL, NULL, NULL,
			  encoded->data, -1);
	  
	  g_byte_array_free(encoded, TRUE);
     }
     gtk_text_thaw(GTK_TEXT(widget));
}

#if 0
GByteArray *dt_text_get_data(struct formfill *form, GtkWidget *widget) 
{
    GByteArray *copy;
    int l;

    gchar *content = gtk_editable_get_chars(GTK_EDITABLE(widget), 0, -1);
    if (!content) return NULL;

    l = strlen(content);
    if (l == 0) {
	g_free(content);
	return NULL;
    }

    copy = DT_TEXT(form->dt_handler)->decode(content, strlen(content));
    
    g_free(content);

    return copy;
}
#endif

/* 
   Local Variables:
   c-basic-offset: 5
   End:
 */
