/*
    GQ -- a GTK-based LDAP client
    Copyright (C) 1998-2001 Bert Vermeulen

    This program is released under the Gnu General Public License with
    the additional exemption that compiling, linking, and/or using
    OpenSSL is allowed.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

/* $Id: browse.h,v 1.19 2002/06/21 00:34:32 stamfest Exp $ */

#ifndef GQ_BROWSE_H_INCLUDED
#define GQ_BROWSE_H_INCLUDED

#include "common.h"

typedef struct _browse_entry browse_entry;

struct ldapserver *server_from_node(GtkCTree *ctreeroot, 
				    GtkCTreeNode *node);


/** Define an OO style object hierarchy for the payload data for CTree
    Nodes of the browsing tree. */

/* Callback types to avoid a lot of warnings when assigning to the
   virtual function table */
typedef void (*browse_entry_destructor)(browse_entry *entry);
typedef void (*browse_entry_expand)(browse_entry *entry,
				    GtkCTree *ctreeroot,
				    GtkCTreeNode *node,
				    GHashTable *hash);
typedef void (*browse_entry_select)(browse_entry *entry,
				    GtkCTree *ctreeroot,
				    GtkCTreeNode *node,
				    GHashTable *hash);
typedef void (*browse_entry_refresh)(browse_entry *entry,
				     GtkCTree *ctreeroot,
				     GtkCTreeNode *node,
				     GHashTable *hash);
typedef char* (*browse_entry_get_name)(browse_entry *entry,
				       gboolean long_form);

/* The basic object layout */
struct _browse_entry {
     /** runtime type identification information - every type must
         define a private integer variable this information points to */
     int *rtti_info;

     /* destructor */
     browse_entry_destructor	destroy;

     /* expansion callback of corresponding GtkCtreeNode */
     browse_entry_expand	expand;

     /* select callback of corresponding GtkCtreeNode */
     browse_entry_select	select;

     /* refresh callback of corresponding GtkCtreeNode */
     browse_entry_refresh	refresh;

     /* Gets the user visible name of the node, must be freed using g_free */
     browse_entry_get_name	get_name;
};

/*
 * A browse_entry describing a singe DN (eg. a single LDAP object)
 */

typedef struct {
     struct _browse_entry base_methods;
     char *dn;
     gboolean seen;
     gboolean leaf;
     gboolean uncache;
} dn_browse_entry;

extern int dn_browse_entry_rtti;

#define IS_DN_ENTRY(entry) (((entry) != NULL) && (((struct _browse_entry *)(entry))->rtti_info == &dn_browse_entry_rtti))





/* 
 * A browse_entry object describing a LDAP server
 */
typedef struct {
     struct _browse_entry base_methods;
     struct ldapserver *server;
     int once_expanded;
} server_browse_entry;

/* RTTI info variable */
extern int server_browse_entry_rtti;

#define IS_SERVER_ENTRY(entry) (((entry) != NULL) && (((struct _browse_entry *)(entry))->rtti_info == &server_browse_entry_rtti))


browse_entry *new_dn_browse_entry(const char *dn);
browse_entry *new_server_browse_entry(struct ldapserver *server);


/* get the server object for the current entry */
struct ldapserver *server_from_node(GtkCTree *ctreeroot, 
				    GtkCTreeNode *node);

void cleanup_browse_mode(GHashTable *hash);
void new_browsemode(GHashTable *hash);

void browsehash_free(GHashTable *browsehash);

void refresh_subtree(GtkCTree *ctree, 
		     GtkCTreeNode *node);

void refresh_subtree_new_dn(GtkCTree *ctree, 
			    GtkCTreeNode *node,
			    const char *newdn,
			    int options);

void refresh_subtree_with_options(GtkCTree *ctree,
				  GtkCTreeNode *node,
				  int options);

void refresh_server(GtkCTree *ctree, 
		    GtkCTreeNode *node);

void show_dn(GtkCTree *tree, GtkCTreeNode *node, char *dn);

GtkCTreeNode *node_from_dn(GtkCTree *ctreeroot, 
			   GtkCTreeNode *top,
			   char *dn);

/* options to the refresh_subtree_with_options functions */
/* NOTE: browse-dnd.h defines additional options starting at 256 */
#define REFRESH_FORCE_EXPAND	1
#define REFRESH_FORCE_UNEXPAND	2

GtkCTreeNode *tree_node_from_server_dn(GtkCTree *ctree, 
				       const struct ldapserver *server,
				       const char *dn);

#endif


/* 
   Local Variables:
   c-basic-offset: 5
   End:
 */
