/*
    GQ -- a GTK-based LDAP client
    Copyright (C) 1998-2001 Bert Vermeulen

    This program is released under the Gnu General Public License with
    the additional exemption that compiling, linking, and/or using
    OpenSSL is allowed.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/


#include <config.h>

#if defined(HAVE_LIBCRYPTO)

#include <stdio.h>
#include <string.h>
#include <time.h>

#include <openssl/rand.h>
#include <openssl/des.h>
#include <openssl/md5.h>
#include <openssl/sha.h>

#include <glib.h>
#include <gtk/gtk.h>

#include "common.h"
#include "util.h"
#include "formfill.h"
#include "ldif.h"
#include "encode.h"


extern struct tokenlist cryptmap[];


/*
 * iterate through the hash's formlist and find any password
 * entries that need an encoding applied (and apply it)
 */
void encode_password(GHashTable *hash)
{
     GList *formlist;
     struct formfill *form;
     char *password;

     formlist = g_hash_table_lookup(hash, "formlist");

     while(formlist) {
	  form = (struct formfill *) formlist->data;
	  if(form->displaytype == DISPLAYTYPE_PASSWORD && form->flags & ENCODING_MASK && form->values) {
	       password = form->values->data;
	       if(password[0] != '{') {
		    switch(form->flags & ENCODING_MASK) {
		    case FLAG_ENCODE_CRYPT:
			 encode_password_crypt(form);
			 break;
		    case FLAG_ENCODE_MD5:
			 encode_password_md5(form);
			 break;
		    case FLAG_ENCODE_SHA:
			 encode_password_sha1(form);
			 break;
		    default:

		    }
	       }

	  }

	  formlist = formlist->next;
     }

}


void encode_password_crypt(struct formfill *form)
{
     GString *salt;
     unsigned char *password, rand[16], password_out[64], *crypt_out;

     password = form->values->data;
     salt = g_string_sized_new(32);
     RAND_pseudo_bytes(rand, 8);
     b64_encode(salt, rand, 8);
     /* crypt(3) says [a-zA-Z0-9./] while base64 has [a-zA-Z0-9+/] */
     if(salt->str[0] == '+') salt->str[0] = '.';
     if(salt->str[1] == '+') salt->str[1] = '.';
     salt->str[2] = 0;
     crypt_out = des_crypt(password, salt->str);
     strcpy(password_out, "{crypt}");
     strncat(password_out, crypt_out, 63);
     g_string_free(salt, TRUE);
     password_out[63] = 0;
     g_free(form->values->data);
     form->values->data = g_strdup(password_out);

}


void encode_password_md5(struct formfill *form)
{
     int i;
     unsigned char *password, password_out[64], md5_out[MD5_DIGEST_LENGTH];

     password = form->values->data;
     MD5(password, strlen(password), md5_out);
     strcpy(password_out, "{md5}");
     for(i = 0; i < MD5_DIGEST_LENGTH; i++)
	  sprintf(password_out + strlen(password_out), "%.02x", md5_out[i]);
     g_free(form->values->data);
     form->values->data = g_strdup(password_out);

}


void encode_password_sha1(struct formfill *form)
{
     int i;
     unsigned char *password, password_out[64], sha1_out[SHA_DIGEST_LENGTH];

     password = form->values->data;
     SHA1(password, strlen(password), sha1_out);
     strcpy(password_out, "{sha}");
     for(i = 0; i < SHA_DIGEST_LENGTH; i++)
	  sprintf(password_out + strlen(password_out), "%.02x", sha1_out[i]);
     g_free(form->values->data);
     form->values->data = g_strdup(password_out);

}

#endif
