/*
    GQ -- a GTK-based LDAP client
    Copyright (C) 1998-2001 Bert Vermeulen

    This program is released under the Gnu General Public License with
    the additional exemption that compiling, linking, and/or using
    OpenSSL is allowed.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/


#include <lber.h>
#include <ldap.h>

#include <glib.h>

#define MAX_SERVERNAME_LEN    64
#define MAX_HOSTNAME_LEN      64

#define MAX_NUM_ATTRIBUTES   256
#define MAX_DN_LEN          1024
#define MAX_ATTR_LEN          64
#define MAX_BINDPW_LEN        32

#define DEFAULT_SHOWDN         1
#define DEFAULT_SHOWOC         1
#define DEFAULT_SHOW_RDN_ONLY  1

#define SEARCHARG_BEGINS_WITH    0
#define SEARCHARG_ENDS_WITH      1
#define SEARCHARG_CONTAINS       2
#define SEARCHARG_EQUALS         3

#define LDIF_UMICH               0
#define LDIF_V1                  1


struct server_schema {
     GList *oc;
     GList *at;
     GList *mr;
     GList *s;
};


#define SERVER_HAS_NO_SCHEMA     1

struct ldapserver {
     char name[MAX_SERVERNAME_LEN];
     char ldaphost[MAX_HOSTNAME_LEN];
     int ldapport;
     char basedn[MAX_DN_LEN];
     char binddn[MAX_DN_LEN];
     char bindpw[MAX_BINDPW_LEN];
     int bindtype;
     char searchattr[MAX_ATTR_LEN];
     int maxentries;
     int cacheconn;
     int enabletls;
     LDAP *connection;
     struct server_schema *ss;
     int flags;

     struct ldapserver *next;
};


struct tokenlist {
     int token;
     char keyword[32];
};


