.TH gone 1 "Version _VERSION_ for _OS_"
.SH NAME
gone \- a terminal locking utility with many improvements over lock
.SH SYNTAX
.B gone \fR[\fB\-v\fR] \fR[\fB-p\fR] \fR[\fB\-y|-n\fR] \fR[\fB\-t timeout\fR]\fR
.SH DESCRIPTION
\fBGone\fR is a utility that locks a terminal with a password chosen by
the user.  \fBGone\fR will prompt the user for a password, then print the \fBgone\fR banner, then drop into the \fBgone\fR shell.  From this shell, only a restricted set of commands can be run.  \fBGone\fR will also disallow messages by removing permissions on the parent tty.  After the timeout period (10 minutes by default), \fBgone\fR will automatically log the user out. 
.PP
If \fBgone\fR is installed setuid to root, then specifying the \fB-p\fR option
will instruct gone to read the password from the system password
file/database instead of prompting the user.  Setuid'ing the program is
done by seeting the environmental variable with_setuid to ``yes'' then
running configure.
.PP
.SH OPTIONS
The command line options are:
.PP
-v                  \fBGone\fR prints out the version
.br
                    number and exits
.PP
-p                  \fBGone\fR reads the password from the system
.br
                    password database (must be setuid root at install-time)
.PP
-y|-n               By default \fBgone\fR turns messages off 
.br
                    (see \fImesg\fR (1)).  These options will
.br                    
                    turn messages on.  The -n option is deprecated.
.PP
-t timeout          Specify an optional timeout value to
.br				    
                    \fBgone\fR in minutes.  Default is 10 minutes.
.br
                    If set to 0, gone will lock the terminal indefinitely.
.PP
\fBGone\fR also accepts an optional string that is visible by using the \fIw\fR (1) command.  Use this, and other users can see why you are gone.                    
.SH SHELL COMMANDS
Commands for the \fBgone\fR shell (these commands can be abbreviated):
.PP
\fBw\fR                    Invoke a UNIX \fIw\fR (1) command
.PP
\fBfinger\fR               Invoke a UNIX \fIfinger\fR (1) command
.br
                     When you type finger, you will be 
                     prompted for optional arguments.
.br
                     See \fIfinger\fR (1) for a list
.br
                     of allowed options.
.PP
\fBwhoami\fR               Invoke a UNIX \fIwhoami\fR (1) command
.PP
\fBhelp\fR                 Print the \fBgone\fR banner, and list of 
.br
                     valid commands
.PP
\fBcls\fR                  Clear the screen and print the \fBgone\fR
                     banner
.PP
\fBdate\fR                 Invoke the UNIX \fIdate\fR (1) command
.PP
\fBunlock\fR               Unlock the terminal; prompts for 
.br
                     unlock password
.PP                          
.SH FILES
\fB_BINPATH_\fR       Gone binary application
.br
.SH MINUTIAE
* \fBGone\fR will only run if the user is logged into a valid tty.  
.br
* Invoking a \fBSIGINT\fR, a \fBSIGSTP\fR, a \fBSIGQUIT\fR, or a \fBSIGKILL\fR will cause \fBgone\fR to print the time remaining before the user is logged out.
.PP
.SH BUGS
No known bugs, but I welcome any bug reports or comments to <marcus@miami.edu>
.SH AUTHOR
Joe "Marcus" Clarke <marcus@miami.edu>
.SH ACKNOWLEDGEMENTS
Dr. Burt "THE Doctor" Rosenberg, for motivating, for being a good
friend, and for having a great jump shot.
.br
Alexandra Loubeau, for using the damn thing.
.br
Jason Glick for giving me the quota to do most of the initial work...and
for Joe Satriani.
.br
Craig Kolthoff for installing it on jaguar....finally; and for giving me
a monster quota for FreeBSD.
.br
Blake Winton <BlakeW@rpmtec.com>, for contributing the patch for indefinite
terminal locking.
