/*-
 * Copyright (c) 2001 Jordan DeLong
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the author nor the names of contributors may be
 *    used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
#ifndef DGROUP_H
#define DGROUP_H

/*
 * a window decoration group.  this is a group of decoration units; each client is
 * associated with one of these decoration groups at a time; it determines which of
 * the decor_t structures are going to be used in the decoration of said client.
 */
struct dgroup {
	char		*ident;		/* identifier for this group */

	int		decor_count;	/* number of decor units in this group */
	decor_t		**decor;	/* array of the decor units that are part of this group */

	decor_t		*title;		/* the unit that we draw the title on, or NULL */
	int		title_x;	/* xpos for the upper left corner of title text */
	int		title_y;	/* ypos for the upper left corner of title text */

	int		top_space;	/* amount of room this group takes up */
	int		left_space;
	int		right_space;
	int		bottom_space;

	SLIST_ENTRY(dgroup) dg_list;
};

extern dgroup_t dgroup_empty;

void dgroup_shutdown();
dgroup_t *dgroup_add(char *ident);
dgroup_t *dgroup_ident(char *ident);
int dgroup_add_decor(dgroup_t *dgroup, decor_t *decor);
void dgroup_learn_space();
void dgroup_switch(client_t *client, dgroup_t *dgroup);

#endif
