/*-
 * Copyright (c) 2001 Jordan DeLong
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the author nor the names of contributors may be
 *    used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
#ifndef MENU_H
#define MENU_H

#include "plugutil.h"

/* some constants */
#define MENU_XBORDER	5
#define MENU_YBORDER	2
#define MENU_MINWIDTH	75

/* possible menuent types */
enum {
	ET_SUBMENU,
	ET_COMMAND,
	ET_RESTART,
	ET_EXIT,
	ET_ABORT
};

/* positions for addent */
#define POS_LAST	-1

/* an entry on a menu */
typedef struct menuent {
	int	type;		/* type of this entry */
	char	*text;		/* text to display */

	/* data that depends on type */
	union {
		void	*dat;
		char	*cmd;
		int	submenu;
	} dat;
} menuent_t;

/* structure describing a menu */
typedef struct menu {
	struct menu	*forefather;	/* the root parent of this menu tree, can point to this */
	struct menu	**active_sub;	/* the currently open submenu, if any, per screen */
	client_t	**client;	/* a client_t for each screen */

	int		entry_count;	/* menu entries */
	menuent_t	**entries;

	int		submenu_count;	/* submenus, idx's in menuent ref them */
	struct menu	**submenus;
} menu_t;

extern XContext menu_context;
extern int menu_stacklayer;

int menu_init(char *fontname, dgroup_t *dgroup, pixmap_t *bullet);
void menu_shutdown();
menu_t *menu_create();
menuent_t *menu_addent(menu_t *menu, int pos, int type, char *text, void *dat);
void menu_freeent(menuent_t *ent);
void menu_size(menu_t *menu);
int menu_realize(menu_t *menu);
void menu_delete(menu_t *menu);
void menu_expose(menu_t *menu, client_t *client, XExposeEvent *e);
void menu_use(menu_t *menu, screen_t *screen);
void menu_click(menu_t *menu, client_t *client, XButtonEvent *e);

#include "parseparams.h"

#endif
