/*-
 * Copyright (c) 2001 Jordan DeLong
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the author nor the names of contributors may be
 *    used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
#ifndef _SCREEN_H
#define _SCREEN_H

/* forward decl from workspace.h */
struct desktop;

/* 
 * structure describing a screen.  this is stored in an XContext for the root window
 * of the screen, and the client_t structure has a pointer to the screen obj for that
 * client.
 */
typedef struct screen {
	int		num;			/* screen number */
	Window		root;			/* root window for this screen */
	Window		nofocus;		/* window that we focus when no clients get the focus */

	int		width, height;		/* root window dimensions */

	/* GCs for this screen */
	GC		xorgc;			/* gc used for drawing window outlines, etc */
	GC		cpygc;			/* gc used for button drawing, other copys etc */
	GC		titlegc;		/* gc used for title font */

	/* colors for this screen */
	Pixel		linefg;			/* color for drawing lines on this screen */

	/* workspace stuff */
	int		desktop_count;		/* to prevent list traversal just for counting */
	struct desktop *desktop_list;		/* list of desktops */
	struct desktop *desktop;		/* current desktop */

	struct screen *next;
	struct screen *prev;
} screen_t;

extern int screen_count;
extern screen_t *screen_list;

void screen_init();
void screen_manage_existing();
void screen_shutdown();

#endif
