/*-
 * Copyright (c) 2001 Jordan DeLong
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the author nor the names of contributors may be
 *    used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
#ifndef _OPTIONS_H
#define _OPTIONS_H

/* path to golem plugins */
#define PLUGINPATH	"~/.golem/plugins:" PREFIX "/lib/golem/plugins"

/* increments for smart placement testing */
#define PLACETEST_XINC		8
#define PLACETEST_YINC		8

/* types of focusing; code can assume >0 is non-click */
#define FOCUS_CLICK		0		/* click on a window and it gets focused */
#define FOCUS_SLOPPY		1		/* change focus on EnterNotify events */
#define FOCUS_POINTER		2		/* change focus on EnterNotifys and LeaveNotifys */

/* types of placement */
#define PLACEMENT_NONE		0		/* we use whatever vals the window is already at */
#define PLACEMENT_RANDOM	1		/* random vals; makings sure it's all in the scr */
#define PLACEMENT_POINTER	2		/* right under the pointer */
#define PLACEMENT_SMART		3		/* place where it covers the least amount of other clients */

/* options structure */
typedef struct {
	/* string options */
	char	*title_font;			/* font for title bars */
	char	*titleclr;			/* color for title text */
	char	*linefgclr;			/* color to use for lines */

	int	focus;				/* type of focus method to use */
	int	placement;			/* type of placement to use */

	/* numeric options */
	int	mouse_modifier;			/* modifier pressed to allow dragging/resizing of windows */
	int	anim_delay;			/* delay passed to usleep for various animations */
	int	interact_timeout;		/* timeout for interactive place in micro seconds. 0 = no timeout */
	int	linewidth;			/* width of lines for drawing window outlines, etc */
	int	desktop_count;			/* number of desktops per screen */
	int	desktop_width;			/* width of each desktop */
	int	desktop_height;			/* height of each desktop */

	/* decoration groups */
	dgroup_t	*dgroup_default;	/* default decoration group */
	dgroup_t	*dgroup_trans;		/* group to use for transients */
	dgroup_t	*dgroup_internal;	/* decoration for internal windows made by plugins */

	/* boolean-style options */
	unsigned int	opaquemove:1;		/* show window contents while moving */
	unsigned int	place_nonzeros:1;	/* do we place windows that have requested a position */
	unsigned int	place_transients:1;	/* does user place transients (requires manual_placement) */
	unsigned int	place_interactive:1;	/* do we interact with the user after placing */
	unsigned int	fullscreen_zoom:1;	/* full screen Zooming */
	unsigned int	focus_new:1;		/* do we focus new arrivals */
} options_t;

extern options_t options;

void options_init();
void options_clean();

#endif
