/*-
 * Copyright (c) 2001 Jordan DeLong
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the author nor the names of contributors may be
 *    used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
#ifndef _PIER_H
#define _PIER_H

/* types for pier items */
#define PI_NOTHING	0	/* nothing */
#define PI_LAUNCH	1	/* we launch progs when clicked */
#define PI_WMDOCK	2	/* a windowmaker-style 'dock app' */
#define PI_SWALLOWED	3	/* a afterstep-style 'wharf app' */

/* types for piers */
#define PT_HORIZ	0
#define PT_VERT		1

/* one item on the pier */
typedef struct {
	int		type;		/* type of this item */
	Window		frame;		/* the pier frame window */

	Pixmap		pixmap;		/* pixmap for this item */
	Pixmap		shapemask;	/* shape mask of the pixmap */

	char		*cmd;		/* command for launching or for dock/swallowing */
	XClassHint	classhint;	/* class of the window we swallow */
	Window		window;		/* client window for swallowing/docking, or pixmap window on launchers */
	pid_t		pid;		/* pid of the swallowed/docked app; kill on exit */
} pieritem_t;

/* a pier; can be either horizontal or verticle */
typedef struct pier {
	int		type;		/* pier type */
	int		screen;		/* screen the pier is on */
	int		x, y;		/* position pier is at */
	int		width, height;	/* dimension information */
	Window		window;		/* window around the whole pier */

	int		item_count;	/* the items for this pier */
	pieritem_t	**items;

	struct pier	*next;		/* next pier for the list of piers */
} pier_t;

/* a string to pier/pieritem table for starting dockapps/swallowed apps */
typedef struct comtab {
	XClassHint	classhint;	/* class to watch for */
	pier_t		*pier;		/* pier that needs this command */
	int		idx;		/* idx of the item waiting for command */

	struct comtab	*next;
	struct comtab	*prev;
} comtab_t;

extern int pier_size;
extern comtab_t *comtab_list;

int pier_init();
void pier_shutdown();
pier_t *pier_create(int screen, int type, int x, int y);
void pier_delete(pier_t *pier);
pieritem_t *pier_additem(pier_t *pier, int type, char *cmd, char *res_name, char *res_class, char *xpmfn);
void pier_freeitem(pieritem_t *item);
int pier_realize(plugin_t *plugin, pier_t *pier);
int pier_realize_all(plugin_t *plugin);
pier_t *pier_findpier(Window wnd);
void pier_click(pier_t *pier, XButtonEvent *e);
void pier_gotcom(plugin_t *plugin, comtab_t *comtab, XMapRequestEvent *e);

#endif
