/*-
 * Copyright (c) 2001 Jordan DeLong
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the author nor the names of contributors may be
 *    used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
#ifndef _PAGER_H
#define _PAGER_H

/* used by pager_t's for list of client windows */
typedef struct paged {
	client_t	*client;	/* client we represent */
	Window		win;		/* our mini-representation window */

	struct paged *next;
	struct paged *prev;
} paged_t;

/* a pager */
typedef struct {
	Window		win;		/* the pager window */
	client_t	*client;	/* this pager's client structure (we are managed) */
	desktop_t	*desktop;	/* desktop we represent */
	paged_t		*paged_list;	/* list of our paged windows */
} pager_t;

/* per screen structure */
struct pagerscr {
	GC		drawgc;		/* graphics context for this scr */
	int		pager_count;	/* number of pagers */
	pager_t		**pagers;	/* pagers: 1 per desktop on the scr */
	Pixel		grid_color;	/* color to use for grid drawing */
	Pixel		sel_color;	/* color for the selected portion of the grid */
};

extern struct pagerscr *pagerscr;
extern double pager_ratio;
extern XContext pager_context;

void pager_init(double ratio, dgroup_t *dgroup);
pager_t *pager_create(plugin_t *plugin, screen_t *screen, desktop_t *desktop);
void pager_delete(pager_t *pager);
void pager_addpaged(plugin_t *plugin, pager_t *pager, client_t *client);
paged_t *pager_findpaged(pager_t *pager, Window win);
void pager_rmpaged(pager_t *pager, paged_t *paged, client_t *client);
void pager_movepaged(pager_t *pager, paged_t *paged, pager_t *newpager);
void pager_sizepaged(pager_t *pager, paged_t *paged, client_t *client);
void pager_click(pager_t *pager, int x, int y);
void pager_expose(pager_t *pager, GC gc, XExposeEvent *e);
void pager_drag(pager_t *origpager, paged_t *paged, XButtonEvent *ev);

#endif
