/*-
 * Copyright (c) 2001 Jordan DeLong
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the author nor the names of contributors may be
 *    used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
#include "wm.h"
#include "plugutil.h"

/* motif hints */
#define MWM_HINTS_FUNCTIONS	(1L << 0)
#define MWM_HINTS_DECORATIONS	(1L << 1)

/* bit definitions for functions */
#define MWM_FUNC_ALL		(1L << 0)
#define MWM_FUNC_RESIZE		(1L << 1)
#define MWM_FUNC_MOVE		(1L << 2)
#define MWM_FUNC_MINIMIZE	(1L << 3)
#define MWM_FUNC_MAXIMIZE	(1L << 4)
#define MWM_FUNC_CLOSE		(1L << 5)

/* bit definitions for decorations */
#define MWM_DECOR_ALL		(1L << 0)
#define MWM_DECOR_BORDER	(1L << 1)
#define MWM_DECOR_RESIZEH	(1L << 2)
#define MWM_DECOR_TITLE		(1L << 3)
#define MWM_DECOR_MENU		(1L << 4)
#define MWM_DECOR_MINIMIZE	(1L << 5)
#define MWM_DECOR_MAXIMIZE	(1L << 6)

/* Motif wm hints structure */
typedef struct {
	long flags;
	long functions;
	long decorations;
	long inputmode;
	long status;
} mwmhints_t;

/* the hint atom */
static Atom	motif_wm_hints;

/* get our atom */
int start(plugin_t *plugin) {
	motif_wm_hints = XInternAtom(display, "_MOTIF_WM_HINTS", 0);

	return PLUGIN_OK;
}

/* handle new client arrival in terms of mwm hints */
int init_hints(plugin_t *plugin, client_t *client, dgroup_t *dgroup) {
	mwmhints_t *mwmhints;
	Atom rettype;
	int retfmt;
	long items, bytes;

	/* get the hints structure */
	mwmhints = NULL;
	XGetWindowProperty(display, client->window, motif_wm_hints, 0, 5, 0,
		motif_wm_hints, &rettype, &retfmt, &items, &bytes,
		(unsigned char **) &mwmhints);
	if (!mwmhints)
		return PLUGIN_OK;
	if (items != 5 || rettype != motif_wm_hints)
		goto free;

	/* handle functions hints */
	if (mwmhints->flags & MWM_HINTS_FUNCTIONS) {
		client->flags.noresize = 1;
		client->flags.nomove = 1;
		client->flags.noiconify = 1;
		client->flags.nodelete = 1;

		if (mwmhints->functions & MWM_FUNC_ALL) {
			client->flags.noresize = 0;
			client->flags.nomove = 0;
			client->flags.noiconify = 0;
			client->flags.nodelete = 0;
		}
		if (mwmhints->functions & MWM_FUNC_RESIZE)
			client->flags.noresize = 0;
		if (mwmhints->functions & MWM_FUNC_MOVE)
			client->flags.nomove = 0;
		if (mwmhints->functions & MWM_FUNC_MINIMIZE)
			client->flags.noiconify = 0;
		/* no difference between allowing zoom and allowing resize */
		if (mwmhints->functions & MWM_FUNC_MAXIMIZE)
			client->flags.noresize = 0;
		if (mwmhints->functions & MWM_FUNC_CLOSE)
			client->flags.nodelete = 0;
	}

	/*
	 * handle decorations hints; because all of what the decoration
	 * looks like is handled by the dgroup and the user's rcfile,
	 * mwmhints on decorations are an all-or-nothing thing.  If
	 * a window wants any decoration it gets all of it.
	 */
	if (mwmhints->flags & MWM_HINTS_DECORATIONS) {
		if (mwmhints->decorations == 0)
			client->dgroup = &dgroup_empty;
	}

free:
	XFree(mwmhints);
	return PLUGIN_OK;
}
