/*-
 * Copyright (c) 2001 Jordan DeLong
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the author nor the names of contributors may be
 *    used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
#include "wm.h"
#include "animations.h"
#include "plugutil.h"

/*
 * all of our animations work by calling the anim handler
 * from the appropriate golem callback function; the handler
 * can do whatever it wants; it should be noted that some handlers
 * may call XMapWindow to do opaque movements of windows for
 * entry or whatever; the main code will call map on it again, but
 * it's no big deal.
 */
static animhandler_t	a_iconify;
static animhandler_t	a_restore;
static animhandler_t	a_zoom;
static animhandler_t	a_unzoom;
static animhandler_t	a_birth;
static animhandler_t	a_death;

/* parse parameters */
int init(plugin_t *plugin) {
	char *iconname;
	char *restname;
	char *birthname;
	char *deathname;
	char *zoomname;
	char *unzoomname;

	/* get parameters describing which handlers to use for what */
	OPTIONAL_PARAM(iconname, &plugin->params, string, "iconify", NULL);
	OPTIONAL_PARAM(restname, &plugin->params, string, "restore", NULL);
	OPTIONAL_PARAM(birthname, &plugin->params, string, "birth", NULL);
	OPTIONAL_PARAM(deathname, &plugin->params, string, "death", NULL);
	OPTIONAL_PARAM(zoomname, &plugin->params, string, "zoom", NULL);
	OPTIONAL_PARAM(unzoomname, &plugin->params, string, "unzoom", NULL);

	/* get handler pointers where the handlers were specified */
	if (iconname)
		a_iconify = animbyname(plugin, iconname);
	if (restname)
		a_restore = animbyname(plugin, restname);
	if (birthname)
		a_birth = animbyname(plugin, birthname);
	if (deathname)
		a_death = animbyname(plugin, deathname);
	if (zoomname)
		a_zoom = animbyname(plugin, zoomname);
	if (unzoomname)
		a_unzoom = animbyname(plugin, unzoomname);

	/* free up strings and ret */
	if (iconname)	free(iconname);
	if (restname)	free(restname);
	if (birthname)	free(birthname);
	if (deathname)	free(deathname);
	if (zoomname)	free(zoomname);
	if (unzoomname)	free(unzoomname);

	return PLUGIN_OK;
}

/* shutdown the animations plugin */
/*void shutdown() {
}*/

/*
 * relativly noninteresting from here down; callbacks just pass their
 * stuffs on to a handler.
 */

/* new windows being born */
int anim_birth(plugin_t *plugin, client_t *client) {
	if (a_birth)
		a_birth(client, EV_BIRTH);

	return PLUGIN_OK;
}

/* window death: old clients departing */
int window_death(plugin_t *plugin, client_t *client) {
	if (a_death)
		a_death(client, EV_DEATH);

	return PLUGIN_OK;
}

/* client iconification */
int iconify_notify(plugin_t *plugin, client_t *client) {
	if (a_iconify)
		a_iconify(client, EV_ICONIFY);

	return PLUGIN_OK;
}

/* client restoration */
int restore_notify(plugin_t *plugin, client_t *client) {
	if (a_restore)
		a_restore(client, EV_RESTORE);

	return PLUGIN_OK;
}

/* clients getting zoomed */
int zoom_notify(plugin_t *plugin, client_t *client) {
	if (a_zoom)
		a_zoom(client, EV_ZOOM);

	return PLUGIN_OK;
}

/* clients getting unzoomed */
int unzoom_notify(plugin_t *plugin, client_t *client) {
	if (a_unzoom)
		a_unzoom(client, EV_UNZOOM);

	return PLUGIN_OK;
}
