/*-
 * Copyright (c) 2001 Jordan DeLong
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the author nor the names of contributors may be
 *    used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
#include "wm.h"
#include "animations.h"

/* sliding in a winbox */
void window_slide(client_t *client, int event) {
	int x, y;
	int wid, hei;

	/* grab (we're doing xor lines) */
	XGrabServer(display);

	/* get wid/hei of the client, including decor */
	wid = client->left_space + client->width + client->right_space;
	hei = client->top_space + client->height + client->bottom_space;

	/* left/right or from top/bottom */
	if (random() % 2) {
		x = random() % 2 ? 0 - wid : client->screen->width + wid;
		y = random() % client->screen->height;
	} else {
		x = random() % client->screen->width;
		y = random() % 2 ? 0 - hei : client->screen->height + hei;
	}

#if 1
	draw_zoomrects(client->screen, client, x, y, wid, hei,
		client->x, client->y, client->width, client->height, 1);
#else
	/*
	 * doing it opaquely; this is not yet done.
	 * this would happen in a seperate anim handler (or with an option);
	 */

	xinc = (x - client->x) / NUM_RECTS;
	yinc = (y - client->y) / NUM_RECTS;

	if (options.opaquemove) {
		XMoveWindow(display, client->frame, x, y);
		XMapRaised(display, client->frame);
		XMapWindow(display, client->window);
	} else {
		draw_winbox(client->screen, client, (int) x, (int) y, client->width, client->height);
	}
	XSync(display, 0);

	for (i = 0; i < NUM_RECTS; i++) {
		if (options.opaquemove)
			XMoveWindow(display, client->frame, x, y);
		else
			draw_winbox(client->screen, client, (int) x, (int) y, client->width, client->height);

		XSync(display, 0);
		usleep(options.anim_delay);

		if (!options.opaquemove)
			draw_winbox(client->screen, client, (int) x, (int) y, client->width, client->height);

		x += xinc;
		y += yinc;
	}
#endif

	/* release the server mutex */
	XUngrabServer(display);
}

/* declare our animation */
ANIMATION_DECLARE("window_slide", window_slide)
