/*
 *	for new GOGO-no-coda (1999/09)
 *	modified by PEN@MarineCat
 */

/**********************************************************************
 * ISO MPEG Audio Subgroup Software Simulation Group (1996)
 * ISO 13818-3 MPEG-2 Audio Encoder - Lower Sampling Frequency Extension
 *
 * $Id: reservoir.c,v 1.1 1996/02/14 04:04:23 rowlands Exp $
 *
 * $Log: reservoir.c,v $
 * Revision 1.1  1996/02/14 04:04:23  rowlands
 * Initial revision
 *
 * Received from Mike Coleman
 **********************************************************************/
/*
  Revision History:

  Date        Programmer                Comment
  ==========  ========================= ===============================
  1995/09/06  mc@fivebats.com           created

*/
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <assert.h>
#include "l3side.h"
#include "loop.h"
#include "huffman.h"
#include "l3bs.h"
#include "reserv.h"

/*
  Layer3 bit reservoir:
  Described in C.1.5.4.2.2 of the IS
*/

static int ResvSize = 0; /* in bits */
static int ResvMax  = 0; /* in bits */

void InitReservoir(void)
{
	ResvSize = 0;
	ResvMax  = 0;
}


/*
 * input  : mean_bits, ResvSize, frameLength;
 * output : fullFrameBits, ResvMax
 */

int
ResvFrameBegin( int mean_bits, int frameLength )
{
	int fullFrameBits;
	int resvLimit;

	if( gl.mode_gr == 2 ){
		resvLimit = 4088; /* main_data_begin has 9 bits in MPEG 1 */
		fullFrameBits = mean_bits * 2 + ResvSize;
	}else{
		resvLimit = 2040; /* main_data_begin has 8 bits in MPEG 2 */
		fullFrameBits = mean_bits + ResvSize;
	}

	if( frameLength > 7680 ){
		ResvMax = 0;
	}else{
		ResvMax = 7680 - frameLength;
		if( ResvMax > resvLimit ) ResvMax = resvLimit;
	}
	return fullFrameBits;
}

/*
  ResvMaxBits2:
  As above, but now it *really* is bits per granule (both channels).  
  Mark Taylor 4/99
*/
void ResvMaxBits2(int mean_bits, int *targ_bits, int *extra_bits, int gr)
{
	int add_bits;

	*targ_bits = mean_bits ;
	/* extra bits if the reservoir is almost full */
	if( ResvSize > ((ResvMax * 9) / 10)){
		add_bits= ResvSize-((ResvMax * 9) / 10);
		*targ_bits += add_bits;
	}else{
		add_bits =0 ;
	/* build up reservoir.  this builds the reservoir a little slower
	 * than FhG.  It could simple be mean_bits/15, but this was rigged
	 * to always produce 100 (the old value) at 128kbs */
		*targ_bits -= (int) (mean_bits/15.2);
	}

	/* amount from the reservoir we are allowed to use */
	*extra_bits = (ResvSize  < (ResvMax*6)/10  ? ResvSize : (ResvMax*6)/10);
	*extra_bits -= add_bits;
  
	if( *extra_bits < 0 ) *extra_bits = 0;

#ifndef LAME355
	if( *targ_bits > 4095 ) *targ_bits = 4095;
	if( *targ_bits + *extra_bits > 4095 ) *extra_bits = 4095 - *targ_bits;
#endif  
}

/*
  ResvAdjust:
  Called after a granule's bit allocation. Readjusts the size of
  the reservoir to reflect the granule's usage.
*/
void
ResvAdjust( gr_info *gi, int mean_bits )
{
    ResvSize += (mean_bits / gl.stereo) - gi->part2_3_length;
}

/*
  ResvFrameEnd:
  Called after all granules in a frame have been allocated. Makes sure
  that the reservoir size is within limits, possibly by adding stuffing
  bits. Note that stuffing bits are added by increasing a granule's
  part2_3_length. The bitstream formatter will detect this and write the
  appropriate stuffing bits to the bitstream.
*/
void
ResvFrameEnd( III_side_info_t *l3_side, int mean_bits )
{
	int stuffingBits;
	int over_bits;

	/* just in case mean_bits is odd, this is necessary... */
	if( gl.stereo == 2 && ( mean_bits & 1 ) ) ResvSize++;

	over_bits = ResvSize - ResvMax;
	if( over_bits > 0 ){
		ResvSize = ResvMax;
		stuffingBits = over_bits;
	}else{
		stuffingBits = 0;
	}

	/* we must be byte aligned */
	over_bits = ResvSize & 7;
	if( over_bits ){
		stuffingBits += over_bits;
		ResvSize -= over_bits;
	}
#ifdef LAME355
	l3_side->resvDrain = stuffingBits;
#else
	if ( stuffingBits ){
		gr_info *gi;
		int ch, gr;
	/*
	  plan a: put all into the first granule
	  This was preferred by someone designing a
	  real-time decoder...
	*/
		gi = (gr_info *) &(l3_side->gr[0].ch[0]);	
	
		if ( gi->part2_3_length + stuffingBits < 4095 ){
			gi->part2_3_length += stuffingBits;
		}else{
	    /* plan b: distribute throughout the granules */
			for( gr = 0; gr < gl.mode_gr; gr++ ){
				for( ch = 0; ch < gl.stereo; ch++ ){
					int extraBits, bitsThisGr;
					gi = (gr_info *) &(l3_side->gr[gr].ch[ch]);
					extraBits = 4095 - gi->part2_3_length;
					bitsThisGr = extraBits < stuffingBits ? extraBits : stuffingBits;
					gi->part2_3_length += bitsThisGr;
					stuffingBits -= bitsThisGr;
				}
			}
			l3_side->resvDrain = stuffingBits;
		}
	}
#endif
}

