/*
 *	for new GOGO-no-coda (1999/09)
 *	optimized by shigeo
 */
#define MIE

#include "common.h"
#include "global.h"
#include "encoder.h"
#include "l3psy.h"
#include "l3side.h"
#include "haveunit.h"
#include "musenc.h"

/*
 *	λꤷƽ
 *	ޥ HAVEGTK Ƥʤ
 *	ɬ gpsycho = 1 (ä syncflush = WINDELAY )
 *
 *	ʲοͤϸͤȰ㤦̣ˤʤäƤΤ
 *	minval[i]  pow( 10, -0.1 * minval[i]) 
 *	SNR_s[i]  exp( SNR_s[i] * LN_TO_LOG10 ) * norm_s[i] 
 *	Ʊ norm_s κ
 *	tmn פѿκ
 *      99/10/07 lame3.30betaν
 */

#define MSFREQ 20	/* 0ˤ, 4ܿʳˤfft_side()νɬ */

#define LN_TO_LOG10 0.2302585093	/* = log(10)/10 */
#define sync_flush WINDELAY	/* = 752 */

	/* vdb dB̤򲼤뤿ɬפʷ */
#define decibel_lower 0.31622776602 /* = pow(10.0,-vdb/10.0), vdb=5 */

/* ʲȶɽŪˤʤ꤬ short block ⡼ɤˤʤ */

#define AWS	/* from Gabriel Bouvigne <bouvigne@multimania.com> */
#define ENER_AWS


/* align ڤӺƽΤ˳˽Ф(*.nasˤͽ) */

/*  static פʤ */

//static float ectb[CBANDS][2];
extern float wsamp_rs[256];		/* defined in l3psya.nas */

/* staticɬפʤ */

static int new = 0, old = 1;
static int switch_pe=1800;
static int savebuffer[2][1344];
extern float wsamp_r_int[2][BLKSIZE];	/* defined in l3psya.nas */
static float window_s[BLKSIZE_s];
static float window[BLKSIZE];
extern float s3_l[CBANDS][CBANDS];	/* defined in l3psya.nas */
static float s3_s[CBANDS][CBANDS];
static float SNR_s[CBANDS_s];
static float minval[CBANDS],qthr_l[CBANDS],norm_l[CBANDS];
static float qthr_s[CBANDS_s];
static float nb_1[2][CBANDS], nb_2[2][CBANDS];
static int bu_l[SBMAX_l],bo_l[SBMAX_l] ;
static int bu_s[SBMAX_s],bo_s[SBMAX_s] ;
static float w1_l[SBMAX_l], w2_l[SBMAX_l];
static float w1_s[SBMAX_s], w2_s[SBMAX_s];
static int numlines[CBANDS];

static float abx_sav[2][2][6][2];	/* 6ޤǤǽʬ */

static float rx_sav[2][2][6];

static float mld_l[SBMAX_l],mld_s[SBMAX_s];
static int partition_l[HBLKSIZE],partition_s[HBLKSIZE_s];
static int numCBANDS,numCBANDS_s;
static int num_part,num_part_s;

/* Ϣץȥ */

void L3psy_init(int sfreqHz);

static void L3para_read( int sfreqHz );

/* ƥ롼ؤΥݥ */

extern void (*fft_side)( float in[2][1024], int s, float *ret);
extern void (*fft1k)(float *x_real, float *energy, float (*abx)[2], float *window, int *savebuf);
extern void (*fft256)(float *x_real, float *energy, float (*abx)[2], float *window, int *savebuf);
void (*sprdngf)( float dest[CBANDS][2], float src[CBANDS][2] );
void (*calc_phase)(float abx_s[3][HBLKSIZE_s][2], float energy_s[3][HBLKSIZE_s],float *cw);

static void L3psycho_energy( int *buffer,
	float energy[HBLKSIZE],
	float abx[HBLKSIZE][2],
	float energy_s[3][HBLKSIZE_s],
	float abx_s[3][HBLKSIZE_s][2],
	int chn,int check_ms_stereo, float *ms_ener_ratio)
{
	int *savebuf;
	int i,j,k;

	float *wsamp_r;

	wsamp_r = wsamp_r_int[chn];
	savebuf = &savebuffer[chn][0];

	/* sync_flush Ĥɸܤ٤餻 */

	for ( i = 0; i < sync_flush; i++ ){
		savebuf[i] = savebuf[i+576];
     }
	for ( i = sync_flush; i < sync_flush+576; i++ ){
		savebuf[i] = buffer[i-sync_flush];
     }
#if 0
	/* subs.c ذư */
	for ( i = 0; i < BLKSIZE; i++ ){
		wsamp_r[i] = window[i] * savebuf[i];
        }
	fft( wsamp_r, energy, abx, BLKSIZE);
#else
	fft1k( wsamp_r, energy, abx, window, savebuf);
#endif

#define shlen 192	/* gpsycho = 1ꤵ */
#define shoff 1

	for ( i = 0; i < 3; i++ ){
#if 0
		/* subs.c ذư */
		for ( j = 0, k = shlen * (shoff + i); j < 256; j++, k++ ){
			wsamp_rs[j] = window_s[j]* savebuf[k];
		}
		fft( wsamp_rs, &energy_s[i][0], abx_s[i], 256);
#else
		k = shlen * (shoff + i);
		fft256( wsamp_rs, &energy_s[i][0], abx_s[i], window_s, savebuf+k);
#endif
	}
#undef shlen
#undef shoff
  
	/* ξ¦ /  ͥ륮η׻ */

	*ms_ener_ratio=0;
  
	if( check_ms_stereo || force_ms ){
		static float ms_ener[2];	/* פstatic */

		for(ms_ener[chn]=0, j=MSFREQ; j<HBLKSIZE ; j++){
			ms_ener[chn] += energy[j];
        }
		if( chn == 1 ){
			float temp;
			if( check_ms_stereo ){	/* Τ wsamp_r_init  */
				fft_side( wsamp_r_int, MSFREQ, &temp);
			}else{
				temp = ms_ener[1];
     }
 
			/* ¦ / ξ¦ ͥ륮 */

			if( temp <= .01*(ms_ener[0]+ms_ener[1]) ){
				*ms_ener_ratio = .01;
			}else{
				*ms_ener_ratio = temp / (ms_ener[0]+ms_ener[1]);
           }
        }
     }
}

void calc_phase_SSE(float abx_s[3][HBLKSIZE_s][2], float energy_s[3][HBLKSIZE_s],float *cw);
void calc_phase_3DN(float abx_s[3][HBLKSIZE_s][2], float energy_s[3][HBLKSIZE_s],float *cw);

void calc_phase_C(float abx_s[3][HBLKSIZE_s][2], float energy_s[3][HBLKSIZE_s],float *cw)
{
	int k, j;
	for( k= 2; k < 52; k++ ){
		float rn, r2, tmp;
		float numre, numim, den;
		float tmp3;
		/* square (x1,y1) */
		den = energy_s[0][k];
		if( den ){
			float a1 = abx_s[0][k][0];
			float b1 = abx_s[0][k][1];
			tmp3 = sqrt( den ) * 2;
			numre = a1*b1;
			numim = (a1*a1-b1*b1)*0.5;
		}else{
			tmp3 = 0;
			numre = 1;
			numim = 0;
			den = 1;
		}
		/* multiply by (x2,-y2) */
		r2 = energy_s[2][k];
		if( r2 ){
			float a2 = abx_s[2][k][0];
			float b2 = abx_s[2][k][1];
			float tmp2 = (numim+numre)*(a2+b2)*0.5;
			float tmp1 = -a2*numre+tmp2;
			numre =       -b2*numim+tmp2;
			numim = tmp1;
			r2 = sqrt( r2 );
			den *= r2;
			tmp3 -= r2;
		}
		tmp = tmp3 / den;
		numre *= tmp;
		numim *= tmp;
		rn = sqrt( energy_s[1][k] );
		den = rn + fabs( tmp3 );
		j = k * 4 - 2;
		if( den ){
			float an = abx_s[1][k][0];
			float bn = abx_s[1][k][1];
			numre = ( an + bn ) * 0.5 - numre;
			numim = ( an - bn ) * 0.5 - numim;
			cw[j] = sqrt(numre*numre+numim*numim)/den;
		}else{
			cw[j] = 0.0;
		}
		cw[j+1] = cw[j+2] = cw[j+3] = cw[j];
	}
	for( j = 206; j < HBLKSIZE; j++ ){
		cw[j] = 0.4;
	}
}

void setup_calc_phase(int useUNIT){
	if( useUNIT & t3DN ){
		SETUP_DSP("use:calc_phase_3DN\n");
		calc_phase = calc_phase_3DN;
	}else
	if( useUNIT & tSSE ){
		SETUP_DSP("use:calc_phase_SSE\n");
		calc_phase = calc_phase_SSE;
	}else
	{
		SETUP_DSP("use:calc_phase_C\n");
		calc_phase = calc_phase_C;
//		SETUP_DSP("use:calc_phase_FPU\n");
//		calc_phase = calc_phase_FPU;
	}
}


/* 19k clk on K6-2 */
void calc_pe_C( float *pe, int num, float *thr, float *ebc, int *numlines ){
	float tmp = 0;
	for( ; num > 0; num-- ){
		if( *thr < *ebc ){ /* almost true */
			tmp -= *numlines * log( (*thr + 1) / (*ebc + 1) );
		}
		thr++;
		ebc += 2;
		numlines++;
	}
	*pe = tmp;
}

static void (*calc_pe)( float *pe, int num, float *thr, float *ebc, int *numlines );
void calc_pe_3DN( float *pe, int num, float *thr, float *ebc, int *numlines );

void setup_calc_pe(int useUNIT){
	if( useUNIT & t3DN ){
		SETUP_DSP("use:calc_pe_3DN\n");
		calc_pe = calc_pe_3DN;
	}else
	{
		SETUP_DSP("use:calc_pe_C\n");
		calc_pe = calc_pe_C;
	}
}

/*
 *	99/08/24 by shigeo
 *	tbb = min(1, max(0,-0.299-0.43*cbb))ʤΤ
 *	cbb>-0.299/0.43=-0.6953488372ʤtbb=0
 *	cbb<-1.299/0.43=-3.0209302325ʤtbb=1
 *	äƼϰϤ׻Ф褤
 *	e^(-1.299/0.43)=0.04875584301 < cbb < e^(-0.299/0.43)=0.4989003827
 *	˼Υ롼פη׻
 *	nb[b] = ecb[b] * norm_l[b] * exp( -SNR_l[b] * LN_TO_LOG10 );
 *	
 *	Τminvalexp(minval * -LN_TO_LOG10)=pow(10,-minval*0.1)֤
 *
 *	tbb=-0.299-0.43 x, x=log(cbb) 
 *	 e^( ( 29 tbb + 6 (1-tbb) ) * -LN_TO_LOG10 )
 *	=e^( (-0.877 -9.89 x) * -LN_TO_LOG10 )
 *	=10^0.0877 * e^( 9.89 * LN_TO_LOG10 * x )
 *	=10^0.0877 * 10^(0.989 log(cbb))
 *	=10^0.0877 * x^(0.989 log 10)
 *	=1.22377055646 * x^2.27725665736
 */

#define SP_POW_TABLE_N 512

float sp_pow_table[SP_POW_TABLE_N*2];

#define a 0.04875584301				/* (a,b) */
#define b (0.4989003827 + 0.0001)	/* +0.0001x=bնϢ³ˤ뤿 */
									/* ޤ̣Ϥʤ */
#define c 1.22377055646	/* 1 */
#define d 2.27725665736 /* Ҿ跸 */
#define h ( (b - a) / SP_POW_TABLE_N )
#define rev_h ( 1 / h )

/*
 *	y= c*x^d 1䴰ǵ(â a< x <b )
 *	 1.5 * h^2  1.0E-6
 */
static
void sp_pow_init(void){
	int i;
	double x;
	for( i = 0; i < SP_POW_TABLE_N; i++ ){
		x = a + ( b - a ) * (double)i / SP_POW_TABLE_N;
		sp_pow_table[i*2  ] = c * pow( x,d );			/* y_i    */
		sp_pow_table[i*2+1] = c * d * pow( x,d-1 ) * h;	/* y'_i*h */
	}
}

/*
 *	xϰϤ a< x <b
 */
static
void special_pow(float *x){
	int i;
	float e,temp;
	temp = ( *x - a ) * rev_h;
	i = (int)temp;	/* ڼΤ!!! */
	e = temp - i;	/*  */
	*x = sp_pow_table[i*2] + sp_pow_table[i*2+1] * e;
//	*x = c * pow( *x,d );
}
#undef a
#undef b
#undef c
#undef d
#undef h
#undef rev_h

/* 35410clk */
void calc_nb(float ectb[CBANDS][2], float *thr, int chn,int numCBANDS){
	int i;
	for ( i = 0; i < numCBANDS; i++ ){
		float temp1, temp2;
		if( !ectb[i][0] || (temp1=ectb[i][1]/ectb[i][0]) >= 0.4989003827 ){
			/* tbb==1 */
			temp1 = Min( minval[i], 0.251188643153 ); /* =10^-0.6 */
		}else
		if( temp1 <= 0.04875584301 ){	/* tbb==0 */
			temp1 = Min( minval[i], 0.0012589254118 ); /* =10^-2.9 */
		}else
		{
//			temp1=1.22377055646 * pow(temp1,2.27725665736);
			special_pow( &temp1 );
			temp1 = Min( minval[i], temp1 );
		}
		temp1 *= ectb[i][0] * norm_l[i];
		temp2 = Min( temp1, Min( 2*nb_1[chn][i], 16*nb_2[chn][i] ) );
		if (experimentalX) temp2 *= decibel_lower;
		thr[i] = Max( qthr_l[i], temp2 );
		nb_2[chn][i] = nb_1[chn][i];
		nb_1[chn][i] = temp1;
	}
}
	
/* ƽΤᳰ˽Ф */

static float pe[2]={0,0};
static float ms_ratio_s_old=0,ms_ratio_l_old=0;
	
static float ratio[2][SBMAX_l];
static float ratio_s[2][SBMAX_s][3];
static float thm_save[2][SBMAX_l];
static float en_save[2][SBMAX_l];
static float thm_s_save[2][SBMAX_s][3];
static float en_s_save[2][SBMAX_s][3];
static int blocktype_old[2] ;

void L3psycho_anal( int *buffer[2],
	int check_ms_stereo, float *ms_ener_ratio,
	float ratio_d[2][21], float ratio_ds[2][12][3],
	float percep_energy[2], int blocktype_d[2])
{

	int blocktype[2],uselongblock[2],chn;
	unsigned int   b, i, j, k;
	float ms_ratio_l=0,ms_ratio_s=0;

	float thr[CBANDS];
	float abx[6][2];
#if 0
	float energy[HBLKSIZE];
#else
	float unaligned_energy[HBLKSIZE+4];
	float	*energy = (float *)(((int)unaligned_energy + 15) & -16);
#endif
	float energy_s[3][HBLKSIZE_s];
	float abx_s[3][HBLKSIZE_s][2];

/*
 *	`r', 'phi_sav', 'new', 'old'ԳΤ¬Τ¸Ƥ
 *	`r''phi_sav'[ͥ][ǡ`ǯ']Ȥ
 */

	float cw[HBLKSIZE];//, eb[CBANDS];
	float ebc[CBANDS][2];
	int    sb,sblock;

#ifdef AWS
 /* reduce switch_pe if there where preecho events in previous granules */
	{
		int prev_granule_used_shortblock = 0;
   
		for( chn = 0; chn < gl.stereo; chn++ ){
			if( blocktype_old[chn] == SHORT_TYPE ) prev_granule_used_shortblock = 1;
		}
		if( prev_granule_used_shortblock ){
			switch_pe = Max(switch_pe-700,900);
		}else{
			switch_pe = Min(switch_pe+200,1800);
		}
	}
#endif

	for (chn = 0; chn < gl.stereo; chn++){

		for ( j = 0; j < 21; j++ ){
			ratio_d[chn][j] = ratio[chn][j];
		}
		for ( j = 0; j < 12; j++ ){
			for ( i = 0; i < 3; i++ ){
				ratio_ds[chn][j][i] = ratio_s[chn][j][i];
     		}
     	}
		percep_energy[chn] = pe[chn];

		/* oldest==newǤʤΤoldestκ */
		/* new/old0, 1Υȥ */
                                                                                  
		new ^= 1;
		old = 1 - new;

		L3psycho_energy( buffer[chn], energy, abx, energy_s, abx_s,
		chn,check_ms_stereo,&ms_ratio_l);
		ms_ratio_s=ms_ratio_l;

		/* ƱŬƤ뤷 ͤ뤳Ȥϳ? */

		for ( j = 0; j < 6; j++ ){
			/* calculate unpredictability measure cw */
			float an, a1, a2;
			float bn, b1, b2;
			float rn, r1, r2;
			float numre, numim, den;

			a2 = abx_sav[chn][new][j][0];
			b2 = abx_sav[chn][new][j][1];
			r2 = rx_sav[chn][new][j];
			a1 = abx_sav[chn][new][j][0] = abx_sav[chn][old][j][0];
			b1 = abx_sav[chn][new][j][1] = abx_sav[chn][old][j][1];
			r1 = rx_sav[chn][new][j] = rx_sav[chn][old][j];
			an = abx_sav[chn][old][j][0] = abx[j][0];
			bn = abx_sav[chn][old][j][1] = abx[j][1];
			rn = rx_sav[chn][old][j] = sqrt(energy[j]);

     { /* square (x1,y1) */
				if( r1 != 0.0 ){
					numre = a1*b1;
	 numim = (a1*a1-b1*b1)*0.5;
	 den = r1*r1;
				}else{
	 numre = 1.0;
	 numim = 0.0;
	 den = 1.0;
       }
     }

     { /* multiply by (x2,-y2) */
				if( r2 != 0.0 ){
					float tmp2 = (numim+numre)*(a2+b2)*0.5;
					float tmp1 = -a2*numre+tmp2;
	 numre =       -b2*numim+tmp2;
	 numim = tmp1;
	 den *= r2;
				}else{
	 /* do nothing */
       }
     }

     { /* r-prime factor */
				float tmp = (r1 + r1 - r2)/den;
       numre *= tmp;
       numim *= tmp;
     }

			if( (den=rn+fabs(r1 + r1 - r2)) != 0.0 ){
				numre = (an+bn)*0.5 - numre;
				numim = (an-bn)*0.5 - numim;
       cw[j] = sqrt(numre*numre+numim*numim)/den;
			}else{
       cw[j] = 0.0;
     }
   }
		calc_phase(abx_s,energy_s,cw);
		for ( b = 0; b < CBANDS; b++ ){
			ebc[b][0] = 0;
			ebc[b][1] = 0;
   }
		/* partition_l[j]Ͼ0ʾ */
		for ( j = 0; j < HBLKSIZE; j++ ){
     int tp = partition_l[j];
				ebc[tp][0] += energy[j];
				ebc[tp][1] += cw[j] * energy[j];
   }
	
/*
 *	Ȼؿ(s3_l[b][k])Ѥ ʬ䥨ͥ륮ԳΤ(unpredictability)
 *	߹
 *	s3_l44.1kHzΤsparse()
 */
	{
	   static float __ectb[CBANDS*2+16];
	   float (*ectb)[2];
	   ectb = (float (*)[2])( (int)(__ectb+15) & -16 );
	   if(gl.enc_freqHz == 44100 ){
	     sprdngf( ectb, ebc );
	   }else{
	     for ( b = 0;b < numCBANDS; b++ ){
	       ectb[b][0] = 0;
	       ectb[b][1] = 0;
	       for ( k = 0; k < num_part; k++ ){
		 ectb[b][0] += s3_l[b][k] * ebc[k][0];
		 ectb[b][1] += s3_l[b][k] * ebc[k][1];
	       }
	     }
	   }

	   /* ͷ׻ʬĴ(tonality)η׻??? */
	   calc_nb(ectb, thr, chn, numCBANDS);
	 }
		/*
		 *	: PEƤΤͤtempˤĤƤξҤpre-echo
		 *	 ⤷줬ȤƤʤPEϾ600
		 */

		/* γ(perceptual)ȥԡη׻ */

		calc_pe( &pe[chn], numCBANDS, thr, ebc[0], numlines );

 /*************************************************************** 
  * Check to see if we also need to compute long block thresholds
  ***************************************************************/
   uselongblock[chn] = (pe[chn] < switch_pe);

	    {
			float mn,mx;
			float estot[3];
			estot[0] = 0;
			estot[1] = 0;
			estot[2] = 0;
			for ( j = HBLKSIZE_s/2; j < HBLKSIZE_s; j ++){
				estot[0]+=energy_s[0][j];
				estot[1]+=energy_s[1][j];
				estot[2]+=energy_s[2][j];
        }
			mn = Min( Min(estot[0],estot[1]), estot[2] );
			mx = Max( Max(estot[0],estot[1]), estot[2] );
#ifdef ENER_AWS
			if( (pe[chn] <= 3000 && mx <=  2.5 * mn) ||
			    (pe[chn] <= 1800 && mx <= 10   * mn) ||  /* 1800=switch_pe */
			    (pe[chn] <= 1000 && mx <= 30   * mn) ){
			  uselongblock[chn] = 1;
			}else{
			  uselongblock[chn] = 0;
			}
#endif
	}

		if(chn == 1 && force_ms){
			/*  ms_stereo ⡼ */
			/* ch=0 (mid) blocktype determines ch=1 (side) blocktype */
			uselongblock[1] = uselongblock[0];
       }
     
/*
 *	ޥ줿ͤ
 *	granule(γ?)short blockѹʬʤΤ
 *	short blockΥޥ줿ͤɬפ
 */
		if( uselongblock[chn] ){
			/* å̵ʤlong blockȤ */

			for( j = 0; j < SBMAX_l; j++ ){
				float thm, en;
				en =  w1_l[j] * ebc[bu_l[j]][0] + w2_l[j] * ebc[bo_l[j]][0];
				thm = w1_l[j] *thr[bu_l[j]] + w2_l[j] * thr[bo_l[j]];
				for( k = bu_l[j]+1; k < bo_l[j]; k++ ){
					en  += ebc[k][0];
					thm += thr[k];
   }

				if( en ){
					ratio[chn][j] = thm/en;
				}else{
					ratio[chn][j] = 0;
   }
				thm_save[chn][j]=thm;
				en_save[chn][j]=en;
 }
 }
 
/* in some cases, when computing the next granule, we may switch this
 * granule to a short block.  compute short block thresholds just in case */
/* threshold calculation for short blocks */
 
		for ( i = 0; i < 3; i++ ){
			float eb[CBANDS_s];
			for ( j = 0; j < CBANDS_s; j++ ){
			  eb[j] = 0;
			}
			for ( j = 0; j < HBLKSIZE_s; j++ ){
			  eb[partition_s[j]] += energy_s[i][j];
			}

			for( j = 0; j < numCBANDS_s; j++ ){
			  float temp = 0;
			  for( k = 0; k < num_part_s; k++ ){
			    temp += s3_s[j][k] * eb[k];
			  }
			  temp *= SNR_s[j];
			  thr[j] = Max( qthr_s[j],temp );
			}

			for( j = 0; j < SBMAX_s; j++ ){
				float thm, en;
				en =  w1_s[j] * eb[bu_s[j]] + w2_s[j] *  eb[bo_s[j]];
				thm = w1_s[j] *thr[bu_s[j]] + w2_s[j] * thr[bo_s[j]];
				for( k = bu_s[j]+1; k < bo_s[j]; k++ ){
				  en += eb[k];
				  thm += thr[k];
				}

				if( en ){
					ratio_s[chn][j][i] = thm/en;
				}else{
					ratio_s[chn][j][i] = 0;
				}
				thm_s_save[chn][j][i]=thm;
				en_s_save[chn][j][i]=en;
			      }
		      } 
 
 /* compute M/S thresholds from Johnston & Ferreira 1992 ICASSP paper */
#define JOHNSTON
#ifdef JOHNSTON
		if( force_ms && chn == 1 ){
		  float rside,rmid,mld;
		    for ( sb = 0; sb < SBMAX_l; sb++ ){
		      mld = mld_l[sb];
		      rmid = Max(ratio[0][sb],Min(ratio[1][sb],mld));
		      rside = Max(ratio[1][sb],Min(ratio[0][sb],mld));
		      ratio[0][sb]=rmid;
		      ratio[1][sb]=rside;
		    }
		  /* alwasy compute these - we may need them later */
		  for ( sblock = 0; sblock < 3; sblock++ ){
		    for ( sb = 0; sb < SBMAX_s; sb++ ){
		      mld = mld_s[sb];
		      rmid = Max(ratio_s[0][sb][sblock],Min(ratio_s[1][sb][sblock],mld));
		      rside = Max(ratio_s[1][sb][sblock],Min(ratio_s[0][sb][sblock],mld));
		      ratio_s[0][sb][sblock]=rmid;
		      ratio_s[1][sb][sblock]=rside;
		    }
		  }
		}
#endif /* JOHNSTON */

	} /* end loop over chn */

	if( check_ms_stereo ){
		/* ޥ줿ͤ ms_ratio  */
		/* ʿѤͤκ 5dB ̤ʤ ms_stereo(ms_ratio < .35)Ȥ */

		float db,xmin,xmax,sidetot=0,tot=0;

		for (sb= SBMAX_l/4 ; sb< SBMAX_l; sb ++ ){
			if( thm_save[0][sb] > thm_save[1][sb] ){
				xmin = thm_save[1][sb];
				xmax = thm_save[0][sb];
			}else{
				xmin = thm_save[0][sb];
				xmax = thm_save[1][sb];
	}

			if(xmax >= 1000*xmin){
				db = 30;
			}else{
				db = 10*log10(xmax/xmin);
	    }
   sidetot += db;
   tot++;
	}
		ms_ratio_l= 0.07 * sidetot / tot;

 sidetot=0; tot=0;
		for ( sblock = 0; sblock < 3; sblock++ ){
			for ( sb = SBMAX_s/4; sb < SBMAX_s; sb++ ){
				if( thm_s_save[0][sb][sblock] > thm_s_save[1][sb][sblock] ){
					xmin = thm_s_save[1][sb][sblock];
					xmax = thm_s_save[0][sb][sblock];
				}else{
					xmin = thm_s_save[0][sb][sblock];
					xmax = thm_s_save[1][sb][sblock];
				}

				if(xmax >= 1000*xmin){
					db = 30;
				}else{
					db = 10*log10(xmax/xmin);
	}
				sidetot += db;
				tot++;
	    }
	}
		ms_ratio_s = 0.07 * sidetot / tot;
	} /* if( check_ms_stereo ) */

	/* Ǹ block type η */
	if( force_ms ){
	  /* Forced ms_stereo mode.  */
	  /* ch=0 (mid) blocktype determines ch=1 (side) blocktype */
	  uselongblock[1] = uselongblock[0];
	}
	for (chn=0; chn<gl.stereo; chn++){
		blocktype[chn] = NORM_TYPE;
	}

//	if( !allow_diff_short )	/*  1 */
                {
		if( gl.mode == MPG_MD_JOINT_STEREO ){
			/* Ʊ block typeȤξΥͥ */
			/* ms_stereo ǥ󥳡ɤƤȤΤɬ */
   /* But even without ms_stereo, FhG  does this */

			if( !uselongblock[0] || !uselongblock[1] ){
				uselongblock[0]=0;
				uselongblock[1]=0;
			}
		}
	}

	/*
	 *	 granule Ϻ granule ˰¸Τ block type 
	 *	
	 */

	for(chn=0; chn<gl.stereo; chn++){
		if( uselongblock[chn] ){
	
			/* å̵ʤΤ long block */

			switch( blocktype_old[chn] ){
	      case NORM_TYPE:
	      case STOP_TYPE:
				blocktype[chn] = NORM_TYPE;
		break;
	      case SHORT_TYPE:
				blocktype[chn] = STOP_TYPE; 
		break;
	      case START_TYPE:
		fprintf( stderr, "Error in block selecting\n" );
		abort();
		break; /* problem */
	    }
		}else{

			/* åͭʤΤ short block */
	    
			blocktype[chn] = SHORT_TYPE;
			if ( blocktype_old[chn] == NORM_TYPE ){
		blocktype_old[chn] = START_TYPE;
		}
			if ( blocktype_old[chn] == STOP_TYPE ){
				blocktype_old[chn] = SHORT_TYPE ;
	    }
	} 
	
		/* ץƤְ٤֤ */
		blocktype_d[chn] = blocktype_old[chn];

		/* ƤӽФ */
		blocktype_old[chn] = blocktype[chn];
 }

	if (blocktype_d[0]==2){
		*ms_ener_ratio = ms_ratio_s_old;
	}else{
		*ms_ener_ratio = ms_ratio_l_old;
	}
	ms_ratio_s_old = ms_ratio_s;
	ms_ratio_l_old = ms_ratio_l;
}

/*
 *	99/08/25
 *	sprdngf{1,2}ƱǤä򤫤...
 *	99/08/28
 *	٥黻䤹褦ѹ & 3D Now!
 */

void sprdngf_3DN( float dest[CBANDS][2], float src[CBANDS][2] );
void sprdngf_FPU( float dest[CBANDS][2], float src[CBANDS][2] );
void sprdngf_SSE( float dest[CBANDS][2], float src[CBANDS][2] );

static void sprdngf_C( float dest[CBANDS][2], float src[CBANDS][2] )
{
	int b,k;
 static int s3ind[CBANDS][2] = {
		{ 0, 2},{ 0, 3},{ 0, 4},{ 0, 5},{ 0, 6},{ 0, 7},{ 0, 8},{ 0, 9},
		{ 0,10},{ 0,11},{ 0,12},{ 1,14},{ 1,14},{ 2,15},{ 3,15},{ 5,16},
		{ 6,17},{ 7,19},{ 9,20},{10,21},{11,22},{12,23},{14,24},{15,25},
		{15,27},{16,28},{16,28},{17,29},{18,30},{19,31},{19,32},{20,34},
		{21,35},{22,36},{22,36},{23,37},{24,38},{25,39},{26,41},{27,42},
		{28,43},{29,44},{30,45},{31,46},{32,47},{33,48},{34,49},{35,50},
		{36,51},{37,52},{37,53},{38,54},{39,55},{40,56},{41,57},{42,58},
		{43,59},{44,60},{45,61},{46,62},{47,62},{48,62},{48,62}
 };
	for ( b = 0;b < CBANDS; b++ ){
		dest[b][0] = 0;
		dest[b][1] = 0;
		for ( k = s3ind[b][0]; k <= s3ind[b][1]; k++ ){
			dest[b][0] += s3_l[b][k] * src[k][0];
			dest[b][1] += s3_l[b][k] * src[k][1];
		}
	}
}

void setup_sprdngf(int useUNIT){
	if( useUNIT & t3DN ){
		SETUP_DSP("use:sprdngf_3DN\n");
		sprdngf = sprdngf_3DN;
	}else
	if( useUNIT & tSSE ){
		SETUP_DSP("use:sprdngf_SSE\n");
		sprdngf = sprdngf_SSE;
	}else
	if( useUNIT & tSPC1 ){
		SETUP_DSP("use:sprdngf_C\n");
		sprdngf = sprdngf_C;
	}else{
		SETUP_DSP("use:sprdngf_FPU\n");
		sprdngf = sprdngf_FPU;
	}
}

void frame_shiftin_NONE(int *mfbuf, short *frmBuffer, int samplesPerFrame, int stereo);
void frame_shiftin_MMX(int *mfbuf, short *frmBuffer, int samplesPerFrame, int stereo);
void frame_shiftin_3DN(int *mfbuf, short *frmBuffer, int samplesPerFrame, int stereo);

void setup_frame_shiftin(int useUNIT){
	if( useUNIT & t3DN ){
		SETUP_DSP("use:frame_shiftin_3DN\n");
		frame_shiftin = frame_shiftin_3DN;
	}else
	if( useUNIT & tMMX ){
		SETUP_DSP("use:frame_shiftin_MMX\n");
		frame_shiftin = frame_shiftin_MMX;
	}else
	{
		SETUP_DSP("use:frame_shiftin_NONE\n");
		frame_shiftin = frame_shiftin_NONE;
	}
}

extern float psy_data[];

static void L3para_read( int sfreqHz )
{
	float freq_tp;
	static float bval_l[CBANDS], bval_s[CBANDS];
	int   cbmax=0, cbmax_tp;
	float *p = psy_data;
#ifndef LAME355
	int cbw_l[SBMAX_l],cbw_s[SBMAX_s];
#endif
	int numlines2[CBANDS];

	int  sbmax ;
	int  i,j,k,k2,loop, part_max ;

	memset( bval_l, 0, sizeof( bval_l ) );	/* ƸƽбΤ */
	memset( bval_s, 0, sizeof( bval_s ) );
	
	/* Read long block data */

	for(loop=0;loop<6;loop++){
    	freq_tp = *p++;
    	cbmax_tp = (int) *p++;
		cbmax_tp++;

		if( sfreqHz == freq_tp ){
			cbmax = cbmax_tp;
			for(i=0,k2=0;i<cbmax_tp;i++){
				j = (int) *p++;
				numlines2[i] = (int) *p++;
#if 1
				minval[i] = pow( 10, -0.1 * *p);p++;
#else
				minval[i] = *p++;
#endif
				qthr_l[i] = *p++;
				norm_l[i] = *p++;
				bval_l[i] = *p++;
				if( j!=i ){
					printf("1. please check \"psy_data\"");
					TERM(ME_INTERNALERROR );	//exit(-1);
				}
				for( k = 0; k < numlines2[i]; k++ ) partition_l[k2++] = i ;
			}
		}else{
			p += cbmax_tp * 6;
		}
	}

	/************************************************************************
	 * Now compute the spreading function, s[j][i], the value of the spread-*
	 * ing function, centered at band j, for band i, store for later use    *
	 ************************************************************************/
	part_max = cbmax ;
	for( i = 0; i < part_max; i++ ){
		float tempx,x,tempy,temp;
		for(j=0;j<part_max;j++){
             if (j>=i) tempx = (bval_l[i] - bval_l[j])*3.0;
               else    tempx = (bval_l[i] - bval_l[j])*1.5;

			if(tempx>=0.5 && tempx<=2.5){
               temp = tempx - 0.5;
               x = 8.0 * (temp*temp - 2.0 * temp);
			}else
				x = 0.0;
             tempx += 0.474;
             tempy = 15.811389 + 7.5*tempx - 17.5*sqrt(1.0+tempx*tempx);
             if (tempy <= -60.0) s3_l[i][j] = 0.0;
             else                s3_l[i][j] = exp( (x + tempy)*LN_TO_LOG10 );
            }
          }

  /* Read short block data */

	for(loop=0;loop<6;loop++){
      freq_tp = *p++;
      cbmax_tp = (int) *p++;
	cbmax_tp++;

		if (sfreqHz == freq_tp ){
			float temp;
	     cbmax = cbmax_tp;
			for(i=0,k2=0;i<cbmax_tp;i++){
	      j = (int) *p++;
				numlines2[i] = (int) *p++;
	      qthr_s[i] = *p++;
#if 1
				temp = *p++;
				SNR_s[i] = exp( *p * LN_TO_LOG10 ) * temp;
				p++;
#else
	      norm_s[i] = *p++;
				SNR_s[i] = *p++;
#endif
	      bval_s[i] = *p++;
				if (j!=i){
		  printf("3. please check \"psy_data\"");
		   	TERM(ME_INTERNALERROR);	//exit(-1);
	         }
				for(k=0;k<numlines2[i];k++)
		partition_s[k2++] = i ;
	       }
		}else
	p += cbmax_tp * 6;
       }

  /************************************************************************
 * Now compute the spreading function, s[j][i], the value of the spread-*
 * ing function, centered at band j, for band i, store for later use    *
 ************************************************************************/
	  part_max = cbmax ;
	for(i=0;i<part_max;i++){
	  float tempx,x,tempy,temp;
	  for(j=0;j<part_max;j++){
//             tempx = (bval_s[i] - bval_s[j])*1.05;
            if (j>=i) tempx = (bval_s[i] - bval_s[j])*3.0;
	    else    tempx = (bval_s[i] - bval_s[j])*1.5;
            if(tempx>=0.5 && tempx<=2.5){
	      temp = tempx - 0.5;
               x = 8.0 * (temp*temp - 2.0 * temp);
	    }else
	      x = 0.0;
            tempx += 0.474;
            tempy = 15.811389 + 7.5*tempx - 17.5*sqrt(1.0+tempx*tempx);
            if (tempy <= -60.0) s3_s[i][j] = 0.0;
	    else                s3_s[i][j] = exp( (x + tempy)*LN_TO_LOG10 );
         }
	}
  /* Read long block data for converting threshold calculation 
   partitions to scale factor bands */

	for(loop=0;loop<6;loop++){
      freq_tp = *p++;
      sbmax =  (int) *p++;
	sbmax++;

		if (sfreqHz == freq_tp){
			for(i=0;i<sbmax;i++){
	      j = (int) *p++;
#ifdef LAME355
	      p++;
#else
	      cbw_l[i] = (int) *p++;
#endif
	      bu_l[i] = (int) *p++;
	      bo_l[i] = (int) *p++;
				w1_l[i] = (float) *p++;
				w2_l[i] = (float) *p++;
				if (j!=i){
					printf("30:please check \"psy_data\"\n");
		  TERM(ME_INTERNALERROR);	// exit(-1);
	         }

	        if (i!=0)
#ifdef LAME355
		  if ( (fabs(1.0-w1_l[i]-w2_l[i-1]) > 0.01 ) )
#else
		 if ( (bo_l[i] != (bu_l[i]+cbw_l[i])) || (fabs(1.0-w1_l[i]-w2_l[i-1]) > 0.01 ) )
#endif
		   {
		    printf("31l: please check \"psy_data.\"\n");
		  TERM(ME_INTERNALERROR);	// exit(-1);
	         }
	      }
		}else
	p += sbmax * 6;
       }

  /* Read short block data for converting threshold calculation 
   partitions to scale factor bands */

	for(loop=0;loop<6;loop++){
      freq_tp = *p++;
      sbmax = (int) *p++;
	sbmax++;

		if (sfreqHz == freq_tp){
			for(i=0;i<sbmax;i++){
	      j = (int) *p++;
#ifdef LAME355
	      p++;
#else
	      cbw_s[i] = (int) *p++;
#endif
	      bu_s[i] = (int) *p++;
	      bo_s[i] = (int) *p++;
	      w1_s[i] = *p++;
	      w2_s[i] = *p++;
				if (j!=i){
					printf("30:please check \"psy_data\"\n");
		  TERM(ME_INTERNALERROR);	// exit(-1);
	         }

	        if (i!=0)
#ifdef LAME355
     if ( (fabs(1.0-w1_s[i]-w2_s[i-1]) > 0.01 ) )
#else
		 if ( (bo_s[i] != (bu_s[i]+cbw_s[i])) ||(fabs(1.0-w1_s[i]-w2_s[i-1]) > 0.01 ) )
#endif
       {
						printf("31s: please check \"psy_data.\"\n");
		  TERM(ME_INTERNALERROR);	// exit(-1);
	         }
	      }
		}else
	p += sbmax * 6;
	   }
}


void
L3psy_init( int sfreqHz )
{
	int i,j,sb;
	float bval_lo;
	float fthr[HBLKSIZE];
	int partition[HBLKSIZE];
	float crit_band[27] = {0,  100,  200, 300, 400, 510, 630,  770,
		920, 1080, 1270,1480,1720,2000,2320, 2700,3150, 3700, 4400,
		5300,6400,7700,9500,12000,15500,25000,30000
	};

	new = 0;
	old = 1;
	switch_pe = 1800;
	memset( savebuffer, 0, sizeof( savebuffer ) );
	memset( wsamp_r_int, 0, sizeof( wsamp_r_int ) );

	{
		float scalefac;
		scalefac = force_ms ? SQRT2 : 1;

		/* scalefac ߤ HANN 뷸η׻ */

		for( i = 0; i < BLKSIZE; i++ ){
			window[i]  = 0.5*(1-cos(2.0*PI*(i-0.5)/BLKSIZE)) * scalefac;
		}
		for( i = 0; i < BLKSIZE_s ;i++ ){
			window_s[i]= 0.5*(1-cos(2.0*PI*(i-0.5)/BLKSIZE_s)) * scalefac;
		}
	}

	memset( s3_l, 0, sizeof( s3_l ) );
	memset( s3_s, 0, sizeof( s3_s ) );
	memset( SNR_s, 0, sizeof( SNR_s ) );
	memset( minval, 0, sizeof( minval ) );
	memset( qthr_l, 0, sizeof( qthr_l ) );
	memset( norm_l, 0, sizeof( norm_l ) );
	memset( qthr_s, 0, sizeof( qthr_s ) );
	memset( nb_1, 0, sizeof( nb_1 ) );
	memset( nb_2, 0, sizeof( nb_2 ) );
	memset( bu_l, 0, sizeof( bu_l ) );
	memset( bo_l, 0, sizeof( bo_l ) );
	memset( bu_s, 0, sizeof( bu_s ) );
	memset( bo_s, 0, sizeof( bo_s ) );
	memset( w1_l, 0, sizeof( w1_l ) );
	memset( w2_l, 0, sizeof( w2_l ) );
	memset( w1_s, 0, sizeof( w1_s ) );
	memset( w2_s, 0, sizeof( w2_s ) );
	memset( numlines, 0, sizeof( numlines ) );

	memset( abx_sav, 0, sizeof( abx_sav ) );
	memset( rx_sav, 0, sizeof( rx_sav ) );

	/* setup stereo demasking thresholds */
	/* formula reverse enginerred from plot in paper */

	for ( sb = 0; sb < SBMAX_s; sb++ ){
		mld_s[sb] = pow(10.0, 1.25*(1-cos(3.14159*sb/SBMAX_s))-2.5);
	}
	for ( sb = 0; sb < SBMAX_l; sb++ ){
		mld_l[sb] = pow(10.0, 1.25*(1-cos(3.14159*sb/SBMAX_l))-2.5);
	}

	memset( partition_l, 0, sizeof( partition_l ) );
	memset( partition_s, 0, sizeof( partition_s ) );

	for( i = 0; i < HBLKSIZE; i++ ){
		float freq_mult = (float)sfreqHz/BLKSIZE;
		float temp;
		temp = i * freq_mult;
		j = 1;
		while( temp > crit_band[j] ) j++;
		fthr[i]=j-1+(temp-crit_band[j-1])/(crit_band[j]-crit_band[j-1]);
	}
	partition[0] = 0;

	{
		float temp;
		temp = 1;
		bval_lo = fthr[0];
		for( i = 1; i < HBLKSIZE; i++ ){
			if( fthr[i] - bval_lo > 0.33 ){
				partition[i] = partition[i-1] + 1;
				bval_lo = fthr[i];
				numlines[partition[i-1]] = temp;
				temp = 1;
			}else{
				partition[i] = partition[i-1];
				temp++;
			}
		}
		numlines[partition[i-1]] = temp;
	}

	L3para_read( sfreqHz );
	sp_pow_init();

     num_part=0; num_part_s=0;
     for (i=0;i<HBLKSIZE;i++) 
       if (partition_l[i]>num_part) num_part=partition_l[i];
     for (i=0;i<HBLKSIZE_s;i++) 
       if (partition_s[i]>num_part_s) num_part_s=partition_s[i];
     num_part++;
     num_part_s++;

     numCBANDS=bo_l[SBMAX_l-1]+1;
     numCBANDS_s=bo_s[SBMAX_s-1]+1;
	

	/* reset for L3psycho_anal */
	memset( pe, 0, sizeof( pe ) );
	ms_ratio_s_old = 0;
	ms_ratio_l_old = 0;
	memset( ratio, 0, sizeof( ratio ) );
	memset( ratio_s, 0, sizeof( ratio_s ) );
	memset( thm_save, 0, sizeof( thm_save ) );
	memset( en_save, 0, sizeof( en_save ) );
	memset( thm_s_save, 0, sizeof( thm_s_save ) );
	memset( en_s_save, 0, sizeof( en_s_save ) );
	memset( blocktype_old, 0, sizeof( blocktype_old ) );
}
