/*
 *	for new GOGO-no-coda (1999/09)
 *	modified by PEN@MarineCat, shigeo
 */

#define IOSTREAM_BUFFERING	/* եϤΥХåե󥰤Ԥ */

#ifdef WIN32
#include <windows.h>
#endif

#include "common.h"
#include "bitstrem.h"
#include "musenc.h"

#define MIEasmPutBits

/* open_bit_stream_wǽ */
#if defined( WIN32 ) && defined( NDEBUG )
static char	outfilename[ 1024 ];
#endif

extern struct bit_stream_struc{
	/* putbits.nasȤ */
	FILE	*pt;				/* pointer to bit stream device */
	char	*buf;				/* bit stream buffer */
	int		buf_size;			/* size of buffer (in number of bytes) */
	long	totbit;				/* bit counter of bit stream */
	int		buf_bit_idx;		/* pointer to top bit of top byte in buffer */
	/* ɲ  */
	MPGE_USERFUNC	storefunc;	/* store function */
} bs_pt;

/* ХåեդˤʤäǽϥǥХ˰ܤ */

void empty_buffer(void)
{
	unsigned int	i;
	int				sz = (bs_pt.totbit - bs_pt.buf_bit_idx) >> 3;

	if( bs_pt.storefunc == MPGE_NULL_FUNC ){
		i = fwrite( bs_pt.buf, 1,sz , bs_pt.pt);
	} else {
		if( bs_pt.storefunc( bs_pt.buf, sz ) == ME_NOERR )
			i = sz;
		else
			i = 0;
	}
	if( i < sz ){
		TERM( ME_WRITEERROR );
	}

	i  = *(unsigned int *)(bs_pt.buf + sz);
	memset( bs_pt.buf , 0 , sz + 4);
	*(unsigned int *)(bs_pt.buf + 0) = i;
	bs_pt.buf_bit_idx += sz * 8;
}

/* bit stream ˽񤭹िΥǥХopen */
int open_bit_stream_w(char *bs_filenam,int size)
{
	if ((bs_pt.pt = fopen(bs_filenam, "wb")) == NULL){
		fprintf(stderr,"Could not create `%s'.\n", bs_filenam);
		return FALSE;
	}
#if defined( WIN32 ) && defined( NDEBUG )
	strcpy( outfilename, bs_filenam );
	SetFileAttributes( outfilename, FILE_ATTRIBUTE_HIDDEN );
#endif

#if (defined(__HIGHC__)&&defined(IOSTREAM_BUFFERING))
	{	/* ϤΥХåե򹭤Ƥ */
		static char		outBuf[4096*4];
		if(setvbuf(bs_pt.pt, outBuf, _IOFBF, sizeof( outBuf ))!=0){
			fprintf(stderr, "setvbuf failed in open_bit_stream_w\n");
			return FALSE;
		}
	}
#endif
	bs_pt.buf=mem_alloc(size + 64, "");
	memset(bs_pt.buf,0,size + 64);
	bs_pt.buf_size=size;
	bs_pt.totbit = 0;
	bs_pt.buf_bit_idx = 0;
	bs_pt.storefunc = MPGE_NULL_FUNC;

	return TRUE;
}

/* bit stream ˽񤭹िΥǥХopen */
int open_bit_stream_userfunc( MPGE_USERFUNC userfunc,int size)
{
	bs_pt.buf = mem_alloc(size + 64, "");
	memset(bs_pt.buf,0,size + 64);
	bs_pt.buf_size=size;
	bs_pt.totbit = 0;
	bs_pt.buf_bit_idx = 0;
	bs_pt.storefunc = userfunc;

	return TRUE;
}



/* 񤭹߽ɤbit streamΥǥХĤ */
void close_bit_stream_w(void)
{
	putbits( 0, 7);
	empty_buffer();

	if( bs_pt.storefunc == MPGE_NULL_FUNC ){
		if( nid3taglen && pid3tag ){
			fwrite( pid3tag, 1, nid3taglen, bs_pt.pt );
		}
		fclose( bs_pt.pt );
#if defined( WIN32 ) && defined( NDEBUG )
		SetFileAttributes( outfilename, FILE_ATTRIBUTE_NORMAL );
#endif
	} else {
		if( nid3taglen && pid3tag ){
			//if( bs_pt.storefunc( pid3tag, nid3taglen ) != ME_NOERR )
				//TERM( ME_WRITEERROR );
			bs_pt.storefunc( pid3tag, nid3taglen );			// ֤ͤĴ٤ʤ
		}
		bs_pt.storefunc( NULL, 0 );							// to Close
	}
	mem_free((void **)&bs_pt.buf);
}

#ifndef MIEasmPutBits
/* bit stream  N bit 񤭹 */

void putbits(unsigned int val,unsigned int N)
{
	unsigned int	tmp;
	int				bitstm, bt, pt;

	if( N > 24 ){
		/* 33ʾϤꤨʤϤ2ʬ.. */
		putbits( val & 0xFFFF /* (val << 16)>> 16*/ ,	 16);
		putbits(  val	   >> 16, N - 16);
		return;
	}

	bitstm = bs_pt.totbit - bs_pt.buf_bit_idx;
	bt = bitstm & 7;
	pt = bitstm >> 3;

	tmp = val << ( 32 - N );	/* MASK */
	tmp = tmp >> bt;			/* SHIFT */
	/* ʤԳʹbswapȤ. --> Τputbits.nas */
	bs_pt.buf[ pt   ] |= *((char *)(&tmp) + 3);
	bs_pt.buf[ pt+1 ]  = *((char *)(&tmp) + 2);
	bs_pt.buf[ pt+2 ]  = *((char *)(&tmp) + 1);
	bs_pt.buf[ pt+3 ]  = *((char *)(&tmp) + 0);
	bs_pt.totbit += N;
	bitstm	 += N;

	if( ( bitstm >> 3 ) >= bs_pt.buf_size )
		empty_buffer();

}
#endif		/* MIEasmPutBits */

/* ߤstream Ĺ bit֤ */
unsigned long
sstell(void)
{
	return(bs_pt.totbit);
}
