/*******************************************************************************
*               Goggles - Graphical User Interface for OGLE                    *
********************************************************************************
*        Copyright (C) 2002-2005 by Sander Jansen. All Rights Reserved         *
*                               ---                                            *
* This program is free software; you can redistribute it and/or modify         *
* it under the terms of the GNU General Public License as published by         *
* the Free Software Foundation; either version 2 of the License, or            *
* (at your option) any later version.                                          *
*                                                                              *
* This program is distributed in the hope that it will be useful,              *
* but WITHOUT ANY WARRANTY; without even the implied warranty of               *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the                *
* GNU General Public License for more details.                                 *
* You should have received a copy of the GNU General Public License            *
* along with this program; if not, write to the Free Software                  *
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA    *
*******************************************************************************/

/*
$Id: dvdwindow.cpp,v 1.7 2003/05/08 03:22:25 sander Exp $
*/
#ifdef HAVE_SYS_STAT_H
#include <sys/stat.h>
#endif


#include <new>
#include <xincs.h>
#include <fx.h>
#include <fxkeys.h>
#include <FXThread.h>
#include <FXJPGImage.h>
#include <FXPNGImage.h>
#include <FXPNGIcon.h>
extern "C" {
#include <ogle/dvdcontrol.h>
}


#include "version.h"
#include "dvdwindow.h"
#include "dvdnav.h"
#include "dvddesktop.h"
#include "dvdabout.h"
#include "icons.h"

#define DISPLAY ((Display*)((getApp())->getDisplay()))




// Define Message Map
FXDEFMAP(DVDWindow) DVDWindowMap[]={
  //____Message_Type______________ID_______________Message_Handler___
  FXMAPFUNC(SEL_COMMAND,        DVDWindow::ID_QUIT,                 DVDWindow::onCmdQuit),
  FXMAPFUNC(SEL_SIGNAL,         DVDWindow::ID_QUIT,                 DVDWindow::onCmdQuit),
  FXMAPFUNC(SEL_CLOSE,          DVDWindow::ID_SELF,                 DVDWindow::onCmdQuit),
  FXMAPFUNC(SEL_COMMAND,        DVDWindow::ID_ABOUT,                DVDWindow::onCmdAbout),
  FXMAPFUNC(SEL_COMMAND,        DVDWindow::ID_OPEN,                 DVDWindow::onCmdOpen),
  FXMAPFUNC(SEL_UPDATE,         DVDWindow::ID_OPEN,                 DVDWindow::onUpdOpen),


  //Timers
  FXMAPFUNC(SEL_TIMEOUT,        DVDWindow::ID_REFRESH,              DVDWindow::onRefresh),
  FXMAPFUNC(SEL_TIMEOUT,        DVDWindow::ID_RAISE_TIMER,          DVDWindow::onCmdRaiseControl),


  //Play Handlers
  FXMAPFUNC(SEL_COMMAND,        DVDWindow::ID_PLAY,                 DVDWindow::onCmdPlay),
  FXMAPFUNC(SEL_COMMAND,        DVDWindow::ID_STOP,                 DVDWindow::onCmdStop),
  FXMAPFUNC(SEL_COMMAND,        DVDWindow::ID_PAUSE,                DVDWindow::onCmdPause),
  FXMAPFUNC(SEL_COMMAND,        DVDWindow::ID_NEXT,                 DVDWindow::onCmdNext),
  FXMAPFUNC(SEL_LEFTBUTTONRELEASE,DVDWindow::ID_PREVIOUS,           DVDWindow::onCmdPrevious),
  FXMAPFUNC(SEL_COMMAND,        DVDWindow::ID_SEARCH_FORWARD,       DVDWindow::onCmdSearchForward),
  FXMAPFUNC(SEL_COMMAND,        DVDWindow::ID_SEARCH_BACKWARD,      DVDWindow::onCmdSearchBackward),

  FXMAPFUNC(SEL_UPDATE,         DVDWindow::ID_PLAY,                 DVDWindow::onUpdPlay),
  FXMAPFUNC(SEL_UPDATE,         DVDWindow::ID_STOP,                 DVDWindow::onUpdStop),
  FXMAPFUNC(SEL_UPDATE,         DVDWindow::ID_PAUSE,                DVDWindow::onUpdPause),
  FXMAPFUNC(SEL_UPDATE,         DVDWindow::ID_NEXT,                 DVDWindow::onUpdNext),
  FXMAPFUNC(SEL_UPDATE,         DVDWindow::ID_PREVIOUS,             DVDWindow::onUpdPrevious),
  FXMAPFUNC(SEL_UPDATE,         DVDWindow::ID_SEARCH_FORWARD,       DVDWindow::onUpdSearchForward),
  FXMAPFUNC(SEL_UPDATE,         DVDWindow::ID_SEARCH_BACKWARD,      DVDWindow::onUpdSearchBackward),


  //Navigatiom Handlers
  FXMAPFUNC(SEL_COMMAND,        DVDWindow::ID_ENTER,                DVDWindow::onCmdEnter),
  FXMAPFUNC(SEL_COMMAND,        DVDWindow::ID_NAV_UP,               DVDWindow::onCmdNavUp),
  FXMAPFUNC(SEL_COMMAND,        DVDWindow::ID_NAV_DOWN,             DVDWindow::onCmdNavDown),
  FXMAPFUNC(SEL_COMMAND,        DVDWindow::ID_NAV_LEFT,             DVDWindow::onCmdNavLeft),
  FXMAPFUNC(SEL_COMMAND,        DVDWindow::ID_NAV_RIGHT,            DVDWindow::onCmdNavRight),

  FXMAPFUNC(SEL_UPDATE,         DVDWindow::ID_ENTER,                DVDWindow::onUpdEnter),
  FXMAPFUNC(SEL_UPDATE,         DVDWindow::ID_NAV_UP,               DVDWindow::onUpdNavUp),
  FXMAPFUNC(SEL_UPDATE,         DVDWindow::ID_NAV_DOWN,             DVDWindow::onUpdNavDown),
  FXMAPFUNC(SEL_UPDATE,         DVDWindow::ID_NAV_LEFT,             DVDWindow::onUpdNavLeft),
  FXMAPFUNC(SEL_UPDATE,         DVDWindow::ID_NAV_RIGHT,            DVDWindow::onUpdNavRight),

  FXMAPFUNC(SEL_IO_READ,        DVDWindow::ID_NAV_KEYPRESS,         DVDWindow::onNavKeyPress),
  FXMAPFUNC(SEL_IO_READ,        DVDWindow::ID_NAV_KEYRELEASE,       DVDWindow::onNavKeyRelease),

  //Menu Handlers
  FXMAPFUNC(SEL_COMMAND,        DVDWindow::ID_MENU_ROOT,            DVDWindow::onCmdMenuRoot),
  FXMAPFUNC(SEL_COMMAND,        DVDWindow::ID_MENU_TITLE,           DVDWindow::onCmdMenuTitle),
  FXMAPFUNC(SEL_COMMAND,        DVDWindow::ID_MENU_SUBPICTURE,      DVDWindow::onCmdMenuSubpicture),
  FXMAPFUNC(SEL_COMMAND,        DVDWindow::ID_MENU_AUDIO,           DVDWindow::onCmdMenuAudio),
  FXMAPFUNC(SEL_COMMAND,        DVDWindow::ID_MENU_ANGLE,           DVDWindow::onCmdMenuAngle),
  FXMAPFUNC(SEL_COMMAND,        DVDWindow::ID_MENU_PART,            DVDWindow::onCmdMenuPart),

  FXMAPFUNC(SEL_UPDATE,         DVDWindow::ID_MENU_ROOT,            DVDWindow::onUpdMenuRoot),
  FXMAPFUNC(SEL_UPDATE,         DVDWindow::ID_MENU_TITLE,           DVDWindow::onUpdMenuTitle),
  FXMAPFUNC(SEL_UPDATE,         DVDWindow::ID_MENU_SUBPICTURE,      DVDWindow::onUpdMenuSubpicture),
  FXMAPFUNC(SEL_UPDATE,         DVDWindow::ID_MENU_AUDIO,           DVDWindow::onUpdMenuAudio),
  FXMAPFUNC(SEL_UPDATE,         DVDWindow::ID_MENU_ANGLE,           DVDWindow::onUpdMenuAngle),
  FXMAPFUNC(SEL_UPDATE,         DVDWindow::ID_MENU_PART,            DVDWindow::onUpdMenuPart),

  FXMAPFUNC(SEL_COMMAND,        DVDWindow::ID_CHANGE_ANGLE,         DVDWindow::onCmdChangeAngle),
  FXMAPFUNC(SEL_COMMAND,        DVDWindow::ID_CHANGE_AUDIO,         DVDWindow::onCmdChangeAudio),
  FXMAPFUNC(SEL_COMMAND,        DVDWindow::ID_CHANGE_SUBPICTURE,    DVDWindow::onCmdChangeSubpicture),

  FXMAPFUNC(SEL_COMMAND,        DVDWindow::ID_CROP,                 DVDWindow::onCmdCrop),
  FXMAPFUNC(SEL_UPDATE,         DVDWindow::ID_CROP,                 DVDWindow::onUpdCrop),

  FXMAPFUNC(SEL_COMMAND,        DVDWindow::ID_SCREENSHOT,           DVDWindow::onCmdScreenShot),
  FXMAPFUNC(SEL_UPDATE,         DVDWindow::ID_SCREENSHOT,           DVDWindow::onUpdScreenShot),

  FXMAPFUNC(SEL_COMMAND,        DVDWindow::ID_BROWSE_SCREENSHOTS,   DVDWindow::onCmdBrowseScreenshots),
  FXMAPFUNC(SEL_UPDATE,         DVDWindow::ID_BROWSE_SCREENSHOTS,   DVDWindow::onUpdBrowseScreenshots),

  FXMAPFUNC(SEL_DOUBLECLICKED,  DVDWindow::ID_SCREENSHOT_LIST,      DVDWindow::onCmdShowScreenshot),


  FXMAPFUNC(SEL_COMMAND,        DVDWindow::ID_TITLE_DIALOG,         DVDWindow::onCmdTitleDialog),
  FXMAPFUNC(SEL_UPDATE,         DVDWindow::ID_TITLE_DIALOG,         DVDWindow::onUpdTitleDialog),
  FXMAPFUNC(SEL_CLICKED,        DVDWindow::ID_TITLE_LIST,           DVDWindow::onCmdTitleSelect),



  FXMAPFUNC(SEL_COMMAND,        DVDWindow::ID_TOGGLE_FULLSCREEN,    DVDWindow::onCmdFullScreen),
  FXMAPFUNC(SEL_UPDATE,         DVDWindow::ID_TOGGLE_FULLSCREEN,    DVDWindow::onUpdFullScreen),

  FXMAPFUNC(SEL_COMMAND,        DVDWindow::ID_RAISE_CONTROL,        DVDWindow::onCmdRaiseControl),

  // Update Handlers

  FXMAPFUNCS(SEL_COMMAND,DVDWindow::ID_SHORTCUT_BEGIN,DVDWindow::ID_SHORTCUT_LAST,DVDWindow::onCmdEditShortCut),


  //Slide Handlers
  FXMAPFUNC(SEL_CHANGED,          DVDWindow::ID_SLIDER,               DVDWindow::onChgSlider),
  FXMAPFUNC(SEL_COMMAND,          DVDWindow::ID_SLIDER,               DVDWindow::onCmdTimePlay),
  FXMAPFUNC(SEL_UPDATE,           DVDWindow::ID_SLIDER,               DVDWindow::onUpdSlider),
  FXMAPFUNC(SEL_LEFTBUTTONPRESS,  DVDWindow::ID_SLIDER,               DVDWindow::onSliderPress),
  FXMAPFUNC(SEL_LEFTBUTTONRELEASE,DVDWindow::ID_SLIDER,               DVDWindow::onSliderRelease),

  FXMAPFUNC(SEL_COMMAND,        DVDWindow::ID_OPTIONS,              DVDWindow::onCmdOptions),

  FXMAPFUNC(SEL_COMMAND,        DVDWindow::ID_ASPECT_RATIO,           DVDWindow::onCmdAspectRatio),


  FXMAPFUNC(SEL_COMMAND,        DVDWindow::ID_POPUP_MENU,           DVDWindow::onCmdMenuPopup),

  FXMAPFUNC(SEL_COMMAND,        DVDWindow::ID_GETBOOKMARKDIR,       DVDWindow::onCmdSelectDirectory),
  FXMAPFUNC(SEL_COMMAND,        DVDWindow::ID_GETDVDROOTDIR,        DVDWindow::onCmdSelectDirectory),

  FXMAPFUNC(SEL_COMMAND,        DVDWindow::ID_BOOKMARK,             DVDWindow::onCmdBookmark),
  FXMAPFUNC(SEL_DOUBLECLICKED,  DVDWindow::ID_PICTUREMARK,          DVDWindow::onCmdPicturemark),

  FXMAPFUNC(SEL_COMMAND,        DVDWindow::ID_ADD_BOOKMARK,         DVDWindow::onCmdAddBookmark),
  FXMAPFUNC(SEL_UPDATE,         DVDWindow::ID_ADD_BOOKMARK,         DVDWindow::onUpdAddBookmark),

  FXMAPFUNC(SEL_COMMAND,        DVDWindow::ID_CLEAR_BOOKMARKS,      DVDWindow::onCmdClearBookmarks),
  FXMAPFUNC(SEL_UPDATE,         DVDWindow::ID_CLEAR_BOOKMARKS,      DVDWindow::onUpdClearBookmarks),

  FXMAPFUNC(SEL_COMMAND,        DVDWindow::ID_BROWSE_BOOKMARKS,      DVDWindow::onCmdBrowseBookmarks),
  FXMAPFUNC(SEL_UPDATE,         DVDWindow::ID_BROWSE_BOOKMARKS,      DVDWindow::onUpdBrowseBookmarks),


  FXMAPFUNC(SEL_COMMAND,        DVDWindow::ID_REPEAT_CHAPTER,       DVDWindow::onCmdRepeatChapter),
  FXMAPFUNC(SEL_UPDATE,         DVDWindow::ID_REPEAT_CHAPTER,       DVDWindow::onUpdRepeatChapter),

  };


// Object implementation
FXIMPLEMENT(DVDWindow,FXMainWindow,DVDWindowMap,ARRAYNUMBER(DVDWindowMap))

#define AUDIO_OFF 15
#define SUBPICTURE_OFF 63



#define TIMEOUT 1000

FXWindow * targetwindow;
FXbool popupwindow;
FXEvent  popupevent;
FXbool doCrop;


class FXRoundedFrame : public FXVerticalFrame {
    FXDECLARE(FXRoundedFrame)
public:
    long onPaint(FXObject*,FXSelector,void*);    
protected:
  FXRoundedFrame(){}
private:
  FXRoundedFrame(const FXRoundedFrame&);
  FXRoundedFrame& operator=(const FXRoundedFrame&);    
public:
    FXRoundedFrame(FXComposite *c,FXuint opts);
    virtual ~FXRoundedFrame();

};


FXDEFMAP(FXRoundedFrame) FXRoundedFrameMap[]={
	FXMAPFUNC(SEL_PAINT,0,FXRoundedFrame::onPaint),
	};

FXIMPLEMENT(FXRoundedFrame,FXVerticalFrame,FXRoundedFrameMap,ARRAYNUMBER(FXRoundedFrameMap));

FXRoundedFrame::FXRoundedFrame(FXComposite*c,FXuint opts) : FXVerticalFrame(c,opts,0,0,0,0,3,3,0,0) {
    }
    
FXRoundedFrame::~FXRoundedFrame(){
    }
    
long FXRoundedFrame::onPaint(FXObject*,FXSelector,void*ptr){
  FXEvent *ev=(FXEvent*)ptr;
  FXDCWindow dc(this,ev);
  dc.setForeground(FXRGB(255,255,255));
  //dc.fillRectangle(ev->rect.x,ev->rect.y,ev->rect.w,ev->rect.h);
  dc.fillRectangle(0,0,width,height);
  
  
  dc.setForeground(FXRGB(104,117,105));  
  dc.fillRoundRectangle(0,0,width-1,height-1,4,4); 

  dc.setForeground(FXRGB(104,117,105));  
  dc.drawRoundRectangle(0,0,width-1,height-1,4,4); 


  //drawFrame(dc,0,0,width-1,height-1);
  return 1;
  }

//----------------------------------------------------------------------------------
// Constructor
//----------------------------------------------------------------------------------
DVDWindow::DVDWindow(FXApp* a):FXMainWindow(a,"Goggles",NULL,NULL,DECOR_TITLE|DECOR_MINIMIZE|DECOR_MAXIMIZE|DECOR_CLOSE|DECOR_BORDER|DECOR_MENU|DECOR_RESIZE,10,10,0,0,0,0,0,0) {

  /// Init State Variables
  fullscreen=FALSE;
  pause=FALSE;
  is_seeking=FALSE;
  fspeed=1.0;
  bspeed=1.0;
  navigator=NULL;
  current_time=0;
  total_time=0;
  uop=(DVDUOP_t)0;
  popupwindow=FALSE;
  doCrop=FALSE;
  dvd_started=FALSE;
  show_info=TRUE;
  dvdbookmark=NULL;
  last_title=-1;
  last_chapter=-1;
  aspectmode=0;
  disable_dpms=FALSE;
  disable_screensaver=FALSE;
  usercommand=FALSE;

  autobookmark=NULL;

  screensaver_manager = new FXScreenSaver(getApp());
  dpms_manager = new FXDPMS(getApp());


  // Audio Menu Setup
  audio_id=AUDIO_OFF;
  audio_target.connect(audio_id);
  audio_target.setTarget(this);
  audio_target.setSelector(DVDWindow::ID_CHANGE_AUDIO);

  // Subpicture Menu Setup
  subpicture_id=SUBPICTURE_OFF;
  subpicture_target.connect(subpicture_id);
  subpicture_target.setTarget(this);
  subpicture_target.setSelector(DVDWindow::ID_CHANGE_SUBPICTURE);

  // Angle Menu Setup
  angle_id=0;
  angle_target.connect(angle_id);
  angle_target.setTarget(this);
  angle_target.setSelector(DVDWindow::ID_CHANGE_ANGLE);

  // Create Icons
  createIcons();

  // Set myself as the target
  setTarget(this);
  setSelector(ID_SELF);

  FXFontDesc fontdescription;
  getApp()->getNormalFont()->getFontDesc(fontdescription);
  fontdescription.weight += 200;
  font_display = new FXFont(getApp(),fontdescription);
  font_display->create();


  new FXToolTip(getApp());

  const FXuint toolbarstyle=FRAME_RAISED|BUTTON_TOOLBAR;

  // Make menu bar
  FXMenuBar * menubar = new FXMenuBar(this,LAYOUT_SIDE_TOP|LAYOUT_FILL_X|FRAME_RAISED);

 
  FXHorizontalFrame * play_frame = new FXHorizontalFrame(this,LAYOUT_SIDE_BOTTOM|LAYOUT_FILL_X|FRAME_RAISED,0,0,0,0);
  new FXButton(play_frame,"\tPlay",icon_play,this,ID_PLAY,toolbarstyle);
  new FXButton(play_frame,"\tPause",icon_pause,this,ID_PAUSE,toolbarstyle);
  new FXVerticalSeparator(play_frame);
  new FXButton(play_frame,"\tSingle Click - Skip to beginning of current chapter\nDouble Click - Skip to beginning of previous chapter",icon_sprevious,this,ID_PREVIOUS,toolbarstyle);
  new FXButton(play_frame,"\tSearch Back",icon_previous,this,ID_SEARCH_BACKWARD,toolbarstyle);
  new FXButton(play_frame,"\tSearch Forward",icon_next,this,ID_SEARCH_FORWARD,toolbarstyle);
  new FXButton(play_frame,"\tSkip to next Chapter",icon_snext,this,ID_NEXT,toolbarstyle);
  new FXVerticalSeparator(play_frame);

  progressbar=new FXSlider(play_frame,this,DVDWindow::ID_SLIDER,LAYOUT_CENTER_Y|LAYOUT_FILL_X);
  progressbar->setRange(0,100);
  progressbar->setValue(0);

  /// BEGIN OF MENU


  // File Menu
  filemenu=new FXMenuPane(this);
  new FXMenuTitle(menubar,"&File",NULL,filemenu);
  new FXMenuCommand(filemenu,"&Open...",NULL,this,ID_OPEN);
  new FXMenuSeparator(filemenu);
  new FXMenuCommand(filemenu,"&Quit\tCtrl-Q\tQuit the application.",icon_exit,this,DVDWindow::ID_QUIT);

  getAccelTable()->addAccel(fxparseAccel("ctrl-Q"),this,FXSEL(SEL_COMMAND,DVDWindow::ID_QUIT));

  bookmarkmenu = new FXMenuPane(this,POPUP_VERTICAL|POPUP_SHRINKWRAP|FRAME_RAISED|FRAME_THICK);
  new FXMenuCommand(bookmarkmenu,"&Browse Bookmarks...",NULL,this,DVDWindow::ID_BROWSE_BOOKMARKS);
  FXMenuSeparator * booksep=new FXMenuSeparator(bookmarkmenu);
  booksep->setTarget(this);
  booksep->setSelector(ID_CLEAR_BOOKMARKS);
  new FXMenuCommand(bookmarkmenu,"&Set Bookmark",icon_bookset,this,ID_ADD_BOOKMARK);
  new FXMenuCommand(bookmarkmenu,"&Clear Bookmarks",icon_bookdel,this,ID_CLEAR_BOOKMARKS);
  booksep=new FXMenuSeparator(bookmarkmenu);
  booksep->setTarget(this);
  booksep->setSelector(ID_CLEAR_BOOKMARKS);

  // Option Menu
  optionmenu=new FXMenuPane(this);
  new FXMenuTitle(menubar,"&Options",NULL,optionmenu);
  new FXMenuCheck(optionmenu,"&Fullscreen",this,ID_TOGGLE_FULLSCREEN);
  new FXMenuCommand(optionmenu,"&Hide Goggles",NULL,this,FXWindow::ID_LOWER);
  new FXMenuCommand(optionmenu,"&Browse Screenshots...",NULL,this,DVDWindow::ID_BROWSE_SCREENSHOTS);
  new FXMenuSeparator(optionmenu);
  new FXMenuCommand(optionmenu,"&Preferences...",NULL,this,DVDWindow::ID_OPTIONS);


  // Help Menu
  helpmenu=new FXMenuPane(this);
  new FXMenuTitle(menubar,"&Help",NULL,helpmenu,LAYOUT_RIGHT);
  new FXMenuCommand(helpmenu,"&About Goggles...",NULL,this,DVDWindow::ID_ABOUT);



  // Audio Menu
  audiomenu=new FXMenuPane(this,POPUP_VERTICAL|POPUP_SHRINKWRAP|FRAME_RAISED|FRAME_THICK);
  new FXMenuCaption(audiomenu,"None");

  // Subpicture Menu
  subpicturemenu=new FXMenuPane(this,POPUP_VERTICAL|POPUP_SHRINKWRAP|FRAME_RAISED|FRAME_THICK);
  new FXMenuCaption(subpicturemenu,"None");

  // Angle Menu
  anglemenu=new FXMenuPane(this,POPUP_VERTICAL|POPUP_SHRINKWRAP|FRAME_RAISED|FRAME_THICK);
  new FXMenuCaption(subpicturemenu,"None");




  // Goto Menu
  gotomenu=new FXMenuPane(this,POPUP_VERTICAL|POPUP_SHRINKWRAP|FRAME_RAISED|FRAME_THICK);
//  new FXMenuTitle(menubar,"&Goto",icon_goto,gotomenu);
  new FXMenuCommand(gotomenu,"&Root Menu",icon_goroot,this,DVDWindow::ID_MENU_ROOT);
  new FXMenuCommand(gotomenu,"&Title Menu",icon_bookclose_menu,this,DVDWindow::ID_MENU_TITLE);
  new FXMenuCommand(gotomenu,"&Subpicture Menu",icon_subpicture,this,DVDWindow::ID_MENU_SUBPICTURE);
  new FXMenuCommand(gotomenu,"&Audio Menu",icon_audio,this,DVDWindow::ID_MENU_AUDIO);
  new FXMenuCommand(gotomenu,"A&ngle Menu",icon_angle,this,DVDWindow::ID_MENU_ANGLE);
  new FXMenuCommand(gotomenu,"&Chapter Menu",icon_bookopen_menu,this,DVDWindow::ID_MENU_PART);

  FXMatrix * settingsframe = new FXMatrix(this,9,LAYOUT_SIDE_TOP|MATRIX_BY_COLUMNS|LAYOUT_FILL_X|PACK_UNIFORM_HEIGHT|PACK_UNIFORM_WIDTH,0,0,0,0, 0,0,0,0,0,0);
  new FXMenuButton(settingsframe,"\tGoto...\tGoto ..",icon_goto,gotomenu,FRAME_RAISED|JUSTIFY_CENTER_X|TEXT_BELOW_ICON|MENUBUTTON_DOWN);
  new FXButton(settingsframe,"\tChapter - Title Browser\tChapter - Title Browser",icon_bookopen_menu,this,ID_TITLE_DIALOG,FRAME_RAISED|TEXT_BELOW_ICON|JUSTIFY_CENTER_X);
  new FXMenuButton(settingsframe,"\tBookmarks\tBookmarks",icon_bookset,bookmarkmenu,FRAME_RAISED|JUSTIFY_CENTER_X|TEXT_BELOW_ICON|MENUBUTTON_DOWN);
  audiotitle=new FXMenuButton(settingsframe,"\tSelect Audio Stream\tSelect Audio Stream",icon_audio,audiomenu,FRAME_RAISED|JUSTIFY_CENTER_X|TEXT_BELOW_ICON|MENUBUTTON_DOWN);
  subpicturetitle = new FXMenuButton(settingsframe,"\tSelect Subpicture Stream\tSelect Subpicture Stream",icon_subpicture,subpicturemenu,FRAME_RAISED|JUSTIFY_CENTER_X|TEXT_BELOW_ICON|MENUBUTTON_DOWN);
  angletitle = new FXMenuButton(settingsframe,"\tSelect Angle\tSelect Angle",icon_angle,anglemenu,FRAME_RAISED|JUSTIFY_CENTER_X|TEXT_BELOW_ICON|MENUBUTTON_DOWN);
  new FXButton(settingsframe,"\tTake Screenshot\tTake Screenshot",icon_screenshot,this,ID_SCREENSHOT,FRAME_RAISED|TEXT_BELOW_ICON|JUSTIFY_CENTER_X|JUSTIFY_CENTER_Y);
  new FXButton(settingsframe,"\tOne Click: Repeat Chapter\nTwo Click: Repeat Title\nThree Click: Repeat Off",icon_repeat,this,DVDWindow::ID_REPEAT_CHAPTER,FRAME_RAISED|TEXT_BELOW_ICON|JUSTIFY_CENTER_X|JUSTIFY_CENTER_Y);

  new FXFrame(settingsframe,LAYOUT_FILL_X|LAYOUT_FILL_COLUMN|FRAME_RAISED);

  audiotitle->disable();
  subpicturetitle->disable();
  angletitle->disable();


  displayswitcher= new FXSwitcher(this,LAYOUT_FILL_X|LAYOUT_FILL_Y,0,0,0,0,0,0,0,0);
  FXImageFrame * imgframe = new  FXImageFrame(displayswitcher,img_gogglessmall,LAYOUT_FILL_X|LAYOUT_FILL_Y|FRAME_RAISED);
  imgframe->setBackColor(FXRGB(255,255,255));


  FXVerticalFrame * main= new FXVerticalFrame(displayswitcher,LAYOUT_FILL_X|LAYOUT_FILL_Y|FRAME_RAISED,0,0,0,0,0,0,0,0,0,0);




  FXHorizontalFrame* infoframe    =new FXHorizontalFrame(main,LAYOUT_FILL_X|LAYOUT_FILL_Y,0,0,0,0,0,0,0,0,0,0);

  FXVerticalFrame* infoframe2    =new FXVerticalFrame(infoframe,LAYOUT_FILL_X|LAYOUT_FILL_Y,0,0,0,0,5,5,5,5,0,0);
  infoframe2->setBackColor(FXRGB(255,255,255));


  FXLabel * label =NULL; 


  FXHorizontalFrame *  clockframe = new FXHorizontalFrame(infoframe2,LAYOUT_FILL_X|LAYOUT_FILL_Y|FRAME_NONE,0,0,0,0,0,0,0,0);

  label = new FXLabel(clockframe,"title",NULL,JUSTIFY_BOTTOM|LAYOUT_FILL_Y);
  label->setBackColor(FXRGB(255,255,255));
  titlelabel = new FX7Segment(clockframe," ",SEVENSEGMENT_SHADOW|JUSTIFY_BOTTOM|JUSTIFY_LEFT|LAYOUT_FILL_Y);
  titlelabel->setBackColor(FXRGB(255,255,255));
  titlelabel->setTextColor(FXRGB(104,117,105));

  label = new FXLabel(clockframe,"chapter",NULL,JUSTIFY_BOTTOM|LAYOUT_FILL_Y);
  label->setBackColor(FXRGB(255,255,255));
  chapterlabel = new FX7Segment(clockframe," ",SEVENSEGMENT_SHADOW|JUSTIFY_BOTTOM|JUSTIFY_LEFT|LAYOUT_FILL_Y);
  chapterlabel->setBackColor(FXRGB(255,255,255));
  chapterlabel->setTextColor(FXRGB(104,117,105));

  label = new FXLabel(clockframe,"time",NULL,JUSTIFY_BOTTOM|LAYOUT_FILL_Y|LAYOUT_FILL_X|JUSTIFY_RIGHT);
  label->setBackColor(FXRGB(255,255,255));
  infolabel  =new FX7Segment(clockframe,"--:--:--",SEVENSEGMENT_SHADOW|LAYOUT_FILL_Y|JUSTIFY_BOTTOM|JUSTIFY_RIGHT);
	infolabel->setCellWidth(24);
	infolabel->setCellHeight(30);
  infolabel->setThickness(4);
  infolabel->setBackColor(FXRGB(255,255,255));
  infolabel->setTextColor(FXRGB(104,117,105));


  clockframe->setBackColor(FXRGB(255,255,255));


  new FXSeparator(infoframe2,LAYOUT_FILL_X|SEPARATOR_LINE);

  FXHorizontalFrame * titleframe = new FXHorizontalFrame(infoframe2,LAYOUT_FILL_X,0,0,0,0,0,0);

  titleframe->setBackColor(FXRGB(255,255,255));

  FXRoundedFrame * rframe;
  rframe = new FXRoundedFrame(titleframe,LAYOUT_NORMAL);

  audiolanglabel = new FXLabel(rframe,"English",NULL,LAYOUT_FILL_X|JUSTIFY_LEFT|TEXT_AFTER_ICON,0,0,0,0);
  audiolanglabel->setBackColor(FXRGB(104,117,105));
  audiolanglabel->setFont(font_display);
  audiolanglabel->setTextColor(FXRGB(255,255,255));

  rframe = new FXRoundedFrame(titleframe,LAYOUT_NORMAL);
  audiolabel = new FXLabel(rframe,"Dolby Digital",NULL,LAYOUT_FILL_X|JUSTIFY_LEFT|TEXT_AFTER_ICON,0,0,0,0);
  audiolabel->setBackColor(FXRGB(104,117,105));
  audiolabel->setFont(font_display);
  audiolabel->setTextColor(FXRGB(255,255,255));

  rframe = new FXRoundedFrame(titleframe,LAYOUT_NORMAL);
  audioextlabel = new FXLabel(rframe,"5.1",NULL,LAYOUT_FILL_X|JUSTIFY_LEFT|TEXT_AFTER_ICON,0,0,0,0);
  audioextlabel->setBackColor(FXRGB(104,117,105));
  audioextlabel->setFont(font_display);
  audioextlabel->setTextColor(FXRGB(255,255,255));

  audioextlabelframe=rframe;

  rframe = new FXRoundedFrame(titleframe,LAYOUT_NORMAL|LAYOUT_RIGHT);
  speedlabel = new FXLabel(rframe," 1 ",NULL,LAYOUT_RIGHT|LAYOUT_FILL_X|JUSTIFY_LEFT|TEXT_AFTER_ICON,0,0,0,0);
  speedlabel->setBackColor(FXRGB(104,117,105));
  speedlabel->setFont(font_display);
  speedlabel->setTextColor(FXRGB(255,255,255));

  titleframe = new FXHorizontalFrame(infoframe2,LAYOUT_FILL_X,0,0,0,0,0,0,0);
  titleframe->setBackColor(FXRGB(255,255,255));
  rframe = new FXRoundedFrame(titleframe,LAYOUT_NORMAL);
  subtitlelabel = new FXLabel(rframe,"Nederlands",NULL,LAYOUT_FILL_X|JUSTIFY_LEFT|TEXT_AFTER_ICON,0,0,0,0);
  subtitlelabel->setBackColor(FXRGB(104,117,105));
  subtitlelabel->setFont(font_display);
  subtitlelabel->setTextColor(FXRGB(255,255,255));

  subtitlelabelframe = (FXWindow*)rframe;


  label = new FXLabel(titleframe," ",NULL,LAYOUT_FILL_X);
  label->setBackColor(FXRGB(255,255,255));



  rframe = new FXRoundedFrame(titleframe,LAYOUT_NORMAL|LAYOUT_RIGHT);
  repeatexlabel = new FXLabel(rframe,"All",NULL,LAYOUT_RIGHT|LAYOUT_FILL_X|JUSTIFY_LEFT|TEXT_AFTER_ICON,0,0,0,0);
  repeatexlabel->setBackColor(FXRGB(104,117,105));
  repeatexlabel->setFont(font_display);
  repeatexlabel->setTextColor(FXRGB(255,255,255));
  repeatexlabelframe=(FXWindow*)rframe;

  rframe = new FXRoundedFrame(titleframe,LAYOUT_NORMAL|LAYOUT_RIGHT);
  repeatlabel = new FXLabel(rframe,"Repeat",NULL,LAYOUT_RIGHT|LAYOUT_FILL_X|JUSTIFY_LEFT|TEXT_AFTER_ICON,0,0,0,0);
  repeatlabel->setBackColor(FXRGB(104,117,105));
  repeatlabel->setFont(font_display);
  repeatlabel->setTextColor(FXRGB(255,255,255));
  repeatlabelframe=(FXWindow*)rframe;


  repeatexlabelframe->hide();
  repeatlabelframe->hide();
  }


//----------------------------------------------------------------------------------
// Destructor
//----------------------------------------------------------------------------------
DVDWindow::~DVDWindow(){  
  delete font_display;
  delete filemenu;
  delete optionmenu;
  delete gotomenu;
  delete audiomenu;
  delete anglemenu;
  delete subpicturemenu;
  delete helpmenu;
  delete bookmarkmenu;
  deleteIcons();
  }


//----------------------------------------------------------------------------------
// Create
//----------------------------------------------------------------------------------
void DVDWindow::create(){
  readRegistry();

  FXMainWindow::create();
  show(PLACEMENT_SCREEN);
  targetwindow=this;

  if (disable_dpms) dpms_manager->disable();
  if (disable_screensaver) screensaver_manager->disable();
  if (start_dvd) openDVD();
  }

//----------------------------------------------------------------------------------
// Create Icons
//----------------------------------------------------------------------------------
void DVDWindow::createIcons(){
  icon_play       =new FXGIFIcon(getApp(),right_gif);
  icon_pause      =new FXGIFIcon(getApp(),pause_gif);
  icon_next       =new FXGIFIcon(getApp(),next_gif);
  icon_previous   =new FXGIFIcon(getApp(),prev_gif);
  icon_snext      =new FXGIFIcon(getApp(),skipnext_gif);
  icon_sprevious  =new FXGIFIcon(getApp(),skipprev_gif);
  icon_exit       =new FXGIFIcon(getApp(),exit_gif);
  icon_bookset    =new FXGIFIcon(getApp(),bookset_gif);
  icon_bookdel    =new FXGIFIcon(getApp(),bookdel_gif);
  icon_goroot     =new FXPNGIcon(getApp(),gohome_png);
  icon_goto       =new FXPNGIcon(getApp(),goto_png);
  icon_angle      =new FXPNGIcon(getApp(),angle_png);
  icon_subpicture =new FXPNGIcon(getApp(),subpicture_png);
  icon_audio      =new FXPNGIcon(getApp(),audio_png);
  icon_dvdsmall   =new FXPNGIcon(getApp(),dvd_small_png);
  icon_clock      =new FXPNGIcon(getApp(),clock_png);
  icon_screenshot =new FXPNGIcon(getApp(),frame_image_png);
  icon_repeat     = new FXPNGIcon(getApp(),reload_png);

  icon_bookopen   =new FXPNGIcon(getApp(),bookopen_png);
  icon_bookclose  =new FXPNGIcon(getApp(),bookclose_png);
  icon_bookopen_menu   =new FXPNGIcon(getApp(),bookopen_png);
  icon_bookclose_menu  =new FXPNGIcon(getApp(),bookclose_png);

  icon_logo=new FXPNGIcon(getApp(),goggleslogosmall_png);
  img_gogglessmall     =new FXPNGImage(getApp(),goggles_default_png);


  FXColor basecolor = getApp()->getBaseColor();
  icon_goroot->blend(basecolor);
  icon_goto->blend(basecolor);
  icon_bookopen->blend(FXRGB(255,255,255));
  icon_bookclose->blend(FXRGB(255,255,255));
  icon_bookopen_menu->blend(basecolor);
  icon_bookclose_menu->blend(basecolor);
  icon_angle->blend(basecolor);
  icon_audio->blend(basecolor);
  icon_screenshot->blend(basecolor);
  icon_dvdsmall->blend(FXRGB(255,255,255));
  icon_clock->blend(FXRGB(255,255,255));
  icon_subpicture->blend(basecolor);
  icon_repeat->blend(basecolor);
  }

//----------------------------------------------------------------------------------
// Destroy Icons
//----------------------------------------------------------------------------------
void DVDWindow::deleteIcons(){
  delete img_gogglessmall;
  delete icon_logo;
  delete icon_play;
  delete icon_pause;
  delete icon_next;
  delete icon_snext;
  delete icon_previous;
  delete icon_sprevious;
  delete icon_exit;
  delete icon_goto;
  delete icon_goroot;
  delete icon_bookclose_menu;
  delete icon_bookclose;
  delete icon_bookopen_menu;
  delete icon_bookopen;
  delete icon_angle;
  delete icon_subpicture;
  delete icon_audio;
  delete icon_bookset;
  delete icon_bookdel;
  delete icon_dvdsmall;
  delete icon_clock;
  delete icon_repeat;
  }


//----------------------------------------------------------------------------------
// Read the registry - FIXME add last window position
//----------------------------------------------------------------------------------
void DVDWindow::readRegistry(){

  initLanguageNames();
  initCountryNames();

  // Get Settings
  dvdroot=getApp()->reg().readStringEntry("OGLE","dvdroot",DEFAULT_DVD_DEVICE);
  bookmarkdir=getApp()->reg().readStringEntry("OGLE","bookmarkdir","");
  auto_show=getApp()->reg().readIntEntry("OGLE","autoshow",0);
  auto_disable=getApp()->reg().readIntEntry("OGLE","autodisable",1);
  auto_bookmark=getApp()->reg().readIntEntry("OGLE","autobookmark",0);
  auto_audiostream=getApp()->reg().readIntEntry("OGLE","autoaudiostream",1);
  disable_dpms=getApp()->reg().readIntEntry("OGLE","dpms",0);
  disable_screensaver=getApp()->reg().readIntEntry("OGLE","screensaver",0);
  filter_subpicture_entry=getApp()->reg().readIntEntry("OGLE","filtersubpicture",1);
  start_dvd=getApp()->reg().readIntEntry("OGLE","autostart",0);
  start_fullscreen=getApp()->reg().readIntEntry("OGLE","startfullscreen",0);
  screenshot_with_spu=getApp()->reg().readIntEntry("OGLE","screenshot_with_spu",0);
  play_last_session=getApp()->reg().readIntEntry("OGLE","play_last_session",1);
  aspectmode=getApp()->reg().readIntEntry("OGLE","aspectratio",0);


  // Read in Shortcuts
  getAccelTable()->addAccel(fxparseAccel(getApp()->reg().readStringEntry("HotKeys","Fullscreen",DEFAULT_SHORTCUT_FULLSCREEN)),this,FXSEL(SEL_COMMAND,ID_TOGGLE_FULLSCREEN));
  getAccelTable()->addAccel(fxparseAccel(getApp()->reg().readStringEntry("HotKeys","Pause",DEFAULT_SHORTCUT_PAUSE)),this,FXSEL(SEL_COMMAND,ID_PAUSE));
  getAccelTable()->addAccel(fxparseAccel(getApp()->reg().readStringEntry("HotKeys","Stop",DEFAULT_SHORTCUT_STOP)),this,FXSEL(SEL_COMMAND,ID_STOP));
  getAccelTable()->addAccel(fxparseAccel(getApp()->reg().readStringEntry("HotKeys","Raise",DEFAULT_SHORTCUT_RAISE)),this,FXSEL(SEL_COMMAND,ID_RAISE_CONTROL));
  getAccelTable()->addAccel(fxparseAccel(getApp()->reg().readStringEntry("HotKeys","Next",DEFAULT_SHORTCUT_NEXT)),this,FXSEL(SEL_COMMAND,ID_NEXT));
  getAccelTable()->addAccel(fxparseAccel(getApp()->reg().readStringEntry("HotKeys","Previous",DEFAULT_SHORTCUT_PREVIOUS)),this,FXSEL(SEL_COMMAND,ID_PREVIOUS));
  getAccelTable()->addAccel(fxparseAccel(getApp()->reg().readStringEntry("HotKeys","TitleMenu",DEFAULT_SHORTCUT_TITLEMENU)),this,FXSEL(SEL_COMMAND,ID_MENU_TITLE));
  getAccelTable()->addAccel(fxparseAccel(getApp()->reg().readStringEntry("HotKeys","RootMenu",DEFAULT_SHORTCUT_ROOTMENU)),this,FXSEL(SEL_COMMAND,ID_MENU_ROOT));
  getAccelTable()->addAccel(fxparseAccel(getApp()->reg().readStringEntry("HotKeys","AudioMenu",DEFAULT_SHORTCUT_AUDIOMENU)),this,FXSEL(SEL_COMMAND,ID_MENU_AUDIO));
  getAccelTable()->addAccel(fxparseAccel(getApp()->reg().readStringEntry("HotKeys","AngleMenu",DEFAULT_SHORTCUT_ANGLEMENU)),this,FXSEL(SEL_COMMAND,ID_MENU_ANGLE));
  getAccelTable()->addAccel(fxparseAccel(getApp()->reg().readStringEntry("HotKeys","SubtitleMenu",DEFAULT_SHORTCUT_SUBPICTUREMENU)),this,FXSEL(SEL_COMMAND,ID_MENU_SUBPICTURE));
  getAccelTable()->addAccel(fxparseAccel(getApp()->reg().readStringEntry("HotKeys","SearchForward",DEFAULT_SHORTCUT_SEARCHFORWARD)),this,FXSEL(SEL_COMMAND,ID_SEARCH_FORWARD));
  getAccelTable()->addAccel(fxparseAccel(getApp()->reg().readStringEntry("HotKeys","SearchBackward",DEFAULT_SHORTCUT_SEARCHBACKWARD)),this,FXSEL(SEL_COMMAND,ID_SEARCH_BACKWARD));
  getAccelTable()->addAccel(fxparseAccel(getApp()->reg().readStringEntry("HotKeys","Enter",DEFAULT_SHORTCUT_ENTER)),this,FXSEL(SEL_COMMAND,ID_ENTER));
  getAccelTable()->addAccel(fxparseAccel(getApp()->reg().readStringEntry("HotKeys","NavUp",DEFAULT_SHORTCUT_NAVUP)),this,FXSEL(SEL_COMMAND,ID_NAV_UP));
  getAccelTable()->addAccel(fxparseAccel(getApp()->reg().readStringEntry("HotKeys","NavDown",DEFAULT_SHORTCUT_NAVDOWN)),this,FXSEL(SEL_COMMAND,ID_NAV_DOWN));
  getAccelTable()->addAccel(fxparseAccel(getApp()->reg().readStringEntry("HotKeys","NavLeft",DEFAULT_SHORTCUT_NAVLEFT)),this,FXSEL(SEL_COMMAND,ID_NAV_LEFT));
  getAccelTable()->addAccel(fxparseAccel(getApp()->reg().readStringEntry("HotKeys","NavRight",DEFAULT_SHORTCUT_NAVRIGHT)),this,FXSEL(SEL_COMMAND,ID_NAV_RIGHT));
  getAccelTable()->addAccel(fxparseAccel(getApp()->reg().readStringEntry("HotKeys","SnapShot",DEFAULT_SHORTCUT_SNAPSHOT)),this,FXSEL(SEL_COMMAND,ID_SCREENSHOT));

  }


//----------------------------------------------------------------------------------
// Write the registry - FIXME add last window position
//----------------------------------------------------------------------------------
void DVDWindow::writeRegistry(){
  getApp()->reg().writeStringEntry("OGLE","bookmarkdir",bookmarkdir.text());
  getApp()->reg().writeStringEntry("OGLE","dvdroot",dvdroot.text());
  getApp()->reg().writeIntEntry("OGLE","autoshow",auto_show);
  getApp()->reg().writeIntEntry("OGLE","autodisable",auto_disable);
  getApp()->reg().writeIntEntry("OGLE","dpms",disable_dpms);
  getApp()->reg().writeIntEntry("OGLE","screensaver",disable_screensaver);
  getApp()->reg().writeIntEntry("OGLE","startfullscreen",start_fullscreen);
  getApp()->reg().writeIntEntry("OGLE","autostart",start_dvd);
  getApp()->reg().writeIntEntry("OGLE","autobookmark",auto_bookmark);
  getApp()->reg().writeIntEntry("OGLE","filtersubpicture",filter_subpicture_entry);
  getApp()->reg().writeIntEntry("OGLE","autoaudiostream",auto_audiostream);
  getApp()->reg().writeIntEntry("OGLE","screenshot_with_spu",screenshot_with_spu);
  getApp()->reg().writeIntEntry("OGLE","play_last_session",play_last_session);
  getApp()->reg().writeIntEntry("OGLE","aspectratio",aspectmode);
  }


//----------------------------------------------------------------------------------
// NET WM Hints
//----------------------------------------------------------------------------------
void DVDWindow::setNETProperty(){
/*
  if (checkNETSupport()){
    Atom type  = XInternAtom(DISPLAY,"_NET_WM_WINDOW_TYPE",false);
    Atom atom  = XInternAtom(DISPLAY,"_NET_WM_WINDOW_TYPE_NORMAL",false);
    XChangeProperty(DISPLAY,id(),type,XA_ATOM,32,PropModeReplace,(unsigned char *)&atom,1);
    }
*/
  }


/*
  The Window Manager MUST set _NET_SUPPORTING_WM_CHECK property on the root window to be the ID of a child window created by the WM,
  to indicate that a compliant WM is active. The child window MUST also have the _NET_SUPPORTING_WM_CHECK property set
  to the ID of the child window. The child window MUST also have the _NET_WM_NAME property set to the name of the Window Manager.
  Rationale: The child window is used to distinguish an active window manager from a stale _NET_SUPPORTING_WM_CHECK property
  that happens to point to another window. If the _NET_SUPPORTING_WM_CHECK window on the client window is missing or
  not properly set, clients SHOULD assume that no conforming window manager is present.
*/
FXbool DVDWindow::checkNETSupport(){
/*
	FXint format;
  unsigned long nitems;
  unsigned long nbytes;
  FXint * n;
	FXuchar *data=NULL;
  FXString title;

  Window netid;
  Window childid;
  Atom wmcheck    =XInternAtom(DISPLAY,"_NET_SUPPORTING_WM_CHECK",false);
  Atom netwmname  =XInternAtom(DISPLAY,"_NET_WM_NAME",false);
  Atom utf8string =XInternAtom(DISPLAY,"UTF8_STRING",false);
  Atom type;


  if (XGetWindowProperty(DISPLAY,getApp()->getRootWindow()->id(),wmcheck,0,32,false,XA_WINDOW,&type,&format,&nitems,&nbytes,(FXuchar**)&n)==Success){
    netid=*n;
    XFree(n);
    if (XGetWindowProperty(DISPLAY,netid,wmcheck,0,32,false,XA_WINDOW,&type,&format,&nitems,&nbytes,(FXuchar**)&n) == Success){
      childid=*n;
      XFree(n);
      if (childid!=netid) return FALSE;

	    if (XGetWindowProperty(DISPLAY,childid,netwmname,0L,32,false,utf8string,&type,&format,&nitems,&nbytes,(FXuchar**)&data)==Success){
        if ((type==utf8string) && (format==8) && data){
          title = (char*) data;
          XFree(data);
           return TRUE;
          }
        if (data) XFree((FXuchar*)data);
        }
      }
    }
  return FALSE;
*/
  return TRUE;
  }







//----------------------------------------------------------------------------------
// Quit
//----------------------------------------------------------------------------------
long DVDWindow::onCmdQuit(FXObject *,FXSelector sel, void*){
  getApp()->removeTimeout(this,DVDWindow::ID_REFRESH);
  getApp()->removeTimeout(this,DVDWindow::ID_RAISE_TIMER);

  writeRegistry(); /// Write our settings
  saveBookmarks(); /// Save any bookmarks we might have.

  if(navigator && (DVDCloseNav((DVDNav_t*)navigator)!=DVD_E_Ok)){
    fxwarning("Unable to close OGLE!\n");
    return 0;
    }

  targetwindow=NULL;

  delete dpms_manager;
  delete screensaver_manager;

  if (FXSELTYPE(sel)==SEL_CLOSE){
    return 0;
    }
  else {
    getApp()->exit(0);  
    }
///getApp()->handle(this,FXSEL(SEL_COMMAND,FXApp::ID_QUIT),NULL);

  return 1;
  }


//----------------------------------------------------------------------------------
// Open DVD
//----------------------------------------------------------------------------------
FXbool DVDWindow::openDVD(){
  if (navigator && DVDSetDVDRoot((DVDNav_t*)navigator,(char*)dvdroot.text())!=DVD_E_Ok) {
      FXMessageBox::error(this,MBOX_OK,"DVD Error","Unable to open dvd for playing.");
      return FALSE;
      }

  initOgle();

  FXchar volid[33];
  FXint  status;

  if (DVDGetVolumeIdentifiers((DVDNav_t*)navigator,0,&status,volid,NULL)==DVD_E_Ok){
    if (status!=0) {
      setTitle(FXStringFormat("Goggles - %s",volid));
      //dvdidlabel->setText(volid);
      volumeid=volid;
      }
    }

  /// Store the DISC ID
  FXchar dvdid_str[33];

  if (DVDGetDiscID((DVDNav_t*)navigator,dvdid) != DVD_E_Ok){
      FXMessageBox::error(this,MBOX_OK,"DVD Error","Unable to retrieve DVD ID.");
      return FALSE;
      }

  for (FXint i=0;i<16;i++)
    sprintf(&dvdid_str[i*2],"%02x",dvdid[i]);

  dvdid_string=FXStringFormat("%s",dvdid_str);

  initBookmarks();
  getApp()->addTimeout(this,DVDWindow::ID_REFRESH,TIMEOUT);
  dvd_started=TRUE;
  return TRUE;
  }

//----------------------------------------------------------------------------------
// Close DVD - FIXME FUTURE THING
//----------------------------------------------------------------------------------
FXbool DVDWindow::closeDVD(){
  return TRUE;
  }


//----------------------------------------------------------------------------------
// Init Ogle -  Setups various Ogle settings
//----------------------------------------------------------------------------------
void DVDWindow::initOgle(){
  if (!navigator) return;

  DVDPlayerRegion_t   region=getApp()->reg().readIntEntry("OGLE","player region",1);
  if (region > 6) region=1;
  DVDPlayerRegionSelect((DVDNav_t*)navigator,region);

  DVDLangID_t a_lcode=getLanguageCode(getApp()->reg().readStringEntry("OGLE","default audio language",DEFAULTLANGUAGE));
  DVDLangID_t m_lcode=getLanguageCode(getApp()->reg().readStringEntry("OGLE","default menu language",DEFAULTLANGUAGE));
  DVDLangID_t s_lcode=getLanguageCode(getApp()->reg().readStringEntry("OGLE","default subpicture language",DEFAULTLANGUAGE));

  DVDDefaultAudioLanguageSelect((DVDNav_t*)navigator,a_lcode);
  DVDDefaultMenuLanguageSelect((DVDNav_t*)navigator,m_lcode);
  DVDDefaultSubpictureLanguageSelect((DVDNav_t*)navigator,s_lcode);

  DVDCountryID_t p_ccode=getCountryCode(getApp()->reg().readStringEntry("OGLE","parental country",DEFAULTCOUNTRY));
  DVDParentalCountrySelect((DVDNav_t*)navigator,p_ccode);

  DVDParentalLevel_t level=(DVDParentalLevel_t)getApp()->reg().readIntEntry("OGLE","parental level",DVD_PARENTAL_LEVEL_None);
  DVDParentalLevelSelect((DVDNav_t*)navigator,level);

  setAspectRatio(aspectmode);
  }


void DVDWindow::setAspectRatio(FXuint mode){
  FXASSERT(navigator);
  switch(mode){
    case 0: DVDSetAspectModeSrc((DVDNav_t*)navigator,AspectModeSrcVM); break;
    case 1: DVDSetAspectModeSrc((DVDNav_t*)navigator,AspectModeSrcMPEG); break;
    case 2:
            DVDSetAspectModeSrc((DVDNav_t*)navigator,AspectModeSrcUser);
            DVDSetSrcAspect((DVDNav_t*)navigator,AspectModeSrcUser,16,9);
            break;
    case 3:
            DVDSetAspectModeSrc((DVDNav_t*)navigator,AspectModeSrcUser);
            DVDSetSrcAspect((DVDNav_t*)navigator,AspectModeSrcUser,4,3);
            break;
    default:DVDSetAspectModeSrc((DVDNav_t*)navigator,AspectModeSrcVM);
            break;
    }
  }


long DVDWindow::onCmdAspectRatio(FXObject*,FXSelector,void * ptr){
  FXint mode = (FXint)(FXival)ptr;
  aspectmode=mode;
  setAspectRatio(aspectmode);
  return 1;
  }

/*
//----------------------------------------------------------------------------------
// Init Menus - Initialization of the Audio/Angle/Subpicture Menu
//----------------------------------------------------------------------------------

void DVDWindow::initMenus(){
  audiomenu->setTarget(this);
  audiomenu->setSelector(DVDWindow::ID_QUERY_AUDIO_MENU);
  subpicturemenu->setTarget(this);
  subpicturemenu->setSelector(DVDWindow::ID_QUERY_SUBPICTURE_MENU);
  anglemenu->setTarget(this);
  anglemenu->setSelector(DVDWindow::ID_QUERY_ANGLE_MENU);
  }
*/



/// returns TRUE if b has reached a
static FXbool hasReached(DVDTimecode_t * a, DVDTimecode_t * b){
  if (b->Hours > a->Hours) return TRUE;
  else if (b->Hours < a->Hours) return FALSE;
  else if (b->Minutes > a->Minutes) return TRUE;
  else if (b->Minutes < a->Minutes) return FALSE;
  else if (b->Seconds > a->Seconds) return TRUE;
  else if (b->Seconds < a->Seconds) return FALSE;
  else return TRUE;
  }


//----------------------------------------------------------------------------------
// GUI Refresh
//----------------------------------------------------------------------------------
long DVDWindow::onRefresh(FXObject *,FXSelector,void*){

  FXbool updatestate=FALSE;
  DVDResult_t res;
  static DVDDomain_t last_dom=DVD_DOMAIN_Stop;

  if (!navigator || !dvd_started) {
    getApp()->addTimeout(this,DVDWindow::ID_REFRESH,TIMEOUT);
    return 1;
    }


  /// Retrieve Current UOPS
  res = DVDGetCurrentUOPS((DVDNav_t*)navigator,&uop);
  if(res != DVD_E_Ok) {
    DVDPerror("Goggles: DVDGetCurrentUOPS",res);
    getApp()->addTimeout(this,DVDWindow::ID_REFRESH,TIMEOUT);
    return 1;
    }

  /// Retrieve Current Domain
  res = DVDGetCurrentDomain((DVDNav_t*)navigator,&dom);
  if(res != DVD_E_Ok) {
    DVDPerror("Goggles: DVDGetCurrentDomain",res);
    getApp()->addTimeout(this,DVDWindow::ID_REFRESH,TIMEOUT);
    return 1;
    }

  if (dom!=last_dom){
    last_dom=dom;
    updatestate=TRUE;
    if (repeat.on()) {
      if (repeat.user()) {
        if (repeat.command==COMMAND_CHAPTER){ /// Probably never happens here
          repeat.title = location.title;
          repeat.ptt  = location.ptt;
          }
        else if (repeat.command==COMMAND_MENU)
          repeat.mode=DVD_REPEAT_OFF;
          //repeatlabel->setText("Off");
          }
      else {
         if (repeat.mode==DVD_REPEAT_CHAPTER)
           openTitle(repeat.title,repeat.ptt);
         else if (repeat.mode==DVD_REPEAT_TITLE)
           openTitle(repeat.title,1);
          }
      }
    }


  if (dom==DVD_DOMAIN_VTSTitle) {
    displayswitcher->setCurrent(1);
    DVDGetCurrentLocation((DVDNav_t*)navigator,&location);

    /// Handle Repeat
    if (repeat.on()) {
      if (repeat.user()){
        if (repeat.command==COMMAND_CHAPTER){
          repeat.title = location.title;
          repeat.ptt  = location.ptt;
          }
        else if (repeat.command==COMMAND_MENU){ /// probably never happens here
          repeat.mode=DVD_REPEAT_OFF;
          repeatlabelframe->hide();
          repeatexlabelframe->hide();
          //repeatlabel->setText("Off");
          }
        }
      else {
        if ((repeat.mode==DVD_REPEAT_CHAPTER) && (location.ptt!=repeat.ptt) ){
          openTitle(repeat.title,repeat.ptt);

          // Get the new location
          DVDGetCurrentLocation((DVDNav_t*)navigator,&location);
          }
        else if (repeat.mode==DVD_REPEAT_AB) {
          if (hasReached(&repeat.b,&location.title_current) ){
            DVDTimePlay((DVDNav_t*)navigator,repeat.title,repeat.a);
            // Get the new location
            DVDGetCurrentLocation((DVDNav_t*)navigator,&location);
            }
          else {
            fxmessage("Not Reached\n");
            }
         }
}
      }

    titlelabel->setText(FXStringFormat("%d",location.title));
    chapterlabel->setText(FXStringFormat("%.2d",location.ptt));
    if (!is_seeking) {
      infolabel->setText(FXStringFormat("%d:%.2d:%.2d",location.title_current.Hours,location.title_current.Minutes,location.title_current.Seconds));
      }
    speedlabel->setText(FXStringFormat("%gx",fspeed));
//    if (!is_seeking) infolabel->setText(FXStringFormat("%d:%.2d:%.2d of %d:%.2d:%.2d - %gx",location.title_current.Hours,location.title_current.Minutes,location.title_current.Seconds,location.title_total.Hours,location.title_total.Minutes,location.title_total.Seconds,fspeed));
    timeinfo=FXStringFormat("Chapter %.2d - %d:%.2d:%.2d",location.ptt,location.title_current.Hours,location.title_current.Minutes,location.title_current.Seconds);

    FXint total=location.title_total.Seconds+(location.title_total.Minutes*60)+(location.title_total.Hours*3600);
    current_time=location.title_current.Seconds+(location.title_current.Minutes*60)+(location.title_current.Hours*3600);
    progressbar->setRange(0,total);
    //progressbar->setValue(current_time);
    progressbar->enable();

    if (location.ptt!=last_chapter){
      last_chapter=location.ptt;
      updatestate=TRUE;
      }

    if (location.title!=last_title){
       last_title=location.title;
       updatestate=TRUE;
       }

    }
  else {
    displayswitcher->setCurrent(0);
    titlelabel->setText("Title  -- ");
    chapterlabel->setText("Chapter -- ");
    if (!is_seeking) infolabel->setText(" -- -");
    timeinfo="";
    progressbar->setRange(0,100);
    //progressbar->setValue(0);
    progressbar->disable();
    }

  if (auto_disable){

    if (uop&UOP_FLAG_AngleChange)
      angletitle->enable();
    else
      angletitle->disable();

    if (uop&UOP_FLAG_SubPicStreamChange)
      subpicturetitle->enable();
    else
      subpicturetitle->disable();

    if (uop&UOP_FLAG_AudioStreamChange)
      audiotitle->enable();
    else
      audiotitle->disable();

    }
  else {
    audiotitle->enable();
    angletitle->enable();
    subpicturetitle->enable();
    }

  if (updatestate){
    update_subpicture_menu();
    update_audio_menu();
    update_angle_menu();
    }

  if (popupwindow) {
     handle(NULL,FXSEL(SEL_COMMAND,DVDWindow::ID_POPUP_MENU),(void*)&popupevent);
     popupwindow=FALSE;
     }

  repeat.reset();

  /// Add new timer...
  getApp()->addTimeout(this,DVDWindow::ID_REFRESH,TIMEOUT);
  return 1;
  }


//----------------------------------------------------------------------------------
// Dialog Open DVD
//----------------------------------------------------------------------------------
long DVDWindow::onCmdOpen(FXObject *,FXSelector,void*){
  if (dvd_started) return 1;

  FXString dvdroot_backup=dvdroot;

  FXDataTarget target_dvdroot(dvdroot);

  FXDialogBox dialog(this,"Open DVD",DECOR_ALL);
  FXVerticalFrame * main=new FXVerticalFrame(&dialog,LAYOUT_FILL_X|LAYOUT_FILL_Y,0,0,0,0,0,0,0,0);
  new FXLabel(main,"DVD mount point, device or Directory:");
  FXHorizontalFrame* dvdrootframe=new FXHorizontalFrame(main,LAYOUT_FILL_X|LAYOUT_FILL_Y,0,0,0,0,0,0,0,0);
  new FXTextField(dvdrootframe,15,&target_dvdroot,FXDataTarget::ID_VALUE,LAYOUT_FILL_X|FRAME_SUNKEN|FRAME_THICK);
  new FXButton(dvdrootframe,"...\tBrowse",NULL,this,ID_GETDVDROOTDIR);

  // Bottom part
  new FXHorizontalSeparator(main,SEPARATOR_RIDGE|LAYOUT_FILL_X);
  FXHorizontalFrame *closebox=new FXHorizontalFrame(main,LAYOUT_BOTTOM|LAYOUT_FILL_X|PACK_UNIFORM_WIDTH);
  new FXButton(closebox," &Open ",NULL,&dialog,FXDialogBox::ID_ACCEPT,BUTTON_INITIAL|BUTTON_DEFAULT|LAYOUT_RIGHT|FRAME_RAISED|FRAME_THICK,0,0,0,0, 20,20);
  new FXButton(closebox," &Cancel ",NULL,&dialog,FXDialogBox::ID_CANCEL,BUTTON_DEFAULT|LAYOUT_RIGHT|FRAME_RAISED|FRAME_THICK,0,0,0,0, 20,20);

  if (dialog.execute(PLACEMENT_SCREEN)){
    if (dvdroot.empty()) {
      FXMessageBox::error(this,MBOX_OK,"DVD Error","You need to specify the dvd device or directory you want to play from. You can do this in the preferences panel.");
      }
    else {
      openDVD();
      }
    }
  dvdroot=dvdroot_backup;
  return 1;
  }

long DVDWindow::onUpdOpen(FXObject * sender,FXSelector,void*){
  sender->handle(this,dvd_started?FXSEL(SEL_COMMAND,ID_DISABLE):FXSEL(SEL_COMMAND,ID_ENABLE),NULL);
  return 1;
  }







//----------------------------------------------------------------------------------
// Play
//----------------------------------------------------------------------------------
long DVDWindow::onCmdPlay(FXObject*sender,FXSelector selector,void* ptr){
  if (!dvd_started){
    if (dvdroot.empty()) {
      return onCmdOpen(sender,selector,ptr);
      return 1;
      }
    else {
      openDVD();
      }
    return 1;
    }

  DVDResult_t res;

  if (pause) {
    DVDPauseOff((DVDNav_t*)navigator);
    pause=FALSE;
    }

  if ((fspeed!=1.0) || (bspeed!=1.0)) {
    fspeed=bspeed=1.0;
    DVDForwardScan((DVDNav_t*)navigator,fspeed);
    return 1;
    }

/*
  if (pause) {
    DVDPauseOff((DVDNav_t*)navigator);
    pause=FALSE;
    return 1;
    }
*/

  if (uop&UOP_FLAG_Resume){
    res=DVDResume((DVDNav_t*)navigator);
    if (res!=DVD_E_Ok) DVDPerror("DVDResume", res);
    return 1;
    }


  return 1;
  }

long DVDWindow::onUpdPlay(FXObject* sender,FXSelector,void*){
  FXbool enable=(navigator!=NULL) && ( (!dvd_started) || (pause) || (bspeed!=1.0) || (fspeed!=1.0) || ((dom!=DVD_DOMAIN_VTSTitle) && (uop&UOP_FLAG_Resume)) );
  sender->handle(this,enable?FXSEL(SEL_COMMAND,ID_ENABLE):FXSEL(SEL_COMMAND,ID_DISABLE),NULL);
  return 1;
  }

//----------------------------------------------------------------------------------
// Stop
//----------------------------------------------------------------------------------
long DVDWindow::onCmdStop(FXObject*,FXSelector,void*){
  DVDResult_t res=DVDStop((DVDNav_t*)navigator);
  if (res!=DVD_E_Ok) DVDPerror("DVDStop", res);
  return 1;
  }

long DVDWindow::onUpdStop(FXObject* sender,FXSelector,void*){
//  FXbool enable=((navigator!=NULL) && (uop&UOP_FLAG_Stop));
//  sender->handle(this,enable?FXSEL(SEL_COMMAND,ID_ENABLE):FXSEL(SEL_COMMAND,ID_DISABLE),NULL);
  sender->handle(this,FXSEL(SEL_COMMAND,ID_DISABLE),NULL);
  return 1;
  }


//----------------------------------------------------------------------------------
// Pause
//----------------------------------------------------------------------------------
long DVDWindow::onCmdPause(FXObject*,FXSelector,void*){
  DVDResult_t res;
  if (pause) {
    res = DVDPauseOff((DVDNav_t*)navigator);
    if (res!=DVD_E_Ok) {
        DVDPerror("DVDPauseOff", res);
        return 1;
        }
    pause=FALSE;
    }
  else {
    DVDResult_t res=DVDPauseOn((DVDNav_t*)navigator);
    if (res!=DVD_E_Ok) {
        DVDPerror("DVDPauseOn", res);
        return 1;
        }
    pause=TRUE;
    }
  return 1;
  }

long DVDWindow::onUpdPause(FXObject* sender,FXSelector,void*){
  FXbool enable=((navigator!=NULL) && (uop&UOP_FLAG_PauseOn) && (pause==FALSE));
  sender->handle(this,enable?FXSEL(SEL_COMMAND,ID_ENABLE):FXSEL(SEL_COMMAND,ID_DISABLE),NULL);
  return 1;
  }


//----------------------------------------------------------------------------------
// Next
//----------------------------------------------------------------------------------
long DVDWindow::onCmdNext(FXObject*,FXSelector,void*){
  DVDResult_t res=DVDNextPGSearch((DVDNav_t*)navigator);
  if (res!=DVD_E_Ok) DVDPerror("DVDNextPGSearch",res);
  repeat.chapter();
  return 1;
  }

long DVDWindow::onUpdNext(FXObject* sender,FXSelector,void*){
  FXbool enable=((navigator!=NULL) && (uop&UOP_FLAG_NextPGSearch) && (!pause) );
  sender->handle(this,enable?FXSEL(SEL_COMMAND,ID_ENABLE):FXSEL(SEL_COMMAND,ID_DISABLE),NULL);
  return 1;
  }


//----------------------------------------------------------------------------------
// Previous
//----------------------------------------------------------------------------------
long DVDWindow::onCmdPrevious(FXObject*,FXSelector,void*ptr){
  DVDResult_t result;
  FXEvent * event = reinterpret_cast<FXEvent*>(ptr);
//  printf("Click count=%d\n",event->click_count);
  if (event->click_count==1){
    result=DVDTopPGSearch((DVDNav_t*)navigator);
    if (result!=DVD_E_Ok) DVDPerror("DVDTopPGSearch", result);
    }
  else{
    result=DVDPrevPGSearch((DVDNav_t*)navigator);
    if (result!=DVD_E_Ok) DVDPerror("DVDPrevPGSearch", result);
    }
  repeat.chapter();
  return 0;
  }

long DVDWindow::onUpdPrevious(FXObject* sender,FXSelector,void*){
  FXbool enable=((navigator!=NULL) && (uop&UOP_FLAG_PrevOrTopPGSearch) && (!pause));
  sender->handle(this,enable?FXSEL(SEL_COMMAND,ID_ENABLE):FXSEL(SEL_COMMAND,ID_DISABLE),NULL);
  return 1;
  }


//----------------------------------------------------------------------------------
// Search Forward
//----------------------------------------------------------------------------------
long DVDWindow::onCmdSearchForward(FXObject*,FXSelector,void*){
  if (bspeed > 1.0){
    bspeed-=0.5;
    pause=FALSE;
    DVDBackwardScan((DVDNav_t*)navigator,bspeed);
    }
  else {
//    fspeed+=0.5;
//    pause=FALSE;
    if (pause)
      fspeed=0.0625;
    else if ((fspeed >= 1.0) && (fspeed < 8.0)) //max speed from dvd_cli
      fspeed+=0.5;
    else
      fspeed*=2;
    pause=FALSE;
    DVDForwardScan((DVDNav_t*)navigator,fspeed);
    }
  return 1;
  }

long DVDWindow::onUpdSearchForward(FXObject* sender,FXSelector,void*){
  FXbool enable=((navigator!=NULL) && (dvd_started) && (fspeed<8.0) /*&& (uop&UOP_FLAG_ForwardScan)*/);
  sender->handle(this,enable?FXSEL(SEL_COMMAND,ID_ENABLE):FXSEL(SEL_COMMAND,ID_DISABLE),NULL);
  return 1;
  }


//----------------------------------------------------------------------------------
// Search Backward
//----------------------------------------------------------------------------------
long DVDWindow::onCmdSearchBackward(FXObject*,FXSelector,void*){
  if (fspeed > 1.0) {
    fspeed-=0.5;
    pause=FALSE;
    DVDForwardScan((DVDNav_t*)navigator,fspeed);
    }
  else if ((fspeed < 1.0)&&(fspeed > 0.1)){
    fspeed/=2;
    pause = FALSE;
    DVDForwardScan((DVDNav_t*)navigator,fspeed);
    }
  else {
//    bspeed+=0.5;
//    pause=FALSE;
//    DVDBackwardScan((DVDNav_t*)navigator,bspeed);
    }
  return 1;
  }

long DVDWindow::onUpdSearchBackward(FXObject* sender,FXSelector,void*){
  FXbool enable=((navigator!=NULL) && (dvd_started) && (bspeed<3.0) /*&& (uop&UOP_FLAG_BackwardScan)*/);
  sender->handle(this,enable?FXSEL(SEL_COMMAND,ID_ENABLE):FXSEL(SEL_COMMAND,ID_DISABLE),NULL);
  return 1;
  }


//----------------------------------------------------------------------------------
// Enter
//----------------------------------------------------------------------------------
long DVDWindow::onCmdEnter(FXObject*,FXSelector,void*){
  if ((!navigator) || (!dvd_started) || (!(uop&UOP_FLAG_ButtonSelectOrActivate))) return 1;
  DVDResult_t res=DVDButtonActivate((DVDNav_t*)navigator);
  if (res!=DVD_E_Ok) DVDPerror("DVDButtonActivate", res);
  return 1;
  }

long DVDWindow::onUpdEnter(FXObject* sender,FXSelector,void*){
  FXbool enable=((navigator!=NULL) && (dvd_started) && (uop&UOP_FLAG_ButtonSelectOrActivate));
  sender->handle(this,enable?FXSEL(SEL_COMMAND,ID_ENABLE):FXSEL(SEL_COMMAND,ID_DISABLE),NULL);
  return 1;
  }

//----------------------------------------------------------------------------------
//  Navigate Up
//----------------------------------------------------------------------------------
long DVDWindow::onCmdNavUp(FXObject*,FXSelector,void*){
  if ((!navigator) || (!dvd_started) || (!(uop&UOP_FLAG_ButtonSelectOrActivate))) return 1;
  DVDResult_t res=DVDUpperButtonSelect((DVDNav_t*)navigator);
  if (res!=DVD_E_Ok) DVDPerror("DVDUpperButtonSelect", res);
  return 1;
  }

long DVDWindow::onUpdNavUp(FXObject* sender,FXSelector,void*){
  FXbool enable=((navigator!=NULL) && (dvd_started) && (uop&UOP_FLAG_ButtonSelectOrActivate));
  sender->handle(this,enable?FXSEL(SEL_COMMAND,ID_ENABLE):FXSEL(SEL_COMMAND,ID_DISABLE),NULL);
  return 1;
  }

//----------------------------------------------------------------------------------
// Navigate Down
//----------------------------------------------------------------------------------
long DVDWindow::onCmdNavDown(FXObject*,FXSelector,void*){
  if ((!navigator) || (!dvd_started) || (!(uop&UOP_FLAG_ButtonSelectOrActivate))) return 1;
  DVDResult_t res=DVDLowerButtonSelect((DVDNav_t*)navigator);
  if (res!=DVD_E_Ok) DVDPerror("DVDLowerButtonSelect", res);
  return 1;
  }


long DVDWindow::onUpdNavDown(FXObject* sender,FXSelector,void*){
  FXbool enable=((navigator!=NULL) && (dvd_started) && (uop&UOP_FLAG_ButtonSelectOrActivate));
  sender->handle(this,enable?FXSEL(SEL_COMMAND,ID_ENABLE):FXSEL(SEL_COMMAND,ID_DISABLE),NULL);
  return 1;
  }

//----------------------------------------------------------------------------------
// Navigate Left
//----------------------------------------------------------------------------------
long DVDWindow::onCmdNavLeft(FXObject*,FXSelector,void*){
  if ((!navigator) || (!dvd_started) || (!(uop&UOP_FLAG_ButtonSelectOrActivate))) return 1;
  DVDResult_t res=DVDLeftButtonSelect((DVDNav_t*)navigator);
  if (res!=DVD_E_Ok) DVDPerror("DVDLeftButtonSelect", res);
  return 1;
  }

long DVDWindow::onUpdNavLeft(FXObject* sender,FXSelector,void*){
  FXbool enable=((navigator!=NULL) && (dvd_started) && (uop&UOP_FLAG_ButtonSelectOrActivate));
  sender->handle(this,enable?FXSEL(SEL_COMMAND,ID_ENABLE):FXSEL(SEL_COMMAND,ID_DISABLE),NULL);
  return 1;
  }

//----------------------------------------------------------------------------------
// Navigate Right
//----------------------------------------------------------------------------------
long DVDWindow::onCmdNavRight(FXObject*,FXSelector,void*){
  if ((!navigator) || (!dvd_started) || (!(uop&UOP_FLAG_ButtonSelectOrActivate))) return 1;
  DVDResult_t res=DVDRightButtonSelect((DVDNav_t*)navigator);
  if (res!=DVD_E_Ok) DVDPerror("DVDRightButtonSelect", res);
  return 1;
  }

long DVDWindow::onUpdNavRight(FXObject* sender,FXSelector,void*){
  FXbool enable=((navigator!=NULL) && (dvd_started) && (uop&UOP_FLAG_ButtonSelectOrActivate));
  sender->handle(this,enable?FXSEL(SEL_COMMAND,ID_ENABLE):FXSEL(SEL_COMMAND,ID_DISABLE),NULL);
  return 1;
  }





//----------------------------------------------------------------------------------
// Toggle Fullscreen
//----------------------------------------------------------------------------------
long DVDWindow::onCmdFullScreen(FXObject*,FXSelector,void*){
  fullscreen=!fullscreen;
  if (fullscreen) {
    DVDSetZoomMode((DVDNav_t*)navigator,(ZoomMode_t)(ZoomModeFullScreen));
    if (auto_show) getApp()->addTimeout(this,DVDWindow::ID_RAISE_TIMER,1000);
    }
  else {
    DVDSetZoomMode((DVDNav_t*)navigator,(ZoomMode_t)(ZoomModeResizeAllowed));
    }
  return 1;
  }

long DVDWindow::onUpdFullScreen(FXObject*sender,FXSelector,void*){
  FXbool enabled=((navigator!=NULL) && (dvd_started));
  sender->handle(this,enabled?FXSEL(SEL_COMMAND,ID_ENABLE):FXSEL(SEL_COMMAND,ID_DISABLE),NULL);
  sender->handle(this,fullscreen?FXSEL(SEL_COMMAND,FXWindow::ID_CHECK):FXSEL(SEL_COMMAND,FXWindow::ID_UNCHECK),NULL);
  return 1;
  }


long DVDWindow::onCmdRaiseControl(FXObject*,FXSelector,void*){
//  if (isMinimized()){
//    restore();
//    raise();
//    }
//  else {
//    raise();
//    }
  raise();


  return 1;
  }


//----------------------------------------------------------------------------------
// Handle Key Presses / Key Releases from Navigator
//----------------------------------------------------------------------------------
long DVDWindow::onNavKeyRelease(FXObject*,FXSelector,void* ptr){
  return getAccelTable()->handle(this,FXSEL(SEL_KEYRELEASE,0),ptr);
  }

long DVDWindow::onNavKeyPress(FXObject*,FXSelector,void* ptr){
  return getAccelTable()->handle(this,FXSEL(SEL_KEYPRESS,0),ptr);
  }

//----------------------------------------------------------------------------------
// Open Root Menu
//----------------------------------------------------------------------------------
long DVDWindow::onCmdMenuRoot(FXObject*,FXSelector,void*){
  DVDResult_t res=DVDMenuCall((DVDNav_t*)navigator,DVD_MENU_Root);
  if (res!=DVD_E_Ok) DVDPerror("DVDMenuCall", res);
  repeat.menu();
  return 1;
  }

long DVDWindow::onUpdMenuRoot(FXObject* sender,FXSelector,void*){
  FXbool enable=((navigator!=NULL) && (uop&UOP_FLAG_RootMenuCall));
  sender->handle(this,enable?FXSEL(SEL_COMMAND,ID_ENABLE):FXSEL(SEL_COMMAND,ID_DISABLE),NULL);
  return 1;
  }


//----------------------------------------------------------------------------------
// Open Title Menu
//----------------------------------------------------------------------------------
long DVDWindow::onCmdMenuTitle(FXObject*,FXSelector,void*){
  DVDResult_t res=DVDMenuCall((DVDNav_t*)navigator,DVD_MENU_Title);
  if (res!=DVD_E_Ok) DVDPerror("DVDMenuCall",res);
  repeat.menu();
  return 1;
  }

long DVDWindow::onUpdMenuTitle(FXObject *sender,FXSelector,void*){
  FXbool enable=((navigator!=NULL) && (uop&UOP_FLAG_TitleMenuCall));
  sender->handle(this,enable?FXSEL(SEL_COMMAND,ID_ENABLE):FXSEL(SEL_COMMAND,ID_DISABLE),NULL);
  return 1;
  }

//----------------------------------------------------------------------------------
// Open Subpicture Menu
//----------------------------------------------------------------------------------
long DVDWindow::onCmdMenuSubpicture(FXObject*,FXSelector,void*){
  DVDResult_t res=DVDMenuCall((DVDNav_t*)navigator,DVD_MENU_Subpicture);
  if (res!=DVD_E_Ok) DVDPerror("DVDMenuCall",res);
  repeat.menu();
  return 1;
  }

long DVDWindow::onUpdMenuSubpicture(FXObject*sender,FXSelector,void*){
  FXbool enable=((navigator!=NULL) && (uop&UOP_FLAG_SubPicMenuCall));
  sender->handle(this,enable?FXSEL(SEL_COMMAND,ID_ENABLE):FXSEL(SEL_COMMAND,ID_DISABLE),NULL);
  return 1;
  }


//----------------------------------------------------------------------------------
// Open Audio Menu
//----------------------------------------------------------------------------------
long DVDWindow::onCmdMenuAudio(FXObject*,FXSelector,void*){
  DVDResult_t res=DVDMenuCall((DVDNav_t*)navigator,DVD_MENU_Audio);
  if (res!=DVD_E_Ok) DVDPerror("DVDMenuCall", res);
  repeat.menu();
  return 1;
  }

long DVDWindow::onUpdMenuAudio(FXObject*sender,FXSelector,void*){
  FXbool enable=((navigator!=NULL) && (uop&UOP_FLAG_AudioMenuCall));
  sender->handle(this,enable?FXSEL(SEL_COMMAND,ID_ENABLE):FXSEL(SEL_COMMAND,ID_DISABLE),NULL);
  return 1;
  }



//----------------------------------------------------------------------------------
// Open Angle Menu
//----------------------------------------------------------------------------------
long DVDWindow::onCmdMenuAngle(FXObject*,FXSelector,void*){
  DVDResult_t res=DVDMenuCall((DVDNav_t*)navigator,DVD_MENU_Angle);
  if (res!=DVD_E_Ok) DVDPerror("DVDMenuCall",res);
  repeat.menu();
  return 1;
  }

long DVDWindow::onUpdMenuAngle(FXObject*sender,FXSelector,void*){
  FXbool enable=((navigator!=NULL) && (uop&UOP_FLAG_AngleMenuCall));
  sender->handle(this,enable?FXSEL(SEL_COMMAND,ID_ENABLE):FXSEL(SEL_COMMAND,ID_DISABLE),NULL);
  return 1;
  }


//----------------------------------------------------------------------------------
// Open Chapter Menu
//----------------------------------------------------------------------------------
long DVDWindow::onCmdMenuPart(FXObject*,FXSelector,void*){
  DVDResult_t res=DVDMenuCall((DVDNav_t*)navigator,DVD_MENU_Part);
  if (res!=DVD_E_Ok) DVDPerror("DVDMenuCall",res);
  repeat.menu();
  return 1;
  }

long DVDWindow::onUpdMenuPart(FXObject*sender,FXSelector,void*){
  FXbool enable=((navigator!=NULL) && (uop&UOP_FLAG_ChapterMenuCall));
  sender->handle(this,enable?FXSEL(SEL_COMMAND,ID_ENABLE):FXSEL(SEL_COMMAND,ID_DISABLE),NULL);
  return 1;
  }
/*

static FXbool isEqual(DVDTimecode_t * a, DVDTimecode_t * b){
  if (b->Hours!=a->Hours) return FALSE;
  if (b->Minutes!=a->Minutes) return FALSE;
  if (b->Seconds!=a->Seconds) return FALSE;
//  if (b->Frames!=a->Frames) return FALSE;
  return TRUE;
  }

/// returns TRUE if b is after a
static FXbool isAfter(DVDTimecode_t * a, DVDTimecode_t * b){
  if (b->Hours < a->Hours) return FALSE;
  if (b->Minutes < a->Minutes) return FALSE;
  if (b->Seconds < a->Seconds) return FALSE;
  //if (b->Frames < a->Frames) return FALSE;
  return TRUE;
  }


static void printTime(DVDTimecode_t *t){
  fxmessage("%d:%d:%d\n",t->Hours,t->Minutes,t->Seconds);
  }
*/

//----------------------------------------------------------------------------------
// Repeat Chapter
//----------------------------------------------------------------------------------
long DVDWindow::onCmdRepeatChapter(FXObject*,FXSelector,void*){
  if (repeat.mode==DVD_REPEAT_OFF) {
    repeat.mode=DVD_REPEAT_CHAPTER;
    repeat.title=location.title;
    repeat.ptt=location.ptt;
    repeatlabelframe->show();
    //repeatlabel->setText("Chapter");
    }
  else if (repeat.mode==DVD_REPEAT_CHAPTER){
    repeat.mode=DVD_REPEAT_TITLE;
    repeat.title=location.title;
    repeatexlabelframe->show();
    //repeatlabel->setText("Title");
    }
/*
  else if (repeat.mode==DVD_REPEAT_TITLE){
    repeat.mode=DVD_REPEAT_A;
    repeat.title=location.title;
    repeat.a.Hours = location.title_current.Hours;
    repeat.a.Minutes = location.title_current.Minutes;
    repeat.a.Seconds = location.title_current.Seconds;
    repeat.a.Frames = location.title_current.Frames;
    fxmessage("A: ");
    printTime(&repeat.a);
    }
 else if (repeat.mode==DVD_REPEAT_A){
    if (repeat.title!=location.title) {
      repeat.mode=DVD_REPEAT_OFF;
      return 1;
      }
    if (isEqual(&repeat.a, &location.title_current)) return 1;
    if (isAfter(&repeat.a,&location.title_current)){
      repeat.b.Hours = location.title_current.Hours;
      repeat.b.Minutes = location.title_current.Minutes;
      repeat.b.Seconds = location.title_current.Seconds;
      repeat.b.Frames = location.title_current.Frames;
      fxmessage("B: ");
      printTime(&repeat.b);
      }
    else {
      repeat.b.Hours = repeat.a.Hours;
      repeat.b.Minutes = repeat.a.Minutes;
      repeat.b.Seconds = repeat.a.Seconds;
      repeat.b.Frames = repeat.a.Frames;
      repeat.a.Hours = location.title_current.Hours;
      repeat.a.Minutes = location.title_current.Minutes;
      repeat.a.Seconds = location.title_current.Seconds;
      repeat.a.Frames = location.title_current.Frames;
      }

    repeat.mode=DVD_REPEAT_AB;
    }
*/
  else  {
    repeat.mode=DVD_REPEAT_OFF;
    repeatlabelframe->hide();
    repeatexlabelframe->hide();
    //repeatlabel->setText("Off");
    }

  repeatexlabelframe->getParent()->layout();
  //getApp()->repaint();
  return 1;
  }

long DVDWindow::onUpdRepeatChapter(FXObject*sender,FXSelector,void*){
  FXbool enable=(dvd_started && (dom==DVD_DOMAIN_VTSTitle));
  sender->handle(this,enable?FXSEL(SEL_COMMAND,ID_ENABLE):FXSEL(SEL_COMMAND,ID_DISABLE),NULL);
  return 1;
  }

//----------------------------------------------------------------------------------
// Crop Screen
//----------------------------------------------------------------------------------
long DVDWindow::onCmdCrop(FXObject*,FXSelector,void*) {
  return 1;
  }

long DVDWindow::onUpdCrop(FXObject*sender,FXSelector,void*){
  FXbool enable=false;
  sender->handle(this,enable?FXSEL(SEL_COMMAND,ID_ENABLE):FXSEL(SEL_COMMAND,ID_DISABLE),NULL);
  return 1;
  }


//----------------------------------------------------------------------------------
// Init Bookmarks
//----------------------------------------------------------------------------------
void DVDWindow::initBookmarks(){

  if (navigator==NULL) return;

  if (!bookmarkdir.empty()){
    bookmarkdir = FXFile::absolute(bookmarkdir);
    if (!FXFile::exists(bookmarkdir)){
      return;
      }
    }

  if (bookmarkdir.empty())
    dvdbookmark = DVDBookmarkOpen(dvdid,NULL,0);
  else
    dvdbookmark = DVDBookmarkOpen(dvdid,(char*)bookmarkdir.text(),0);

  if (dvdbookmark){
    FXMenuCommand * menucommand=NULL;
    FXBookmark * bookmark;
    FXint entry=0;
    FXuint counter=1;
    char * navstate=NULL;
    FXchar * usercomment=NULL;
    FXchar * appname="Goggles";
    FXchar * extra_appinfo=NULL;
    FXchar * appinfo=NULL;

    while(DVDBookmarkGet(dvdbookmark,entry,&navstate,&usercomment,appname,&appinfo)!=-1){
      DVDBookmarkGet(dvdbookmark,entry,NULL,NULL,"common",&extra_appinfo);
      if (!autobookmark && extra_appinfo && (compare(extra_appinfo,"autobookmark")==0) ){
        autobookmark = new FXBookmark("Autobookmark",navstate,entry);
        }
      else {
        bookmark = new FXBookmark(FXStringFormat("%d - %s",counter,usercomment),navstate,entry);
        bookmarks.append(bookmark);
        counter++;
        }
      if (extra_appinfo) { FXFREE(&extra_appinfo); extra_appinfo=NULL; }
      FXFREE(&usercomment);
      FXFREE(&appinfo);
      entry++;
      }
    
    /// Build the bookmark menu
    for (FXint i=0;i<bookmarks.no();i++){
      menucommand = new FXMenuCommand(bookmarkmenu,bookmarks[i]->getTitle(),NULL,this,ID_BOOKMARK);
      menucommand->setUserData((void*)bookmarks[i]);
      menucommand->create();
      }
   
    /// Goto menu
    if (autobookmark) {
      new FXMenuSeparator(gotomenu);
      menucommand = new FXMenuCommand(gotomenu,"&Last Position",NULL,this,ID_BOOKMARK);
      menucommand->setUserData((void*)autobookmark);
      menucommand->create();
      }
    
    /// Start playing
    if (play_last_session && autobookmark) {
      handle(menucommand,FXSEL(SEL_COMMAND,ID_BOOKMARK),NULL);
      }
    }
  }

//----------------------------------------------------------------------------------
// Save Bookmarks
//----------------------------------------------------------------------------------
void DVDWindow::saveBookmarks(){
  if (!navigator) return;

  /// Save Autobookmark
  saveAutoBookmark();

  if (dvdbookmark){

    DVDBookmarkSave(dvdbookmark,0);

    for (FXint i=bookmarks.no()-1;i>=0;i--){
      delete bookmarks[i];
      }
    bookmarks.clear();
    
    if (autobookmark) delete autobookmark;

    DVDBookmarkClose(dvdbookmark);
    dvdbookmark=NULL;
    }
  }

//----------------------------------------------------------------------------------
// Go To Bookmark
//----------------------------------------------------------------------------------
long DVDWindow::onCmdBookmark(FXObject*sender,FXSelector,void*){
  FXBookmark * bookmark = (FXBookmark*)(((FXWindow*)sender)->getUserData());
  if (bookmark==NULL) return 1;
  DVDSetState((DVDNav_t*)navigator,bookmark->getState());
  return 1;
  }


long DVDWindow::onCmdPicturemark(FXObject*sender,FXSelector,void* ptr){
  FXint no = (FXint)(FXival)ptr;
  DVDSetState((DVDNav_t*)navigator,bookmarks[no]->getState());
  return 1;
  }


//----------------------------------------------------------------------------------
// Add a Bookmark
//----------------------------------------------------------------------------------
long DVDWindow::onCmdAddBookmark(FXObject*sender,FXSelector,void*){
  addBookmark(FALSE);
  return 1;
  }

void DVDWindow::saveAutoBookmark(){

  /// Remove Previous Bookmark
  if (autobookmark) {
    DVDBookmarkRemove(dvdbookmark,autobookmark->getEntry());
    delete autobookmark;
    }

  /// Add new auto bookmark
  if (auto_bookmark && (dom==DVD_DOMAIN_VTSTitle)){
    addBookmark(TRUE);
    }    

  }

//----------------------------------------------------------------------------------
// addBookmark -  autobookmark should only be true when we exit the application
//----------------------------------------------------------------------------------
void DVDWindow::addBookmark(FXbool autobookmark){
  FXString filename;
  FXchar *navstate=NULL;
  FXMenuCommand * command=NULL;

  if (DVDGetState((DVDNav_t*)navigator,&navstate) != DVD_E_Ok) {
    return;
    }

  /// Take Picture Mark
  if (!autobookmark) takeScreenshot("picturemarks",FXStringFormat("bookmark%.2d.jpg",bookmarks.no()+1),FALSE);

  if (!dvdbookmark){

    if (!bookmarkdir.empty()){
      bookmarkdir = FXFile::absolute(bookmarkdir);
      if (!FXFile::exists(bookmarkdir)){
        return;
        }
      }

    if (bookmarkdir.empty())
      dvdbookmark = DVDBookmarkOpen(dvdid,NULL,1);
    else
      dvdbookmark = DVDBookmarkOpen(dvdid,(char*)bookmarkdir.text(),1);

    if (!dvdbookmark) {
      FXFREE(&navstate);
      return;
      }
    }

  if (autobookmark){
    FXuint counter=0;
    DVDBookmarkAdd(dvdbookmark,navstate,"bookmark","Goggles",NULL);
    counter=DVDBookmarkGetNr(dvdbookmark);
    DVDBookmarkSetAppInfo(dvdbookmark,counter-1,"common","autobookmark");
    FXFREE(&navstate);
    return;
    }
  else {
    if (DVDBookmarkAdd(dvdbookmark,navstate,(char*)timeinfo.text(),"Goggles",NULL)==-1){
      FXFREE(&navstate);
      }
    else {
      FXint entry = bookmarks.no();
      if (autobookmark) entry++;
      FXBookmark * bookmark = new FXBookmark(FXStringFormat("%d - %s",bookmarks.no()+1,timeinfo.text()),navstate,entry);
      bookmarks.append(bookmark);
      command = new FXMenuCommand(bookmarkmenu,bookmark->getTitle(),NULL,this,ID_BOOKMARK);
      command->setUserData((void*)bookmark);
      command->create();
      }
    }
  }

long DVDWindow::onUpdAddBookmark(FXObject*sender,FXSelector,void*){
  FXbool enable=(dvd_started && (dom==DVD_DOMAIN_VTSTitle));
  sender->handle(this,enable?FXSEL(SEL_COMMAND,ID_ENABLE):FXSEL(SEL_COMMAND,ID_DISABLE),NULL);
  return 1;
  }



//----------------------------------------------------------------------------------
// Clear Bookmarks
//----------------------------------------------------------------------------------
long DVDWindow::onCmdClearBookmarks(FXObject*sender,FXSelector,void*){
  FXWindow * window=NULL;
  FXASSERT(dvdbookmark);
  FXuint result = FXMessageBox::question(this,MBOX_YES_NO,"Clear Bookmarks?","Are you sure you want to clear the bookmarks for this DVD?");
  if (result==MBOX_CLICKED_YES){

    /// Remove bookmarks
    for (FXint i=bookmarks.no()-1;i>=0;i--){
      DVDBookmarkRemove(dvdbookmark,bookmarks[i]->getEntry());
      delete bookmarks[i];
      }
    bookmarks.clear();

    /// Remove Menu Entries      
    window=bookmarkmenu;
    while(window->getLast()->getUserData()){
      delete window->getLast();
      window=bookmarkmenu;
      }

    /// Reset 
    if (autobookmark) {
      autobookmark->setEntry(0);      
      }
    
    /// Remove picture marks
    FXString picturemarks = FXFile::getHomeDirectory()+PATHSEPSTRING+".ogle"+PATHSEPSTRING+"picturemarks"+PATHSEPSTRING+dvdid_string;
    if (FXFile::exists(picturemarks)){
      FXFile::remove(picturemarks);
      }
    }
  return 1;
  }

long DVDWindow::onUpdClearBookmarks(FXObject*sender,FXSelector,void*){
  if (bookmarks.no()>0)
    sender->handle(this,FXSEL(SEL_COMMAND,FXWindow::ID_SHOW),NULL);
  else
    sender->handle(this,FXSEL(SEL_COMMAND,FXWindow::ID_HIDE),NULL);
  return 1;
  }



long DVDWindow::onCmdBrowseBookmarks(FXObject*sender,FXSelector,void*){
  FXuint dialogwidth = 150 + getApp()->getNormalFont()->getTextWidth("XX - Chapter XX - XX:XX:XX") + 50;

  FXDialogBox dialog(this,"Bookmarks",DECOR_ALL,0,0,dialogwidth,400);
  FXVerticalFrame * main=new FXVerticalFrame(&dialog,LAYOUT_FILL_X|LAYOUT_FILL_Y,0,0,0,0,0,0,0,0);
  FXVerticalFrame * smain=new FXVerticalFrame(main,LAYOUT_FILL_X|LAYOUT_FILL_Y|FRAME_SUNKEN|FRAME_THICK,0,0,0,0,0,0,0,0);
  FXList * list = new FXList(smain,this,ID_PICTUREMARK,LAYOUT_FILL_X|LAYOUT_FILL_Y);

  
  FXIconSource src(getApp());
  FXString picturemarkdir = FXFile::getHomeDirectory() + PATHSEPSTRING + ".ogle" + PATHSEPSTRING + "picturemarks" + PATHSEPSTRING + dvdid_string + PATHSEPSTRING;

  FXString filename;
  FXIcon * icon;

  for (FXint i=0;i<bookmarks.no();i++){
    filename = FXStringFormat("%sbookmark%.2d.jpg",picturemarkdir.text(),(i+1));
    if (FXFile::exists(filename)) {
      icon = src.loadScaledIcon(filename,150);
      }  
    else {
      icon = NULL;
      }
    list->appendItem(bookmarks[i]->getTitle(),icon); 
    }
    
  new FXButton(main,"     &Close     ",NULL,&dialog,FXDialogBox::ID_CANCEL,BUTTON_DEFAULT|BUTTON_INITIAL|BUTTON_NORMAL|LAYOUT_CENTER_X);
  dialog.execute();
  return 1;
  }

long DVDWindow::onUpdBrowseBookmarks(FXObject*sender,FXSelector,void*){
  if (bookmarks.no()>0)
    sender->handle(this,FXSEL(SEL_COMMAND,FXWindow::ID_SHOW),NULL);
  else
    sender->handle(this,FXSEL(SEL_COMMAND,FXWindow::ID_HIDE),NULL);
  return 1;
  }




void DVDWindow::takeScreenshot(const FXString & directory, const FXString & filename,FXbool spu){
  FXString dir = FXFile::getHomeDirectory() + PATHSEPSTRING + ".ogle" + PATHSEPSTRING + directory;
  if (!FXFile::exists(dir)){
    if (!FXFile::createDirectory(dir,0755)){
      return;
      }
    }
  dir += PATHSEPSTRING + dvdid_string;

  if (!FXFile::exists(dir)){
    if (!FXFile::createDirectory(dir,0755)){
      return;
      }
    }

  dir += PATHSEPSTRING + filename;
    
  DVDResult_t res;
  if (spu)
    res = DVDSaveScreenshot((DVDNav_t*)navigator,ScreenshotModeWithSPU,(char*)dir.text());
  else
    res = DVDSaveScreenshot((DVDNav_t*)navigator,ScreenshotModeWithoutSPU,(char*)dir.text());

  if(res != DVD_E_Ok) {
    DVDPerror("Goggles: DVDSaveScreenshot",res);
    return;
    }   
  }


//----------------------------------------------------------------------------------
// Make a screenshot
//----------------------------------------------------------------------------------
long DVDWindow::onCmdScreenShot(FXObject*,FXSelector,void*){
  FXString filename;

  if (timeinfo.empty())
    filename =  "menu%02i.jpg";
  else 
    filename = FXStringFormat("%d_%d_%d_%d_%d_%%02i.jpg",location.title,location.ptt,location.title_current.Hours,location.title_current.Minutes,location.title_current.Seconds);

  takeScreenshot("screenshots",filename,screenshot_with_spu);
  return 1;
  }


long DVDWindow::onUpdScreenShot(FXObject*sender,FXSelector,void*){
  sender->handle(this,dvd_started?FXSEL(SEL_COMMAND,ID_ENABLE):FXSEL(SEL_COMMAND,ID_DISABLE),NULL);
  return 1;
  }



long DVDWindow::onCmdBrowseScreenshots(FXObject*,FXSelector,void*){
  FXString dir = FXFile::getHomeDirectory() + PATHSEPSTRING + ".ogle" + PATHSEPSTRING + "screenshots" + PATHSEPSTRING + dvdid_string;

  FXDialogBox dialog(this,"Screenshots",DECOR_ALL,0,0,400,300);
  FXVerticalFrame * main=new FXVerticalFrame(&dialog,LAYOUT_FILL_X|LAYOUT_FILL_Y,0,0,0,0,0,0,0,0);
  FXVerticalFrame * smain=new FXVerticalFrame(main,LAYOUT_FILL_X|LAYOUT_FILL_Y|FRAME_SUNKEN|FRAME_THICK,0,0,0,0,0,0,0,0);

  FXFileList * list = new FXFileList(smain,this,ID_SCREENSHOT_LIST,LAYOUT_FILL_X|LAYOUT_FILL_Y|ICONLIST_BIG_ICONS|FILELIST_SHOWFILES|FILELIST_SHOWIMAGES|ICONLIST_AUTOSIZE);
  list->setImageSize(150);

  new FXButton(main,"     &Close     ",NULL,&dialog,FXDialogBox::ID_CANCEL,BUTTON_DEFAULT|BUTTON_INITIAL|BUTTON_NORMAL|LAYOUT_CENTER_X);
  list->setDirectory(dir);
  list->setPattern("*.jpg");
  dialog.execute();
  return 1;
  }


long DVDWindow::onUpdBrowseScreenshots(FXObject*sender,FXSelector,void*){
  FXString dir = FXFile::getHomeDirectory() + PATHSEPSTRING + ".ogle" + PATHSEPSTRING + "screenshots" + PATHSEPSTRING + dvdid_string;
  if (FXFile::exists(dir) && !dvdid_string.empty())
    sender->handle(this,FXSEL(SEL_COMMAND,FXWindow::ID_ENABLE),NULL);
  else
    sender->handle(this,FXSEL(SEL_COMMAND,FXWindow::ID_DISABLE),NULL);
  return 1;
  }


long DVDWindow::onCmdShowScreenshot(FXObject*sender,FXSelector,void*ptr){
  FXFileList * filelist=reinterpret_cast<FXFileList*>(sender);
  FXint index=(FXint)(FXival)ptr;
  FXString filename = filelist->getItemPathname(index);

  FXJPGImage * image=new FXJPGImage(getApp(),NULL,IMAGE_KEEP|IMAGE_SHMI|IMAGE_SHMP);

  if(image){
    FXFileStream stream;
    if(stream.open(filename,FXStreamLoad)){
      getApp()->beginWaitCursor();
      image->loadPixels(stream);
/*
      image->getPixelSize(xdpi,ydpi);
      if ((xdpi!=100) || (ydpi!=100)){
       printf("New width=%g %d\n",(image->getWidth() *(100.0/xdpi)),image->getWidth());
        printf("New height=%g\n",(image->getHeight() * (100.0/ydpi)));
        image->scale((image->getWidth() *(100.0/xdpi)),(image->getHeight() * (100.0/ydpi)),1);
        }
*/
      stream.close();
      image->create();
      getApp()->endWaitCursor();
      FXDialogBox dialog(this,FXStringFormat("Screenshot: %s",filename.text()),DECOR_ALL,0,0,750,550);
      FXVerticalFrame * main=new FXVerticalFrame(&dialog,LAYOUT_FILL_X|LAYOUT_FILL_Y,0,0,0,0,0,0,0,0,0);
      FXVerticalFrame * smain=new FXVerticalFrame(main,LAYOUT_FILL_X|LAYOUT_FILL_Y|FRAME_SUNKEN|FRAME_THICK,0,0,0,0,0,0,0,0);
      new FXImageView(smain,image,NULL,0,LAYOUT_FILL_X|LAYOUT_FILL_Y|IMAGEVIEW_NORMAL);
      new FXButton(main,"     &Close     ",NULL,&dialog,FXDialogBox::ID_CANCEL,BUTTON_DEFAULT|BUTTON_INITIAL|BUTTON_NORMAL|LAYOUT_CENTER_X);
      dialog.execute(PLACEMENT_SCREEN);
      }
    delete image;
    }
  return 1;
  }



//----------------------------------------------------------------------------------
// Change Audio Stream  - FIXME
//----------------------------------------------------------------------------------
long DVDWindow::onCmdChangeAudio(FXObject* sender,FXSelector,void*){

  if (navigator==NULL) return 1;

  DVDResult_t res;
  DVDStream_t stream;

  int number_of_streams;

  /// WHY DO I GET THE CURRENT AUDIOSTREAM???
  res = DVDGetCurrentAudio((DVDNav_t*)navigator, &number_of_streams, &stream);
  if(res != DVD_E_Ok) {
    DVDPerror("Goggles: DVDGetCurrentAudio",res);
    return 1;
    }

  res = DVDAudioStreamChange((DVDNav_t*)navigator,audio_id);
  if(res != DVD_E_Ok) {
      DVDPerror("Goggles: DVDAudioStreamChange", res);
      return 1;
      }

  setAudioLabel(audio_id);

  return 1;
  }


//----------------------------------------------------------------------------------
// Change Subpicture Stream
//----------------------------------------------------------------------------------
long DVDWindow::onCmdChangeSubpicture(FXObject*,FXSelector,void*){
/*
typedef enum {
  DVD_SUBPICTURE_STATE_OFF       = 0, ///< normal subpictures off 
  DVD_SUBPICTURE_STATE_ON        = 1, ///< normal subpictures on  
  DVD_SUBPICTURE_STATE_FORCEDOFF = 2, ///< normal/forced subp off (vts dom) 
  DVD_SUBPICTURE_STATE_DISABLED  = 3  ///< subpicture overlay off (all dom) 
} DVDSubpictureState_t;
*/

  DVDResult_t res;
  if (navigator==NULL) return 1;
  if (subpicture_id==SUBPICTURE_OFF){
#ifdef HAVE_NEWOGLEAPI
    res=DVDSetSubpictureState((DVDNav_t*)navigator,DVD_SUBPICTURE_STATE_OFF);          
#else
    res=DVDSetSubpictureState((DVDNav_t*)navigator,DVDFalse);
#endif
    if (res!=DVD_E_Ok) DVDPerror("DVDSetSubpictureState",res);
    }
  else {
#ifdef HAVE_NEWOGLEAPI
    res=DVDSetSubpictureState((DVDNav_t*)navigator,DVD_SUBPICTURE_STATE_ON);          
#else
    res=DVDSetSubpictureState((DVDNav_t*)navigator,DVDTrue);
#endif
    if (res!=DVD_E_Ok) DVDPerror("DVDSetSubpictureState",res);
    res=DVDSubpictureStreamChange((DVDNav_t*)navigator,subpicture_id);
    if (res!=DVD_E_Ok) DVDPerror("DVDSubpictureStreamChange",res);
    }

  if (subpicture_id!=SUBPICTURE_OFF){
    subtitlelabel->setText(getSubpictureName(subpicture_id));
   subtitlelabelframe->show();
    }
  else {
   subtitlelabelframe->hide();
   }

  return 1;
  }




//----------------------------------------------------------------------------------
// Change Angle
//----------------------------------------------------------------------------------
long DVDWindow::onCmdChangeAngle(FXObject*,FXSelector,void*){
  if (navigator==NULL) return 1;
  DVDResult_t res=DVDAngleChange((DVDNav_t*)navigator, angle_id);
  if (res!=DVD_E_Ok) DVDPerror("DVDAngleChange",res);
  return 1;
  }


//----------------------------------------------------------------------------------
// Change Title Stream
//----------------------------------------------------------------------------------
void DVDWindow::openTitle(FXint title,FXint chapter){
  if (navigator==NULL) return;
  DVDResult_t res=DVDPTTPlay((DVDNav_t*)navigator,title,chapter);
  if (res!=DVD_E_Ok) DVDPerror("DVDPTTPlay", res);
  }


//----------------------------------------------------------------------------------
// Titles Dialog -- FIXME maybe don't destroy this window everytime...
//----------------------------------------------------------------------------------
long DVDWindow::onCmdTitleDialog(FXObject*,FXSelector,void*){
  DVDResult_t res;
  FXint num_titles;
  FXint num_ptts;
  FXTreeItem * titleitem;
  FXTreeItem * currentitem=NULL;
  FXTreeItem * chapteritem;

  FXDialogBox dialog(getApp(),"Select Chapter/Title",DECOR_ALL);
  FXVerticalFrame * main=new FXVerticalFrame(&dialog,LAYOUT_FILL_X|LAYOUT_FILL_Y,0,0,0,0,0,0,0,0);
  new FXLabel(main,"To jump to a specific chapter,\nclick the corresponding item:",NULL,LABEL_NORMAL|JUSTIFY_CENTER_X);
  FXVerticalFrame * sunkenlistframe=new FXVerticalFrame(main,LAYOUT_FILL_X|LAYOUT_FILL_Y|FRAME_SUNKEN|FRAME_THICK,0,0,0,0,0,0,0,0);
  FXTreeList * list = new FXTreeList(sunkenlistframe,this,ID_TITLE_LIST,TREELIST_ROOT_BOXES|TREELIST_SHOWS_BOXES|TREELIST_SHOWS_LINES|TREELIST_SINGLESELECT|LAYOUT_FILL_X|LAYOUT_FILL_Y);
  list->setNumVisible(15);

  FXTreeItem * rootitem=list->appendItem(NULL,volumeid,icon_dvdsmall,icon_dvdsmall);

  /// Fill the treelist
  res = DVDGetTitles((DVDNav_t*)navigator, &num_titles);
  if (res != DVD_E_Ok) {
    DVDPerror("DVDGetTitles", res);
    return 1;
    }

  for (FXint i=1;i<=num_titles;i++){
    res = DVDGetNumberOfPTTs((DVDNav_t*)navigator,i,&num_ptts);
    if(res!=DVD_E_Ok) {
      DVDPerror("DVDGetNumberOfPTTs", res);
      return 1;
      }

    titleitem=list->appendItem(rootitem,FXStringFormat("Title %d",i),icon_bookclose,icon_bookclose,(void*)(FXival)i);

    for (FXint j=1;j<=num_ptts;j++){
      chapteritem=list->appendItem(titleitem,FXStringFormat("Chapter %d",j),icon_bookopen,icon_bookclose,(void*)(FXival)j);
      if ((last_chapter==j) && (last_title==i)) {
        currentitem=chapteritem;
        list->expandTree(titleitem);
        list->openItem(currentitem);
        }
      }
    }
  list->expandTree(rootitem);


  new FXButton(main,"    &Close    \tClose Dialog",NULL,&dialog,FXDialogBox::ID_CANCEL,BUTTON_NORMAL|BUTTON_INITIAL|LAYOUT_CENTER_X);
  dialog.create();
  if (currentitem) list->makeItemVisible(currentitem);

  dialog.execute(PLACEMENT_SCREEN);
  return 1;
  }


long DVDWindow::onCmdTitleSelect(FXObject*,FXSelector,void* ptr){
  FXTreeItem * item=(FXTreeItem*)ptr;
  if (item->getParent()!=NULL){
    FXint title,chapter;
    if (item->getParent()->getData()){
      title=(FXival)item->getParent()->getData();
      chapter=(FXival)item->getData();
      }
    else{ // If we select a title.. by default Chapter 1 is being played...
      title=(FXival)item->getData();
      chapter=1;
      }
    openTitle(title,chapter);
    repeat.chapter();
    }
  return 1;
  }

long DVDWindow::onUpdTitleDialog(FXObject*sender,FXSelector,void*){
  sender->handle(this,dvd_started?FXSEL(SEL_COMMAND,ID_ENABLE):FXSEL(SEL_COMMAND,ID_DISABLE),NULL);
  return 1;
  }



//----------------------------------------------------------------------------------
// Construct Subpicture Menu
//----------------------------------------------------------------------------------
void DVDWindow::update_subpicture_menu(){

  // delete current ones
  while(subpicturemenu->getFirst()){
    delete subpicturemenu->getFirst();
    }

  if (navigator==NULL) return;


  FXMenuRadio *   command;
  FXString          name;
  DVDResult_t       res;
  DVDStream_t       stream;
#ifdef HAVE_NEWOGLEAPI
  DVDSubpictureState_t shown;
  DVDBool_t enabled;
#else
  DVDBool_t enabled,shown;
#endif

  subpicture_id=SUBPICTURE_OFF;


  int number_of_streams=0;
  int count=0;

  FXMenuRadio * cap = new FXMenuRadio(subpicturemenu,"Off",&subpicture_target,FXDataTarget::ID_OPTION+SUBPICTURE_OFF);
  cap->create();

  res = DVDGetCurrentSubpicture((DVDNav_t*)navigator, &number_of_streams,&stream,&shown);
  if(res != DVD_E_Ok) {
    DVDPerror("Could not retrieve audio formats\n",res);
    return;
    }

  for (count=0;count<number_of_streams;count++){
    res = DVDIsSubpictureStreamEnabled((DVDNav_t*)navigator, (DVDStream_t)count , &enabled);
    if(res != DVD_E_Ok) {
      DVDPerror("DVDIsSubpictureStreamEnabled Failure\n",res);
      break;
      }
    if (!enabled) continue;

    name = getSubpictureName(count);
    if (filter_subpicture_entry && name.empty()) continue;

    command=new FXMenuRadio(subpicturemenu,name,&subpicture_target,FXDataTarget::ID_OPTION+count);
    if (stream==count && shown) subpicture_id=count;
    command->create();
    }

  if (subpicture_id!=SUBPICTURE_OFF){
    subtitlelabel->setText(getSubpictureName(subpicture_id));
    subtitlelabelframe->show();
    }
  else {
    subtitlelabelframe->hide();
   }

}


//----------------------------------------------------------------------------------
// Construct Audio Menu
//----------------------------------------------------------------------------------
void DVDWindow::update_audio_menu(){

  // delete current ones
  while(audiomenu->getFirst()){
    delete audiomenu->getFirst();
    }

  if (navigator==NULL) return;

  DVDResult_t res;
  DVDStream_t stream;

  int number_of_streams;
  int count=0;
  DVDBool_t enabled;
  FXString audioformat;
  FXString audioext;
  FXString audiomode;
  FXString audioname;
  FXbool audio_enabled=FALSE;
  FXint firststream=0;
  FXint actualstreams=0;

  res = DVDGetCurrentAudio((DVDNav_t*)navigator, &number_of_streams, &stream);
  if(res != DVD_E_Ok) {
    DVDPerror("Could not retrieve audio formats\n",res);
    return;
    }

  if (number_of_streams==0) {
     FXMenuRadio * cap = new FXMenuRadio(audiomenu,"Off",&audio_target,FXDataTarget::ID_OPTION+AUDIO_OFF);
     cap->create();
     return;
     }

  for (count=0;count<number_of_streams;count++){
    res = DVDIsAudioStreamEnabled((DVDNav_t*)navigator, (DVDStream_t)count , &enabled);
    if(res != DVD_E_Ok) {
      DVDPerror("DVDIsAudioStreamEnabled Failure\n",res);
      break;
      }
    if (enabled) {
      audioname=getAudioName(count);
      FXMenuCommand * command = new FXMenuRadio(audiomenu,audioname,&audio_target,FXDataTarget::ID_OPTION+count);
      if (stream==count) {
         audio_id=count;
         audio_enabled=TRUE;
         }
      command->create();
      actualstreams++;
      if (actualstreams==1) firststream=count;
      }
    }

  /// Turn on the First Audio Stream if nothing was enabled.
  if ((actualstreams>0) && !audio_enabled && auto_audiostream){
    res = DVDAudioStreamChange((DVDNav_t*)navigator,firststream);
    if(res != DVD_E_Ok) {
      DVDPerror("Goggles: DVDAudioStreamChange", res);
      return;
      }
    audio_id=firststream;
    }

  setAudioLabel(audio_id);
  audiomenu->recalc();
  audiomenu->update();
  audiomenu->forceRefresh();
  }


//----------------------------------------------------------------------------------
// Construct Angle Menu
//----------------------------------------------------------------------------------
void DVDWindow::update_angle_menu(){

  // delete current ones
  while(anglemenu->getFirst()){
    delete anglemenu->getFirst();
    }


  if (navigator==NULL) return;

  DVDResult_t res;
  DVDAngle_t stream;

  int number_of_streams=0;
  int count=0;

  res = DVDGetCurrentAngle((DVDNav_t*)navigator, &number_of_streams, &stream);
  if(res != DVD_E_Ok) {
    DVDPerror("DVDGetCurrentAngle\n",res);
    return;
    }

  if (number_of_streams==0){
     FXMenuRadio * cap = new FXMenuRadio(anglemenu,"None",&audio_target,FXDataTarget::ID_OPTION+AUDIO_OFF);
     cap->create();
     return;
     }


  while(count<number_of_streams) {
      FXMenuRadio * command = new FXMenuRadio(anglemenu,FXStringFormat("Angle %d",count+1),&angle_target,FXDataTarget::ID_OPTION+count);
      command->create();
      count++;
      }
  }


long DVDWindow::onCmdTimePlay(FXObject*,FXSelector,void*ptr){
//  DVDTimecode_t code;
/*
  FXuint hours=value/3600;
  FXuint minutes=(value/60)-(hours*60);
  FXuint seconds=value-((minutes*60)+(hours*3600));

  code.Hours=hours;
  code.Minutes=minutes;
  code.Seconds=seconds;
  code.Frames=0;

  res = DVDTimeSearch((DVDNav_t*)navigator,code);
  if (res != DVD_E_Ok){
    DVDPerror("DVDTimeSearch",res);
    return 1;
    }
*/
  DVDResult_t res;
  FXuint seconds=(FXuint)(FXuval)ptr;
  FXuint skip=seconds-current_time;
  res=DVDTimeSkip((DVDNav_t*)navigator,skip);
  if (res!=DVD_E_Ok){
    DVDPerror("DVDTimeSkip",res);
    }
  repeat.chapter();
  return 1;
  }

long DVDWindow::onChgSlider(FXObject*,FXSelector,void*ptr){
  FXuint hours;
  FXuint minutes;
  FXuint seconds;

  FXuint temp_current=(FXuint)(FXuval)(ptr);

  hours = (FXuint) floor(temp_current/3600.);
  temp_current -= (FXuint) (3600.*hours);

  minutes = (FXuint) floor(temp_current / 60.);
  temp_current -= (FXuint) (60.*minutes);

  seconds = temp_current;

  infolabel->setText(FXStringFormat("%d:%.2d:%.2d",hours,minutes,seconds));
  return 1;
  }

long DVDWindow::onUpdSlider(FXObject* sender,FXSelector,void*){
  if (dvd_started)
    sender->handle(this,FXSEL(SEL_COMMAND,FXWindow::ID_ENABLE),NULL);
  else
    sender->handle(this,FXSEL(SEL_COMMAND,FXWindow::ID_DISABLE),NULL);
  progressbar->setValue(current_time);
  return 1;
  }

long DVDWindow::onSliderPress(FXObject*,FXSelector,void*ptr){
  is_seeking=!is_seeking;
  return 0;
  }

long DVDWindow::onSliderRelease(FXObject*,FXSelector,void*ptr){
  is_seeking=FALSE;
  return 0;
  }



//----------------------------------------------------------------------------------
// Right Click Popup Menu
//----------------------------------------------------------------------------------
long DVDWindow::onCmdMenuPopup(FXObject*,FXSelector,void* ptr){
  FXEvent *event=(FXEvent*)ptr;
  FXMenuPane pane(this);
  new FXMenuCascade(&pane,"&Goto",icon_goto,gotomenu);
  FXMenuCascade *audiocascade=new FXMenuCascade(&pane,"&Audio",icon_audio,audiomenu);
  FXMenuCascade *subpicturecascade=new FXMenuCascade(&pane,"&Subpicture",icon_subpicture,subpicturemenu);
  FXMenuCascade *anglecascade=new FXMenuCascade(&pane,"&Angle",icon_angle,anglemenu);
  new FXMenuSeparator(&pane);
  new FXMenuCheck(&pane,"&Fullscreen",this,ID_TOGGLE_FULLSCREEN);

//  new FXMenuCascade(&pane,"&Options",NULL,optionmenu);
//  new FXMenuCascade(&pane,"&Help",NULL,helpmenu);

  if (!angletitle->isEnabled())       anglecascade->disable();
  if (!subpicturetitle->isEnabled())  subpicturecascade->disable();
  if (!audiotitle->isEnabled())       audiocascade->disable();

  pane.create();
  pane.popup(NULL,event->root_x+3,event->root_y+3);
  getApp()->runPopup(&pane);
  return 1;
  }





//----------------------------------------------------------------------------------
// ShortCut Editor Handler
//
// A New shortcut has been entered. We need to parse and if right adjust current
// shortcut.
// Else give feedback..
//
//----------------------------------------------------------------------------------
long DVDWindow::onCmdEditShortCut(FXObject*,FXSelector selector,void* ptr){
  FXString shortcut=FXString((FXchar*)ptr);

  FXString regentry;
  FXString defregentry;
  FXSelector selentry=0;
  FXHotKey key=fxparseAccel(shortcut);


  if (key) {

    /// Find Duplicate if found, don't change the current one...
    if (getAccelTable()->hasAccel(key)){
      FXMessageBox::error(this,MBOX_OK,"Shortcut already in use!","The Shortcut you're trying to enter is already being used.");
      return 1;
      }

    /// Not a duplicate
    switch(FXSELID(selector)){
      case ID_SHORTCUT_FULLSCREEN     : selentry=FXSEL(SEL_COMMAND,ID_TOGGLE_FULLSCREEN); regentry="FullScreen";      defregentry=DEFAULT_SHORTCUT_FULLSCREEN;    break;
      case ID_SHORTCUT_RAISE          : selentry=FXSEL(SEL_COMMAND,ID_RAISE_CONTROL);     regentry="Raise";           defregentry=DEFAULT_SHORTCUT_RAISE;         break;
      case ID_SHORTCUT_TITLEMENU      : selentry=FXSEL(SEL_COMMAND,ID_MENU_TITLE);        regentry="TitleMenu";       defregentry=DEFAULT_SHORTCUT_TITLEMENU;     break;
      case ID_SHORTCUT_ROOTMENU       : selentry=FXSEL(SEL_COMMAND,ID_MENU_ROOT);         regentry="RootMenu";        defregentry=DEFAULT_SHORTCUT_ROOTMENU;      break;
      case ID_SHORTCUT_AUDIOMENU      : selentry=FXSEL(SEL_COMMAND,ID_MENU_AUDIO);        regentry="AudioMenu";       defregentry=DEFAULT_SHORTCUT_AUDIOMENU;     break;
      case ID_SHORTCUT_ANGLEMENU      : selentry=FXSEL(SEL_COMMAND,ID_MENU_ANGLE);        regentry="AngleMenu";       defregentry=DEFAULT_SHORTCUT_ANGLEMENU;     break;
      case ID_SHORTCUT_SUBPICTUREMENU : selentry=FXSEL(SEL_COMMAND,ID_MENU_SUBPICTURE);   regentry="SubtitleMenu";    defregentry=DEFAULT_SHORTCUT_SUBPICTUREMENU;break;
      case ID_SHORTCUT_PAUSE          : selentry=FXSEL(SEL_COMMAND,ID_PAUSE);             regentry="Pause";           defregentry=DEFAULT_SHORTCUT_PAUSE;         break;
      case ID_SHORTCUT_STOP           : selentry=FXSEL(SEL_COMMAND,ID_STOP);              regentry="Stop";            defregentry=DEFAULT_SHORTCUT_STOP;          break;
      case ID_SHORTCUT_NEXT           : selentry=FXSEL(SEL_COMMAND,ID_NEXT);              regentry="Next";            defregentry=DEFAULT_SHORTCUT_NEXT;          break;
      case ID_SHORTCUT_PREVIOUS       : selentry=FXSEL(SEL_COMMAND,ID_PREVIOUS);          regentry="Previous";        defregentry=DEFAULT_SHORTCUT_PREVIOUS;      break;
      case ID_SHORTCUT_SEARCHFORWARD  : selentry=FXSEL(SEL_COMMAND,ID_SEARCH_FORWARD);    regentry="SearchForward";   defregentry=DEFAULT_SHORTCUT_SEARCHFORWARD; break;
      case ID_SHORTCUT_SEARCHBACKWARD : selentry=FXSEL(SEL_COMMAND,ID_SEARCH_BACKWARD);   regentry="SearchBackward";  defregentry=DEFAULT_SHORTCUT_SEARCHBACKWARD;break;
      case ID_SHORTCUT_ENTER          : selentry=FXSEL(SEL_COMMAND,ID_ENTER);             regentry="Enter";           defregentry=DEFAULT_SHORTCUT_ENTER;         break;
      case ID_SHORTCUT_UP             : selentry=FXSEL(SEL_COMMAND,ID_NAV_UP);            regentry="NavUp";           defregentry=DEFAULT_SHORTCUT_NAVUP;         break;
      case ID_SHORTCUT_DOWN           : selentry=FXSEL(SEL_COMMAND,ID_NAV_DOWN);          regentry="NavDown";         defregentry=DEFAULT_SHORTCUT_NAVDOWN;       break;
      case ID_SHORTCUT_LEFT           : selentry=FXSEL(SEL_COMMAND,ID_NAV_LEFT);          regentry="NavLeft";         defregentry=DEFAULT_SHORTCUT_NAVLEFT;       break;
      case ID_SHORTCUT_RIGHT          : selentry=FXSEL(SEL_COMMAND,ID_NAV_RIGHT);         regentry="NavRight";        defregentry=DEFAULT_SHORTCUT_NAVRIGHT;      break;
      case ID_SHORTCUT_SNAPSHOT       : selentry=FXSEL(SEL_COMMAND,ID_SCREENSHOT);        regentry="SnapShot";        defregentry=DEFAULT_SHORTCUT_SNAPSHOT;      break;
      }

    /// Remove Old One
    getAccelTable()->removeAccel(fxparseAccel(getApp()->reg().readStringEntry("HotKeys",regentry.text(),defregentry.text())));

    /// Replace Accellerator Key
    getAccelTable()->addAccel(key,this,selentry);

    /// Add Key to Registry
    getApp()->reg().writeStringEntry("HotKeys",regentry.text(),shortcut.text());


    }
  else {
    getApp()->beep();
    }
  return 1;
  }

//----------------------------------------------------------------------------------
// Directory Selector Dialog
//----------------------------------------------------------------------------------
long DVDWindow::onCmdSelectDirectory(FXObject*,FXSelector selector,void*){
  if (FXSELID(selector)==ID_GETDVDROOTDIR){
    FXFileDialog dialog(this,"Select DVD device, DVD mount point or directory...");
    dialog.setFilename(dvdroot);
    if (dialog.execute()){
      dvdroot = dialog.getFilename();
      }
    return 1;
    }
  else if (FXSELID(selector)==ID_GETBOOKMARKDIR){
    FXDirDialog dialog(this,"Select Bookmark Directory...");
    dialog.setDirectory(bookmarkdir);
    if (dialog.execute()){
      bookmarkdir = dialog.getDirectory();
      }
    return 1;
    }
  return 1;
  }



//----------------------------------------------------------------------------------
// About Dialog
//----------------------------------------------------------------------------------
long DVDWindow::onCmdAbout(FXObject *,FXSelector,void*){
FXAboutDialog dialog(this,"Goggles DVD Player",GOGGLES_VERSION_STRING,"Sander Jansen","2002-2005",icon_logo);
	dialog.execute(PLACEMENT_SCREEN);
  return 1;
  }




//----------------------------------------------------------------------------------
// Get the Subpicture Name for Stream
//----------------------------------------------------------------------------------
FXString DVDWindow::getSubpictureName(FXuint id){
  FXString subpicture_ext;
  DVDResult_t res;
  DVDSubpictureAttributes_t Attr;

  res = DVDGetSubpictureAttributes((DVDNav_t*)navigator, (DVDStream_t)id , &Attr);
  if(res != DVD_E_Ok) {
    DVDPerror("DVDGetSubpictureAttributes Failure\n",res);
    return FXString("Unknown");
    }

  switch(Attr.LanguageExtension){
    case DVD_SUBPICTURE_LANG_EXT_NotSpecified               : subpicture_ext=""; break;
    case DVD_SUBPICTURE_LANG_EXT_NormalCaptions             : subpicture_ext=" Captions"; break;
    case DVD_SUBPICTURE_LANG_EXT_BigCaptions                : subpicture_ext=" Captions (Big)"; break;
    case DVD_SUBPICTURE_LANG_EXT_ChildrensCaptions          : subpicture_ext=" Captions (Children's)"; break;
    case DVD_SUBPICTURE_LANG_EXT_NormalCC                   : subpicture_ext=" Closed Captions"; break;
    case DVD_SUBPICTURE_LANG_EXT_BigCC                      : subpicture_ext=" Closed Captions (Big)"; break;
    case DVD_SUBPICTURE_LANG_EXT_ChildrensCC                : subpicture_ext=" Closed Captions (Children's)"; break;
    case DVD_SUBPICTURE_LANG_EXT_Forced                     : subpicture_ext=" Forced"; break;
    case DVD_SUBPICTURE_LANG_EXT_NormalDirectorsComments    : subpicture_ext=" Director's Comments"; break;
    case DVD_SUBPICTURE_LANG_EXT_BigDirectorsComments       : subpicture_ext=" Director's Comments (Big)"; break;
    case DVD_SUBPICTURE_LANG_EXT_ChildrensDirectorsComments : subpicture_ext=" Director's Comments (Children's)"; break;
    }
  return FXString(getLanguageName(Attr.Language) + subpicture_ext);
  }




void DVDWindow::setAudioLabel(FXuint id){
  FXString audioformat;
  FXString audiotype;
  FXString audiolang;

  DVDResult_t res;
  DVDAudioAttributes_t Attr;

  res = DVDGetAudioAttributes((DVDNav_t*)navigator, (DVDStream_t)id , &Attr);
  if(res != DVD_E_Ok) {
    DVDPerror("DVDGetAudioAttributes Failure\n",res);
    return;
    }

  switch(Attr.AudioFormat) {
    case DVD_AUDIO_FORMAT_AC3       : audioformat="Dolby Digital";            break;
    case DVD_AUDIO_FORMAT_MPEG1     : audioformat="MPEG1";          break;
    case DVD_AUDIO_FORMAT_MPEG1_DRC : audioformat="MPEG1 DRC";      break;
    case DVD_AUDIO_FORMAT_MPEG2     : audioformat="MPEG2";          break;
    case DVD_AUDIO_FORMAT_MPEG2_DRC : audioformat="MPEG2 DRC";      break;
    case DVD_AUDIO_FORMAT_LPCM      : audioformat="LPCM";           break;
    case DVD_AUDIO_FORMAT_DTS       : audioformat="DTS";            break;
    case DVD_AUDIO_FORMAT_SDDS      : audioformat="SDDS";           break;
    case DVD_AUDIO_FORMAT_Other     : audioformat="Other";          break;
    default                         : audioformat="???"; break;
    }
  switch(Attr.NumberOfChannels){

    case 0:  audiotype=""; break;
    case 1:  audiotype="1.0"; break;
    case 2:  audiotype="2.0"; break;
    case 3:  audiotype="2.1"; break;
//    case 4:  audiotype=" 3.1"; break;
//    case 5:  audiotype=" 3.2"; break;
    case 6:  audiotype="5.1"; break;
    default: audiotype=""; break; 
    }

#ifdef HAVE_NEWOGLEAPI
  if(Attr.AudioType == DVD_AUDIO_TYPE_Language) {
    audiolang = getLanguageName(Attr.Language);
    }
  else {
    audiolang = "Audio";
    }
#else
  audiolang = getLanguageName(Attr.Language);
#endif
  audiolabel->setText(audioformat);
  if (audiotype.empty()) {
    audioextlabelframe->hide();
    }
  else {
    audioextlabel->setText(audiotype);
    audioextlabelframe->show();
    }
  audiolanglabel->setText(audiolang);
  }
    

  



//----------------------------------------------------------------------------------
// Get the Audio Name for Stream
//----------------------------------------------------------------------------------
FXString DVDWindow::getAudioName(FXuint id){
  FXString audiomode;
  FXString audioformat;
  FXString audioext;
  FXString audiotype;

  DVDResult_t res;
  DVDAudioAttributes_t Attr;


  res = DVDGetAudioAttributes((DVDNav_t*)navigator, (DVDStream_t)id , &Attr);
  if(res != DVD_E_Ok) {
    DVDPerror("DVDGetAudioAttributes Failure\n",res);
    return FXString("Unknown");
    }
  
  switch(Attr.AudioFormat) {
    case DVD_AUDIO_FORMAT_AC3       : audioformat="Dolby Digital";            break;
    case DVD_AUDIO_FORMAT_MPEG1     : audioformat="MPEG1";          break;
    case DVD_AUDIO_FORMAT_MPEG1_DRC : audioformat="MPEG1 DRC";      break;
    case DVD_AUDIO_FORMAT_MPEG2     : audioformat="MPEG2";          break;
    case DVD_AUDIO_FORMAT_MPEG2_DRC : audioformat="MPEG2 DRC";      break;
    case DVD_AUDIO_FORMAT_LPCM      : audioformat="LPCM";           break;
    case DVD_AUDIO_FORMAT_DTS       : audioformat="DTS";            break;
    case DVD_AUDIO_FORMAT_SDDS      : audioformat="SDDS";           break;
    case DVD_AUDIO_FORMAT_Other     : audioformat="Other";          break;
    default                         : audioformat="???"; break;
    }
      
  switch(Attr.LanguageExtension){
    case DVD_AUDIO_LANG_EXT_NotSpecified        : audioext="";break;
    case DVD_AUDIO_LANG_EXT_NormalCaptions      : audioext="";break;
    case DVD_AUDIO_LANG_EXT_VisuallyImpaired    : audioext=" Visually Impaired";break;
    case DVD_AUDIO_LANG_EXT_DirectorsComments1  : audioext=" Director's Commentary 1";break;
    case DVD_AUDIO_LANG_EXT_DirectorsComments2  : audioext=" Director's Commentary 2";break;
    }

  switch(Attr.AppMode){
    case DVD_AUDIO_APP_MODE_None        : audiomode="";break;
    case DVD_AUDIO_APP_MODE_Karaoke     : audiomode=" Karaoke";break;
    case DVD_AUDIO_APP_MODE_Surround    : audiomode=" Surround";break;
    case DVD_AUDIO_APP_MODE_Other       : audiomode=" Other";break;
    }

  switch(Attr.NumberOfChannels){
    case 0:  audiotype=""; break;
    case 1:  audiotype=" 1.0"; break;
    case 2:  audiotype=" 2.0"; break;
    case 3:  audiotype=" 2.1"; break;
//    case 4:  audiotype=" 3.1"; break;
//    case 5:  audiotype=" 3.2"; break;
    case 6:  audiotype=" 5.1"; break;
    default: audiotype.format(" %d channels",Attr.NumberOfChannels); break; 
    }

#ifdef HAVE_NEWOGLEAPI
  if(Attr.AudioType == DVD_AUDIO_TYPE_Language) {
    return FXString(getLanguageName(Attr.Language)+" ("+audioformat + audiotype + audiomode + ")" + audioext);     
    }
  return FXString("Audio ("+audioformat + audiotype + audiomode + ")" + audioext);     
#else
  return FXString(getLanguageName(Attr.Language)+" ("+audioformat + audiotype + audiomode + ")" + audioext);
#endif

  }






