/*******************************************************************************
*               Goggles - Graphical User Interface for OGLE                    *
********************************************************************************
*        Copyright (C) 2002-2005 by Sander Jansen. All Rights Reserved         *
*                               ---                                            *
* This program is free software; you can redistribute it and/or modify         *
* it under the terms of the GNU General Public License as published by         *
* the Free Software Foundation; either version 2 of the License, or            *
* (at your option) any later version.                                          *
*                                                                              *
* This program is distributed in the hope that it will be useful,              *
* but WITHOUT ANY WARRANTY; without even the implied warranty of               *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the                *
* GNU General Public License for more details.                                 *
* You should have received a copy of the GNU General Public License            *
* along with this program; if not, write to the Free Software                  *
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA    *
*******************************************************************************/

/*
$Id: dvdint.cpp,v 1.2 2003/02/15 15:33:48 sander Exp $
*/
#include <fx.h>

extern "C" {
#include <ogle/dvdcontrol.h>
}

#include "dvdwindow.h"


const FXint language_names_count=171;
const FXint country_names_count=239;

const FXString sorted_language_codes[]={
  "ab","af","sq","am","ar","hy","as","ae","ay",
  "az","ba","eu","be","bn","bh","bi","bs","br",
  "bg","my","ca","ch","ce","ny","zh","cu","cv",
  "kw","co","hr","cs","da","nl","dz","en","eo",
  "et","fo","fj","fi","fr","fy","gd","gl","ka",
  "de","el","gn","gu","ha","he","iw","hz","hi",
  "ho","hu","is","id","in","ia","ie","iu","ik",
  "ga","it","ja","jv","jw","kl","kn","ks","kk",
  "km","ki","rw","ky","kv","ko","kj","ku","lo",
  "la","lv","lb","ln","lt","mk","mg","ms","ml",
  "mt","gv","mi","mr","mh","mo","mn","na","nv",
  "nd","nr","ng","ne","se","no","nb","nn","ny",
  "oc","or","om","os","pi","pa","fa","pl","pt",
  "oc","ps","qu","rm","ro","rn","ru","sm","sg",
  "sa","sc","sr","sh","sn","sd","si","sk","sl",
  "so","st","es","su","sw","ss","sv","tl","ty",
  "tg","ta","tt","te","th","bo","ti","to","ts",
  "tn","tr","tk","tw","ug","uk","ur","uz","vi",
  "vo","cy","wo","xh","yi","ji","yo","za","zu"};

const FXString sorted_country_codes[]={
  "af","al","dz","as","ad","ao","ai","aq","ag",
  "ar","am","aw","au","at","az","bs","bh","bd",
  "bb","by","be","bz","bj","bm","bt","bo","ba",
  "bw","bv","br","io","bn","bg","bf","bi","kh",
  "cm","ca","cv","ky","cf","td","cl","cn","cx",
  "cc","co","km","cg","cd","ck","cr","ci","hr",
  "cu","cy","cz","dk","dj","dm","do","tl","ec",
  "eg","sv","gq","er","ee","et","fk","fo","fj",
  "fi","fr","gf","pf","tf","ga","gm","ge","de",
  "gh","gi","gr","gl","gd","gp","gu","gt","gn",
  "gw","gy","hi","hm","va","hn","hk","hu","is",
  "in","id","ir","iq","ie","il","it","jm","jp",
  "jo","kz","ke","ki","kp","kr","kw","kg","la",
  "lv","lb","ls","lr","ly","li","lt","lu","mo",
  "mk","mg","mw","my","mv","ml","mt","mh","mq",
  "mr","mu","yt","mx","fm","md","mc","mn","ms",
  "ma","mz","mm","na","nr","np","nl","an","nc",
  "nz","ni","ne","ng","nu","nf","mp","no","om",
  "pk","pw","ps","pa","pg","py","pe","ph","pn",
  "pl","pt","pr","qa","re","ro","ru","rw","sh",
  "kn","lc","pm","vc","ws","sm","st","sa","sn",
  "sc","sl","sg","sk","si","sb","so","za","gs",
  "es","lk","sd","sr","sj","sz","se","ch","sy",
  "tw","tj","tz","th","tg","tk","td","tt","tn",
  "tr","tm","tc","tv","ug","ua","ae","gb","us",
  "um","uy","uz","vu","ve","vn","vg","vi","wf",
  "eh","ye","yu","zm","zw"};



//----------------------------------------------------------------------------------
// Get Language Name for code
//----------------------------------------------------------------------------------
FXString DVDWindow::getLanguageName(DVDLangID_t lang){
  if (lang==0) return FXString("");
  FXString code;
  code.append((lang >> 8));
  code.append((lang & 0xff));
  return getApp()->reg().readStringEntry("Language Names",code.text(),code.text());
  }


//----------------------------------------------------------------------------------
// Get Country Name for code
//----------------------------------------------------------------------------------
FXString DVDWindow::getCountryName(DVDCountryID_t lang){
  if (lang==0) return FXString("");
  FXString code;
  code.append((lang >> 8));
  code.append((lang & 0xff));
  return getApp()->reg().readStringEntry("Country Names",code.text(),code.text());
  }

//----------------------------------------------------------------------------------
// Convert string code to int code
//----------------------------------------------------------------------------------
DVDLangID_t DVDWindow::getLanguageCode(FXString code){
  return (((unsigned int)(code[1]&0xff)) | ((unsigned int)(code[0]<<8)));
  }

//----------------------------------------------------------------------------------
// Convert string code to int code
//----------------------------------------------------------------------------------
DVDCountryID_t DVDWindow::getCountryCode(FXString code){
  return (((unsigned int)(code[1]&0xff)) | ((unsigned int)(code[0]<<8)));
  }

//----------------------------------------------------------------------------------
// Init Language List Boxes
//----------------------------------------------------------------------------------
void DVDWindow::initLanguageListBoxes(FXListBox * l1,FXListBox * l2,FXListBox * l3,FXString i1,FXString i2,FXString i3){
  for (FXint i=0;i<language_names_count;i++){
    FXString langname = getApp()->reg().readStringEntry("Language Names",sorted_language_codes[i].text(),sorted_language_codes[i].text());
    l1->appendItem(langname,NULL,(void*)sorted_language_codes[i].text());
    l2->appendItem(langname,NULL,(void*)sorted_language_codes[i].text());
    l3->appendItem(langname,NULL,(void*)sorted_language_codes[i].text());
    if (i1==sorted_language_codes[i]) l1->setCurrentItem(i);
    if (i2==sorted_language_codes[i]) l2->setCurrentItem(i);
    if (i3==sorted_language_codes[i]) l3->setCurrentItem(i);
    }

  }

//----------------------------------------------------------------------------------
// Init Country List Boxes
//----------------------------------------------------------------------------------
void DVDWindow::initCountryListBoxes(FXListBox * l1,FXString i1){
  for (FXint i=0;i<country_names_count;i++){
    FXString langname = getApp()->reg().readStringEntry("Country Names",sorted_country_codes[i].text(),sorted_country_codes[i].text());
    l1->appendItem(langname,NULL,(void*)sorted_country_codes[i].text());
    if (i1==sorted_country_codes[i]) l1->setCurrentItem(i);
    }
  }

//----------------------------------------------------------------------------------
// Init Language Names
//----------------------------------------------------------------------------------
void DVDWindow::initLanguageNames(){
  if (getApp()->reg().existingEntry("Language Names","us")) return;

  getApp()->reg().writeStringEntry("Language Names","ab","Abkhazian");
  getApp()->reg().writeStringEntry("Language Names","af","Afrikaans");
  getApp()->reg().writeStringEntry("Language Names","sq","Albanian");
  getApp()->reg().writeStringEntry("Language Names","am","Amharic");
  getApp()->reg().writeStringEntry("Language Names","ar","Arabic");
  getApp()->reg().writeStringEntry("Language Names","hy","Armenian");
  getApp()->reg().writeStringEntry("Language Names","as","Assamese");
  getApp()->reg().writeStringEntry("Language Names","ae","Avestan");
  getApp()->reg().writeStringEntry("Language Names","ay","Aymara");
  getApp()->reg().writeStringEntry("Language Names","az","Azerbaijani");
  getApp()->reg().writeStringEntry("Language Names","ba","Bashkir");
  getApp()->reg().writeStringEntry("Language Names","eu","Basque");
  getApp()->reg().writeStringEntry("Language Names","be","Belarusian");
  getApp()->reg().writeStringEntry("Language Names","bn","Bengali");
  getApp()->reg().writeStringEntry("Language Names","bh","Bihari");
  getApp()->reg().writeStringEntry("Language Names","bi","Bislama");
  getApp()->reg().writeStringEntry("Language Names","bs","Bosnian");
  getApp()->reg().writeStringEntry("Language Names","br","Breton");
  getApp()->reg().writeStringEntry("Language Names","bg","Bulgarian");
  getApp()->reg().writeStringEntry("Language Names","my","Burmese");
  getApp()->reg().writeStringEntry("Language Names","ca","Catalan");
  getApp()->reg().writeStringEntry("Language Names","ch","Chamorro");
  getApp()->reg().writeStringEntry("Language Names","ce","Chechen");
  getApp()->reg().writeStringEntry("Language Names","ny","Chichewa; Nyanja");
  getApp()->reg().writeStringEntry("Language Names","zh","Chinese");
  getApp()->reg().writeStringEntry("Language Names","cu","Church Slavic");
  getApp()->reg().writeStringEntry("Language Names","cv","Chuvash");
  getApp()->reg().writeStringEntry("Language Names","kw","Cornish");
  getApp()->reg().writeStringEntry("Language Names","co","Corsican");
  getApp()->reg().writeStringEntry("Language Names","hr","Croatian");
  getApp()->reg().writeStringEntry("Language Names","cs","Czech");
  getApp()->reg().writeStringEntry("Language Names","da","Danish");
  getApp()->reg().writeStringEntry("Language Names","nl","Dutch");
  getApp()->reg().writeStringEntry("Language Names","dz","Dzongkha");
  getApp()->reg().writeStringEntry("Language Names","en","English");
  getApp()->reg().writeStringEntry("Language Names","eo","Esperanto");
  getApp()->reg().writeStringEntry("Language Names","et","Estonian");
  getApp()->reg().writeStringEntry("Language Names","fo","Faroese");
  getApp()->reg().writeStringEntry("Language Names","fj","Fijian");
  getApp()->reg().writeStringEntry("Language Names","fi","Finnish");
  getApp()->reg().writeStringEntry("Language Names","fr","French");
  getApp()->reg().writeStringEntry("Language Names","fy","Frisian");
  getApp()->reg().writeStringEntry("Language Names","gd","Gaelic (Scots)");
  getApp()->reg().writeStringEntry("Language Names","gl","Gallegan");
  getApp()->reg().writeStringEntry("Language Names","ka","Georgian");
  getApp()->reg().writeStringEntry("Language Names","de","German");
  getApp()->reg().writeStringEntry("Language Names","el","Greek");
  getApp()->reg().writeStringEntry("Language Names","gn","Guarani");
  getApp()->reg().writeStringEntry("Language Names","gu","Gujarati");
  getApp()->reg().writeStringEntry("Language Names","ha","Hausa");
  getApp()->reg().writeStringEntry("Language Names","he","Hebrew");
  getApp()->reg().writeStringEntry("Language Names","iw","Hebrew");
  getApp()->reg().writeStringEntry("Language Names","hz","Herero");
  getApp()->reg().writeStringEntry("Language Names","hi","Hindi");
  getApp()->reg().writeStringEntry("Language Names","ho","Hiri Motu");
  getApp()->reg().writeStringEntry("Language Names","hu","Hungarian");
  getApp()->reg().writeStringEntry("Language Names","is","Icelandic");
  getApp()->reg().writeStringEntry("Language Names","id","Indonesian");
  getApp()->reg().writeStringEntry("Language Names","in","Indonesian");
  getApp()->reg().writeStringEntry("Language Names","ia","Interlingua");
  getApp()->reg().writeStringEntry("Language Names","ie","Interlingue");
  getApp()->reg().writeStringEntry("Language Names","iu","Inuktitut");
  getApp()->reg().writeStringEntry("Language Names","ik","Inupiaq");
  getApp()->reg().writeStringEntry("Language Names","ga","Irish");
  getApp()->reg().writeStringEntry("Language Names","it","Italian");
  getApp()->reg().writeStringEntry("Language Names","ja","Japanese");
  getApp()->reg().writeStringEntry("Language Names","jv","Javanese");
  getApp()->reg().writeStringEntry("Language Names","jw","Javanese");
  getApp()->reg().writeStringEntry("Language Names","kl","Kalaallisut");
  getApp()->reg().writeStringEntry("Language Names","kn","Kannada");
  getApp()->reg().writeStringEntry("Language Names","ks","Kashmiri");
  getApp()->reg().writeStringEntry("Language Names","kk","Kazakh");
  getApp()->reg().writeStringEntry("Language Names","km","Khmer");
  getApp()->reg().writeStringEntry("Language Names","ki","Kikuyu");
  getApp()->reg().writeStringEntry("Language Names","rw","Kinyarwanda");
  getApp()->reg().writeStringEntry("Language Names","ky","Kirghiz");
  getApp()->reg().writeStringEntry("Language Names","kv","Komi");
  getApp()->reg().writeStringEntry("Language Names","ko","Korean");
  getApp()->reg().writeStringEntry("Language Names","kj","Kuanyama");
  getApp()->reg().writeStringEntry("Language Names","ku","Kurdish");
  getApp()->reg().writeStringEntry("Language Names","lo","Lao");
  getApp()->reg().writeStringEntry("Language Names","la","Latin");
  getApp()->reg().writeStringEntry("Language Names","lv","Latvian");
  getApp()->reg().writeStringEntry("Language Names","lb","Letzeburgesch");
  getApp()->reg().writeStringEntry("Language Names","ln","Lingala");
  getApp()->reg().writeStringEntry("Language Names","lt","Lithuanian");
  getApp()->reg().writeStringEntry("Language Names","mk","Macedonian");
  getApp()->reg().writeStringEntry("Language Names","mg","Malagasy");
  getApp()->reg().writeStringEntry("Language Names","ms","Malay");
  getApp()->reg().writeStringEntry("Language Names","ml","Malayalam");
  getApp()->reg().writeStringEntry("Language Names","mt","Maltese");
  getApp()->reg().writeStringEntry("Language Names","gv","Manx");
  getApp()->reg().writeStringEntry("Language Names","mi","Maori");
  getApp()->reg().writeStringEntry("Language Names","mr","Marathi");
  getApp()->reg().writeStringEntry("Language Names","mh","Marshall");
  getApp()->reg().writeStringEntry("Language Names","mo","Moldavian");
  getApp()->reg().writeStringEntry("Language Names","mn","Mongolian");
  getApp()->reg().writeStringEntry("Language Names","na","Nauru");
  getApp()->reg().writeStringEntry("Language Names","nv","Navajo");
  getApp()->reg().writeStringEntry("Language Names","nd","Ndebele, North");
  getApp()->reg().writeStringEntry("Language Names","nr","Ndebele, South");
  getApp()->reg().writeStringEntry("Language Names","ng","Ndonga");
  getApp()->reg().writeStringEntry("Language Names","ne","Nepali");
  getApp()->reg().writeStringEntry("Language Names","se","Northern Sami");
  getApp()->reg().writeStringEntry("Language Names","no","Norwegian");
//  getApp()->reg().writeStringEntry("Language Names","nb","Norwegian Bokml");
  getApp()->reg().writeStringEntry("Language Names","nn","Norwegian Nynorsk");
  getApp()->reg().writeStringEntry("Language Names","ny","Nyanja; Chichewa");
  getApp()->reg().writeStringEntry("Language Names","oc","Occitan");
  getApp()->reg().writeStringEntry("Language Names","or","Oriya");
  getApp()->reg().writeStringEntry("Language Names","om","Oromo");
  getApp()->reg().writeStringEntry("Language Names","os","Ossetian");
  getApp()->reg().writeStringEntry("Language Names","pi","Pali");
  getApp()->reg().writeStringEntry("Language Names","pa","Panjabi");
  getApp()->reg().writeStringEntry("Language Names","fa","Persian");
  getApp()->reg().writeStringEntry("Language Names","pl","Polish");
  getApp()->reg().writeStringEntry("Language Names","pt","Portuguese");
//  getApp()->reg().writeStringEntry("Language Names","oc","Provenal");
  getApp()->reg().writeStringEntry("Language Names","ps","Pushto");
  getApp()->reg().writeStringEntry("Language Names","qu","Quechua");
  getApp()->reg().writeStringEntry("Language Names","rm","Raeto-Romance");
  getApp()->reg().writeStringEntry("Language Names","ro","Romanian");
  getApp()->reg().writeStringEntry("Language Names","rn","Rundi");
  getApp()->reg().writeStringEntry("Language Names","ru","Russian");
  getApp()->reg().writeStringEntry("Language Names","sm","Samoan");
  getApp()->reg().writeStringEntry("Language Names","sg","Sango");
  getApp()->reg().writeStringEntry("Language Names","sa","Sanskrit");
  getApp()->reg().writeStringEntry("Language Names","sc","Sardinian");
  getApp()->reg().writeStringEntry("Language Names","sr","Serbian");
  getApp()->reg().writeStringEntry("Language Names","sh","Serbo-Croatian");
  getApp()->reg().writeStringEntry("Language Names","sn","Shona");
  getApp()->reg().writeStringEntry("Language Names","sd","Sindhi");
  getApp()->reg().writeStringEntry("Language Names","si","Sinhalese");
  getApp()->reg().writeStringEntry("Language Names","sk","Slovak");
  getApp()->reg().writeStringEntry("Language Names","sl","Slovenian");
  getApp()->reg().writeStringEntry("Language Names","so","Somali");
  getApp()->reg().writeStringEntry("Language Names","st","Sotho, Southern");
  getApp()->reg().writeStringEntry("Language Names","es","Spanish");
  getApp()->reg().writeStringEntry("Language Names","su","Sundanese");
  getApp()->reg().writeStringEntry("Language Names","sw","Swahili");
  getApp()->reg().writeStringEntry("Language Names","ss","Swati");
  getApp()->reg().writeStringEntry("Language Names","sv","Swedish");
  getApp()->reg().writeStringEntry("Language Names","tl","Tagalog");
  getApp()->reg().writeStringEntry("Language Names","ty","Tahitian");
  getApp()->reg().writeStringEntry("Language Names","tg","Tajik");
  getApp()->reg().writeStringEntry("Language Names","ta","Tamil");
  getApp()->reg().writeStringEntry("Language Names","tt","Tatar");
  getApp()->reg().writeStringEntry("Language Names","te","Telugu");
  getApp()->reg().writeStringEntry("Language Names","th","Thai");
  getApp()->reg().writeStringEntry("Language Names","bo","Tibetan");
  getApp()->reg().writeStringEntry("Language Names","ti","Tigrinya");
  getApp()->reg().writeStringEntry("Language Names","to","Tonga");
  getApp()->reg().writeStringEntry("Language Names","ts","Tsonga");
  getApp()->reg().writeStringEntry("Language Names","tn","Tswana");
  getApp()->reg().writeStringEntry("Language Names","tr","Turkish");
  getApp()->reg().writeStringEntry("Language Names","tk","Turkmen");
  getApp()->reg().writeStringEntry("Language Names","tw","Twi");
  getApp()->reg().writeStringEntry("Language Names","ug","Uighur");
  getApp()->reg().writeStringEntry("Language Names","uk","Ukrainian");
  getApp()->reg().writeStringEntry("Language Names","ur","Urdu");
  getApp()->reg().writeStringEntry("Language Names","uz","Uzbek");
  getApp()->reg().writeStringEntry("Language Names","vi","Vietnamese");
//  getApp()->reg().writeStringEntry("Language Names","vo","Volapk");
  getApp()->reg().writeStringEntry("Language Names","cy","Welsh");
  getApp()->reg().writeStringEntry("Language Names","wo","Wolof");
  getApp()->reg().writeStringEntry("Language Names","xh","Xhosa");
  getApp()->reg().writeStringEntry("Language Names","yi","Yiddish");
  getApp()->reg().writeStringEntry("Language Names","ji","Yiddish");
  getApp()->reg().writeStringEntry("Language Names","yo","Yoruba");
  getApp()->reg().writeStringEntry("Language Names","za","Zhuang");
  getApp()->reg().writeStringEntry("Language Names","zu","Zulu");
  }


//----------------------------------------------------------------------------------
// Init Country Names
//----------------------------------------------------------------------------------
void DVDWindow::initCountryNames(){

  if (getApp()->reg().existingEntry("Country Names","us")) return;

  getApp()->reg().writeStringEntry("Country Names","af","Afghanistan");

  getApp()->reg().writeStringEntry("Country Names","al","Albania");
  getApp()->reg().writeStringEntry("Country Names","dz","Algeria");
  getApp()->reg().writeStringEntry("Country Names","as","American Samoa");
  getApp()->reg().writeStringEntry("Country Names","ad","Andorra");
  getApp()->reg().writeStringEntry("Country Names","ao","Angola");
  getApp()->reg().writeStringEntry("Country Names","ai","Anguilla");
  getApp()->reg().writeStringEntry("Country Names","aq","Antarctica");
  getApp()->reg().writeStringEntry("Country Names","ag","Antigua and Barbuda");
  getApp()->reg().writeStringEntry("Country Names","ar","Argentina");
  getApp()->reg().writeStringEntry("Country Names","am","Armenia");
  getApp()->reg().writeStringEntry("Country Names","aw","Aruba");
  getApp()->reg().writeStringEntry("Country Names","au","Australia");
  getApp()->reg().writeStringEntry("Country Names","at","Austria");
  getApp()->reg().writeStringEntry("Country Names","az","Azerbaijan");
  getApp()->reg().writeStringEntry("Country Names","bs","Bahamas");
  getApp()->reg().writeStringEntry("Country Names","bh","Bahrain");
  getApp()->reg().writeStringEntry("Country Names","bd","Bangladesh");
  getApp()->reg().writeStringEntry("Country Names","bb","Barbados");
  getApp()->reg().writeStringEntry("Country Names","by","Belarus");
  getApp()->reg().writeStringEntry("Country Names","be","Belgium");
  getApp()->reg().writeStringEntry("Country Names","bz","Belize");
  getApp()->reg().writeStringEntry("Country Names","bj","Benin");
  getApp()->reg().writeStringEntry("Country Names","bm","Bermuda");
  getApp()->reg().writeStringEntry("Country Names","bt","Bhutan");
  getApp()->reg().writeStringEntry("Country Names","bo","Bolivia");
  getApp()->reg().writeStringEntry("Country Names","ba","Bosina and Herzegovina");
  getApp()->reg().writeStringEntry("Country Names","bw","Botswana");
  getApp()->reg().writeStringEntry("Country Names","bv","Bouvet Island");
  getApp()->reg().writeStringEntry("Country Names","br","Brazil");
  getApp()->reg().writeStringEntry("Country Names","io","British Indian Ocean Territory");

  getApp()->reg().writeStringEntry("Country Names","bn","Brunei Darussalam");
  getApp()->reg().writeStringEntry("Country Names","bg","Bulgaria");
  getApp()->reg().writeStringEntry("Country Names","bf","Burkina Faso");
  getApp()->reg().writeStringEntry("Country Names","bi","Burundi");
  getApp()->reg().writeStringEntry("Country Names","kh","Cambodia");
  getApp()->reg().writeStringEntry("Country Names","cm","Cameroon");
  getApp()->reg().writeStringEntry("Country Names","ca","Canada");
  getApp()->reg().writeStringEntry("Country Names","cv","Cape Verde");
  getApp()->reg().writeStringEntry("Country Names","ky","Cayman Islands");
  getApp()->reg().writeStringEntry("Country Names","cf","Central African Republic");
  getApp()->reg().writeStringEntry("Country Names","td","Chad");
  getApp()->reg().writeStringEntry("Country Names","cl","Chile");
  getApp()->reg().writeStringEntry("Country Names","cn","China");
  getApp()->reg().writeStringEntry("Country Names","cx","Christmas Island");
  getApp()->reg().writeStringEntry("Country Names","cc","Cocos (Keeling) Islands");
  getApp()->reg().writeStringEntry("Country Names","co","Colombia");
  getApp()->reg().writeStringEntry("Country Names","km","Comoros");
  getApp()->reg().writeStringEntry("Country Names","cg","Congo");
  getApp()->reg().writeStringEntry("Country Names","cd","Congo, The Democratic Republic of The");
  getApp()->reg().writeStringEntry("Country Names","ck","Cook Islands");
  getApp()->reg().writeStringEntry("Country Names","cr","Costa Rica");
//  getApp()->reg().writeStringEntry("Country Names","ci","Cte D'Ivoire");
  getApp()->reg().writeStringEntry("Country Names","hr","Croatia");
  getApp()->reg().writeStringEntry("Country Names","cu","Cuba");
  getApp()->reg().writeStringEntry("Country Names","cy","Cyprus");
  getApp()->reg().writeStringEntry("Country Names","cz","Czech Republic");
  getApp()->reg().writeStringEntry("Country Names","dk","Denmark");
  getApp()->reg().writeStringEntry("Country Names","dj","Djibouti");
  getApp()->reg().writeStringEntry("Country Names","dm","Dominica");
  getApp()->reg().writeStringEntry("Country Names","do","Dominican Republic");
  getApp()->reg().writeStringEntry("Country Names","tl","East Timor");
  getApp()->reg().writeStringEntry("Country Names","ec","Ecuador");
  getApp()->reg().writeStringEntry("Country Names","eg","Egypt");
  getApp()->reg().writeStringEntry("Country Names","sv","El Salvador");
  getApp()->reg().writeStringEntry("Country Names","gq","Equatorial Guinea");
  getApp()->reg().writeStringEntry("Country Names","er","Eritrea");
  getApp()->reg().writeStringEntry("Country Names","ee","Estonia");
  getApp()->reg().writeStringEntry("Country Names","et","Ethiopia");
  getApp()->reg().writeStringEntry("Country Names","fk","Falkland Islands (Malvinas)");
  getApp()->reg().writeStringEntry("Country Names","fo","Faroe Islands");
  getApp()->reg().writeStringEntry("Country Names","fj","Fiji");
  getApp()->reg().writeStringEntry("Country Names","fi","Finland");
  getApp()->reg().writeStringEntry("Country Names","fr","France");
  getApp()->reg().writeStringEntry("Country Names","gf","French Guiana");
  getApp()->reg().writeStringEntry("Country Names","pf","French Polynesia");
  getApp()->reg().writeStringEntry("Country Names","tf","French Southern Territories");
  getApp()->reg().writeStringEntry("Country Names","ga","Gabon");
  getApp()->reg().writeStringEntry("Country Names","gm","Gambia");
  getApp()->reg().writeStringEntry("Country Names","ge","Georgia");
  getApp()->reg().writeStringEntry("Country Names","de","Germany");
  getApp()->reg().writeStringEntry("Country Names","gh","Ghana");
  getApp()->reg().writeStringEntry("Country Names","gi","Gibraltar");
  getApp()->reg().writeStringEntry("Country Names","gr","Greece");
  getApp()->reg().writeStringEntry("Country Names","gl","Greenland");
  getApp()->reg().writeStringEntry("Country Names","gd","Grenada");
  getApp()->reg().writeStringEntry("Country Names","gp","Guadeloupe");
  getApp()->reg().writeStringEntry("Country Names","gu","Guam");

  getApp()->reg().writeStringEntry("Country Names","gt","Guatemala");
  getApp()->reg().writeStringEntry("Country Names","gn","Guinea");
  getApp()->reg().writeStringEntry("Country Names","gw","Guinea-Bissau");
  getApp()->reg().writeStringEntry("Country Names","gy","Guyana");
  getApp()->reg().writeStringEntry("Country Names","hi","Haiti");
  getApp()->reg().writeStringEntry("Country Names","hm","Heard Island and McDonald Islands");
  getApp()->reg().writeStringEntry("Country Names","va","Vatican City State");
  getApp()->reg().writeStringEntry("Country Names","hn","Honduras");
  getApp()->reg().writeStringEntry("Country Names","hk","Hong Kong");
  getApp()->reg().writeStringEntry("Country Names","hu","Hungary");
  getApp()->reg().writeStringEntry("Country Names","is","Iceland");
  getApp()->reg().writeStringEntry("Country Names","in","India");
  getApp()->reg().writeStringEntry("Country Names","id","Indonesia");
  getApp()->reg().writeStringEntry("Country Names","ir","Iran, Islamic Republic of");
  getApp()->reg().writeStringEntry("Country Names","iq","Iraq");
  getApp()->reg().writeStringEntry("Country Names","ie","Ireland");
  getApp()->reg().writeStringEntry("Country Names","il","Israel");
  getApp()->reg().writeStringEntry("Country Names","it","Italy");
  getApp()->reg().writeStringEntry("Country Names","jm","Jamaica");
  getApp()->reg().writeStringEntry("Country Names","jp","Japan");
  getApp()->reg().writeStringEntry("Country Names","jo","Jordan");
  getApp()->reg().writeStringEntry("Country Names","kz","Kazakhstan");
  getApp()->reg().writeStringEntry("Country Names","ke","Kenya");
  getApp()->reg().writeStringEntry("Country Names","ki","Kiribati");
  getApp()->reg().writeStringEntry("Country Names","kp","Korea, Democratic People's Republic of");
  getApp()->reg().writeStringEntry("Country Names","kr","Korea, Republic of");
  getApp()->reg().writeStringEntry("Country Names","kw","Kuwait");
  getApp()->reg().writeStringEntry("Country Names","kg","Kyrgyzstan");
  getApp()->reg().writeStringEntry("Country Names","la","Lao People's Democratic Republic");
  getApp()->reg().writeStringEntry("Country Names","lv","Latvia");
  getApp()->reg().writeStringEntry("Country Names","lb","Lebanon");
  getApp()->reg().writeStringEntry("Country Names","ls","Lesotho");
  getApp()->reg().writeStringEntry("Country Names","lr","Liberia");
  getApp()->reg().writeStringEntry("Country Names","ly","Libyan Arab Jamahiriya");
  getApp()->reg().writeStringEntry("Country Names","li","Liechtenstein");
  getApp()->reg().writeStringEntry("Country Names","lt","Lithuania");
  getApp()->reg().writeStringEntry("Country Names","lu","Luxembourg");
  getApp()->reg().writeStringEntry("Country Names","mo","Macao");
  getApp()->reg().writeStringEntry("Country Names","mk","Macedonia, The Former Yugoslav Republic of");
  getApp()->reg().writeStringEntry("Country Names","mg","Madagascar");
  getApp()->reg().writeStringEntry("Country Names","mw","Malawi");
  getApp()->reg().writeStringEntry("Country Names","my","Malaysia");
  getApp()->reg().writeStringEntry("Country Names","mv","Maldives");
  getApp()->reg().writeStringEntry("Country Names","ml","Mali");
  getApp()->reg().writeStringEntry("Country Names","mt","Malta");
  getApp()->reg().writeStringEntry("Country Names","mh","Marshall Islands");
  getApp()->reg().writeStringEntry("Country Names","mq","Martinique");
  getApp()->reg().writeStringEntry("Country Names","mr","Mauritania");
  getApp()->reg().writeStringEntry("Country Names","mu","Mauritius");
  getApp()->reg().writeStringEntry("Country Names","yt","Mayotte");
  getApp()->reg().writeStringEntry("Country Names","mx","Mexico");
  getApp()->reg().writeStringEntry("Country Names","fm","Micronesia, Federated States of");
  getApp()->reg().writeStringEntry("Country Names","md","Moldova, Republic of");
  getApp()->reg().writeStringEntry("Country Names","mc","Monaco");
  getApp()->reg().writeStringEntry("Country Names","mn","Mongolia");
  getApp()->reg().writeStringEntry("Country Names","ms","Montserrat");
  getApp()->reg().writeStringEntry("Country Names","ma","Morocco");
  getApp()->reg().writeStringEntry("Country Names","mz","Mozambique");
  getApp()->reg().writeStringEntry("Country Names","mm","Myanmar");
  getApp()->reg().writeStringEntry("Country Names","na","Namibia");
  getApp()->reg().writeStringEntry("Country Names","nr","Nauru");
  getApp()->reg().writeStringEntry("Country Names","np","Nepal");
  getApp()->reg().writeStringEntry("Country Names","nl","Netherlands");
  getApp()->reg().writeStringEntry("Country Names","an","Netherlands Antilles");
  getApp()->reg().writeStringEntry("Country Names","nc","New Caledonia");
  getApp()->reg().writeStringEntry("Country Names","nz","New Zealand");
  getApp()->reg().writeStringEntry("Country Names","ni","Nicaragua");
  getApp()->reg().writeStringEntry("Country Names","ne","Niger");
  getApp()->reg().writeStringEntry("Country Names","ng","Nigeria");
  getApp()->reg().writeStringEntry("Country Names","nu","Niue");
  getApp()->reg().writeStringEntry("Country Names","nf","Norfolk Island");
  getApp()->reg().writeStringEntry("Country Names","mp","Northern Mariana Islands");
  getApp()->reg().writeStringEntry("Country Names","no","Norway");
  getApp()->reg().writeStringEntry("Country Names","om","Oman");
  getApp()->reg().writeStringEntry("Country Names","pk","Pakistan");
  getApp()->reg().writeStringEntry("Country Names","pw","Palau");
  getApp()->reg().writeStringEntry("Country Names","ps","Palestinian Territory, Occupied");
  getApp()->reg().writeStringEntry("Country Names","pa","Panama");
  getApp()->reg().writeStringEntry("Country Names","pg","Papua New Guinea");
  getApp()->reg().writeStringEntry("Country Names","py","Paraguay");
  getApp()->reg().writeStringEntry("Country Names","pe","Peru");
  getApp()->reg().writeStringEntry("Country Names","ph","Philippines");
  getApp()->reg().writeStringEntry("Country Names","pn","Pitcairn");
  getApp()->reg().writeStringEntry("Country Names","pl","Poland");
  getApp()->reg().writeStringEntry("Country Names","pt","Portugal");
  getApp()->reg().writeStringEntry("Country Names","pr","Puerto Rico");
  getApp()->reg().writeStringEntry("Country Names","qa","Qatar");
//  getApp()->reg().writeStringEntry("Country Names","re","Runion");
  getApp()->reg().writeStringEntry("Country Names","ro","Romania");
  getApp()->reg().writeStringEntry("Country Names","ru","Russian Federation");
  getApp()->reg().writeStringEntry("Country Names","rw","Rwanda");
  getApp()->reg().writeStringEntry("Country Names","sh","Saint Helena");
  getApp()->reg().writeStringEntry("Country Names","kn","Saint Kitts and Nevis");
  getApp()->reg().writeStringEntry("Country Names","lc","Saint Lucia");
  getApp()->reg().writeStringEntry("Country Names","pm","Saint Pierre and Miquelon");
  getApp()->reg().writeStringEntry("Country Names","vc","Saint Vincent and the Grenadines");
  getApp()->reg().writeStringEntry("Country Names","ws","Samoa");
  getApp()->reg().writeStringEntry("Country Names","sm","San Marino");
  getApp()->reg().writeStringEntry("Country Names","st","Sao Tome and Principe");
  getApp()->reg().writeStringEntry("Country Names","sa","Saudi Arabia");
  getApp()->reg().writeStringEntry("Country Names","sn","Senegal");

  getApp()->reg().writeStringEntry("Country Names","sc","Seychelles");
  getApp()->reg().writeStringEntry("Country Names","sl","Sierra Leone");
  getApp()->reg().writeStringEntry("Country Names","sg","Singapore");
  getApp()->reg().writeStringEntry("Country Names","sk","Slovakia");
  getApp()->reg().writeStringEntry("Country Names","si","Slovenia");
  getApp()->reg().writeStringEntry("Country Names","sb","Solomon Islands");
  getApp()->reg().writeStringEntry("Country Names","so","Somalia");
  getApp()->reg().writeStringEntry("Country Names","za","South Africa");
  getApp()->reg().writeStringEntry("Country Names","gs","South Georgia and the South Sandwich Islands");
  getApp()->reg().writeStringEntry("Country Names","es","Spain");
  getApp()->reg().writeStringEntry("Country Names","lk","Sri Lanka");
  getApp()->reg().writeStringEntry("Country Names","sd","Sudan");
  getApp()->reg().writeStringEntry("Country Names","sr","Suriname");
  getApp()->reg().writeStringEntry("Country Names","sj","Svalbard and Jan Mayen");
  getApp()->reg().writeStringEntry("Country Names","sz","Swaziland");
  getApp()->reg().writeStringEntry("Country Names","se","Sweden");
  getApp()->reg().writeStringEntry("Country Names","ch","Switzerland");
  getApp()->reg().writeStringEntry("Country Names","sy","Syrian Arab Republic");
  getApp()->reg().writeStringEntry("Country Names","tw","Taiwan, Province of China");
  getApp()->reg().writeStringEntry("Country Names","tj","Tajikistan");
  getApp()->reg().writeStringEntry("Country Names","tz","Tanzania, United Republic of");
  getApp()->reg().writeStringEntry("Country Names","th","Thailand");
  getApp()->reg().writeStringEntry("Country Names","tg","Togo");
  getApp()->reg().writeStringEntry("Country Names","tk","Tokelau");
  getApp()->reg().writeStringEntry("Country Names","td","Tonga");
  getApp()->reg().writeStringEntry("Country Names","tt","Trinidad and Tobago");
  getApp()->reg().writeStringEntry("Country Names","tn","Tunisia");
  getApp()->reg().writeStringEntry("Country Names","tr","Turkey");
  getApp()->reg().writeStringEntry("Country Names","tm","Turkmenistan");
  getApp()->reg().writeStringEntry("Country Names","tc","Turks and Caicos Islands");
  getApp()->reg().writeStringEntry("Country Names","tv","Tuvalu");
  getApp()->reg().writeStringEntry("Country Names","ug","Uganda");
  getApp()->reg().writeStringEntry("Country Names","ua","Ukraine");
  getApp()->reg().writeStringEntry("Country Names","ae","United Arab Emirates");
  getApp()->reg().writeStringEntry("Country Names","gb","United Kingdom");
  getApp()->reg().writeStringEntry("Country Names","us","United States");
  getApp()->reg().writeStringEntry("Country Names","um","United States Minore Outlying Islands");
  getApp()->reg().writeStringEntry("Country Names","uy","Uruguay");
  getApp()->reg().writeStringEntry("Country Names","uz","Uzbekistan");
  getApp()->reg().writeStringEntry("Country Names","vu","Vanuatu");
  getApp()->reg().writeStringEntry("Country Names","ve","Venezuela");
  getApp()->reg().writeStringEntry("Country Names","vn","Viet Nam");
  getApp()->reg().writeStringEntry("Country Names","vg","Virgin Islands, British");
  getApp()->reg().writeStringEntry("Country Names","vi","Virgin Islands, U.S.");
  getApp()->reg().writeStringEntry("Country Names","wf","Wallis and Futuna");
  getApp()->reg().writeStringEntry("Country Names","eh","Western Sahara");
  getApp()->reg().writeStringEntry("Country Names","ye","Yemen");
  getApp()->reg().writeStringEntry("Country Names","yu","Yugoslavia");
  getApp()->reg().writeStringEntry("Country Names","zm","Zambia");
  getApp()->reg().writeStringEntry("Country Names","zw","Zimbabwe");

  }
