/*******************************************************************************
*               Goggles - Graphical User Interface for OGLE                    *
********************************************************************************
*        Copyright (C) 2002-2005 by Sander Jansen. All Rights Reserved              *
*                               ---                                            *
* This program is free software; you can redistribute it and/or modify         *
* it under the terms of the GNU General Public License as published by         *
* the Free Software Foundation; either version 2 of the License, or            *
* (at your option) any later version.                                          *
*                                                                              *
* This program is distributed in the hope that it will be useful,              *
* but WITHOUT ANY WARRANTY; without even the implied warranty of               *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the                *
* GNU General Public License for more details.                                 *
* You should have received a copy of the GNU General Public License            *
* along with this program; if not, write to the Free Software                  *
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA    *
*******************************************************************************/

/*
$Id: dvddxr3.cpp,v 1.1.1.1 2003/02/05 06:47:48 sander Exp $
*/
#ifdef HAVE_DXR3

#include <fx.h>
#include <stdlib.h>
#include <unistd.h>
#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <sys/ioctl.h>
#include <linux/em8300.h>
#include "dvddxr3.h"

// Define Message Map
FXDEFMAP(FXDXR3) FXDXR3Map[]={
  FXMAPFUNC(SEL_COMMAND,        FXDXR3::ID_DEVICESELECT,                 FXDXR3::onCmdSwitchDevice),
  FXMAPFUNC(SEL_COMMAND,        FXDXR3::ID_AUDIOMODE_AC3,                FXDXR3::onCmdAudioModeAC3),
  FXMAPFUNC(SEL_COMMAND,        FXDXR3::ID_AUDIOMODE_DIGITALPCM,         FXDXR3::onCmdAudioModeDigital),
  FXMAPFUNC(SEL_COMMAND,        FXDXR3::ID_AUDIOMODE_ANALOG,             FXDXR3::onCmdAudioModeAnalog),

  FXMAPFUNC(SEL_UPDATE,         FXDXR3::ID_AUDIOMODE_AC3,                FXDXR3::onUpdAudioModeAC3),
  FXMAPFUNC(SEL_UPDATE,         FXDXR3::ID_AUDIOMODE_DIGITALPCM,         FXDXR3::onUpdAudioModeDigital),
  FXMAPFUNC(SEL_UPDATE,         FXDXR3::ID_AUDIOMODE_ANALOG,             FXDXR3::onUpdAudioModeAnalog)
  };

FXIMPLEMENT(FXDXR3,FXObject,FXDXR3Map,ARRAYNUMBER(FXDXR3Map))





FXDXR3::FXDXR3(){
  fd=-1;
  device_audio_mode=-1;
  }

FXDXR3::FXDXR3(const FXString & dev){
  fd=-1;
  device_audio_mode=-1;
  device=dev;
  init();
  }

FXDXR3::~FXDXR3(){
  if (fd!=-1) ::close(fd);
  }


FXbool FXDXR3::init(){
  fd=open(device.text(),O_RDONLY);
  if (fd==-1){
    return FALSE;
    }
  }

FXint FXDXR3::getAudioMode(){
  if (fd==-1) return -1;
  if (device_audio_mode!=-1) return device_audio_mode;
  if(ioctl(fd,EM8300_IOCTL_GET_AUDIOMODE,&device_audio_mode)==-1){
    return -1;
    }
  return device_audio_mode;
  }

FXbool FXDXR3::setAudioMode(FXint mode){
  if (fd==-1) return FALSE;
  if (ioctl(fd,EM8300_IOCTL_GET_AUDIOMODE,&device_audio_mode)==-1) return FALSE;
  if (device_audio_mode==mode) return TRUE;
  if (ioctl(fd, EM8300_IOCTL_SET_AUDIOMODE,&mode) == -1) return FALSE;
  device_audio_mode=mode;
  return TRUE;
  }

FXbool FXDXR3::isInitialized(){
  if (fd==-1) return FALSE;
  return TRUE;
  }

void FXDXR3::setDevice(const FXString & dev){
  if (fd!=-1) {
    close(fd);
    fd==-1;
    device_audio_mode=-1;
    }
  device=dev;
  init();
  }

long FXDXR3::onCmdSwitchDevice(FXObject*,FXSelector,void* data){
  setDevice(FXString((char*)data));
  return 1;
  }


long FXDXR3::onCmdAudioModeAnalog(FXObject*,FXSelector,void* data){
  setAudioMode(EM8300_AUDIOMODE_ANALOG);
  return 1;
  }

long FXDXR3::onCmdAudioModeDigital(FXObject*,FXSelector,void* data){
  setAudioMode(EM8300_AUDIOMODE_DIGITALPCM);
  return 1;
  }

long FXDXR3::onCmdAudioModeAC3(FXObject*,FXSelector,void* data){
  setAudioMode(EM8300_AUDIOMODE_DIGITALAC3);
  return 1;
  }


long FXDXR3::onUpdAudioModeAnalog(FXObject* object,FXSelector,void* data){
  FXint am=getAudioMode();
  if (am==EM8300_AUDIOMODE_DIGITALAC3 || am==-1)
    object->handle(this,FXSEL(SEL_COMMAND,FXWindow::ID_DISABLE),NULL);
  else
    object->handle(this,FXSEL(SEL_COMMAND,FXWindow::ID_ENABLE),NULL);

  if (am==EM8300_AUDIOMODE_ANALOG)
      object->handle(this,FXSEL(SEL_COMMAND,FXWindow::ID_CHECK),NULL);
  else
      object->handle(this,FXSEL(SEL_COMMAND,FXWindow::ID_UNCHECK),NULL);

  return 1;
  }

long FXDXR3::onUpdAudioModeDigital(FXObject*object,FXSelector,void* data){
  FXint am=getAudioMode();
  if (am==EM8300_AUDIOMODE_DIGITALAC3 || am==-1)
    object->handle(this,FXSEL(SEL_COMMAND,FXWindow::ID_DISABLE),NULL);
  else
    object->handle(this,FXSEL(SEL_COMMAND,FXWindow::ID_ENABLE),NULL);

  if (am==EM8300_AUDIOMODE_DIGITALPCM)
      object->handle(this,FXSEL(SEL_COMMAND,FXWindow::ID_CHECK),NULL);
  else
      object->handle(this,FXSEL(SEL_COMMAND,FXWindow::ID_UNCHECK),NULL);

  return 1;
  }

long FXDXR3::onUpdAudioModeAC3(FXObject*object,FXSelector,void* data){
  FXint am=getAudioMode();

  if (am==EM8300_AUDIOMODE_DIGITALAC3) {
    object->handle(this,FXSEL(SEL_COMMAND,FXWindow::ID_ENABLE),NULL);
    object->handle(this,FXSEL(SEL_COMMAND,FXWindow::ID_CHECK),NULL);
    }
  else {
    object->handle(this,FXSEL(SEL_COMMAND,FXWindow::ID_DISABLE),NULL);
    object->handle(this,FXSEL(SEL_COMMAND,FXWindow::ID_UNCHECK),NULL);
    }
  return 1;
  }









/*

FXint dxr3_getVideoMode(FXString device){
  int fd,video_mode;
  fd=open(device.text(),O_RDONLY);
  if (fd==-1)
    return -1;

  if(ioctl(fd,EM8300_IOCTL_GET_VIDEOMODE,&video_mode)==-1)
    return -1;

  return video_mode;
  }


FXbool dxr3_setVideoMode(FXString device,FXint mode){
  int fd;
  fd=open(device.text(),O_RDONLY);
  if (fd==-1)
    return FALSE;

  if (ioctl(fd, EM8300_IOCTL_SET_VIDEOMODE,&mode) == -1)
    return FALSE;

  return TRUE;
  }


FXbool dxr3_getVideoBCS(FXString device,FXint & b,FXint & c, FXint & s){
  em8300_bcs_t bcs;

  int fd;
  fd=open(device.text(),O_RDONLY);
  if (fd==-1)
    return FALSE;

  if (ioctl(fd, EM8300_IOCTL_GETBCS,&bcs) == -1)
    return FALSE;

	b = bcs.brightness;
	c = bcs.contrast;
	s = bcs.saturation;
  return TRUE;
  }


FXbool dxr3_setVideoBCS(FXString device,FXint b,FXint c,FXint s){
  em8300_bcs_t bcs={b,c,s};
  int fd;
  fd=open(device.text(),O_RDONLY);
  if (fd==-1)
    return FALSE;

  if (ioctl(fd, EM8300_IOCTL_SETBCS,&bcs) == -1)
    return FALSE;

  return TRUE;
  }

*/

#endif
