/*******************************************************************************
*               Goggles - Graphical User Interface for OGLE                    *
********************************************************************************
*        Copyright (C) 2002-2005 by Sander Jansen. All Rights Reserved         *
*                               ---                                            *
* This program is free software; you can redistribute it and/or modify         *
* it under the terms of the GNU General Public License as published by         *
* the Free Software Foundation; either version 2 of the License, or            *
* (at your option) any later version.                                          *
*                                                                              *
* This program is distributed in the hope that it will be useful,              *
* but WITHOUT ANY WARRANTY; without even the implied warranty of               *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the                *
* GNU General Public License for more details.                                 *
* You should have received a copy of the GNU General Public License            *
* along with this program; if not, write to the Free Software                  *
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA    *
*******************************************************************************/

#include <xincs.h>
#ifdef HAVE_XV
#include <X11/extensions/Xvlib.h>
#endif
#include <fx.h>
#include "dvdapp.h"
#include "dvdxv.h"

#define DISPLAY ((Display*)(getDisplay()))

FXIMPLEMENT(DVDApp,FXApp,NULL,0);

//********************************************************************
//
// Constructor
//
//********************************************************************
DVDApp::DVDApp() : FXApp("Goggles","FIFTHPLANET"){
  }


//********************************************************************
//
// Destructor
//
//********************************************************************
DVDApp::~DVDApp(){
#ifdef HAVE_XV
  delete xvcontrol;
#endif
  }


//********************************************************************
//
// Create
//
//********************************************************************
void DVDApp::create(){
  FXApp::create();
#ifdef HAVE_XV
  xvcontrol = new XVController(this);
#endif
  }


FXbool DVDApp::dispatchEvent(FXRawEvent & ev){
#ifdef HAVE_XV
  if (ev.xany.type==(FXint)(xvcontrol->getEventBase()+XvPortNotify)){
    //XvPortNotifyEvent * event = dynamic_cast<XvPortNotifyEvent*>(&ev);
    XvPortNotifyEvent *event = (XvPortNotifyEvent *)&ev;
    xvcontrol->setPropertyValue(event->port_id,event->attribute,event->value);
    return TRUE;
    }
#endif
  return FXApp::dispatchEvent(ev);
  }

