%define name goggles
%define dirname		goggles
%define version		0.8.0
%define release		1
%define builddir	$RPM_BUILD_DIR/%{dirname}-%{version}
%define prefixdef	/usr
%define defaultdxr3 no

# If you don't like the prefix '/usr' you can override it like this:
# rpm -ba|--rebuild --define 'prefix /usr/local'
%{?!prefix:%define prefix %{prefixdef}}
%{?!dxr3:%define dxr3 %{defaultdxr3}}

Name:		%{name}
Version:	%{version}
Release:	1
Vendor:		Generic
Packager:	Florin Andrei <florin@andrei.myip.org>
URL:		http://www.fifthplanet.net/goggles.html
Source:		%{dirname}-%{version}.tar.bz2
Group:		Applications/Multimedia
License:	GPL
Provides:	goggles
BuildRoot:	%{_tmppath}/%{dirname}-%{version}
Requires:	fox >= 1.4.0, ogle >= 0.9.2
Summary:	Graphical user interface (GUI) for Ogle dvd player


%description
Graphical user interface (GUI) for Ogle dvd player

%prep
%setup -n %{dirname}-%{version}

%build
export CFLAGS="$RPM_OPT_FLAGS"
export CPPFLAGS="$RPM_OPT_FLAGS"
export CXXFLAGS="$RPM_OPT_FLAGS"
./gb --ogle-cvs=yes --with-xv=yes
./gb install

%install
[ -n "$RPM_BUILD_ROOT" -a "$RPM_BUILD_ROOT" != / ] && rm -rf "$RPM_BUILD_ROOT"
mkdir -p %{buildroot}%{_datadir}/applications
cp -p desktop/goggles.desktop %{buildroot}%{_datadir}/applications
mkdir -p %{buildroot}%{_datadir}/goggles
cp -p desktop/goggles_manual.pdf %{buildroot}%{_datadir}/goggles
mkdir -p %{buildroot}%{_datadir}/pixmaps
cp -p icons/dvd_small_png.png %{buildroot}%{_datadir}/pixmaps/goggles.png
mkdir -p %{buildroot}%{_bindir}
cp -p src/ogle_gui_goggles %{buildroot}%{_bindir}
#Create the Goggles Script
sed "s|@prefix@|/usr|" scripts/goggles.in > %{buildroot}%{_bindir}/goggles


%clean
[ -n "$RPM_BUILD_ROOT" -a "$RPM_BUILD_ROOT" != / ] && rm -rf "$RPM_BUILD_ROOT"

%files
%defattr(-, root, root)
%attr(755,root,root) %{_bindir}/goggles
%attr(755,root,root) %{_bindir}/ogle_gui_goggles
%{_datadir}/applications/goggles.desktop
%{_datadir}/pixmaps/goggles.png
%attr(644,root,root)%{_datadir}/goggles/goggles_manual.pdf
%doc AUTHORS COPYING ChangeLog NEWS README

%changelog
* Sat Dec 4 2004 Martin Gansser <mgansser@k-p-ebert.de>
- changes for gb build system
- rebuild for fedora core 3

* Sat Mar 29 2003 Florin Andrei <florin@andrei.myip.org>
- compiler optimizations
- cute icon added to .desktop file
- removed comment from "clean" directive (oops!)

* Fri Dec 27 2002 Florin Andrei <florin@andrei.myip.org>
- first version, 0.2.4-1
