/* Robert Munafo, (c) 2000 */

/* This file is distributed under the GPL, see file COPYING for details */

/* gnut_ui.h contains all the text messages that would need to be
   translated if gnut is adapted for another language. This means
   messages the users see, not debugging messages. Such messages
   are found within the following function calls:
  
      printf sprintf http_write_va  http_write_str

   gnut (or at least the web interface) has actually been translated to
   Japanese, but that version is now somewhat out of date.
 */

#ifndef GNUT_UI_H
#define GNUT_UI_H

/* ---------- for cli_input.c ---------- */

#define UI_IN_NOSUCH "no such command: %s\n"
#define UI_IN_AMBIG "ambiguous command: %s\n"

#define UI_IN_VERS_SO "gnut version %s at your service\n\n"

#define UI_INFO_RATE " %6s/sec "
#define UI_INFO_ETA "ETA: %s\n"
#define UI_INFO_TID "  TID: %-7li "
#define UI_INFO_TYPE_STATE " %3s  State: %-5s "
#define UI_INFO_NAME "Name: "
#define UI_INFO_UNKNOWN "UNKNOWN"
#define UI_INFO_XFER_STATS "TRANSFER STATS:\n"
#define UI_INFO_TOTALS "TOTALS: Rate: %5s:%-5s /sec\n\n"
#define UI_INFO_CONN1 "%i)%-20s  Packs: %6i:%-6i %5i:%-3i \tBytes: %7s:%-7s\n"
#define UI_INFO_CONN2 "   TID: %-6li  Type: %-3s  State: %5s  Rate: %6s:%-6s /sec\n"
#define UI_INFO_CONN3 "\tIn:\tPacket type %3d: %5d   avg %5d  max %5d\n"
#define UI_INFO_CONN4 "\tIn:\tTTL "
#define UI_INFO_CONN5 "\tOut:\tPacket type %3d: %5d   avg %5d  max %5d\n"
#define UI_INFO_CONN6 "\tOut:\tTTL "
#define UI_INFO_CONN_TOTALS "TOTALS: Rate: %5s:%-5s /s  Sent: %ld\n\n"

/* 0.4.27.c11 changed %-5i to %-5u */
#define UI_INFO_SHARE "SHARE STATS: Num Shared: %-5u Size Shared: %-9s\n"
#define UI_INFO_SHAR2 "        Max Upload Rate: %u kbps Available: %d DidUpload: %d DidReceive: %d\n"
#define UI_INFO_SHAR3 "      Meas. Upload Rate: %u kbps Available: %d DidUpload: %d DidReceive: %d\n"
#define UI_INFO_NET "NET STATS:   Msg Received: %-7s  Msg Sent: %-7s\n"

#define UI_FIND_WHEN_YOU "When you want to view results, type 'find' with no argument.\n"

#define UI_LIST_MULTIDIS "Multiple searching is disabled. Set the \"multi_enable\" flag\nto enable it.\n"


#define UI_PUSH_VPN_ERR1 "Remote IP %i.%i.%i.%i cannot connect to local IP %i.%i.%i.%i, so 'push' won't\nwork but 'get' will. Use 'get', or set no_rfc_1597 to override, or set\nlocal_ip if necessary.\n"
#define UI_PUSH_VPN_ERR2 "Remote IP %i.%i.%i.%i and local IP %i.%i.%i.%i, cannot reach each other,\nneither by 'get' nor by 'put'. Set no_rfc_1597 to override, or set local_ip\nif necessary.\n"
#define UI_PUSH_VPN_ERR3 "You can reach remote IP %i.%i.%i.%i directly with 'get'. Please use 'get' to\nsave network bandwidth, or set no_rfc_1597 to override.\n"


/* ---------- for gnut_connection.c ---------- */

#define UI_CN_KILLING "Killing connection to %d.%d.%d.%d\n"
#define UI_CN_NO_WORST "No worst connection found.\n"

/* ---------- for gnut_http.c ---------- */

#define UI_HT_MAIN_TITLE "GNUT Gnutellanet HTTP Gateway"

#define UI_HT_GET_LOCAL_FILES "Get Files On This Server"
#define UI_HT_SEARCH_THE "Search the GnutellaNet"

#define UI_HT_CLIENT_WEB "Gnutella client file server and search gateway"
#define UI_HT_POWERED "Powered by gnut v"

#define UI_HT_RELATED "Related web sites:"
#define UI_HT_GNUTELLA_URL "gnutella.wego.com"
#define UI_HT_GNUT_URL "www.mrob.com/gnut"

#define UI_HT_NET_STATS "Current GnutellaNet statistics:  "
#define UI_HT_STAT_HOSTS "%i hosts "
#define UI_HT_STAT_FILES "%g files "
#define UI_HT_STAT_BYTES "%g M bytes"

#define UI_HT_SUBMIT "Go"

#define UI_HT_SEARCH_RESULTS "Search Results for <i>%s</i> "
#define UI_HT_PLEASE_WAIT " (please wait %i seconds for page to finish loading...)"
#define UI_HT_FILE_NUM "#"
#define UI_HT_FILE_SIZE "file size"
#define UI_HT_SPEED "speed"
#define UI_HT_FILE_LOCATION "file location"
#define UI_HT_FILE_CACHE "in cache?"
#define UI_HT_YES "yes"
#define UI_HT_NO "no"

#define UI_HT_4CHARS_ERROR "Please enter a search string at least 4 characters in length."

#define UI_HT_FILES_ON "Files on this server"

#define UI_HT_WAIT_UP_TO "Wait up to"
#define UI_HT_SECONDS "%i seconds"
#define UI_HT_OR_UNTIL "or until"
#define UI_HT_REPLIES_ARRIVE "replies arrive"

/* ---------- for gnut_net.c ---------- */

#define UI_NT_CONN_FOR_PUSH "Attempted connection for push "
#define UI_NT_CONN_FOR_DOWN "Attempted connection for download "

/* 0.4.27.c03 Added UI_NT_CONN_FOR_CACH */
#define UI_NT_CONN_FOR_CACH "Attempted connection for file cache download "
#define UI_NT_CONN_FOR_GNUT "Attempted connection for GnutellaNet "
#define UI_NT_HOST_REFUSED "to %s, host refused connection.\n"

/* ---------- for gnut_threads.c ---------- */

#define UI_TH_DL_RETRY "GET Download will retry in %d seconds.\n"
#define UI_TH_PDL_STARTED "PUSH Download of %s started.\n"
#define UI_TH_GDL_STARTED "GET Download of %s started.\n"

/* 0.4.27.c03 Added UI_TH_CDL_STARTED */
#define UI_TH_CDL_STARTED "cache GET Download of %s started.\n"
#define UI_TH_DL_QUEUED "Download of %s queued. (too many downloads)\n"
#define UI_TH_FILE_EXISTS "File \"%s\" already exists, download not started!\n"
#define UI_TH_CANT_WRITE "Couldn't open file %s for writing.  Transfer aborted\n"
#define UI_TH_INCOR_PASS "Incorrect password.\n"
#define UI_TH_DL_STPUSH "Sending push request for %s.\n"
#define UI_TH_PDL_FAILED "PUSH Download of %s failed after %i bytes.\n"
#define UI_TH_GDL_FAILED "GET Download of %s failed after %i bytes.\n"

/* 0.4.27.c03 Added UI_TH_CDL_FAILED */
#define UI_TH_CDL_FAILED "Cache download of %s failed after %i bytes.\n"
#define UI_TH_CA_FAILED "Cache download of %s is incomplete, deleting.\n"
#define UI_TH_PDL_SUCCEED "PUSH Download of %s succeeded.\n"
#define UI_TH_GDL_SUCCEED "GET Download of %s succeeded.\n"
#define UI_TH_CA_SUCCEED "Added to cache: %s\n"
#define UI_TH_NO_DUPE "Not downloading duplicate %s\nbecause there is another already in progress.\n"
#define UI_TH_DUP_SEARCH "Ignoring duplicate search string \"%s\"\n"

/* ---------- for transfer.c ---------- */

#define UI_TR_UPLOAD_STARTED "Upload of %s to %u.%u.%u.%u started.\n"
#define UI_TR_UPLOAD_COMPLETE "Upload of %s to %u.%u.%u.%u completed, %i bytes transferred.\n"
#define UI_TR_UPLOAD_ABORT "Upload of %s aborted by other end after %i bytes.\n"
#define UI_TR_UPLOAD_ABRT2 "Upload of %s got a network error after %i bytes.\n"

#endif /* GNUT_UI_H */
