/* Josh Pieper, (c) 2000 */

/* This file is distributed under the GPL, see file COPYING for details */

#ifndef SHARE_H
#define SHARE_H

/* #define USE_DRR_SEARCH */

#include <pthread.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "list.h"
#include "lib.h"

#define MAX_TOKENS 32 /* 0.4.27.c04 */

extern int sh_dbg_1;
extern uint32 g_share_num; /* 0.4.27.c11 */
extern float64 g_share_size;
extern Gnut_List *share_root;

extern pthread_mutex_t share_mutex;

typedef struct _share_item share_item;

struct _share_item {
  char *path;    /* the pretty path to display */
  char *lc_path; /* the pretty path tolower'd for searching */
  char *fpath;   /* the full path for accessing the file */
  uint32 size; /* 0.4.27.c11 */
  uint32 ref; /* 0.4.27.c11 */
  time_t mtime;
};

typedef struct _share_query_results share_query_results;

struct _share_query_results {
  char *query;
  Gnut_List *results;
};

typedef uint32 * match_bitvector;

struct hlist {
  char *hl_term;
  match_bitvector hl_mv;
  uint32 n_matches;
  /* neighbors in the hash table */
  struct hlist **prev_nxt;
  struct hlist *next;
  /* neighbors in the recency list */
  struct hlist *more;
  struct hlist *less;
};

extern int t_counter;
extern int t_hits;
extern int matchvectorsize;
extern share_item **si_vector;

#ifdef __cplusplus
extern "C" {
#endif

  void fre_si(share_item **x, int bugnum);
  void fre_sia(share_item ***x, int bugnum);
  void fre_mbv(match_bitvector *x, int bugnum);

  int match_tok_2(char **tokens, int nt, char *s1, int must_exact); /* 0.4.27.c04 */
  int sh_tokenize(char *str, char **tokens, int maxtokens);
  Gnut_List * share_search(char *query, int max, int *n_reslts);

  int share_scan_dir(char *path, int verbose);
  share_item *share_find(uint32 ref); /* 0.4.27.c11 */
  int share_clear();
  int share_clear_list(Gnut_List *l);
  void share_totals(uint32 *num, float64 *size); /* 0.4.27.c11 */
  Gnut_List *share_get_root();
  int share_delete(void *data, void *user_data);
  Gnut_List *share_copy_list(Gnut_List *);

#define OUR_MAX_PATH 2048

  int share_init();
  Gnut_List *share_cache_run_search(char *token, int max);
  Gnut_List *share_results_combine(Gnut_List *l1, Gnut_List *l2, int max);

#define SHARE_CACHE_MAX 3000

  void share_hash_init(void);
  unsigned int new_search_term(char* term, match_bitvector *mv,
			       match_bitvector scratch);
  unsigned int share_hash_lookup(char* s, match_bitvector *mv);
  match_bitvector share_hash_insert(char *term, 
				    match_bitvector matchvector,
				    unsigned int n_matches);
  Gnut_List *share_srch_hash(char *orig_query, int max, int *n_reslts);
  int share_hash_clear_list(Gnut_List *l);

#ifdef __cplusplus
}
#endif

#endif
