/* Josh Pieper, (c) 2000 */

/* This file is distributed under the GPL, see file COPYING for details. */

#ifndef PROTOCOL_H
#define PROTOCOL_H

#include <sys/types.h>

#include "lib.h"
#include "list.h"


typedef struct _gnutella_ping gnutella_ping;
typedef struct _gnutella_filereq gnutella_filereq;
typedef struct _gnutella_results_name gnutella_results_name;
typedef struct _gnutella_servent gnutella_servent;
typedef struct _gnutella_push gnutella_push;
typedef struct _gnutella_packet gnutella_packet;


/* First off lets define the critical structures used in the protocol.
  IMPORTANT: The fields are all given as arrays of bytes because that's
  the only way to guarantee proper 'network order' of bytes cross-platform.
  When actually reading or writing one of these structures you have to
  convert for endianness.  */

typedef struct {
  uint8 guid[16];
  uint8 func;
  uint8 ttl;
  uint8 hops;
  uint8 dlen[4];
} gnutella_hdr;

struct _gnutella_ping{
  uint8 d[2];
};

struct _gnutella_filereq {
  uint8 guid[16];
  uint8 ref[4];
  uint8 ip[4];
  uint8 port[2];
};

typedef struct {
  uint8 num;
  uint8 port[2];
  uint8 ip[4];
  uint8 speed[4];
} gnutella_results;

struct _gnutella_results_name {
  uint8 ref[4];
  uint8 size[4];
  uint8 name[1];
};

typedef struct {
  uint8 guid[16];
} gnutella_results_suffix;

typedef struct {
  uint8 vendor[4];
  uint8 odlen;
  uint8 flag1;
  uint8 flag2;
} gnutella_eqhd;

struct _gnutella_servent {
  uint8 port[2];
  uint8 ip[4];
  uint8 files[4];
  uint8 kbytes[4];
};

struct _gnutella_push {
  uint8 guid[16];
  uint8 ref[4];
  uint8 ip[4];
  uint8 port[2];
};

struct _gnutella_packet {
  gnutella_hdr gh;
  void * data;
};

typedef struct giud_ref {
  uint8 guid[16];
  uint8 ref[4];
} guid_ref;

#ifdef __cplusplus
extern "C" {
#endif

  /* Now lets define the functions used to manipulate these structures. */

  void fre_gpa(gnutella_packet **x, int bugnum);
  gnutella_packet * gp_reply_make(char *guid, Gnut_List *results,
				  uint8 *ip, uint16 port, uint32 speed,
				  char * mguid, int ttl);

  gnutella_packet * gp_pong_make(char *guid, int files,
				 int bytes, uint8 *ip, uint16 port,
				 int ttl);

  gnutella_packet * gp_ping_make(char *mac, int ttl);

  gnutella_packet * gp_request_make(char *mac, char *name, int ttl);

  gnutella_packet * gp_push_make(char *mac, int ttl, char *guid, 
				 uint32 ref, uint8 *ip, uint16 port);

  gnutella_packet * gp_dup(gnutella_packet *gp); 

  int gp_print(gnutella_packet *);

#ifdef __cplusplus
}
#endif

#endif
