/* Josh Pieper, (c) 2000 */

/* This file is distributed under the GPL, see file COPYING for details */

/* 0.4.27.c08 removed #include assert.h */
#include <stdio.h>
#include <stdlib.h>

#include "lib.h"
#include "list.h"

void fre_gl(Gnut_List **x, int bugnum)
{
  gd_s(5, "fre_gl x="); gd_p(5, x); gd_s(5, "\n");

  yfre((void **) x, bugnum);
}

Gnut_List * gnut_list_unlink(Gnut_List *list, void *data, Gnut_List **unlinked)
{
  Gnut_List *tmp;
  Gnut_List *prev;

  gd_s(5, "gnut_list.unlink list="); gd_p(5, list); gd_s(5, " data=");
  gd_p(5, data); gd_s(5, "\n");

  prev = 0;
  tmp = list;
  *unlinked = 0;
  while (tmp) {
    if (tmp->data == data) {
      if (prev) {
	prev->next = tmp->next;
      }

      if (list == tmp) {
	list = list->next;
      }

      *unlinked = tmp;
      break;
    }
    prev = tmp;
    tmp = tmp->next;
  }

  gd_s(5, "gnut_list.unlink new list="); gd_p(5, list); gd_s(5, "\n");

  return list;
}

/* Gnut_List * gnut_list.remove(Gnut_List *list, void *data)
 *
 * removes the first occurence of data in list. It does NOT try
 * to call xfr.ee on the data block.
 * returns the pointer to the new head of the list, does not indicate
 * whether the data was actually found */
int glr_err1 = 0;
Gnut_List * gnut_list_remove(Gnut_List *list, void *data, int tracking_number)
{
  Gnut_List *tmp;
  Gnut_List *prev;
  int flag;

  gd_s(5, "gnut_list.remove list="); gd_p(5, list); gd_s(5, " data=");
  gd_p(5, data); gd_s(5, "\n");

  flag = 0;
  prev = 0;
  tmp = list;
  while (tmp) {
    gd_s(5, "glr prev="); gd_p(5, prev); gd_s(5, " tmp="); gd_p(5, tmp);
    gd_s(5," tmp->next="); gd_p(5, tmp->next); gd_s(5," tmp->data=");
    gd_p(5, tmp->data); gd_s(5, "\n");

    if (tmp->data == data) {
      /* Found it! */
      flag=1;
      /* Remove from list by changing previous element's next-pointer
       * (unless we're the first) */
      if (prev) {
	prev->next = tmp->next;
      }
      /* If we are the first, update our copy of the list head pointer */
      if (list==tmp) {
	list = list->next;
      }

      tmp->next = 0;

      gd_s(5, "glr tmp="); gd_p(5, tmp); gd_s(5, " &tmp=="); gd_p(5, &tmp);
      gd_s(5, "\n");

      fre_gl(&tmp, 151);

      break;
    }
    prev = tmp;
    tmp = tmp->next;
  }

  if (flag == 0) {
    int l;

    l = 0;
    if (glr_err1) {
      l = 1;
    } else {
      glr_err1 = 1;
    }
    gd_s(l, "gnut_list.remove "); gd_i(l, tracking_number);
    gd_s(l, " item not found\n");
  }

  gd_s(5, "gnut_list.remove new list="); gd_p(5, list); gd_s(5, "\n");

  return list;
}
  
/* Gnut_List * gnut_list.prepend(Gnut_List *list, void *data)
 *
 * prepends data into the given list; returns the new head pointer */
Gnut_List * gnut_list_prepend(Gnut_List *list, void *data)
{
  Gnut_List *gltmp;

  gd_s(5, "gnut_list.prepend list="); gd_p(5, list); gd_s(5, " data=");
  gd_p(5, data); gd_s(5, "\n");

  gltmp = (Gnut_List *) ymaloc(sizeof(Gnut_List), 366);
  if (gltmp) { /* 0.4.27.c08 */
    gltmp->data = data;
    gltmp->next = list;

    gd_s(5, "gnut_list.prepend  new list="); gd_p(5, gltmp); gd_s(5, "\n");

    return gltmp;
  }
  /* else */ /* 0.4.27.c08 */
  return list;
}

/* Returns pointer to data of first item in a list */
void * gnut_list_head(Gnut_List *list)
{
  if (list) {
    return(list->data);
  }
  return 0;
}

Gnut_List * gnut_list_append(Gnut_List *list, void *data, int tracking_number)
{
  Gnut_List *gltmp;
  Gnut_List *glnew;

  glnew = (Gnut_List *) ymaloc(sizeof(Gnut_List), tracking_number);
  if (glnew) { /* 0.4.27.c08 */
    glnew->data = data;
    glnew->next = 0;

    if (list == 0) {
      return glnew;
    } else {
      gltmp = list;
      while(gltmp->next) {
        gltmp = gltmp->next;
      }
      gltmp->next = glnew;
      return list;
    }
  }
  /* else */ /* 0.4.27.c08 */
  return list;
}

/* Gnut_List * gnut_list_next(Gnut_List *list)
 *
 * convenience function to return next item in list */
Gnut_List * gnut_list_next(Gnut_List *list)
{
  return list->next;
}

/* void gnut_list.foreach(Gnut_List * list, void (*GFunc)(void *, void *),
         void *userdata)
 
   for each element in list, call GFunc. But if GFunc returns a -1, stop
   walking through the list immediately */
int gnut_list_foreach(Gnut_List *list, int (*GFunc)(void *,void *),
      void *userdata)
{
  Gnut_List *gltmp;
  
  gd_s(5, "gnut_list_foreach list=");
  gd_p(5, list);
  gd_s(5, "\n");
  for (gltmp=list; gltmp; gltmp=gltmp->next) {
    if ((*GFunc)(gltmp->data, userdata)==-1) {
      /* callback function told us to stop walking */
      return -1;
    }
  }
  gd_s(5, "gnut_list_foreach returning\n");
  return 0;
}

/* Gnut_List * gnut_list.fre(Gnut_List *list)
 *
 * fr.ee all list items and deal.locate (xfr.ee) all data blocks
 * in a list; return a null head pointer */
Gnut_List * gnut_list_fre(Gnut_List *list)
{
  Gnut_List *gltmp, *gltmp2;

  gd_s(5, "gnut_list.fre list="); gd_p(5, list); gd_s(5, "\n");
  for (gltmp=list; gltmp; gltmp=gltmp2) {
    gd_s(5, "gnut_list_fre gltmp="); gd_p(5, gltmp); gd_s(5, " gltmp->next=");
    gd_p(5, gltmp->next); gd_s(5, "\n");

    gltmp2 = gltmp->next;
    fre_v(&(gltmp->data), 152);
    fre_gl(&gltmp, 153);
  }
  
  gd_s(5, "gnut_list.fre returning\n");
  return 0;
}

/* int gnut_list_size(Gnut_List *list)
 *
 * returns the number of items stored in list */
int gnut_list_size(Gnut_List *list)
{
  Gnut_List *glt;
  int i;

  gd_s(5, "gnut_list_size list="); gd_p(5, list); gd_s(5, "\n");

  for (i=0,glt=list; glt; glt=glt->next) {
    gd_s(5, "gnut_list_size i="); gd_i(5, i); gd_s(5, " glt="); gd_p(5, glt);
    gd_s(5, " glt->next="); gd_p(5, glt->next); gd_s(5, "\n");
    i++;
  }

  gd_s(5, "gnut_list_size returning: "); gd_i(5, i); gd_s(5, "\n");

  return i;
}

/* gnut_list_seek looks through a list to see if a given void * data
 * is in the list. */
int gnut_list_seek(Gnut_List *list, void *dat)
{
  int rv;
  Gnut_List *glt;

  rv = 0;
  glt = list;
  while(glt && (rv == 0)) {
    if (glt->data == dat) {
      rv = 1;
    } else {
      glt = glt->next;
    }
  }

  return rv;
}
