/* Josh Pieper, (c) 2000
   Robert Munafo, (c) 2001

   This file is distributed under the GPL, see file COPYING for details */

#ifndef GNUT_LIB_H
#define GNUT_LIB_H 0

#ifdef WIN32
# define VERSION "0.4.27/win32"
#endif

/* Define YTAGS to enable tagging of all memory blocks to trace leaks. Once
 * defined, rebuild and use 'debug' command to display info. This is not
 * for release versions because it is slow and causes a 4-byte per block
 * memory overhead. */
#define YTAGS 0

#if YTAGS
  #define YPROBE(x,y) yprobe((x),(y));
#else
  #define YPROBE(x,y) 
#endif

/* Highest used dqi so far: 0x0183 */

/* close_f is for closing a file. This is close() under both Windows and
 * Unix. */
#define close_f(f) close((f))

#include <sys/types.h>
#ifndef WIN32
# include <sys/socket.h>
# include <netinet/in.h>
#endif

#ifdef DMALLOC
# include <dmalloc.h>
#endif

#include <pthread.h>

#ifndef MIN
# define MIN(a,b) (((a < b)) ? (a) : (b))
# define MAX(a,b) (((a > b)) ? (a) : (b))
#endif

#ifndef __bswap_16
# define __bswap_16(x) \
    ((((x) >> 8) & 0xff) | (((x) &0xff) <<8))
#endif
      
#ifndef __bswap_32
# define __bswap_32(x) \
    ((((x) & 0xff000000) >> 24) | (((x) & 0x00ff0000) >> 8) | \
    (((x) & 0x0000ff00) << 8) | (((x) & 0x000000ff) << 24))
#endif
                                                
#ifndef GUINT16_TO_LE
# ifdef WORDS_BIGENDIAN
#  define GUINT16_TO_LE(x)  __bswap_16(x)
#  define GUINT32_TO_LE(x)  __bswap_32(x)
#  define GUINT16_FROM_LE(x)  __bswap_16(x)
#  define GUINT32_FROM_LE(x)  __bswap_32(x)
# else
#  define GUINT16_TO_LE(x)  (x)
#  define GUINT32_TO_LE(x)  (x)
#  define GUINT16_FROM_LE(x)  (x)
#  define GUINT32_FROM_LE(x)  (x)
# endif
#endif

#define SMCPY(d,s) memcpy((d),(s),sizeof(d))

#define g_debug undefined_g_debug1 undefined_g_debug2;

#define OCTAL(a,b,c) (((a) << 6) | ((b) << 3) | (c))

#define IS_DIGIT(c) (((c) >= '0') && ((c) <= '9'))

typedef unsigned char      uchar;
typedef          char       int8;  /* 0.4.27.c11 */
typedef unsigned char      uint8;
typedef          short      int16;
typedef unsigned short     uint16;
typedef unsigned int       uint32;
typedef          int        int32;
typedef          long long  int64;
typedef unsigned long long uint64;

typedef          float    float32;
typedef          double   float64;

/* Variable-length string */
typedef struct {
  uint32 vs_alloc;
  uint32 vs_used;
  char * vs_data;
} varstring;

#ifdef __cplusplus
extern "C" {
#endif
  extern char *path_separator;
  extern char *path_slash;

  extern int gnut_lib_debug;

#define DQ_SIZE 256
  extern uint16 dq[DQ_SIZE];
#define DQT_CHUNK_SIZE 128
#define DQT_CHUNK_NUM 64
#define DQT_CHUNK_MASK 31
  extern uint16 dqt[DQT_CHUNK_SIZE * DQT_CHUNK_NUM];
  extern int32 dqtp[DQT_CHUNK_NUM];
  extern int32 dqptr;
  extern uint16 dqtt;

  void dq_init(void);
  void dq_hi_init(void);

#define DQ_TID (((int) pthread_self()) & DQT_CHUNK_MASK)
  void dq_start(char *thtype, uint16 dqinum);
  void dq_end(void * retval);

#define dqi(x) (dq[dqptr] = (x), dqptr = (dqptr + 1) % DQ_SIZE, \
		dqtt = DQ_TID, \
		dqt[(dqtt * DQT_CHUNK_SIZE) + dqtp[dqtt]] = (x), \
		dqtp[dqtt] = (dqtp[dqtt] + 1) % DQT_CHUNK_SIZE, 0)
  void dql(uint32 x);
  void dqp(void *p);
  void dq_dump(char *msg);

#define gnut_mprobe(x) _gnut_mprobe(x)
  int gnut_mprobe(void *);

  char *expand_path(char *);

  void init_leaks(void);
  void reset_leaks(void);
  void check_reset(void);
  void tell_leaks(void);
  int yprobe(void *a, int tracking_number);
  void yfre(void **, int tracking_number);
  void fre_v(void **x, int bugnum);
  void fre_strl(char ***x, int bugnum);
  void fre_str(char **x, int bugnum);
  void *ymaloc(int size, int tracking_number);
  char *ystdup(const char *s, int tracking_number);
  void *ycaloc(size_t nmemb, size_t size, int tracking_number);

  int g_isblank(char c); /* 0.4.27.c06 */

  void fre_vs(varstring **x, int bugnum);
  varstring * vs_new(void);
  void vs_kill(varstring *vs);

#ifdef WIN32
#include <windows.h>

#define HAVE_STRTOK_R

  typedef unsigned int uint;

#define stricmp(x,y) strcasecmp(x,y)
#define sleep(x) Sleep(x*1000)
#define usleep(x) Sleep(x)
  char *strtok_r(char *, const char *, char **);
  int getopt(int argc, char *argv[], char *);
  extern char *optarg;
  extern int optind;

#define strncasecmp strnicmp
#define strcasecmp stricmp

#define inet_aton(string, ip) (ip)->s_addr = inet_addr(string)

#define write(sock, buf, len) send((sock), (buf), (len), 0)
#define read(sock, buf, len) recv((sock), (buf), (len), 0)
#define close_s(sock) closesocket(sock)

#define F_SETFL 1
#define O_NONBLOCK 1
  int fcntl(int sock, int, uint);

#define flock(a,b) 0
#else
#define close_s(sock) close(sock)
#endif

  void gd_s(int level, char * str);
  void gd_02x(int level, uchar c);
  void gd_i(int level, int32 x);
  void gd_u(int level, uint32 x); /* 0.4.27.c11 */
  void gd_x(int level, int32 x);
  void gd_li(int level, int32 x);
  void gd_lu(int level, uint32 x);
  void gd_f64(int level, float64 x);
  void gd_p(int level, void *p);

  char *gnut_strdelimit(char *string, char *delimeters, char new_delim);
  void gnut_strstrip(char *string);
  char *munge_time(int secs);
  char *format_si(float64 x, char *s);

  int strlen_an(char *s);
  void crc32_start(uint32 *crc);
  void crc32_add8(uint32 *crc, uchar data);  
  uint32 crc32_string(char *data);
  uint32 crc32_block(void * data, uint32 len);
  void print_ascii(uchar *s);
  void print_asc_n(uchar *s, int len);
  int writestr(int sock, char *str);
  int trycmd(char *cmd, char *pat);
  void strcatlim(char *dest, char *src, int maxlen);
  void make_lc(char *str);
  void make_7bit(char *str);
  int keyword_match(char *query, char *str, int and, int ignorecase);
  void make_htmlsafe(char *str); /* 0.4.28.c15 */
  int gl_strncmp(char *a, char* b, int len, int igcase); /* 0.4.27.c14 */
  uint32 gl_stou32(char *s, char **p);

#ifdef __cplusplus
}
#endif

#endif
