/* Josh Pieper, (c) 2000 */

/* This file is distributed under the GPL, see file COPYING for details */

/* The majority of this file came from Kris Kennaway <kris at fr.eebsd.org>. */

#include <sys/types.h>
#ifndef WIN32
#include <sys/socket.h>
#include <net/if.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <sys/ioctl.h>
#include <unistd.h>
#endif

#ifdef HAVE_SYS_SOCKIO_H
#include <sys/sockio.h>
#endif

#include <errno.h>

#ifdef HAVE_ERR_H
#include <err.h>
#endif

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "lib.h"

#ifndef WIN32
int get_interfaces(int sockfd, struct ifconf *ifc)
{
  int      len, lastlen;
  char      *buf;

  /* Grab a list of interfaces */

  gd_s(2, "sockfd=");
  gd_i(2, sockfd);
  gd_s(2, " ifc=");
  gd_p(2, ifc);
  gd_s(2, "\n");
  
  lastlen = 0;
  len = 20 * sizeof(struct ifreq);  /* initial buffer size guess */
  for ( ; ; ) {
    buf = (char *)ymaloc(len, 325);

    ifc->ifc_len = len;
    ifc->ifc_buf = buf;
    if (ioctl(sockfd, SIOCGIFCONF, ifc) < 0) {
      if (errno != EINVAL || lastlen != 0) {
	gd_s(1,"ioctl(SIOCGIFCONF)\n");
	return -1;
      }
    } else {
      if (ifc->ifc_len == lastlen)
	break;    /* success, len has not changed */
      lastlen = ifc->ifc_len;
    }
    len += sizeof(struct ifreq);  /* increment */
    fre_str(&buf, 382);
  }
  
  gd_s(2, "get_interfaces returning success\n");
  return 0;
}
#endif

struct sockaddr_in *get_if_addr(char *iface)
{
#ifndef WIN32
  int family = AF_INET;
  int      sockfd, len, flags;
  char      *ptr;
  struct ifconf    ifc;
  struct ifreq    *ifr=0, ifrcopy;
  struct sockaddr_in  *sinptr=0;

  if (iface) {
    gd_s(2, "get_if_addr entering iface=");
    gd_s(2, iface);
    gd_s(2, "\n");
  }

  if ((sockfd = socket(AF_INET, SOCK_DGRAM, 0)) == -1) {
    gd_s(1, "socket\n");
    return 0;
  }
  
  if (get_interfaces(sockfd, &ifc) == -1) {
    gd_s(1, "get_interfaces\n");
    return 0;
  }

  /* Walk the list of interfaces and locate the first one which is up */

  for (ptr = ifc.ifc_buf; ptr < (ifc.ifc_buf + ifc.ifc_len); ) {
    ifr = (struct ifreq *) ptr;
    
    gd_s(2, "ifr=");
    gd_p(2, ifr);
    gd_s(2, "  ifc.ifc_buf=");
    gd_p(2, ifc.ifc_buf);
    gd_s(2, "  ifc.ifc_len=");
    gd_i(2, ifc.ifc_len);
    gd_s(2, "\n");
    
    len = sizeof(struct ifreq);
    ptr += len;  /* for next one in buffer */

    if (ifr->ifr_addr.sa_family != family)
      continue;  /* ignore if not desired address family */

    ifrcopy = *ifr;
    if (ioctl(sockfd, SIOCGIFFLAGS, &ifrcopy) < 0) {
      gd_s(1, "ioctl(SIOCGIFFLAGS)\n");
    }

    flags = ifrcopy.ifr_flags;

    if ((flags & IFF_UP) == 0)
      continue;  /* ignore if interface not up */

    if (strncmp("lo", ifr->ifr_name, 2)==0)
      continue;

    if (iface) {
      if (!strncmp(iface, ifr->ifr_name, IFNAMSIZ) == 0)
	continue; /* Not the interface we're looking for */
    }
	
    switch (ifr->ifr_addr.sa_family) {
    case AF_INET:
      sinptr = (struct sockaddr_in *) &ifr->ifr_addr;
      printf("Local IP: %s\n", inet_ntoa(sinptr->sin_addr));
      break;

    default:
      printf("Protocol family not supported.");
    }
    break;
  }
  if (iface && (sinptr == 0)) {
    gd_s(1, "No such interface '");
    gd_s(1, iface);
    gd_s(1, "'\n");
  }
  return sinptr;
#else
  return 0;
#endif
}
