/* Josh Pieper, (c) 2000 */

/* This file is distributed under the GPL, see file COPYING for details */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>


#include "conf.h"
#include "lib.h"
#include "hash.h"
#include "http.h"
#include "threads.h"

int conf_initted = 0;

conf_key_pair configuration_pairs[] = {
  {"auto_clear",      "1"},
  {"auto_download_retry", "60"},
  {"auto_forget",     "0"}, /* 0.4.27.c01 */
  {"auto_response",   "1"},
  {"auto_remove_segv_info", "1"},
  {"autokill_thres",  "10"},
  {"beep_on_all",     "0"},
  {"beep_on_first",   "0"},
  {"cache_path",      ""},
  {"cache_parallel",  "1"},
  {"cache_refresh",   "600"},
  {"cache_size",      "15000"},  /* 15 megs.  Should this be measured in M instead of K? */
  {"checkpoint_hosts", "600"},
  {"checkpoint_net",  "60"},
  {"config_file",     ""},
  {"debug_opts",      "0"},
  {"default_download_cap", "0"},
  {"default_upload_cap", "0"},
  {"download_path",   ""},
  {"download_timeout","60"},
  {"eval_echo",       "1"},
  {"follow_symlinks", "1"},
  {"global_bandwidth_cap", "0"},
  {"guid",            "AAAAAAAAAAAAAAAA"},
  {"hidden",          "0"},
  {"hide_pathname",   "0"},
  {"host_list_size",  "10000"},
  {"html_enable",     "1"},
  {"html_template",   ""},
  {"http_client_headers", "User-Agent: Gnut " VERSION "\\n"
                          "Referrer: Gnutella file sharing network\\n"
                          "Connection: Keep-Alive\\n" },
  {"leave_turds",     "512"},
  {"local_port",      "5634"},
  {"log_level",      "0"},
  {"mac",             "ADCVFD"},
  {"max_downloads",   "10"},
  {"max_incoming",    "4"},
  {"max_responses",   "1000"},
  {"max_results",     "64"},
  {"max_searches",    "10"},
  {"max_uploads",     "10"},
  {"min_cache_size",  "15"},
  {"min_connections", "4"},
  {"multi_enable",    "0"},
  {"munge",           "1"},
  {"no_rfc_1597",     "0"},
  {"packet_stats",    "0"},
  {"paginate",        "1"},
  {"password",        ""},
  {"password_required","0"},
  {"prompt",          "gnut> "},
  {"play_prog",       "xmms"},
  {"qreply_cache",    "500"},
  {"query_guid",      "AAAAAAAAAAAAAAAA"},
  {"redirect",        "0"},
  {"response_format",  "{f#}){N/ I:P}size: {S}speed:{s} rating: {R}"}, /* 0.4.27.c24 */
  {"retry_push",      "1"},
  {"score_available", "50"}, /* 0.4.27.c21 */
  {"score_did_upload","30"}, /* 0.4.27.c21 */
  {"score_did_receive","40"}, /* 0.4.27.c21 */
  {"search_extensions","*"},
  {"search_log",      ""},
  {"search_log_all",  "0"},
  {"search_min_rating","0"}, /* 0.4.27.c21 */
  {"search_min_size", "0"},
  {"share_paths",     ""},
  {"sort_order",      "C-"}, /* 0.4.27.c21 */
  {"speed",           "56"}, /* 0.4.27.c23 */
  {"stats_format",    "0"},
  {"strict_search",   "1"},
  {"transfer_log",    ""},
  {"ttl",             "7"},
  {"update_clear",    "0"},
  {"update_guid",     "AAAAAAAAAAAAAAAA"},
  {"verbose",         "3"},
  {"wait_after_find", "1"},
  {"GDJ_extra_paths", ""},
  {"GDJ_log_playlist",""},
  {0, 0}
};

Gnut_Hash *conf_hash=0;

int gc_auto_forget; /* 0.4.27.c01 */
int gc_cache_parallel;
int gc_cache_refresh;
int gc_debug_opts;
int gc_eval_echo;
int gc_hide_pathname;
int gc_host_list_size;
int gc_max_uploads; /* 0.4.27.c27 */
int gc_munge;
int gc_no_rfc_1597;
int gc_score_available; /* 0.4.27.c21 */
int gc_score_did_upload; /* 0.4.27.c21 */
int gc_score_did_receive; /* 0.4.27.c21 */
int gc_search_log_all;
int gc_search_min_rating; /* 0.4.27.c21 */
int gc_search_min_size;
uint32 gc_speed; /* 0.4.27.c21 */
int gc_strict_search;
int gc_ttl;
FILE *gc_search_log = 0;
FILE *gc_transferlog = 0;
int gc_verbose;

uchar conf_hash_struct(void *arg)
{
  conf_key_pair *ckp;
  int i,len;
  uchar ret;

  ckp = arg;
  len = strlen(ckp->ckp_key);
  for (i=0,ret=0; i<len; i++) {
    ret += ckp->ckp_key[i];
  }

  return ret;
}

int conf_compare_struct(void *arg1, void *arg2)
{
  conf_key_pair *ckp1;
  conf_key_pair *ckp2;

  ckp1=arg1;
  ckp2=arg2;

  return strcmp(ckp1->ckp_key, ckp2->ckp_key);
}

/* conf_cache_entry performs two different but related functions.
 *
 * The first is to save certain configuration values which, for
 * performance reasons, must be kept in real global variables. An
 * example is the "TTL" value, which is referred to all the time
 * in the packet parsing and routing code.
 *
 * The other function is to perform actions that must be performed as
 * a consequence of setting a configuration value. An example is
 * the "search_log" setting -- as soon as you set it, the logfile
 * should be opened (if possible), and if you change it, the existing
 * logfile should be closed and a new one opened.
 *
 * conf_cache_entry is called by each of the other conf_routines,
 * so the global variables and immediate actions are always in sync
 * with the configuration variables. */
void conf_cache_entry(char *key)
{
  char *sval;

  if (strcmp(key, "auto_forget") == 0) { /* 0.4.27.c01 */
    gc_auto_forget = conf_get_int(key);
  } else if (strcmp(key, "cache_parallel") == 0) {
    gc_cache_parallel = conf_get_int(key);
  } else if (strcmp(key, "cache_refresh") == 0) {
    gc_cache_refresh = conf_get_int(key);
  } else if (strcmp(key, "default_upload_cap") == 0) {
    if (conf_initted) {
      update_urate();
    }
  } else if (strcmp(key, "debug_opts") == 0) {
    gc_debug_opts = conf_get_int(key);
  } else if (strcmp(key, "eval_echo") == 0) {
    gc_eval_echo = conf_get_int(key);
  } else if (strcmp(key, "hide_pathname") == 0) {
    gc_hide_pathname = conf_get_int(key);
  } else if (strcmp(key, "host_list_size") == 0) {
    gc_host_list_size = conf_get_int(key);
  } else if (strcmp(key, "log_level") == 0) {
    gnut_lib_debug = conf_get_int(key);
  } else if (strcmp(key, "max_uploads") == 0) {
    gc_max_uploads = conf_get_int(key);
  } else if (strcmp(key, "munge") == 0) {
    gc_munge = conf_get_int(key);
  } else if (strcmp(key, "no_rfc_1597") == 0) {
    gc_no_rfc_1597 = conf_get_int(key);
  } else if (strcmp(key, "search_log") == 0) {
    if (gc_search_log) {
      fclose(gc_search_log);
    }
    sval = conf_get_str(key);
    if (sval && *sval) {
      gc_search_log = fopen(sval, "a");
      if (gc_search_log) {
	setvbuf(gc_search_log, 0, _IONBF, 0);
      }
    }
  } else if (strcmp(key, "score_available") == 0) { /* 0.4.27.c21 */
    gc_score_available = conf_get_int(key);
  } else if (strcmp(key, "score_did_upload") == 0) { /* 0.4.27.c21 */
    gc_score_did_upload = conf_get_int(key);
  } else if (strcmp(key, "score_did_receive") == 0) { /* 0.4.27.c21 */
    gc_score_did_receive = conf_get_int(key);
  } else if (strcmp(key, "search_log_all") == 0) {
    gc_search_log_all = conf_get_int(key);
  } else if (strcmp(key, "search_min_rating") == 0) { /* 0.4.27.c21 */
    gc_search_min_rating = conf_get_int(key);
  } else if (strcmp(key, "search_min_size") == 0) {
    gc_search_min_size = conf_get_int(key);
  } else if (strcmp(key, "speed") == 0) { /* 0.4.27.c21 */
    gc_speed = conf_get_int(key);
    if (conf_initted) {
      update_urate();
    }
  } else if (strcmp(key, "strict_search") == 0) {
    gc_strict_search = conf_get_int(key);
  } else if (strcmp(key, "transfer_log") == 0) {
    if (gc_transferlog) {
      fclose(gc_transferlog);
    }
    sval = conf_get_str(key);
    if (sval && *sval) {
      gc_transferlog = fopen(sval, "a");
      if (gc_transferlog) {
	setvbuf(gc_transferlog, 0, _IONBF, 0);
      }
    }
  } else if (strcmp(key, "ttl") == 0) {
    gc_ttl = conf_get_int(key);
  } else if (strcmp(key, "verbose") == 0) {
    gc_verbose = conf_get_int(key);
  }
}

int conf_init()
{
  conf_key_pair *ckp;
  int i;

  conf_hash = gnut_hash_new(conf_hash_struct, conf_compare_struct);

  for(i=0; configuration_pairs[i].ckp_key; i++) {
    ckp = (conf_key_pair *) ymaloc(sizeof(conf_key_pair), 342);
    ckp->ckp_key = ystdup(configuration_pairs[i].ckp_key, 466);
    ckp->ckp_val = ystdup(configuration_pairs[i].ckp_val, 467);
    gnut_hash_insert(conf_hash, ckp, 501);
    conf_cache_entry(ckp->ckp_key);
  }

  conf_initted = 1;

  return 0;
}

int conf_get_int(char *key)
{
  conf_key_pair ckp;
  conf_key_pair *ckp_ret;
  
  ckp.ckp_key = key;
  
  dqi(0x014f);
  ckp_ret = gnut_hash_find(conf_hash, &ckp);
  dqi(0x0171);

  if (!ckp_ret) {
    gd_s(0, "conf_get_int not found "); gd_s(0, key); gd_s(0, "\n");
    return -1;
  }
  
  return atoi(ckp_ret->ckp_val);
}  

int conf_set_int(char *key, int val)
{
  conf_key_pair ckp;
  conf_key_pair *ckp_ret;

  ckp.ckp_key=key;
  
  dqi(0x0150);
  ckp_ret = gnut_hash_find(conf_hash, &ckp);
  
  if (!ckp_ret) {
    gd_s(1, "conf_set_int not found "); gd_s(1, key); gd_s(1, "\n");
    return -1;
  }
  
  if (ckp_ret->ckp_val) {
    fre_str(&(ckp_ret->ckp_val), 397);
  }

  ckp_ret->ckp_val= ymaloc(20, 343);
  sprintf(ckp_ret->ckp_val, "%i", val);

  conf_cache_entry(key);

  return 0;
}

char *conf_get_str(char *key)
{
  conf_key_pair ckp,*ckp_ret;
  
  ckp.ckp_key=key;
  
  dqi(0x0151);
  ckp_ret = gnut_hash_find(conf_hash, &ckp);
  
  if (!ckp_ret) {
    gd_s(0, "conf_get_str not found "); gd_s(0, key); gd_s(0, "\n");
    return 0;
  }
  if (!ckp_ret->ckp_val) {
    return 0;
  }
  
  return ckp_ret->ckp_val;
}

int conf_set_str(char *key, char *val)
{
  conf_key_pair ckp;
  conf_key_pair *ckp_ret;
  
  ckp.ckp_key = key;
  
  dqi(0x0152);
  ckp_ret = gnut_hash_find(conf_hash, &ckp);
  
  if (!ckp_ret) {
    gd_s(1, "conf_set_str not found "); gd_s(1, key); gd_s(1, "\n");
    return -1;
  }
  if (ckp_ret->ckp_val) {
    fre_str(&(ckp_ret->ckp_val), 398);
  }
  
  if (val) {
    ckp_ret->ckp_val = ystdup(val, 468);
  } else {
    ckp_ret->ckp_val=0;
  }

  conf_cache_entry(key);
  
  return 0;
}

int conf_set_str_len(char *key, char *val, int len)
{
  conf_key_pair ckp, *ckp_ret;
    
  ckp.ckp_key = key;
  
  dqi(0x0153);
  ckp_ret = gnut_hash_find(conf_hash, &ckp);

  if (!ckp_ret) {
    gd_s(1, "conf_set_str_len not found "); gd_s(1, key); gd_s(1, "\n");
    return -1;
  }
  
  if (ckp_ret->ckp_val) {
    fre_str(&(ckp_ret->ckp_val), 399);
  }
  
  if (val) {
    ckp_ret->ckp_val = (char *) ymaloc(len, 344);
    memcpy(ckp_ret->ckp_val, val, len);
  } else {
    ckp_ret->ckp_val = 0;
  }

  conf_cache_entry(key);

  return 0;
}
