/* Josh Pieper, (c) 2000 */

/* This file is distributed under the GPL, see file COPYING for details */

#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>

#ifdef HAVE_TERMCAP_H
#include <termcap.h>
#else
#ifdef HAVE_TERM_H
#include <curses.h>
#include <term.h>
#endif
#endif

#ifdef HAVE_TERMIOS_H
#include <termios.h>
#endif

#ifndef WIN32
#include <unistd.h>
#endif

#include <fcntl.h>
#include <string.h>

#include "lib.h"
#include "conf.h"
#include "cli.h"
#include "cli_output.h"

int num_columns;
int num_rows;
char *output_bold_on;
char *output_special_off;
char cap_stuff[256];

int paginator_count=0;

static char term_buffer[2048];

char *term,*ptr,*bp,termcap[1024];

int cli_output_init()
{
#ifdef HAVE_LIBTERMCAP
  char *c;

  ptr = termcap;

  if ((term = (char *) getenv("TERM"))) {
    if (tgetent(term_buffer, term) >=1) {
      if ((num_columns = tgetnum("co") -2) < 1) {
        num_columns = 78;
      }
      if ((num_rows = tgetnum("li")) == -1) {
        num_rows = 24;
      }

      c = cap_stuff;
      output_bold_on = tgetstr("md", &c);

      if (c == output_bold_on) {
	printf("terminal does not support bold...\n");
      }

      output_special_off = tgetstr("me",&c);

#if 0
      printf("Bold is %s on %s and off, and %s on again %s.\n",
	     output_bold_on,output_special_off,
	     output_bold_on,output_special_off);
      printf("strlen(bold)=%i\n", strlen(output_bold_on));
      printf("strlen(off)=%i\n", strlen(output_special_off));
#endif
      printf("num_columns=%i num_rows=%i\n", num_columns, num_rows);
      return 0;
    }
  }
#endif 
  output_bold_on = cap_stuff;
  output_special_off = cap_stuff;
  cap_stuff[0] = 0;

  num_columns = 78;
  num_rows = 24;

  return 0;
}

/* this code copied from "less" */
void raw_mode(int on)
{
  static int curr_on = 0;
  
  if (on==curr_on) return;
  
#if HAVE_TERMIOS_H && HAVE_TERMIOS_FUNCS
  {
  struct termios s;
  static struct termios save_term;
  static int saved_term = 0;
  
  if (on) {
    tcgetattr(2,&s);
    
    if (!saved_term) {
      save_term=s;
      saved_term=1;
    }
    
    s.c_lflag &= ~(0
#ifdef ICANON
      | ICANON
#endif
#ifdef ECHO
      | ECHO
#endif
#ifdef ECHOE
      | ECHOE
#endif
#ifdef ECHOK
      | ECHOK
#endif
#if ECHONL
      | ECHONL
#endif
    );
    
    s.c_oflag |= (0
#ifdef OXTABS
      | OXTABS
#else
#ifdef TAB3
      | TAB3
#else
#ifdef XTABS
      | XTABS
#endif
#endif
#endif
#ifdef OPOST
      | OPOST
#endif
#ifdef ONLCR
      | ONLCR
#endif
    );
    
    s.c_oflag &= ~(0
#ifdef ONOEOT
      | ONOEOT
#endif
#ifdef OCRNL
      | OCRNL
#endif
#ifdef ONOCR
      | ONOCR
#endif
#ifdef ONLRET
      | ONLRET
#endif
    );
    s.c_cc[VMIN]=1;
    s.c_cc[VTIME]=0;
#ifdef VLNEXT
    s.c_cc[VLNEXT]=0;
#endif
#ifdef VDSUSP
    s.c_cc[VDSUSP] = 0;
#endif
  } else {
    s=save_term;
  }
  
  tcsetattr(2,TCSADRAIN,&s);
  }
#endif
  
  curr_on = on;
}

#ifdef WIN32
char wait_key_callback(void (*a)(void))
{
  char c;
  while (kbhit() == 0) {
    usleep(1000);
    if (a) {
      (*a)();
    }
  }
  c = (char) getch();
  return c;
}
#else
char wait_key_callback(void (*a)(void))
{
  char c;

  raw_mode(1);
  fcntl(STDIN_FILENO,F_SETFL,O_NONBLOCK);

  while (read(STDIN_FILENO, &c, 1) < 0) {
    usleep(1000);
    if (a) {
      (*a)();
    }
  }

  fcntl(STDIN_FILENO,F_SETFL,0);
  raw_mode(0);
  return c;
}
#endif

int cli_output_reset()
{
  paginator_count = 0;
  return 0;
}

/* 0.4.27.c14 removed macro "cli_output_text" and corresponding (unused)
   routine also called cli_output_text */

int cliol_col = 0; /* 0.4.27.c14 */

int cli_output_line(int num_following, char *text)
{
  int i,len;
  char c;

  len = strlen(text);
  for (i=0;i<len;i++) {
    if ((cliol_col==0) && conf_get_int("paginate")) {
      paginator_count++;
      if ((num_following+paginator_count)> (num_rows-1)) {
        printf("---more---\r");
        fflush(stdout);

        c = wait_key_callback(0);
        if (tolower(c)=='q') {
          printf("             \r");
          return -1;
        }
        printf("            \r");
        paginator_count = 1;
      }
    }
    putchar(text[i]);
    cliol_col++;
    if (cliol_col >= num_columns) {
      /*      putchar('\n'); */
      cliol_col=0;
    }
    if (text[i]=='\n') {
      cliol_col=0;
    }
  }
  return 0;
}

/* 0.4.27.c14 */
void cli_outline_nl(char *t)
{
  if (t) {
    cli_output_line(0, t);
    putchar('\n');
    cliol_col = 0;
  }
}

/* 0.4.27.c14 */
void cli_out_lines(char *t1, char *t2, char *t3, char *t4, char *t5, char *t6)
{
  cli_outline_nl(t1); cli_outline_nl(t2); cli_outline_nl(t3);
  cli_outline_nl(t4); cli_outline_nl(t5); cli_outline_nl(t6);
}
