#ifndef BLACKLIST_H
#define BLACKLIST_H

/*
 * Due to the damn spammers (Go! network in particular),
 * this software is designed to fight off the ever growing
 * spam on the network.
 */

#ifndef WIN32
# include <netinet/in.h>
#endif

#define BLACKLIST_TYPE_INCOMING 0x01
#define BLACKLIST_TYPE_OUTGOING 0x02
#define BLACKLIST_TYPE_SEARCH 0x04
#define BLACKLIST_TYPE_PING 0x08
#define BLACKLIST_TYPE_HTTP 0x10

#define BLACKLIST_HAVE_SEARCH 0x01
#define BLACKLIST_HAVE_ADDRESS 0x02
#define BLACKLIST_HAVE_PORT 0x04

typedef struct blacklist_st {
  int type;
  int which;
  char *search_string;
  char *host_string;
  int subnetbits;
#ifndef WIN32
  regex_t search;
#endif
  struct in_addr addr;
  struct in_addr subnet;
  int port;
  unsigned long hits;
} blacklist_t;

#ifdef __cplusplus
extern "C" {
#endif

  void gnut_blacklist_init(void);
  void gnut_blacklist_add(char *search_regex,
			  char *hostname,
			  char *subnet_bits,
			  char *port,
			  int filter_incoming,
			  int filter_outgoing,
			  int filter_ping,
			  int filter_searches,
			  int filter_http);
  void gnut_blacklist_remove(int index);
  int gnut_blacklist_allow(int operation, char *search, struct in_addr *addr,
			   int port, int opt1);
  int gnut_blacklist_foreach(int (*handle)(blacklist_t *bl, void *data),
			     void *data);
  int gnut_blacklist_totals(void);
  void gnut_blacklist_save(void);

#ifdef __cplusplus
}
#endif

#endif /* BLACKLIST_H */
