; Script generated by the Inno Setup Script Wizard.
; SEE THE DOCUMENTATION FOR DETAILS ON CREATING INNO SETUP SCRIPT FILES!

#define MyAppName "GNU Gatekeeper"
#define MyAppVerName "GNU Gatekeeper v2.2.5"
#define MyAppPublisher "www.gnugk.org"
#define MyAppURL "http://www.gnugk.org"

[Setup]
AppName={#MyAppName}
AppVerName={#MyAppVerName}
AppPublisher={#MyAppPublisher}
AppPublisherURL={#MyAppURL}
AppSupportURL={#MyAppURL}
AppUpdatesURL={#MyAppURL}
DefaultDirName={pf}\{#MyAppName}
DefaultGroupName={#MyAppName}
DisableProgramGroupPage=true
OutputBaseFilename=GnuGkSetup225
Compression=lzma
SolidCompression=true
ShowLanguageDialog=yes
UninstallDisplayIcon={app}\GnuGk.ico
AppID={{60FE29A6-735F-4E81-B92E-33367CA59D9C}
SetupIconFile=GnuGk.ico
WindowStartMaximized=false
WindowResizable=false
WindowVisible=false
WizardImageFile=InternetClassic22.bmp
WizardSmallImageFile=D:\gnugk\Install\logo.bmp
MinVersion=0,5.0.2195

[Languages]
Name: english; MessagesFile: compiler:Default.isl

[Files]
Source: ..\GnuGk\billing.pl; DestDir: {app}; Flags: ignoreversion
Source: ..\GnuGk\.cvsignore; DestDir: {app}; Flags: ignoreversion
Source: ..\GnuGk\changes.txt; DestDir: {app}; Flags: ignoreversion
Source: ..\GnuGk\copying; DestDir: {app}; Flags: ignoreversion
Source: ..\GnuGk\readme.txt; DestDir: {app}; Flags: ignoreversion
Source: ..\GnuGk\contrib\*; DestDir: {app}\contrib; Flags: ignoreversion recursesubdirs createallsubdirs
Source: ..\GnuGk\docs-html\*; DestDir: {app}\docs; Flags: ignoreversion recursesubdirs createallsubdirs
Source: ..\GnuGk\etc\*; DestDir: {app}\etc; Flags: ignoreversion recursesubdirs createallsubdirs
; NOTE: Don't use "Flags: ignoreversion" on any shared system files
Source: ..\GnuGk\bin\GnuGk.exe; DestDir: {app}
Source: ..\GnuGk\bin\addpasswd.exe; DestDir: {app}
Source: gatekeeper.ini; DestDir: {app}; Flags: onlyifdoesntexist
Source: GnuGk.ico; DestDir: {app}
Source: uninstall.ico; DestDir: {app}
Source: ..\GnuGkService\NTSVC.ocx; DestDir: {sys}; Flags: regserver uninsneveruninstall
Source: ..\GnuGkService\pacGnuGkNTS.exe; DestDir: {app}; Flags: ignoreversion
Source: monitor.ICO; DestDir: {app}
Source: ..\functions\mswinsck.ocx; DestDir: {sys}; Flags: regserver uninsneveruninstall
Source: ..\functions\GnuGkutil.exe; DestDir: {app}
Source: user.ico; DestDir: {app}
Source: reload.ICO; DestDir: {app}

[Icons]
;Name: {group}\GnuGk Gatekeeper; Filename: {app}\GnuGk.exe; IconFilename: {app}\GnuGk.ico; Comment: GnuGk Gatekeeper; IconIndex: 0; WorkingDir: {app}
Name: {group}\Configuration\gatekeeper.ini; Filename: {app}\gatekeeper.ini; WorkingDir: {app}; Comment: Gatekeeper Configuration File
Name: {group}\Add User; Filename: {app}\GnuGkutil.exe; Parameters: user; IconFilename: {app}\user.ico; IconIndex: 0; Tasks: securelogin; Comment: Add New User and Password
Name: {group}\Monitor; Filename: {sys}\telnet.exe; Parameters: 127.0.0.1 7000; IconFilename: {app}\monitor.ICO; IconIndex: 0; Comment: Telnet Connect to Gatekeeper
Name: {group}\Manual; Filename: {app}\docs\manual.html; Comment: GnuGk Manual
Name: {group}\Website; Filename: {app}\GnuGk.url; WorkingDir: {app}; Comment: GnuGk Website
Name: {group}\Uninstall GnuGK; Filename: {uninstallexe}; IconFilename: {app}\uninstall.ico; IconIndex: 0; Comment: Uninstall GnuGk
Name: {group}\Reload; Filename: {app}\GnuGkutil.exe; WorkingDir: {app}; Parameters: call=reload; Comment: Reload Settings; IconIndex: 0; IconFilename: {app}\reload.ICO
Name: {group}\Configuration\Samples; Filename: {app}\etc\; WorkingDir: {app}; Flags: foldershortcut; Comment: Sample configuration files
[INI]
Filename: {app}\gatekeeper.ini; Section: Gatekeeper::Main; Key: FortyTwo; String: 42
Filename: {app}\gatekeeper.ini; Section: Gatekeeper::Main; Key: Name; String: GnuGk
Filename: {app}\gatekeeper.ini; Section: Gatekeeper::Main; Key: EndpointSuffix; String: _GnuGk
Filename: {app}\gatekeeper.ini; Section: Gatekeeper::Main; Key: TimeToLive; String: 60
Filename: {app}\gatekeeper.ini; Section: Gatekeeper::Main; Key: StatusTraceLevel; String: 0
Filename: {app}\gatekeeper.ini; Section: Gatekeeper::Main; Key: UseBroadcastListener; String: 0
Filename: {app}\gatekeeper.ini; Section: Gatekeeper::Main; Key: UseMulticastListener; String: 0
Filename: {app}\gatekeeper.ini; Section: GkStatus::Auth; Key: rule; String: explicit|password; Tasks: status
Filename: {app}\gatekeeper.ini; Section: GkStatus::Auth; Key: 127.0.0.1; String: allow
Filename: {app}\gatekeeper.ini; Section: GkStatus::Auth; Key: default; String: forbid
Filename: {app}\gatekeeper.ini; Section: GkStatus::Auth; Key: Shutdown; String: allow
Filename: {app}\gatekeeper.ini; Section: RoutedMode; Key: GKRouted; String: 1
Filename: {app}\gatekeeper.ini; Section: RoutedMode; Key: H245Routed; String: 0
Filename: {app}\gatekeeper.ini; Section: RoutedMode; Key: CallSignalPort; String: 1721
Filename: {app}\gatekeeper.ini; Section: RoutedMode; Key: AcceptNeighborCalls; String: 1
Filename: {app}\gatekeeper.ini; Section: RoutedMode; Key: AcceptUnregisteredCalls; String: 0
Filename: {app}\gatekeeper.ini; Section: RoutedMode; Key: RemoveH245AddressOnTunneling; String: 1
Filename: {app}\gatekeeper.ini; Section: RoutedMode; Key: RemoveCallOnDRQ; String: 0
Filename: {app}\gatekeeper.ini; Section: RoutedMode; Key: DropCallsByReleaseComplete; String: 1
Filename: {app}\gatekeeper.ini; Section: RoutedMode; Key: SendReleaseCompleteOnDRQ; String: 0
Filename: {app}\gatekeeper.ini; Section: RoutedMode; Key: SupportNATedEndpoints; String: 1
Filename: {app}\gatekeeper.ini; Section: RoutedMode; Key: TranslateFacility; String: 1
Filename: {app}\gatekeeper.ini; Section: Proxy; Key: Enable; String: 0
Filename: {app}\gatekeeper.ini; Section: Proxy; Key: ProxyForNAT; String: 1
Filename: {app}\gatekeeper.ini; Section: Proxy; Key: ProxyForSameNAT; String: 0
Filename: {app}\gatekeeper.ini; Section: RasSrv::RRQFeatures; Key: AcceptEndpointIdentifier; String: 0
Filename: {app}\gatekeeper.ini; Section: RasSrv::RRQFeatures; Key: AcceptGatewayPrefixes; String: 1
Filename: {app}\gatekeeper.ini; Section: RasSrv::ARQFeatures; Key: CallUnregisteredEndpoints; String: 1
Filename: {app}\gatekeeper.ini; Section: CallTable; Key: GenerateNBCDR; String: 0
Filename: {app}\gatekeeper.ini; Section: CallTable; Key: GenerateUCCDR; String: 1
Filename: {app}\gatekeeper.ini; Section: Gatekeeper::Auth; Key: SimplePasswordAuth; String: "required;RRQ"; Tasks: securelogin

; Behind NAT support
Filename: {app}\gatekeeper.ini; Section: Gatekeeper::Main; Key: UnicastRasPort; String: {code:GetUDP}; Tasks: nat
Filename: {app}\gatekeeper.ini; Section: Gatekeeper::Main; Key: ExternalIP; String: {code:GetIPAddress}; Tasks: nat
Filename: {app}\gatekeeper.ini; Section: Gatekeeper::Main; Key: ExternalIsDynamic; String: {code:GetDDNS}; Tasks: nat
Filename: {app}\gatekeeper.ini; Section: RoutedMode; Key: CallSignalPort; String: {code:GetTCP}; Tasks: nat
Filename: {app}\gatekeeper.ini; Section: RoutedMode; Key: Q931PortRange; String: {code:GetQ931}; Tasks: nat
Filename: {app}\gatekeeper.ini; Section: RoutedMode; Key: H245PortRange; String: {code:GetH245}; Tasks: nat
Filename: {app}\gatekeeper.ini; Section: Proxy; Key: Enable; String: 1; Tasks: nat
Filename: {app}\gatekeeper.ini; Section: Proxy; Key: T120PortRange; String: {code:GetRTP}; Tasks: nat
Filename: {app}\gatekeeper.ini; Section: Proxy; Key: RTPPortRange; String: {code:GetRTP}; Tasks: nat
Filename: {app}\gatekeeper.ini; Section: RasSrv::RRQFeatures; Key: SupportDynamicIP; String: 1; Tasks: nat


Filename: {app}\GnuGk.url; Section: InternetShortcut; Key: URL; String: http://www.GnuGk.org/
[_ISTool]
EnableISX=true
UseAbsolutePaths=false
[UninstallDelete]
Type: files; Name: {app}\GnuGk.url
Name: {app}; Type: filesandordirs
[Run]
Filename: {app}\GnuGkutil.exe; Parameters: kill=pacGnuGkNTS.exe; Flags: runhidden; Tasks: service
Filename: {app}\GnuGkutil.exe; Parameters: kill=GnuGk.exe; Flags: runhidden; Tasks: service
Filename: {app}\pacGnuGkNTS.exe; Parameters: "-install -sname=""GnuGkserv"" -command=""{app}\GnuGk.exe"" -displayname=""GnuGk Service"" -visible=no -process=GnuGk.exe"; Flags: runhidden waituntilidle; StatusMsg: Installing Service; Tasks: service
[UninstallRun]
Filename: {app}\GnuGkutil.exe; Parameters: kill=pacGnuGkNTS.exe; Flags: runhidden; Tasks: service
Filename: {app}\GnuGkutil.exe; Parameters: kill=GnuGk.exe; Flags: runhidden; Tasks: service
Filename: {app}\pacGnuGkNTS.exe; Parameters: "-uninstall -sname=""GnuGkserv"" "; Flags: runhidden waituntilidle; Tasks: service

[Tasks]
Name: securelogin; Description: Require User Passwords (Simple Password Authentication); Flags: checkedonce
Name: status; Description: Allow users access to status port; Flags: unchecked
Name: nat; Description: Install on private LAN; Flags: unchecked
Name: service; Description: Install as Service; Flags: checkedonce; MinVersion: 0,4.0.1381sp4; Languages: 
[Code]
type
 SERVICE_STATUS = record
     dwServiceType    : cardinal;
     dwCurrentState    : cardinal;
     dwControlsAccepted   : cardinal;
     dwWin32ExitCode    : cardinal;
     dwServiceSpecificExitCode : cardinal;
     dwCheckPoint    : cardinal;
     dwWaitHint     : cardinal;
 end;
 HANDLE = cardinal;

const
 SERVICE_QUERY_CONFIG  = $1;
 SERVICE_CHANGE_CONFIG  = $2;
 SERVICE_QUERY_STATUS  = $4;
 SERVICE_START    = $10;
 SERVICE_STOP    = $20;
 SERVICE_ALL_ACCESS   = $f01ff;
 SC_MANAGER_ALL_ACCESS  = $f003f;
 SERVICE_WIN32_OWN_PROCESS = $10;
 SERVICE_WIN32_SHARE_PROCESS = $20;
 SERVICE_WIN32    = $30;
 SERVICE_INTERACTIVE_PROCESS = $100;
 SERVICE_BOOT_START          = $0;
 SERVICE_SYSTEM_START        = $1;
 SERVICE_AUTO_START          = $2;
 SERVICE_DEMAND_START        = $3;
 SERVICE_DISABLED            = $4;
 SERVICE_DELETE              = $10000;
 SERVICE_CONTROL_STOP  = $1;
 SERVICE_CONTROL_PAUSE  = $2;
 SERVICE_CONTROL_CONTINUE = $3;
 SERVICE_CONTROL_INTERROGATE = $4;
 SERVICE_STOPPED    = $1;
 SERVICE_START_PENDING       = $2;
 SERVICE_STOP_PENDING        = $3;
 SERVICE_RUNNING             = $4;
 SERVICE_CONTINUE_PENDING    = $5;
 SERVICE_PAUSE_PENDING       = $6;
 SERVICE_PAUSED              = $7;

//############################################################################
// nt based service utilities
//############################################################################

function OpenSCManager(lpMachineName, lpDatabaseName: string;
dwDesiredAccess :cardinal): HANDLE;
external 'OpenSCManagerA@advapi32.dll stdcall';

function OpenService(hSCManager :HANDLE;lpServiceName: string;
dwDesiredAccess :cardinal): HANDLE;
external 'OpenServiceA@advapi32.dll stdcall';

function CloseServiceHandle(hSCObject :HANDLE): boolean;
external 'CloseServiceHandle@advapi32.dll stdcall';

function CreateService(hSCManager :HANDLE;lpServiceName, lpDisplayName:
string;dwDesiredAccess,dwServiceType,dwStartType,dwErrorControl:
cardinal;lpBinaryPathName,lpLoadOrderGroup: String; lpdwTagId :
cardinal;lpDependencies,lpServiceStartName,lpPassword :string): cardinal;
external 'CreateServiceA@advapi32.dll stdcall';

function DeleteService(hService :HANDLE): boolean;
external 'DeleteService@advapi32.dll stdcall';

function StartNTService(hService :HANDLE;dwNumServiceArgs :
cardinal;lpServiceArgVectors : cardinal) : boolean;
external 'StartServiceA@advapi32.dll stdcall';

function ControlService(hService :HANDLE; dwControl :cardinal;var
ServiceStatus :SERVICE_STATUS) : boolean;
external 'ControlService@advapi32.dll stdcall';

function QueryServiceStatus(hService :HANDLE;var ServiceStatus
:SERVICE_STATUS) : boolean;
external 'QueryServiceStatus@advapi32.dll stdcall';

function QueryServiceStatusEx(hService :HANDLE;ServiceStatus
:SERVICE_STATUS) : boolean;
external 'QueryServiceStatus@advapi32.dll stdcall';

function OpenServiceManager() : HANDLE;
begin
 if UsingWinNT() = true then begin
  Result := OpenSCManager('','ServicesActive',SC_MANAGER_ALL_ACCESS);
  if Result = 0 then
   MsgBox('the servicemanager is not available', mbError, MB_OK)
 end
 else begin
   MsgBox('only nt based systems support services', mbError, MB_OK)
   Result := 0;
 end
end;

function IsServiceInstalled(ServiceName: string) : boolean;
var
 hSCM : HANDLE;
 hService: HANDLE;
begin
 hSCM := OpenServiceManager();
 Result := false;
 if hSCM <> 0 then begin
  hService := OpenService(hSCM,ServiceName,SERVICE_QUERY_CONFIG);
        if hService <> 0 then begin
            Result := true;
            CloseServiceHandle(hService)
  end;
        CloseServiceHandle(hSCM)
 end
end;

function InstallService(FileName, ServiceName, DisplayName, Description :
string;ServiceType,StartType :cardinal) : boolean;
var
 hSCM : HANDLE;
 hService: HANDLE;
begin
 hSCM := OpenServiceManager();
 Result := false;
 if hSCM <> 0 then begin
  hService :=
CreateService(hSCM,ServiceName,DisplayName,SERVICE_ALL_ACCESS,ServiceType,StartType,0,FileName,'',0,'','','');
  if hService <> 0 then begin
   Result := true;
   // Win2K & WinXP supports aditional description text for services
   if Description<> '' then
    RegWriteStringValue(HKLM,'System\CurrentControlSet\Services\' +
ServiceName,'Description',Description);
   CloseServiceHandle(hService)
  end;
        CloseServiceHandle(hSCM)
 end
end;

function RemoveService(ServiceName: string) : boolean;
var
 hSCM : HANDLE;
 hService: HANDLE;
begin
 hSCM := OpenServiceManager();
 Result := false;
 if hSCM <> 0 then begin
  hService := OpenService(hSCM,ServiceName,SERVICE_DELETE);
        if hService <> 0 then begin
            Result := DeleteService(hService);
            CloseServiceHandle(hService)
  end;
        CloseServiceHandle(hSCM)
 end
end;

function StartService(ServiceName: string) : boolean;
var
 hSCM : HANDLE;
 hService: HANDLE;
begin
 hSCM := OpenServiceManager();
 Result := false;
 if hSCM <> 0 then begin
  hService := OpenService(hSCM,ServiceName,SERVICE_START);
        if hService <> 0 then begin
         Result := StartNTService(hService,0,0);
            CloseServiceHandle(hService)
  end;
        CloseServiceHandle(hSCM)
 end;
end;

function StopService(ServiceName: string) : boolean;
var
 hSCM : HANDLE;
 hService: HANDLE;
 Status : SERVICE_STATUS;
begin
 hSCM := OpenServiceManager();
 Result := false;
 if hSCM <> 0 then begin
  hService := OpenService(hSCM,ServiceName,SERVICE_STOP);
        if hService <> 0 then begin
         Result := ControlService(hService,SERVICE_CONTROL_STOP,Status);
            CloseServiceHandle(hService)
  end;
        CloseServiceHandle(hSCM)
 end;
end;

function IsServiceRunning(ServiceName: string) : boolean;
var
 hSCM : HANDLE;
 hService: HANDLE;
 Status : SERVICE_STATUS;
begin
 hSCM := OpenServiceManager();
 Result := false;
 if hSCM <> 0 then begin
  hService := OpenService(hSCM,ServiceName,SERVICE_QUERY_STATUS);
     if hService <> 0 then begin
   if QueryServiceStatus(hService,Status) then begin
    Result :=(Status.dwCurrentState = SERVICE_RUNNING)
         end;
            CloseServiceHandle(hService)
      end;
        CloseServiceHandle(hSCM)
 end;
end;

function InitializeSetup(): boolean;

var
	answ : Integer;
begin
   answ := IDYES;

  if IsServiceInstalled('GnuGkserv') = true then
   begin
	 if IsServiceRunning('GnuGkserv') then begin
	     answ := MsgBox( 'Warning: GnuGk is currently running on this computer.'
	          + #13#13 + 'Calls and Registrations will be affected during Installation Process.'
			  + #13#13 + 'Do you want to upgrade anyway ?',
			  mbConfirmation, MB_YESNO )
		if (answ = IDYES) then begin
            StopService('GnuGkserv');
        end;
      // If user answer is NO abort setup
	 end;
   end;

	Result := ( answ = IDYES );
end;

procedure DeinitializeSetup();
begin

  if IsServiceInstalled('GnuGkserv') = true then
   begin
	   if IsServiceRunning('GnuGkserv') = false then begin
		   StartService('GnuGkserv');
	   end;
   end;

end;

function InitializeUninstall(): boolean;
begin
  if IsServiceInstalled('GnuGkserv') = true then
   begin
	 if IsServiceRunning('GnuGkserv')= true then begin
		  StopService('GnuGkserv');
	 end;
   end;

 Result := true;
end;

///////////////////////////////////////////////////////////////////////

  [CustomMessages]
  gnugk_lanCaption=GnuGk LAN installation
  gnugk_lanDescription=GnuGk installed behind a NAT box but still can access the public internet

  [Code]
  var
    Label1: TLabel;
    Label9: TLabel;
    ipaddress: TEdit;
    ddns: TCheckBox;
    Panel1: TPanel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    Label7: TLabel;
    Label8: TLabel;
    tcp: TEdit;
    udp: TEdit;
    q931: TEdit;
    h245: TEdit;
    rtp: TEdit;

  procedure gnugk_lan_Activate(Page: TWizardPage);
  begin
  end;

  function gnugk_lan_ShouldSkipPage(Page: TWizardPage): Boolean;
  begin
    Result := False;
  end;

  function gnugk_lan_BackButtonClick(Page: TWizardPage): Boolean;
  begin
    Result := True;
  end;

  function gnugk_lan_NextButtonClick(Page: TWizardPage): Boolean;
  begin
    Result := True;
  end;

  procedure gnugk_lan_CancelButtonClick(Page: TWizardPage; var Cancel, Confirm: Boolean);
  begin
  end;

  function gnugk_lan_CreatePage(PreviousPageId: Integer): Integer;
  var
    Page: TWizardPage;
  begin
    Page := CreateCustomPage(
      PreviousPageId,
      ExpandConstant('{cm:gnugk_lanCaption}'),
      ExpandConstant('{cm:gnugk_lanDescription}')
    );

    { Label1 }
    Label1 := TLabel.Create(Page);
    with Label1 do
    begin
      Parent := Page.Surface;
      Left := ScaleX(29);
      Top := ScaleY(24);
      Width := ScaleX(82);
      Height := ScaleY(13);
      Alignment := taRightJustify;
      Caption := 'Public IP Address';
    end;

    { Label9 }
    Label9 := TLabel.Create(Page);
    with Label9 do
    begin
      Parent := Page.Surface;
      Left := ScaleX(16);
      Top := ScaleY(0);
      Width := ScaleX(234);
      Height := ScaleY(13);
      Caption := 'Information if you are Installing GnuGk on a private LAN';
      Color := -16777201;
      Font.Color := 16711680;
      Font.Height := ScaleY(-11);
      Font.Name := 'Tahoma';
    end;

    { ipaddress }
    ipaddress := TEdit.Create(Page);
    with ipaddress do
    begin
      Parent := Page.Surface;
      Left := ScaleX(120);
      Top := ScaleY(24);
      Width := ScaleX(137);
      Height := ScaleY(21);
      TabOrder := 0;
      Text := 'gk.mydomain.com';
    end;

    { ddns }
    ddns := TCheckBox.Create(Page);
    with ddns do
    begin
      Parent := Page.Surface;
      Left := ScaleX(120);
      Top := ScaleY(48);
      Width := ScaleX(137);
      Height := ScaleY(17);
      Caption := 'Dynamic DNS Service';
      TabOrder := 1;
    end;

    { Panel1 }
    Panel1 := TPanel.Create(Page);
    with Panel1 do
    begin
      Parent := Page.Surface;
      Left := ScaleX(16);
      Top := ScaleY(72);
      Width := ScaleX(377);
      Height := ScaleY(145);
      BevelOuter := bvLowered;
      TabOrder := 2;
    end;

    { Label2 }
    Label2 := TLabel.Create(Page);
    with Label2 do
    begin
      Parent := Panel1;
      Left := ScaleX(6);
      Top := ScaleY(18);
      Width := ScaleX(91);
      Height := ScaleY(13);
      Caption := 'TCP Listening Port:';
    end;

    { Label3 }
    Label3 := TLabel.Create(Page);
    with Label3 do
    begin
      Parent := Panel1;
      Left := ScaleX(25);
      Top := ScaleY(48);
      Width := ScaleX(70);
      Height := ScaleY(13);
      Caption := 'UDP RAS Port:';
    end;

    { Label4 }
    Label4 := TLabel.Create(Page);
    with Label4 do
    begin
      Parent := Panel1;
      Left := ScaleX(176);
      Top := ScaleY(18);
      Width := ScaleX(89);
      Height := ScaleY(13);
      Caption := 'TCP  Q.931 Range';
    end;

    { Label5 }
    Label5 := TLabel.Create(Page);
    with Label5 do
    begin
      Parent := Panel1;
      Left := ScaleX(176);
      Top := ScaleY(42);
      Width := ScaleX(88);
      Height := ScaleY(13);
      Caption := 'TCP  H.245 Range';
    end;

    { Label6 }
    Label6 := TLabel.Create(Page);
    with Label6 do
    begin
      Parent := Panel1;
      Left := ScaleX(176);
      Top := ScaleY(67);
      Width := ScaleX(79);
      Height := ScaleY(13);
      Caption := 'UDP  RTP Range';
    end;

    { Label7 }
    Label7 := TLabel.Create(Page);
    with Label7 do
    begin
      Parent := Panel1;
      Left := ScaleX(32);
      Top := ScaleY(96);
      Width := ScaleX(308);
      Height := ScaleY(13);
      Alignment := taCenter;
      Caption := 'Note: These ports must be port forward to the internal IP of the';
      Color := -16777201;
      Font.Color := 128;
      Font.Height := ScaleY(-11);
      Font.Name := 'Tahoma';
    end;

    { Label8 }
    Label8 := TLabel.Create(Page);
    with Label8 do
    begin
      Parent := Panel1;
      Left := ScaleX(40);
      Top := ScaleY(110);
      Width := ScaleX(304);
      Height := ScaleY(13);
      Alignment := taCenter;
      Caption := 'Gatekeeper or the Gatekeeper placed in the DMZ of the router.';
      Color := -16777201;
      Font.Color := 128;
      Font.Height := ScaleY(-11);
      Font.Name := 'Tahoma';
    end;

    { tcp }
    tcp := TEdit.Create(Page);
    with tcp do
    begin
      Parent := Panel1;
      Left := ScaleX(104);
      Top := ScaleY(16);
      Width := ScaleX(57);
      Height := ScaleY(21);
      TabOrder := 0;
      Text := '1721';
    end;

    { udp }
    udp := TEdit.Create(Page);
    with udp do
    begin
      Parent := Panel1;
      Left := ScaleX(104);
      Top := ScaleY(43);
      Width := ScaleX(57);
      Height := ScaleY(21);
      TabOrder := 1;
      Text := '1719';
    end;

    { q931 }
    q931 := TEdit.Create(Page);
    with q931 do
    begin
      Parent := Panel1;
      Left := ScaleX(272);
      Top := ScaleY(16);
      Width := ScaleX(73);
      Height := ScaleY(21);
      TabOrder := 2;
      Text := '30000-30999';
    end;

    { h245 }
    h245 := TEdit.Create(Page);
    with h245 do
    begin
      Parent := Panel1;
      Left := ScaleX(272);
      Top := ScaleY(40);
      Width := ScaleX(73);
      Height := ScaleY(21);
      TabOrder := 3;
      Text := '31000-31999';
    end;

    { rtp }
    rtp := TEdit.Create(Page);
    with rtp do
    begin
      Parent := Panel1;
      Left := ScaleX(272);
      Top := ScaleY(64);
      Width := ScaleX(73);
      Height := ScaleY(21);
      TabOrder := 4;
      Text := '50000-59999';
    end;


    with Page do
    begin
      OnActivate := @gnugk_lan_Activate;
      OnShouldSkipPage := @gnugk_lan_ShouldSkipPage;
      OnBackButtonClick := @gnugk_lan_BackButtonClick;
      OnNextButtonClick := @gnugk_lan_NextButtonClick;
      OnCancelButtonClick := @gnugk_lan_CancelButtonClick;
    end;

    Result := Page.ID;
  end;

  function GetIPAddress(Param: String): String;
  begin
     { Return the selected IPAddress }
     Result := ipaddress.Text;
  end;

  function GetDDNS(Param: String): String;
  begin
     { Return the whether DDNS }
     if ddns.Checked
     then Result := '1'
     else Result := '0';
  end;

  function GetTCP(Param: String): String;
  begin
     { Return the selected TCP port range }
     Result := tcp.Text;
  end;

  function GetUDP(Param: String): String;
  begin
     { Return the selected UDP port range }
     Result := udp.Text;
  end;

  function GetQ931(Param: String): String;
  begin
     { Return the selected Q931 range }
     Result := q931.Text;
  end;

  function GetH245(Param: String): String;
  begin
     { Return the selected H.245 range }
     Result := h245.Text;
  end;

  function GetRTP(Param: String): String;
  begin
     { Return the selected rtp range }
     Result := rtp.Text;
  end;

  procedure InitializeWizard();
  begin
    gnugk_lan_CreatePage(wpSelectTasks);
  end;
