/* gmpc-shout (GMPC plugin)
 * Copyright (C) 2007-2009 Qball Cow <qball@sarine.nl>
 * Project homepage: http://gmpcwiki.sarine.nl/
 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
*/

#include <stdio.h>
#include <string.h>
#include <glib.h>
#include <gmpc/plugin.h>
#ifndef __WIN32__
#include <sys/wait.h>
#include <unistd.h>
#include <signal.h>
#else
#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#endif

#define SHOUT_HOSTNAME "http://192.150.0.102:8000/mpd.ogg"
#define SHOUT_OUTPUT "pulse"
#include <config.h>
GPid ogg123_pid = -1;

static GtkWidget *shout_vbox = NULL;
static void start_ogg123(void);
static void stop_ogg123(void);
void shout_mpd_status_changed(MpdObj *mi, ChangedStatusType what, void *data);
void shout_construct(GtkWidget *container);
void shout_destroy(GtkWidget *container);
static int shout_get_enabled(void);
static void shout_set_enabled(int enabled);

gmpcPrefPlugin shout_gpp = {
	shout_construct,
	shout_destroy
};

int plugin_api_version = PLUGIN_API_VERSION;

static void shout_plugin_destroy(void);
/* main plugin_osd info */
gmpcPlugin plugin = {
	.name           = "Shout plugin",
    .version        = {PLUGIN_MAJOR_VERSION,PLUGIN_MINOR_VERSION,PLUGIN_MICRO_VERSION},
	.plugin_type    = GMPC_PLUGIN_NO_GUI,
	.destroy        = shout_plugin_destroy, /* Destroy */
	.mpd_status_changed = &shout_mpd_status_changed,
	.pref           = &shout_gpp,
	.get_enabled    = shout_get_enabled,
	.set_enabled    = shout_set_enabled	
};


static int shout_get_enabled(void)
{
	return cfg_get_single_value_as_int_with_default(config, "shout-plugin", "enable", FALSE);
}
static void shout_set_enabled(int enabled)
{
	cfg_set_single_value_as_int(config, "shout-plugin", "enable", enabled);
	if(enabled )
	{
		if(mpd_player_get_state(connection) == MPD_STATUS_STATE_PLAY)
		{
			start_ogg123();
		}

	} else {
		/* stop */
		stop_ogg123();
	}
}

void shout_destroy(GtkWidget *container)
{
	gtk_container_remove(GTK_CONTAINER(container), shout_vbox);
}
static void shout_enable_toggle(GtkWidget *wid)
{
	int kk = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(wid));
	shout_set_enabled(kk);	
}
static void shout_entry_edited(GtkWidget *entry)
{
	const char *str = gtk_entry_get_text(GTK_ENTRY(entry));
	if(str)
	{
		cfg_set_single_value_as_string(config, "shout-plugin", "hostname",(char *)str);
	}
}
static void shout_output_entry_edited(GtkWidget *entry)
{
	const char *str = gtk_entry_get_text(GTK_ENTRY(entry));
	if(str)
	{
		cfg_set_single_value_as_string(config, "shout-plugin", "output",(char *)str);
	}
}






void shout_construct(GtkWidget *container)
{
	GtkWidget *enable_cg = gtk_check_button_new_with_mnemonic("_Enable shout-cast streaming"); 
	GtkWidget *entry = NULL;
	char *entry_str = cfg_get_single_value_as_string_with_default(config, "shout-plugin", "hostname",SHOUT_HOSTNAME);
	char *output_str = cfg_get_single_value_as_string_with_default(config, "shout-plugin", "output",SHOUT_OUTPUT);
	shout_vbox = gtk_vbox_new(FALSE,6);

	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(enable_cg), 	
			cfg_get_single_value_as_int_with_default(config, "shout-plugin", "enable", FALSE));

	g_signal_connect(G_OBJECT(enable_cg), "toggled", G_CALLBACK(shout_enable_toggle), NULL);
	gtk_box_pack_start(GTK_BOX(shout_vbox), enable_cg, FALSE, FALSE, 0);
	gtk_container_add(GTK_CONTAINER(container), shout_vbox);

	entry = gtk_entry_new();
	if(entry_str)
	{
		gtk_entry_set_text(GTK_ENTRY(entry), entry_str);
		cfg_free_string(entry_str);
	}
	gtk_box_pack_start(GTK_BOX(shout_vbox), gtk_label_new("Shout URI:"), FALSE, FALSE,0);
	gtk_box_pack_start(GTK_BOX(shout_vbox), entry, FALSE, FALSE,0);

	g_signal_connect(G_OBJECT(entry), "changed", G_CALLBACK(shout_entry_edited), NULL);

	entry = gtk_entry_new();
	if(output_str)
	{
		gtk_entry_set_text(GTK_ENTRY(entry), output_str);
		cfg_free_string(output_str);
	}

	gtk_box_pack_start(GTK_BOX(shout_vbox), gtk_label_new("Audio output:"), FALSE, FALSE,0);
	gtk_box_pack_start(GTK_BOX(shout_vbox), entry, FALSE, FALSE,0);

	g_signal_connect(G_OBJECT(entry), "changed", G_CALLBACK(shout_output_entry_edited), NULL);

	gtk_widget_show_all(container);
}
static void                shout_pid_callback                (GPid pid,
		gint status,
		gpointer data)
{
	g_spawn_close_pid(ogg123_pid);
	printf("client died: %i\n", ogg123_pid);
	ogg123_pid = -1;	
}
static void start_ogg123(void)
{
	if(ogg123_pid == -1)
	{
		gchar *uri = cfg_get_single_value_as_string_with_default(config, "shout-plugin", "hostname", SHOUT_HOSTNAME);
		gchar *output = cfg_get_single_value_as_string_with_default(config, "shout-plugin","output", SHOUT_OUTPUT);
		gchar *argv[] = { "ogg123", "-d", output,uri, NULL};
		GError *error = NULL;
		if(!g_spawn_async(NULL,argv, NULL, G_SPAWN_SEARCH_PATH|G_SPAWN_DO_NOT_REAP_CHILD,NULL, NULL, &ogg123_pid, &error))
		{
			printf("%s\n", error->message);

		}
		else
		{
			g_child_watch_add(ogg123_pid, shout_pid_callback, NULL);
		}
		printf("spawned pid: %i\n", ogg123_pid);
		g_free(output);
		g_free(uri);
	}
}

static void stop_ogg123(void)
{
	if(ogg123_pid >= 0)
	{
#ifndef __WIN32__
		printf("killing: %i\n", ogg123_pid);
		kill (ogg123_pid, SIGHUP);
#else
		TerminateProcess (ogg123_pid, 1);
#endif
	}
	/*	ogg123_pid = -1;*/
}

/* mpd changed */

void   shout_mpd_status_changed(MpdObj *mi, ChangedStatusType what, void *data)
{
	if(!shout_get_enabled())
		return;
	if(what&(MPD_CST_SONGID|MPD_CST_STATE))
	{
		if(mpd_player_get_state(mi) != MPD_STATUS_STATE_PLAY)
		{
			stop_ogg123();
		}
		else
		{
			start_ogg123();
		}
		return;
	}
}
static void shout_plugin_destroy(void)
{
	stop_ogg123();
}

