/* gmpc-extraplaylist (GMPC plugin)
 * Copyright (C) 2006-2009 Qball Cow <qball@sarine.nl>
 * Project homepage: http://gmpcwiki.sarine.nl/
 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
*/

#include <string.h>
#include <glade/glade.h>
#include <gmpc/plugin.h>
#include <config.h>
/* External pointer + function, there internal from gmpc */
extern GladeXML *pl3_xml;
GtkWidget *extraplaylist = NULL;
static GtkWidget *extraplaylist_paned = NULL;

extern gmpcPlugin current_playlist_plug;
static void extra_playlist_row_changed(GtkTreeSelection *sel, gpointer data)
{
    GtkTreeIter iter;
    GtkTreeModel *model = (GtkTreeModel *)playlist3_get_category_tree_store();
    if(extraplaylist == NULL)
        return;
    if(cfg_get_single_value_as_int_with_default(config,"extraplaylist", "enabled", 0) == 0)
        return;

    if(gtk_tree_selection_get_selected(sel, &model, &iter))
    {
        int type;
        gtk_tree_model_get(model, &iter, 0,&type, -1);

        if(type == current_playlist_plug.id){
            if(gtk_bin_get_child(GTK_BIN(extraplaylist)))
                current_playlist_plug.browser->unselected(extraplaylist);
            gtk_widget_hide(extraplaylist);
        }
    }
}

static void extra_playlist_row_changed_after(GtkTreeSelection *sel, gpointer data)
{
    GtkTreeIter iter;
    GtkTreeModel *model = (GtkTreeModel *)playlist3_get_category_tree_store();
    if(extraplaylist == NULL)
        return;
    if(cfg_get_single_value_as_int_with_default(config,"extraplaylist", "enabled", 0) == 0)
        return;

    if(gtk_tree_selection_get_selected(sel, &model, &iter))
    {
        int type;
        gtk_tree_model_get(model, &iter, 0,&type, -1);

        if(type != current_playlist_plug.id){
            if ( gtk_bin_get_child(GTK_BIN(extraplaylist)) == NULL)  {
                /* Can't do this yet, because it is still packaged */
                current_playlist_plug.browser->selected(extraplaylist);
                gtk_widget_show(extraplaylist);
            }
        }
    }
}

static void extra_playlist_destroy() {
	if(extraplaylist) {
		int pos = gtk_paned_get_position(GTK_PANED(extraplaylist_paned));
		printf("pos is: %i\n",pos);
		if(pos>0)
			cfg_set_single_value_as_int(config, "extraplaylist", "paned-pos", pos);
	}
}

static void extra_playlist_add() {

	if(pl3_xml == NULL) return;


	GtkTreeSelection *sel = gtk_tree_view_get_selection(GTK_TREE_VIEW(playlist3_get_category_tree_view()));


	g_signal_connect(G_OBJECT(sel), "changed",G_CALLBACK(extra_playlist_row_changed), NULL); 
	g_signal_connect_after(G_OBJECT(sel), "changed",G_CALLBACK(extra_playlist_row_changed_after), NULL); 

	/**
	 * Hack it into the main view
	 */
    extraplaylist = gtk_event_box_new();

	GtkWidget *temp	= glade_xml_get_widget(pl3_xml, "hpaned1");
	g_object_ref(temp);
	extraplaylist_paned = gtk_vpaned_new();
	gtk_container_remove(GTK_CONTAINER(glade_xml_get_widget(pl3_xml,"vbox_control")),temp);



	gtk_paned_pack1(GTK_PANED(extraplaylist_paned), temp, TRUE, TRUE); 
	gtk_box_pack_start(GTK_BOX(glade_xml_get_widget(pl3_xml, "vbox_control")), extraplaylist_paned, TRUE, TRUE, 0);
	gtk_paned_pack2(GTK_PANED(extraplaylist_paned), extraplaylist, TRUE, TRUE); 

	gtk_paned_set_position(GTK_PANED(extraplaylist_paned),cfg_get_single_value_as_int_with_default(config, "extraplaylist", "paned-pos", 400));

	gtk_widget_show(extraplaylist_paned);
    gtk_widget_hide(extraplaylist);

	extra_playlist_row_changed(sel,NULL);
}


static void extra_playlist_init(void ) {
	if( cfg_get_single_value_as_int_with_default(config,"extraplaylist", "enabled", 1)) {
		gtk_init_add((GtkFunction )extra_playlist_add, NULL);
	}
}
static int get_enabled() {
	return cfg_get_single_value_as_int_with_default(config,"extraplaylist", "enabled", 0); 
}
static void set_enabled(int enable) {
	GtkTreeSelection *sel = gtk_tree_view_get_selection(GTK_TREE_VIEW(playlist3_get_category_tree_view()));
    cfg_set_single_value_as_int(config,"extraplaylist", "enabled", enable);
    if(enable)
	{
		if(!extraplaylist) {
			extra_playlist_add();
		} else {
            extra_playlist_row_changed_after(sel,NULL);
		}

    } else if(extraplaylist){
		gtk_widget_hide(extraplaylist);
        if(gtk_bin_get_child(GTK_BIN(extraplaylist)))
            current_playlist_plug.browser->unselected(extraplaylist);
	}
}

gmpcPlugin plugin = {
	.name = "Exrta Playlist View",
	.version = {PLUGIN_MAJOR_VERSION, PLUGIN_MINOR_VERSION, PLUGIN_MICRO_VERSION},
	.plugin_type = GMPC_PLUGIN_NO_GUI,
	.init = extra_playlist_init,            /* initialization */
	.destroy = extra_playlist_destroy,         /* Destroy */
	.get_enabled = get_enabled,
	.set_enabled = set_enabled
};
int plugin_api_version = PLUGIN_API_VERSION;
