#include <stdio.h>
#include <string.h>
#include <gtk/gtk.h>
#include <axl/axl.h>
#include <gmpc/plugin.h>
#include <gmpc/gmpc_easy_download.h>
#include <gmpc/misc.h>
#include <libmpd/libmpd-internal.h>
#include "magnatune.h"

static void magnatune_cleanup_xml();
static axlDoc *magnatune_xmldoc = NULL;
GMutex *mt_db_lock = NULL;

/* hack fix this */
int magnatune_end_download();

/**
 * Makes a copy with all &#<id>; decoded
 */
static char * url_decode(const char *string)
{
    char *retv = NULL;
    if(string && string[0] != '\0')
    {
        int i;
        const gchar *a = string;
        gchar *b;
        b = retv= g_malloc0((strlen(string)+1)*sizeof(char));
        while(*a){
            if(*a == '&'){
                const char *c = a;
                while(*c != ';')c++;
                /* skip &# */
                a+=2;
                *b= (char)atoi(a);
                a = c;
            }
            else 
                *b = *a;
            b++; 
            a++;
        }
    }
    return retv;
}

void magnatune_db_destroy(void)
{
    if(mt_db_lock)
    {
        g_mutex_lock(mt_db_lock);
        g_mutex_unlock(mt_db_lock);
        g_mutex_free(mt_db_lock);
    }
    if(magnatune_xmldoc)
    {
        axl_doc_free(magnatune_xmldoc);
        axl_end();
        magnatune_xmldoc = NULL;
    }
}

/* run this before using the other fucntions */
void magnatune_db_init()
{
    mt_db_lock = g_mutex_new();
    axl_init();
}

void magnatune_db_open()
{
    gchar *path = gmpc_get_user_path("magnatune.xml"); 

    g_mutex_lock(mt_db_lock);	
    /** 
     * if the db doesn't exists exit
     */
    if(!g_file_test(path, G_FILE_TEST_EXISTS))
    {
        g_free(path);
        g_mutex_unlock(mt_db_lock);
        return;
    }
    /**
     * if open close it
     */
    if(magnatune_xmldoc)
    {
        axl_doc_free(magnatune_xmldoc);
        magnatune_xmldoc = NULL;
    }
    magnatune_xmldoc = axl_doc_parse_from_file(path, NULL); 

    g_mutex_unlock(mt_db_lock);
    g_free(path);
}

gboolean magnatune_db_has_data()
{
    gboolean data = FALSE;
    g_mutex_lock(mt_db_lock);
    data = (magnatune_xmldoc != NULL)? TRUE:FALSE;
    g_mutex_unlock(mt_db_lock);
    return data;
}

MpdData * magnatune_db_get_genre_list()
{
    MpdData *list = NULL;
    axlNode *root;
    axlNode *cur;
    /** check if there is data */
    g_mutex_lock(mt_db_lock);
    if(magnatune_xmldoc == NULL)
    {
        g_mutex_unlock(mt_db_lock);
        return NULL;
    }

    root = axl_doc_get_root(magnatune_xmldoc);
    cur = axl_node_get_first_child(root); 
    while(cur != NULL)
    {
        axlNode *cur2;
        if(NODE_CMP_NAME(cur, "Album"))
        {
            const char *genre = NULL;
            cur2 = axl_node_get_first_child(cur); 
            while(cur2 != NULL)
            {
                if(NODE_CMP_NAME(cur2, "magnatunegenres"))
                {
                    gchar **tokens = NULL;
                    genre = axl_node_get_content(cur2,NULL);
                    if(genre)
                    {
                        int i =0;
                        tokens = g_strsplit(genre,",",0);
                        for(i=0; tokens[i];i++)
                        {
                            list = mpd_new_data_struct_append(list);
                            list->type = MPD_DATA_TYPE_TAG;
                            list->tag_type = MPD_TAG_ITEM_GENRE;
                            list->tag = url_decode(tokens[i]);
                        }
                        g_strfreev (tokens);
                    }
                }
                cur2 = axl_node_get_next(cur2);
            }
        }

        cur = axl_node_get_next(cur);
    }
    g_mutex_unlock(mt_db_lock);
    return misc_mpddata_remove_duplicate_songs(list); 
}

gchar *magnatune_db_get_value(const char *artist, const char *album, int type)
{
    gchar *retval = NULL;
    axlNode *root;
    axlNode *cur;
    /** check if there is data */
    g_mutex_lock(mt_db_lock);
    if(magnatune_xmldoc == NULL || !artist )
    {
        g_mutex_unlock(mt_db_lock);
        return NULL;
    }

    root = axl_doc_get_root(magnatune_xmldoc);
    cur = axl_node_get_first_child(root); 
    while(cur != NULL && !retval)
    {
        axlNode *cur2;
        if(NODE_CMP_NAME(cur, "Album"))
        {
            const char *gartist = NULL;
            const char *galbum = NULL;
            const char *gvalue = NULL;
            cur2 = axl_node_get_first_child(cur);
            while(cur2 != NULL && !retval)
            {
                if(!gartist && NODE_CMP_NAME(cur2, "artist"))
                {
                    gartist = axl_node_get_content(cur2,NULL);
                }
                else if(!galbum && NODE_CMP_NAME(cur2, "albumname"))
                {
                    galbum= axl_node_get_content(cur2,NULL);
                }
                else if(!gvalue && NODE_CMP_NAME(cur2, ((type== META_ARTIST_ART)?"artistphoto":"cover_small")))
                {
                    gvalue= axl_node_get_content(cur2,NULL);
                }
                cur2 = axl_node_get_next(cur2);
            }
            if(gvalue && artist && !strncmp(gartist, artist,strlen(artist)))
            {
                if(type == META_ARTIST_ART)
                {
                    retval = url_decode(gvalue);
                }
                else if(galbum && !strcmp(galbum, album)){
                    retval = url_decode(gvalue);			
                }
            }

        }
        cur = axl_node_get_next(cur);
    }

    g_mutex_unlock(mt_db_lock);
    return retval;
}
/**
 * This removes duplicate/unused fields from every Track entry, 
 * This remove around 1/2 the file size
 * NOT THREAD SAFE, USE INTERNALLY
 */
static void magnatune_cleanup_xml()
{
    axlNode *root;
    axlNode *cur;	
    if(!magnatune_xmldoc)
        return;
    root = axl_doc_get_root(magnatune_xmldoc);
    cur = axl_node_get_first_child(root); 
    while(cur != NULL) 
    {
        axlNode *cur2;
        if(NODE_CMP_NAME(cur, "Album")) 
        {
            cur2 = axl_node_get_first_child(cur);
            while(cur2 != NULL) 
            {
                if(NODE_CMP_NAME(cur2, "Track"))	
                {
                    axlNode *cur3 = axl_node_get_first_child(cur2) ;
                    while(cur3) {
                        if(NODE_CMP_NAME(cur3, "albumname") || 
                                NODE_CMP_NAME(cur3, "artist") ||
                                NODE_CMP_NAME(cur3, "artistdesc") ||
                                NODE_CMP_NAME(cur3, "home") ||
                                NODE_CMP_NAME (cur3, "artistphoto") ||
                                NODE_CMP_NAME (cur3, "mp3lofi") ||
                                NODE_CMP_NAME (cur3, "albumsku") ||
                                NODE_CMP_NAME (cur3, "mp3genre") ||
                                NODE_CMP_NAME (cur3, "magnatunegenres") ||
                                NODE_CMP_NAME (cur3, "license") ||
                                NODE_CMP_NAME (cur3, "album_notes") ||
                                NODE_CMP_NAME (cur3, "launchdate") ||
                                NODE_CMP_NAME (cur3, "buy") ||
                                NODE_CMP_NAME (cur3, "moods") )

                        {
                            axl_node_remove(cur3,TRUE);
                            
                            cur3 = axl_node_get_first_child(cur2) ;
                        } else {
                            cur3 = axl_node_get_next(cur3);
                        }
                    }
                    cur2 = axl_node_get_next(cur2);
                }	
                else if(NODE_CMP_NAME(cur2, "album_notes") ||
                                NODE_CMP_NAME (cur2, "buy") ||
                                NODE_CMP_NAME (cur2, "launchdate"))
                {
                    axl_node_remove(cur2,TRUE);
                    cur2  = axl_node_get_first_child(cur);
                } else {
                    cur2 = axl_node_get_next(cur2);
                }
            }
        }
        cur = axl_node_get_next(cur);
    }
}


void magnatune_db_download_xml_thread(gpointer data)
{
    gmpc_easy_download_struct *dld = data;

    g_mutex_lock(mt_db_lock);

    if(magnatune_xmldoc)
    {
        axl_doc_free(magnatune_xmldoc);

        magnatune_xmldoc = NULL;
    }
    g_mutex_unlock(mt_db_lock);
    if(gmpc_easy_download("http://www.magnatune.com/info/album_info.xml", dld))
    {
        g_mutex_lock(mt_db_lock);
        gchar *path = NULL;
        magnatune_xmldoc = axl_doc_parse(dld->data, dld->size, NULL);
        magnatune_cleanup_xml();
        path = gmpc_get_user_path("magnatune.xml");
        axl_doc_dump_to_file(magnatune_xmldoc, path); 
        g_free(path);
        g_mutex_unlock(mt_db_lock);
    }
    else 
    {
        g_mutex_lock(mt_db_lock);
        /* update */
        gchar *path = gmpc_get_user_path("magnatune.xml");
        if(g_file_test(path, G_FILE_TEST_EXISTS))
        {
            magnatune_xmldoc = axl_doc_parse_from_file(path, NULL); 
        }
        g_free(path);
        g_mutex_unlock(mt_db_lock);
    }
    /**
     * cleanup
     */
    gmpc_easy_download_clean(dld);
    g_free(dld);


    
    g_idle_add(magnatune_end_download, NULL);
   
}
void magnatune_db_download_xml(ProgressCallback cb, gpointer data )
{
    gmpc_easy_download_struct *dld = g_malloc0(sizeof(*dld));
    dld->callback_data = data;
    dld->callback = cb;
    dld->max_size = -1;
    dld->data = NULL;
    dld->size = 0;
    g_thread_create(magnatune_db_download_xml_thread, dld,FALSE, NULL);

}

MpdData * magnatune_db_get_artist_list(char *wanted_genre)
{
    MpdData *list = NULL;
    axlNode *root;
    axlNode *cur;
    /** check if there is data */
    g_mutex_lock(mt_db_lock);
    if(magnatune_xmldoc == NULL || wanted_genre == NULL)
    {
        g_mutex_unlock(mt_db_lock);
        return NULL;
    }

    root = axl_doc_get_root(magnatune_xmldoc);
    cur = axl_node_get_first_child(root);
    while(cur != NULL)
    {
        axlNode *cur2;
        if(NODE_CMP_NAME(cur, "Album"))
        {
            const char *genre = NULL;
            const char *artist = NULL;
            cur2 = axl_node_get_first_child(cur);
            while(cur2 != NULL)
            {
                if(NODE_CMP_NAME(cur2, "magnatunegenres"))
                {
                    genre = axl_node_get_content(cur2,NULL);
                }
                else if(NODE_CMP_NAME(cur2, "artist"))
                {
                    artist = axl_node_get_content(cur2,NULL);
                }
                cur2 = axl_node_get_next(cur2);
            }
            if(genre && artist && strstr(genre, wanted_genre))
            {
                list = mpd_new_data_struct_append(list);
                list->type = MPD_DATA_TYPE_TAG;
                list->tag_type = MPD_TAG_ITEM_ARTIST;
                list->tag = url_decode(artist);

            }

        }
        cur = axl_node_get_next(cur);
    }
    g_mutex_unlock(mt_db_lock);
    return misc_mpddata_remove_duplicate_songs(list);
}

MpdData *magnatune_db_get_album_list(char *wanted_genre,char *wanted_artist)
{
    MpdData *list = NULL;
    axlNode *root;
    axlNode *cur;
    /** check if there is data */
    g_mutex_lock(mt_db_lock);
    if(magnatune_xmldoc == NULL || wanted_genre == NULL || wanted_artist == NULL)
    {
        g_mutex_unlock(mt_db_lock);
        return NULL;
    }

    root = axl_doc_get_root(magnatune_xmldoc);
    cur = axl_node_get_first_child(root);
    while(cur != NULL)
    {
        axlNode *cur2;
        if(NODE_CMP_NAME(cur, "Album"))
        {
            const char *genre = NULL;
            const char *album = NULL;
            const char *artist = NULL;
            cur2 = axl_node_get_first_child(cur);
            while(cur2 != NULL)
            {
                if(NODE_CMP_NAME(cur2, "magnatunegenres"))
                {
                    genre = axl_node_get_content(cur2,NULL);
                }
                else if(NODE_CMP_NAME(cur2, "artist"))
                {
                    artist = axl_node_get_content(cur2,NULL);
                }
                else if(NODE_CMP_NAME(cur2, "albumname"))
                {
                    album = axl_node_get_content(cur2,NULL);
                }
                cur2 = axl_node_get_next(cur2);
            }
            if(genre && artist&&album && strstr(genre, wanted_genre) && !strcmp(artist, wanted_artist))
            {
                list = mpd_new_data_struct_append(list);
                list->type = MPD_DATA_TYPE_TAG;
                list->tag_type = MPD_TAG_ITEM_ALBUM;
                list->tag = url_decode(album);
            }
        }
        cur = axl_node_get_next(cur);
    }
    g_mutex_unlock(mt_db_lock);
    return mpd_data_get_first(list); 
}


GList * magnatune_db_get_url_list(const char *wanted_genre,const char *wanted_artist, const char *wanted_album)
{
    GList *list = NULL;
    axlNode *root;
    axlNode *cur;
    /** check if there is data */
    g_mutex_lock(mt_db_lock);
    if(magnatune_xmldoc == NULL || wanted_genre == NULL) 
    {
        g_mutex_unlock(mt_db_lock);
        return NULL;
    }

    root = axl_doc_get_root(magnatune_xmldoc);
    cur = axl_node_get_first_child(root);
    while(cur != NULL)
    {
        axlNode *cur2;
        if(NODE_CMP_NAME(cur, "Album"))
        {
            const char *genre = NULL;
            const char *album = NULL;
            const char *artist = NULL;
            gboolean add_urls = FALSE;
            axlNode *tracks;
            cur2 = axl_node_get_first_child(cur);
            while(cur2 != NULL)
            {
                if(NODE_CMP_NAME(cur2, "magnatunegenres"))
                {
                    genre = axl_node_get_content(cur2,NULL);
                }
                else if(NODE_CMP_NAME(cur2, "artist"))
                {
                    artist = axl_node_get_content(cur2,NULL);
                }
                else if(NODE_CMP_NAME(cur2, "albumname"))
                {
                    album = axl_node_get_content(cur2,NULL);
                }
                cur2 = axl_node_get_next(cur2);
            }
            if(genre && strstr(genre, wanted_genre))
            {
                if(wanted_artist && wanted_album) {
                    if(!strcmp(wanted_artist,artist) && !strcmp(wanted_album, album)) {
                        add_urls = TRUE;
                    }
                }else if(wanted_artist) {
                    if(!strcmp(wanted_artist, artist)) {
                        add_urls = TRUE;
                    }
                } else {
                    add_urls = TRUE;
                }
            }
            if(add_urls)
            {
                cur2 = axl_node_get_first_child(cur);
                while(cur2)
                {
                    if (NODE_CMP_NAME(cur2, "Track"))
                    {
                        tracks = axl_node_get_first_child(cur2);
                        while(tracks)
                        {
                            if (NODE_CMP_NAME(tracks, "url"))
                            {
                                const char *url = axl_node_get_content(tracks,NULL);
                                list = g_list_append(list, url_decode(url));
                            }
                            tracks = axl_node_get_next(tracks);
                        }
                    }
                    cur2 = axl_node_get_next(cur2);
                }
            }
        }
        cur = axl_node_get_next(cur);
    }
    g_mutex_unlock(mt_db_lock);
    return list;
}



MpdData* magnatune_db_get_song_list(const char *wanted_genre,const char *wanted_artist, const char *wanted_album)
{
    MpdData *data = NULL;
    axlNode * root;
    axlNode * cur;
    /** check if there is data */
    g_mutex_lock(mt_db_lock);
    if(magnatune_xmldoc == NULL || wanted_genre == NULL) 
    {
        g_mutex_unlock(mt_db_lock);
        return NULL;
    }

    root = axl_doc_get_root(magnatune_xmldoc);
    cur = axl_node_get_first_child(root);
    while(cur != NULL)
    {
        axlNode * cur2;
        if(NODE_CMP_NAME(cur, (const char *)"Album"))
        {
            const char *year = NULL;
            const char *temp = NULL;
            const char *genre = NULL;
            const char *album = NULL;
            const char *artist = NULL;
 
            gboolean add_urls = FALSE;
            axlNode * tracks;
            cur2 = axl_node_get_first_child(cur);
            while(cur2 != NULL)
            {
                if(NODE_CMP_NAME(cur2, (const char *)"magnatunegenres"))
                {
                    genre = axl_node_get_content(cur2,NULL);
                }
                else if(NODE_CMP_NAME(cur2, (const char *)"artist"))
                {
                    artist = axl_node_get_content(cur2,NULL);
                }
                else if(NODE_CMP_NAME(cur2, (const char *)"albumname"))
                {
                    album = axl_node_get_content(cur2,NULL);
                }

                cur2 = axl_node_get_next(cur2);
            }
            if(genre && strstr(genre, wanted_genre))
            {
                if(wanted_artist && wanted_album) {
                    if(!strcmp(wanted_artist,artist) && !strcmp(wanted_album, album)) {
                        add_urls = TRUE;
                    }
                }else if(wanted_artist) {
                    if(!strcmp(wanted_artist, artist)) {
                        add_urls = TRUE;
                    }
                } else {
                    add_urls = TRUE;
                }
            }
        
            if(add_urls)
            {
                cur2 = axl_node_get_first_child(cur);
                while(cur2)
                {
                    if (NODE_CMP_NAME(cur2, (const char *)"Track"))
                    {
                        const char *tn = NULL;
                        int stime = 0;
                        const char *url= NULL;
                        const char  *name = NULL;

                        tracks = axl_node_get_first_child(cur2);


                        while(tracks)
                        {
                            if (NODE_CMP_NAME(tracks, (const char *)"url")&& !url)
                            {
                                url= axl_node_get_content(tracks,NULL);
                            }
                            else if (NODE_CMP_NAME(tracks, (const char *)"trackname")&& !name)
                            {
                                name = axl_node_get_content(tracks,NULL);
                            }
                      
                            else if (NODE_CMP_NAME(tracks, (const char *)"tracknum")&& !tn)
                            {
                                tn = axl_node_get_content(tracks,NULL);
                            }
                            else if (NODE_CMP_NAME(tracks, "seconds")&& !stime)
                            {
                                const char *eurl = axl_node_get_content(tracks, NULL);
                                stime = atoi(eurl);
                            }
                            else if (NODE_CMP_NAME(tracks, (const char *)"year")&& !year)
                            {
                                year = axl_node_get_content(tracks,NULL);
                            }
                            tracks = axl_node_get_next(tracks);
                        }

                        if(url){
                            data = (MpdData *)mpd_new_data_struct_append((MpdData *)data);
                            data->type = MPD_DATA_TYPE_SONG;
                            data->song = mpd_newSong();
                            data->song->file = url_decode(url);
                            data->song->title = url_decode(name);
                            data->song->album = url_decode(album);
                            data->song->artist = url_decode(artist);
                            data->song->genre = url_decode(genre);
                            data->song->date = url_decode(year);
                            data->song->track = url_decode(tn);
                            data->song->time = stime;
                        }
                    }
                    cur2 = axl_node_get_next(cur2);
                }
            }
        }
        cur = axl_node_get_next(cur);
    }
    g_mutex_unlock(mt_db_lock);
    return data;
}
