/*
 * Axl Library axl_config.h
 * Platform dependant definitions.
 *
 * This is a generated file.  Please modify 'configure.in'
 */

#ifndef __AXL_CONFIG_H__
#define __AXL_CONFIG_H__

/**
 * \addtogroup axl_decl_module
 * @{
 */

/**
 * @brief Allows to convert integer value (including constant values)
 * into a pointer representation.
 *
 * Use the oposite function to restore the value from a pointer to a
 * integer: \ref PTR_TO_INT.
 *
 * @param integer The integer value to cast to pointer.
 *
 * @return A \ref axlPointer reference.
 */
#define INT_TO_PTR(integer)   ((axlPointer)  ((int)integer))

/**
 * @brief Allows to convert a pointer reference (\ref axlPointer),
 * which stores an integer that was stored using \ref INT_TO_PTR.
 *
 * Use the oposite function to restore the pointer value stored in the
 * integer value.
 *
 * @param ptr The pointer to cast to a integer value.
 *
 * @return A int value.
 */
#define PTR_TO_INT(ptr) ((int)  (ptr))

/**
 * @brief Allows to get current platform configuration. This is used
 * by Axl library but could be used by applications built on top of
 * Axl to change its configuration based on the platform information.
 */
#define AXL_OS_UNIX (1)

/**
 * @internal Allows to now if the platform support vasprintf
 * function. Do not use this macro as it is supposed to be for
 * internal use.
 */
#define AXL_HAVE_VASPRINTF (1)

/* @} */

#endif
