#include <stdio.h>
#include <string.h>
#include <gdk/gdkkeysyms.h>
#include <glade/glade.h>
#include <libxml/parser.h>
#include <gmpc/plugin.h>
#include <gmpc/gmpc_easy_download.h>
#include <gmpc/metadata.h>
#include <gmpc/TreeSearchWidget.h>
#include "magnatune.h"
enum {
	MAGNA_ARTIST,
	MAGNA_ALBUM,
	MAGNA_TRACK,
	MAGNA_GENRE,
	MAGNA_UP
}magnatune_row_type;
enum {
	MAGNA_FIELD_ID,
	MAGNA_FIELD_NAME,
	MAGNA_FIELD_TYPE,
	MAGNA_FIELD_PIXBUF	
} magnatune_row_field;
extern GladeXML *pl3_xml;

/**
 * Function decleration
 */
void magnatune_destroy(void);
void magnatune_selected(GtkWidget *container);
void magnatune_unselected(GtkWidget *container);
void magnatune_changed(GtkWidget *tree, GtkTreeIter *iter);
void magnatune_add(GtkWidget *cat_tree);
static void magnatune_download_xml_callback(int download, int total,gpointer data);
static void magnatune_download();
void   magnatune_mpd_status_changed(MpdObj *mi, ChangedStatusType what, void *data);
static void magnatune_logo_init();
static int magnatune_fetch_cover_priority(void);
static int magnatune_fetch_get_image(mpd_Song *song,MetaDataType type, char **path);
static int magnatune_cat_menu_popup(GtkWidget *menu, int type, GtkWidget *tree, GdkEventButton *event);

static int magnatune_button_release_event(GtkWidget *tree, GdkEventButton *event);

static void magnatune_cat_key_press(GtkWidget *tree, GdkEventKey *event, int selected_type);
static int magnatune_key_press(GtkWidget *tree, GdkEventKey *event);

static int magnatune_get_enabled()
{
	return cfg_get_single_value_as_int_with_default(config, "magnatune", "enable", TRUE);
}
static void magnatune_set_enabled(int enabled)
{
	cfg_set_single_value_as_int(config, "magnatune", "enable", enabled);
}




gmpcMetaDataPlugin magnatune_cover = {
	magnatune_fetch_cover_priority,
	magnatune_fetch_get_image
};


/* Needed plugin_wp stuff */
gmpcPlBrowserPlugin magnatune_gbp = {
	magnatune_add,
	magnatune_selected,
	magnatune_unselected,
	magnatune_changed,
	NULL,
	magnatune_cat_menu_popup,
	magnatune_cat_key_press,
	NULL,
	NULL
};

int plugin_api_version = PLUGIN_API_VERSION;

gmpcPlugin plugin = {
	"Magnatune Stream Browser",
	{0,15,0},
	GMPC_PLUGIN_PL_BROWSER|GMPC_PLUGIN_META_DATA,
	0,/* id */
	NULL,/* path */
	magnatune_logo_init,    /*init*/	
        magnatune_destroy, /* destroy */
	&magnatune_gbp,
	magnatune_mpd_status_changed, /* status */
	NULL,/* connection */
	NULL,
	&magnatune_cover,
	magnatune_get_enabled,
	magnatune_set_enabled
};


/* Playlist window row reference */
static GtkTreeRowReference *magnatune_ref = NULL;
GtkWidget *magnatune_pb = NULL;
GtkWidget *magnatune_vbox = NULL;
GtkListStore *mt_store = NULL;
TreeSearch *mt_tree_search = NULL;

static GtkWidget *magnatune_logo=NULL;
extern GladeXML *pl3_xml;

static void magnatune_buy_album()
{
	gchar *uri = "http://www.magnatune.com/";
	gchar *path = g_strdup_printf("%s%c%s%c%s '%s'",plugin.path,G_DIR_SEPARATOR, "magnatune",G_DIR_SEPARATOR,"xdg-open",uri);
	g_spawn_command_line_async(path, NULL);
	g_free(path);
}

static void magnatune_logo_add()
{
	mpd_Song *song = mpd_playlist_get_current_song(connection);
	GtkWidget *logo, *button;
	GtkWidget *ali;
	
	magnatune_logo = gtk_hbox_new(FALSE,6);
	
	button = gtk_button_new_with_label("Buy this album\nfrom magnatune");
	gtk_button_set_relief(GTK_BUTTON(button), GTK_RELIEF_NONE);

	ali = gtk_alignment_new(0,0.5,0,1);
	gtk_container_add(GTK_CONTAINER(ali), button);
	logo = gtk_image_new_from_icon_name("magnatune", GTK_ICON_SIZE_DND);
//	gtk_box_pack_start(GTK_BOX(magnatune_logo), logo, FALSE, FALSE,0);
	gtk_button_set_image(GTK_BUTTON(button), logo);
	gtk_box_pack_start(GTK_BOX(magnatune_logo), ali, TRUE, TRUE,0);
	gtk_box_pack_end(GTK_BOX(glade_xml_get_widget(pl3_xml, "vbox5")), magnatune_logo, FALSE,FALSE,0);	
	g_signal_connect(G_OBJECT(button), "clicked", G_CALLBACK(magnatune_buy_album), NULL);
	if(song) {
		if(strstr(song->file,"magnatune.com"))
		{
			gtk_widget_show_all(magnatune_logo);
			return;
		}
	}


}

static void magnatune_logo_init()
{
	gchar *path = NULL;

	path = g_strdup_printf("%s%c%s",plugin.path,G_DIR_SEPARATOR, "magnatune");
	gtk_icon_theme_append_search_path(gtk_icon_theme_get_default (),path);
	g_free(path);

	gtk_init_add((GtkFunction )magnatune_logo_add, NULL);
	/** 
	 * init the magnatune stuff
	 */
	magnatune_db_init();
	/**
	 * open the db 
	 */
	magnatune_db_open();
}


void   magnatune_mpd_status_changed(MpdObj *mi, ChangedStatusType what, void *data)
{
	if(!magnatune_logo)
		return;
	if(what&(MPD_CST_SONGID|MPD_CST_STATE))
	{
		mpd_Song *song = mpd_playlist_get_current_song(mi);
		if(song) {
			if(strstr(song->file,"magnatune.com"))
			{
				gtk_widget_show_all(magnatune_logo);
				return;
			}
		}
		gtk_widget_hide(magnatune_logo);
	}
}

static void magnatune_get_genre_list()
{
	GList *list = NULL;
	GtkTreeIter iter;

	list = magnatune_db_get_genre_list();
	if(!list) 
		return;
	if(list && magnatune_ref )
	{
		GtkTreeModel *model = gtk_tree_row_reference_get_model(magnatune_ref);
		GtkTreePath *path = gtk_tree_row_reference_get_path(magnatune_ref);
		if(path)
		{
			if(gtk_tree_model_get_iter(model, &iter, path))
			{
				GtkTreeIter child, child2;
				GList *node = list;
				for(;node; node = g_list_next(node))
				{
					GList *node2, *list2;
					gtk_tree_store_append(GTK_TREE_STORE(model),&child, &iter);
					gtk_tree_store_set(GTK_TREE_STORE(model), &child, 
							PL3_CAT_TYPE, plugin.id,
							PL3_CAT_TITLE, (gchar *)node->data, 
							PL3_CAT_INT_ID, (gchar *)node->data,
							PL3_CAT_ICON_ID, "magnatune",
							PL3_CAT_PROC, TRUE,
							PL3_CAT_ICON_SIZE,GTK_ICON_SIZE_MENU,-1);
					list2 = magnatune_db_get_artist_list(node->data);
					for(node2 = list2;node2; node2 = g_list_next(node2))
					{
						gtk_tree_store_append(GTK_TREE_STORE(model),&child2, &child);
						gtk_tree_store_set(GTK_TREE_STORE(model), &child2, 
								PL3_CAT_TYPE, plugin.id,
								PL3_CAT_TITLE, (gchar *)node2->data, 
								PL3_CAT_INT_ID, (gchar *)node2->data,
								PL3_CAT_ICON_ID, "media-artist",
								PL3_CAT_PROC, TRUE,
								PL3_CAT_ICON_SIZE,GTK_ICON_SIZE_MENU,-1);
					}
					g_list_foreach(list2, (GFunc)g_free, NULL);
					g_list_free(list2);

				}
			}
			gtk_tree_path_free(path);
		}
	}
	g_list_foreach(list, (GFunc)g_free, NULL);
	g_list_free(list);
}

static void magnatune_cover_art_fetched(mpd_Song *song, MetaDataResult ret, char *coverpath,gpointer data)
{
	GtkTreeRowReference *ref = data;
	if(song == NULL || ref == NULL) return;
	else
	{
		GtkTreeIter iter;
		GtkTreePath *path = gtk_tree_row_reference_get_path(ref);
		GtkTreeModel *model = gtk_tree_row_reference_get_model(ref);
		if(path)
		{
			if(gtk_tree_model_get_iter(GTK_TREE_MODEL(model), &iter, path))
			{
				if(ret == META_DATA_AVAILABLE)
				{
					int size = cfg_get_single_value_as_int_with_default(config, "cover-art", "browser-size",64);
					GdkPixbuf *pb = gdk_pixbuf_new_from_file_at_size(coverpath,size,size,NULL);
					screenshot_add_border(&pb);
					gtk_list_store_set(GTK_LIST_STORE(model),&iter, MAGNA_FIELD_PIXBUF, pb, -1);
					if(pb)g_object_unref(pb);
					gtk_tree_row_reference_free(ref);
				}
				else if(ret == META_DATA_FETCHING)
				{
					int size = cfg_get_single_value_as_int_with_default(config, "cover-art", "browser-size",64);
					GdkPixbuf *pb2;
					pb2 = gtk_icon_theme_load_icon(gtk_icon_theme_get_default(), "gmpc-loading-cover", size, 0,NULL);
					gtk_list_store_set(GTK_LIST_STORE(model),&iter, MAGNA_FIELD_PIXBUF, pb2, -1);
					if(pb2)g_object_unref(pb2);
				}
				else
				{
					int size = cfg_get_single_value_as_int_with_default(config, "cover-art", "browser-size",64);
					GdkPixbuf *pb2;
					pb2 = gtk_icon_theme_load_icon(gtk_icon_theme_get_default(), "gmpc-no-cover", size, 0,NULL);
					gtk_list_store_set(GTK_LIST_STORE(model),&iter,MAGNA_FIELD_PIXBUF, pb2, -1);
					if(pb2)g_object_unref(pb2);
					gtk_tree_row_reference_free(ref);
				}
			}
			gtk_tree_path_free(path);
		}
	}

}

static void magnatune_show_album_list()
{
	GtkTreeIter citer;
	xmlNodePtr root;
	xmlNodePtr cur;
	char *wanted_genre = NULL;
	GtkTreePath *tpath = NULL;
	GtkTreeSelection *sel = gtk_tree_view_get_selection(playlist3_get_category_tree_view());
	GtkTreeModel *model = (GtkTreeModel *)playlist3_get_category_tree_store();
	int depth = 0;
	gtk_list_store_clear(mt_store);

	if(magnatune_db_has_data() == FALSE)
		return;
	if(gtk_tree_selection_get_selected(sel,&model,&citer))
	{
		gtk_tree_model_get(model, &citer, PL3_CAT_INT_ID,&wanted_genre, -1);
	} else {
		return; }
	/**
	 * Get the level we are on.
	 */
	tpath = gtk_tree_model_get_path(model, &citer);
	depth = gtk_tree_path_get_depth(tpath);
	gtk_tree_path_free(tpath);

	/**
	 * Depth 1, show genre list
	 */
	if(depth == 1)
	{
		GtkTreeIter iter;
		GList *node,*list = magnatune_db_get_genre_list();
		for(node = list; node;node = g_list_next(node))
		{
			char *escape = g_markup_escape_text(node->data,-1);
			gtk_list_store_append(mt_store, &iter);
			gtk_list_store_set(mt_store, &iter, 
					MAGNA_FIELD_ID, node->data,
					MAGNA_FIELD_NAME, escape,
					MAGNA_FIELD_TYPE, MAGNA_GENRE, 
					-1);
			g_free(escape);
		}
		g_list_foreach(list, (GFunc)g_free, NULL);
		g_list_free(list);
		return;
	}
	if(wanted_genre== NULL || wanted_genre[0] == '\0' )
	{
		return;
	}
	if(depth > 1)
	{
		GtkTreeIter iter;
		GdkPixbuf *pb =  gtk_widget_render_icon(magnatune_vbox, GTK_STOCK_GO_UP,GTK_ICON_SIZE_MENU,NULL);

		gtk_list_store_append(mt_store, &iter);
		gtk_list_store_set(mt_store, &iter, 
				MAGNA_FIELD_ID, NULL,
				MAGNA_FIELD_PIXBUF, pb,
				MAGNA_FIELD_NAME, "..",
				MAGNA_FIELD_TYPE, MAGNA_UP, 
				-1);
		g_object_unref(pb);
	}
	if(depth == 2)
	{
		GtkTreeIter iter;
		GList *node,*list = magnatune_db_get_artist_list(wanted_genre);
		for(node = list; node;node = g_list_next(node))
		{
			char *escape = g_markup_escape_text(node->data,-1);
			GtkTreePath *path2;
			GtkTreeRowReference *ref; 
			gtk_list_store_append(mt_store, &iter);
			mpd_Song *song = mpd_newSong();
			path2 = gtk_tree_model_get_path(GTK_TREE_MODEL(mt_store), &iter);	
			ref = gtk_tree_row_reference_new(GTK_TREE_MODEL(mt_store), path2);
			song->artist = g_strdup(node->data);
			gtk_list_store_set(mt_store, &iter, 
					MAGNA_FIELD_ID, node->data,
					MAGNA_FIELD_NAME, escape,
					MAGNA_FIELD_TYPE, MAGNA_ARTIST,
					-1);
			meta_data_get_path_callback(song, META_ARTIST_ART, magnatune_cover_art_fetched, ref);
			mpd_freeSong(song);	
			gtk_tree_path_free(path2);
			g_free(escape);
		}
		g_list_foreach(list, (GFunc)g_free, NULL);
		g_list_free(list);
	}
	else if(depth == 3)
	{
		GtkTreeIter piter;
		if(gtk_tree_model_iter_parent(model, &piter,&citer))
		{
			GtkTreeIter iter;
			gchar *genre = NULL;
			gtk_tree_model_get(model, &piter, PL3_CAT_INT_ID, &genre, -1);
			if(genre && wanted_genre)
			{
				GList *node,*list = magnatune_db_get_album_list(genre,wanted_genre);
				for(node = list; node;node = g_list_next(node))
				{
					char *escape = g_markup_escape_text(node->data,-1);
					GtkTreePath *path2;
					GtkTreeRowReference *ref; 
					gtk_list_store_append(mt_store, &iter);
					mpd_Song *song = mpd_newSong();
					path2 = gtk_tree_model_get_path(GTK_TREE_MODEL(mt_store), &iter);	
					ref = gtk_tree_row_reference_new(GTK_TREE_MODEL(mt_store), path2);
					song->artist = g_strdup(wanted_genre);
					song->album = g_strdup(node->data);
					gtk_list_store_set(mt_store, &iter, 
							MAGNA_FIELD_ID, node->data,
							MAGNA_FIELD_NAME, escape,
							MAGNA_FIELD_TYPE, MAGNA_ALBUM,
							-1);
					meta_data_get_path_callback(song, META_ALBUM_ART, magnatune_cover_art_fetched, ref);
					mpd_freeSong(song);	
					gtk_tree_path_free(path2);

					g_free(escape);
				}
				g_list_foreach(list, (GFunc)g_free, NULL);
				g_list_free(list);
			}
			if(genre)
				g_free(genre);
		}
	}


	g_free(wanted_genre);
}
static void magnatune_add_album_row_activated(GtkTreeView *tree, GtkTreePath *path, GtkTreeViewColumn *col, gpointer data)
{
	int depth = 0;
	GtkTreeIter iter;
	GtkTreeModel *model = gtk_tree_view_get_model(tree);
	GtkTreeSelection *sel = gtk_tree_view_get_selection(playlist3_get_category_tree_view());
	/* Category view */
	GtkTreeModel *model2 = (GtkTreeModel *)playlist3_get_category_tree_store();
	GtkTreePath *path2 = NULL;
	/** Get depth */
	if(!gtk_tree_selection_get_selected(sel,&model2,&iter)){
		return; 
	}
	path2 = gtk_tree_model_get_path(model2, &iter);
	depth = gtk_tree_path_get_depth(path2);
	gtk_tree_path_free(path2);

	/** 
	 * if on depth 1, go to level 2
	 */
	{
		GtkTreeIter child, iter_r;
		
		if(gtk_tree_model_get_iter(model, &iter_r, path))
		{
			int type;
			gtk_tree_model_get(model, &iter_r, MAGNA_FIELD_TYPE, &type, -1);
			if (type == MAGNA_ALBUM)
			{
				char *album,*artist, *genre;
				GList *list, *node;
				GtkTreeIter piter;
				if(gtk_tree_model_iter_parent(model2, &piter, &iter))
				{
					gtk_tree_model_get(model2, &piter, PL3_CAT_INT_ID, &genre,-1);
					gtk_tree_model_get(model2, &iter, PL3_CAT_INT_ID, &artist,-1);
					gtk_tree_model_get(model, &iter_r, MAGNA_FIELD_ID, &album, -1);
					list = magnatune_db_get_url_list(genre, artist,album);
					for(node = list; node; node = node->next)
					{
						mpd_playlist_queue_add(connection, node->data);
					} 
					mpd_playlist_queue_commit(connection);
					g_list_foreach(list, (GFunc)g_free, NULL);		
					g_list_free(list);
					g_free(artist);
					g_free(genre);
					g_free(album);	
				}


			}

			else if(type != MAGNA_UP)
			{
				if(gtk_tree_model_iter_children(model2,&child, &iter))
				{
					char *name = NULL, *value = NULL;
					/* Get name of underlying entry */
					gtk_tree_model_get(model, &iter_r,1, &name, -1); 

					do{
						gtk_tree_model_get(model2, &child, PL3_CAT_INT_ID, &value, -1);
						if(name && value && !strcmp(value, name))
						{
							path2 = gtk_tree_model_get_path(model2, &child);
							gtk_tree_view_expand_to_path(playlist3_get_category_tree_view(), path2);
							gtk_tree_path_free(path2);
							gtk_tree_selection_select_iter(sel, &child);

							g_free(value);
							g_free(name);
							return;
						}
						if(value)
							g_free(value);
					}while(gtk_tree_model_iter_next(model2,&child));
					/**free name */
					if(name)
						g_free(name);
				}
			}
			else{
				GtkTreeIter piter;
				if(gtk_tree_model_iter_parent(model2, &piter, &iter))
				{
					gtk_tree_selection_select_iter(sel, &piter);
				}

			}
		}
		return;
	}

}

static gboolean magnatune_search_equal_func(GtkTreeModel *model, int column, const gchar *key, GtkTreeIter *iter, gpointer data)
{
	gchar *compare = NULL;
	gtk_tree_model_get(model,iter, column, &compare, -1);
	if(compare){
		gchar *a = g_utf8_casefold(key, -1);
		gchar *b = g_utf8_casefold(compare, -1);
		if(strstr(b,a))
		{
			g_free(a);
			g_free(b);
			return FALSE;
		}
		g_free(a);
		g_free(b);
	}
	return TRUE;
}

static void magnatune_search_activate(TreeSearch *ts)
{
	GtkTreeModel *model = GTK_TREE_MODEL(mt_store);
	GtkTreeSelection *selection = gtk_tree_view_get_selection(GTK_TREE_VIEW(ts->treeview));
	if (gtk_tree_selection_count_selected_rows (selection) == 1)            
	{
		GList *list = gtk_tree_selection_get_selected_rows (selection, &model);
		magnatune_add_album_row_activated(GTK_TREE_VIEW(ts->treeview),(GtkTreePath *)list->data, NULL,NULL);	
		/* free list */
		g_list_foreach (list, (GFunc) gtk_tree_path_free, NULL);                        	
		g_list_free (list);
	}
}

static void magnatune_init()
{
	GtkWidget *tree = NULL;
	GtkWidget *sw = NULL;
	GtkCellRenderer *renderer = NULL;

	magnatune_vbox = gtk_vbox_new(FALSE,6);

	/**
	 * Create list store
	 * 1. pointer 
	 * 2. name
	 */
	mt_store = gtk_list_store_new(4, G_TYPE_STRING,G_TYPE_STRING,G_TYPE_INT,GDK_TYPE_PIXBUF);

	/**
	 * tree
	 */
	tree = gtk_tree_view_new_with_model(GTK_TREE_MODEL(mt_store));
	gtk_tree_view_set_headers_visible(GTK_TREE_VIEW(tree), FALSE);
	gtk_tree_view_set_rules_hint(GTK_TREE_VIEW(tree), TRUE);
	gtk_tree_view_set_search_column(GTK_TREE_VIEW(tree), 1);
	gtk_tree_selection_set_mode(gtk_tree_view_get_selection(GTK_TREE_VIEW(tree)), GTK_SELECTION_MULTIPLE);
	gtk_tree_view_set_search_equal_func(GTK_TREE_VIEW(tree), magnatune_search_equal_func, NULL, NULL);
	g_signal_connect(G_OBJECT(tree), "row-activated", G_CALLBACK(magnatune_add_album_row_activated), NULL);

	g_signal_connect(G_OBJECT(tree), "button-press-event", G_CALLBACK(magnatune_button_release_event), NULL);
	g_signal_connect(G_OBJECT(tree), "key-press-event", G_CALLBACK(magnatune_key_press), NULL);
		/* add columns */
	renderer = gtk_cell_renderer_pixbuf_new();
	gtk_tree_view_insert_column_with_attributes(GTK_TREE_VIEW(tree),0,("Pixbuf"), renderer,
			"pixbuf",MAGNA_FIELD_PIXBUF,
			NULL);

	gtk_tree_view_column_set_sizing(gtk_tree_view_get_column(GTK_TREE_VIEW(tree),0), GTK_TREE_VIEW_COLUMN_AUTOSIZE);

	renderer = gtk_cell_renderer_text_new();
	gtk_tree_view_insert_column_with_attributes(GTK_TREE_VIEW(tree),1,("Name"), renderer,
			"markup",1,
			NULL);

	sw = gtk_scrolled_window_new(NULL, NULL);
	gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(sw), GTK_POLICY_AUTOMATIC,GTK_POLICY_AUTOMATIC);
	gtk_scrolled_window_set_shadow_type(GTK_SCROLLED_WINDOW(sw), GTK_SHADOW_ETCHED_IN);
	gtk_container_add(GTK_CONTAINER(sw), tree);
	gtk_box_pack_start(GTK_BOX(magnatune_vbox), sw, TRUE, TRUE,0);	

	mt_tree_search = (TreeSearch *)treesearch_new(GTK_TREE_VIEW(tree), 1);
	gtk_box_pack_end(GTK_BOX(magnatune_vbox), GTK_WIDGET(mt_tree_search), FALSE, TRUE, 0);	
	g_signal_connect(G_OBJECT(mt_tree_search), "result-activate", G_CALLBACK(magnatune_search_activate),NULL);

	gtk_widget_show_all(sw);
	/**
	 * Progress Bar for the bottom 
	 */
	magnatune_pb = gtk_progress_bar_new();
	gtk_box_pack_end(GTK_BOX(magnatune_vbox), magnatune_pb, FALSE, TRUE, 0);

	g_object_ref(magnatune_vbox);


}
void magnatune_selected(GtkWidget *container)
{
	if(magnatune_vbox == NULL)
	{
		magnatune_init();
		gtk_container_add(GTK_CONTAINER(container), magnatune_vbox);
		gtk_widget_show(magnatune_vbox);
		if(!magnatune_db_has_data())
		{
			magnatune_download();
		}
		magnatune_get_genre_list();
	} else {
		gtk_container_add(GTK_CONTAINER(container), magnatune_vbox);
		gtk_widget_show(magnatune_vbox);
	}
}
void magnatune_unselected(GtkWidget *container)
{
	gtk_container_remove(GTK_CONTAINER(container), magnatune_vbox);
}

void magnatune_changed(GtkWidget *tree, GtkTreeIter *iter)
{
	magnatune_show_album_list();

}

static void magnatune_download_xml_callback(int download, int total,gpointer data)
{
	GtkWidget *pb = data;
	gchar *label = NULL;
	if(total > 0)
		gtk_progress_bar_set_fraction(GTK_PROGRESS_BAR(pb), download/(float)total);
	else
		gtk_progress_bar_pulse(GTK_PROGRESS_BAR(pb));
	if(download >> 20)
	{
		label = g_strdup_printf("%.2f mb",(download>>10)/1024.0);
	}
	else if (download>>10)
	{
		label = g_strdup_printf("%i kb",download>>10);
	}
	else
	{
		label = g_strdup_printf("%i b",download);
	}
	gtk_progress_bar_set_text(GTK_PROGRESS_BAR(pb), label);
	g_free(label);
	while(gtk_events_pending())
		gtk_main_iteration();
}

static void magnatune_download()
{
	gtk_widget_set_sensitive(glade_xml_get_widget(pl3_xml, "pl3_win"), FALSE);
	gtk_widget_show(magnatune_pb);
	magnatune_db_download_xml(magnatune_download_xml_callback, magnatune_pb);
	gtk_widget_hide(magnatune_pb);
	gtk_widget_set_sensitive(glade_xml_get_widget(pl3_xml, "pl3_win"), TRUE);
}

void magnatune_add(GtkWidget *cat_tree)
{
	GtkTreePath *path = NULL;
	GtkTreeIter iter,child;
	GtkTreeStore *pl3_tree = (GtkTreeStore *)gtk_tree_view_get_model(GTK_TREE_VIEW(cat_tree));	

	if(!cfg_get_single_value_as_int_with_default(config, "magnatune", "enable", TRUE)) return;

	gtk_tree_store_append(pl3_tree, &iter, NULL);
	gtk_tree_store_set(pl3_tree, &iter, 
			PL3_CAT_TYPE, plugin.id,
			PL3_CAT_TITLE, "Magnatune Browser",
			PL3_CAT_INT_ID, "",
			PL3_CAT_ICON_ID, "magnatune",
			PL3_CAT_PROC, TRUE,
			PL3_CAT_ICON_SIZE,GTK_ICON_SIZE_DND,-1);
	/**
	 * Clean up old row reference if it exists
	 */
	if (magnatune_ref)
	{
		gtk_tree_row_reference_free(magnatune_ref);
		magnatune_ref = NULL;
	}
	/**
	 * create row reference
	 */
	path = gtk_tree_model_get_path(GTK_TREE_MODEL(playlist3_get_category_tree_store()), &iter);
	if (path)
	{
		magnatune_ref = gtk_tree_row_reference_new(GTK_TREE_MODEL(playlist3_get_category_tree_store()), path);
		gtk_tree_path_free(path);
	}

}
static char * __magnatune_process_string(char *name)
{
	int i = 0;
	int j = 0;
	int depth = 0;
	int spaces = 0;

	/* only gonna be smaller */
	char *result = g_malloc0((strlen(name)+1+spaces*2)*sizeof(char));
	for(i=0; i < strlen(name);i++)
	{
		if(name[i] == '(' || name[i] == '[') depth++;
		else if (name[i] == ')' || name[i] == ']') depth--;
		else if(!depth)
		{
			result[j] = name[i];
			j++;
		}
	}
	for(i=j-1;i>0 && result[i] == ' ';i--)
	{
		result[i] = '\0';
	}
	return result;
}

/*** COVER STUFF */
static int magnatune_fetch_cover_priority(void){
	return cfg_get_single_value_as_int_with_default(config, "magnatune", "priority", 80);
}
static int magnatune_fetch_get_image(mpd_Song *song,MetaDataType type, char **path)
{
	int result = 0;
	if(magnatune_db_has_data() == FALSE)
		return META_DATA_UNAVAILABLE;
	if(type == META_ARTIST_ART && song->artist)
	{
		char *artist = __magnatune_process_string(song->artist);
		char *value = magnatune_db_get_value(artist,NULL,META_ARTIST_ART);
		if(value)
		{
			gmpc_easy_download_struct dld = {NULL, 0, -1, NULL,NULL};
			*path = g_strdup_printf("%s%c.covers%c%s.jpg",g_get_home_dir(), G_DIR_SEPARATOR, G_DIR_SEPARATOR, artist); 
			if(gmpc_easy_download(value, &dld))
			{
				g_file_set_contents(*path, dld.data, dld.size, NULL);
				return META_DATA_AVAILABLE;	
			}
                        gmpc_easy_download_clean(&dld);
			g_free(*path);
			*path = NULL;
		}
		g_free(artist);
	}
	else if(type == META_ALBUM_ART && song->artist && song->album)
	{
		char *artist = __magnatune_process_string(song->artist);
		char *album= __magnatune_process_string(song->album);
		char *value = magnatune_db_get_value(artist,album,META_ALBUM_ART);
		if(value)
		{
			gmpc_easy_download_struct dld = {NULL, 0, -1, NULL,NULL};
			*path = g_strdup_printf("%s%c.covers%c%s-%s.jpg",g_get_home_dir(), G_DIR_SEPARATOR, G_DIR_SEPARATOR, artist,album); 
			if(gmpc_easy_download(value, &dld))
			{
				g_file_set_contents(*path, dld.data, dld.size, NULL);
				return META_DATA_AVAILABLE;	
			}
                        gmpc_easy_download_clean(&dld);
			g_free(*path);
			*path = NULL;
		}
		g_free(artist);
	}
	return META_DATA_UNAVAILABLE; 
}	
static void magnatune_redownload_reload_db()
{
	GtkTreeIter iter;
	GtkTreeModel *model = gtk_tree_row_reference_get_model(magnatune_ref);
	GtkTreePath *path = gtk_tree_row_reference_get_path(magnatune_ref);
	if(path && gtk_tree_model_get_iter(model, &iter, path))
	{
		GtkTreeIter citer;
		while(gtk_tree_model_iter_children(model, &citer,&iter))
		{
			gtk_tree_store_remove(GTK_TREE_STORE(model), &citer);
		}
		magnatune_download();
		magnatune_get_genre_list();
		magnatune_show_album_list();
	}
	if(path)
		gtk_tree_path_free(path);
}

static void magnatune_cat_menu_add()
{
	GtkTreeIter citer;
	GtkTreeSelection *sel = gtk_tree_view_get_selection(playlist3_get_category_tree_view());
	GtkTreeModel *model = (GtkTreeModel *)playlist3_get_category_tree_store();
	GtkTreePath *tpath;
	int depth = 0;
	if(!gtk_tree_selection_get_selected(sel,&model,&citer))
	{
		return ;
	}
	/**
	 * Get the level we are on.
	 */
	tpath = gtk_tree_model_get_path(model, &citer);
	depth = gtk_tree_path_get_depth(tpath);
	gtk_tree_path_free(tpath);
	/** Genre level */
	if(depth == 2)
	{
		GList *list, *node;
		gchar *genre;
		gtk_tree_model_get(model, &citer, PL3_CAT_INT_ID,&genre, -1);
		if(genre)
		{
			list = magnatune_db_get_url_list(genre, NULL ,NULL);
			for(node = list; node; node = node->next)
			{
				mpd_playlist_queue_add(connection, node->data);
			} 
			mpd_playlist_queue_commit(connection);
			g_list_foreach(list, (GFunc)g_free, NULL);		
			g_list_free(list);
			g_free(genre);
		}
	}	
	/** Artist */
	else if(depth == 3)
	{
		gchar *artist;
		gchar *genre;
		GtkTreeIter iter;
		if(gtk_tree_model_iter_parent(model, &iter, &citer))
		{
			GList *list, *node;
			gtk_tree_model_get(model, &iter, PL3_CAT_INT_ID,&genre, -1);
			gtk_tree_model_get(model, &citer, PL3_CAT_INT_ID,&artist, -1);
			list = magnatune_db_get_url_list(genre, artist,NULL);
			for(node = list; node; node = node->next)
			{
				mpd_playlist_queue_add(connection, node->data);
			} 
			mpd_playlist_queue_commit(connection);
			g_list_foreach(list, (GFunc)g_free, NULL);		
			g_list_free(list);
			g_free(genre);
			g_free(artist);
		}
	}




}

static void magnatune_cat_menu_replace()
{
	mpd_playlist_clear(connection);
	magnatune_cat_menu_add();
	mpd_player_play(connection);

}

static int magnatune_cat_menu_popup(GtkWidget *menu, int type, GtkWidget *tree, GdkEventButton *event)
{
	GtkWidget *item;
	if(type != plugin.id) return 0;
	else
	{
		GtkTreeIter citer;
		GtkTreeSelection *sel = gtk_tree_view_get_selection(playlist3_get_category_tree_view());
		GtkTreeModel *model = (GtkTreeModel *)playlist3_get_category_tree_store();
		GtkTreePath *tpath;
		int depth = 0;
		if(!gtk_tree_selection_get_selected(sel,&model,&citer))
		{
			return 0;
		}
		/**
		 * Get the level we are on.
		 */
		tpath = gtk_tree_model_get_path(model, &citer);
		depth = gtk_tree_path_get_depth(tpath);
		gtk_tree_path_free(tpath);
		if(depth == 1)
		{
			/* add the clear widget */
			item = gtk_image_menu_item_new_from_stock(GTK_STOCK_REFRESH,NULL);
			gtk_menu_shell_append(GTK_MENU_SHELL(menu), item);
			g_signal_connect(G_OBJECT(item), "activate", G_CALLBACK(magnatune_redownload_reload_db), NULL);
			return 1;
		}
		else 
		{
			/* add the clear widget */
			item = gtk_image_menu_item_new_from_stock(GTK_STOCK_ADD,NULL);
			gtk_menu_shell_append(GTK_MENU_SHELL(menu), item);
			g_signal_connect(G_OBJECT(item), "activate", G_CALLBACK(magnatune_cat_menu_add), NULL);
			item = gtk_image_menu_item_new_with_label("Replace");
			gtk_image_menu_item_set_image(GTK_IMAGE_MENU_ITEM(item),
					gtk_image_new_from_stock(GTK_STOCK_REDO, GTK_ICON_SIZE_MENU));
			gtk_menu_shell_append(GTK_MENU_SHELL(menu), item);
			g_signal_connect(G_OBJECT(item), "activate", G_CALLBACK(magnatune_cat_menu_replace), NULL);
			return 2;
		}
	}
	return 0;
}

static void magnatune_add_selected(GtkWidget *button, GtkTreeView *tree)
{
	GtkTreeModel *model = GTK_TREE_MODEL(mt_store);
	GtkTreeSelection *sel = gtk_tree_view_get_selection(GTK_TREE_VIEW(tree));
	GList *list = gtk_tree_selection_get_selected_rows(sel,&model);
	if(list)
	{
		GList *node ;
		for(node = list; node; node = g_list_next(node))
		{
			GtkTreeIter iter;
			if(gtk_tree_model_get_iter(model, &iter, node->data))
			{
				int type;
				char *value;
				gtk_tree_model_get(model, &iter, MAGNA_FIELD_TYPE, &type, MAGNA_FIELD_ID, &value, -1);
				if(type == MAGNA_GENRE)
				{
					GList *node,*list2 = magnatune_db_get_url_list(value, NULL, NULL);
					for(node = list2; node;node = node->next)
					{
						mpd_playlist_queue_add(connection, node->data);
					}
					mpd_playlist_queue_commit(connection);
					g_list_foreach(list2, (GFunc)g_free, NULL);		
					g_list_free(list2);

				}
				else if(type == MAGNA_ARTIST)
				{
					GtkTreeIter piter,citer;
					GtkTreeModel *model2 = (GtkTreeModel *)playlist3_get_category_tree_store();
					GtkTreeSelection *sel2 = gtk_tree_view_get_selection(playlist3_get_category_tree_view());
					if(gtk_tree_selection_get_selected(sel2, &model2, &citer))
					{
						if(gtk_tree_model_iter_parent(model2, &piter, &citer))
						{
							char *genre;
							gtk_tree_model_get(model2, &piter,PL3_CAT_INT_ID, &genre, -1);
							GList *node,*list2 = magnatune_db_get_url_list(genre,value, NULL);
							for(node = list2; node;node = node->next)
							{
								mpd_playlist_queue_add(connection, node->data);
							}
							mpd_playlist_queue_commit(connection);
							g_list_foreach(list2, (GFunc)g_free, NULL);		
							g_list_free(list2);
							g_free(genre);
						}
					}	
				}
				else if(type == MAGNA_ALBUM){
					GtkTreeIter piter,citer;
					GtkTreeModel *model2 = (GtkTreeModel *)playlist3_get_category_tree_store();
					GtkTreeSelection *sel2 = gtk_tree_view_get_selection(playlist3_get_category_tree_view());
					if(gtk_tree_selection_get_selected(sel2, &model2, &citer))
					{
						char *artist;
						gtk_tree_model_get(model2, &citer,PL3_CAT_INT_ID, &artist, -1);
						if(gtk_tree_model_iter_parent(model2, &piter, &citer))
						{
							char *genre= NULL;
							GList *node,*list2 = NULL;
							gtk_tree_model_get(model2, &piter,PL3_CAT_INT_ID, &genre, -1);
							list2 = magnatune_db_get_url_list(genre,artist,value);
							for(node = list2; node;node = node->next)
							{
								mpd_playlist_queue_add(connection, node->data);
							}
							mpd_playlist_queue_commit(connection);
							g_list_foreach(list2, (GFunc)g_free, NULL);		
							g_list_free(list2);
							g_free(genre);
						}
						g_free(artist);
					}	
				}
				g_free(value);
			}
		}
		g_list_foreach (list, (GFunc)gtk_tree_path_free, NULL);
		g_list_free (list);
	}
}
static void magnatune_replace_selected(GtkWidget *button , GtkTreeView *tree)
{
	mpd_playlist_clear(connection);
	magnatune_add_selected(button, tree);
	mpd_player_play(connection);

}
static int magnatune_button_release_event(GtkWidget *tree, GdkEventButton *event)
{
	if(event->button != 3) return FALSE;
	GtkWidget *item;

	GtkTreeSelection *sel = gtk_tree_view_get_selection(GTK_TREE_VIEW(tree));
	/* 
	 * show always when version 12..  or when searching in playlist.
	 */
	if(gtk_tree_selection_count_selected_rows(sel)> 0)
	{
		GtkWidget *menu = gtk_menu_new();
		GtkTreeModel *model = GTK_TREE_MODEL(mt_store);
		/* Add */
		item = gtk_image_menu_item_new_from_stock(GTK_STOCK_ADD,NULL);
		gtk_menu_shell_prepend(GTK_MENU_SHELL(menu), item);
		g_signal_connect(G_OBJECT(item), "activate", G_CALLBACK(magnatune_add_selected), tree);
		/* Replace */
		item = gtk_image_menu_item_new_with_label("Replace");
		gtk_image_menu_item_set_image(GTK_IMAGE_MENU_ITEM(item),
				gtk_image_new_from_stock(GTK_STOCK_REDO, GTK_ICON_SIZE_MENU));
		gtk_menu_shell_append(GTK_MENU_SHELL(menu), item);
		gtk_widget_show_all(menu);
		g_signal_connect(G_OBJECT(item), "activate", G_CALLBACK(magnatune_replace_selected), tree);
		gtk_menu_popup(GTK_MENU(menu), NULL, NULL,NULL, NULL, event->button, event->time);
		return TRUE;
	}
	return FALSE;
}

static void magnatune_cat_key_press(GtkWidget *tree, GdkEventKey *event, int selected_type)
{
	if(selected_type != plugin.id) return; 
	if(event->state&GDK_CONTROL_MASK && event->keyval == GDK_Insert)
	{
		magnatune_cat_menu_replace();
	}
	else if(event->keyval == GDK_Insert)
	{
		magnatune_cat_menu_add();	
	}

}

static int magnatune_key_press(GtkWidget *tree, GdkEventKey *event)
{
	if(event->state&GDK_CONTROL_MASK && event->keyval == GDK_Insert)
	{
		magnatune_replace_selected(NULL, GTK_TREE_VIEW(tree));
	}
	else if(event->keyval == GDK_Insert)
	{
		magnatune_add_selected(NULL, GTK_TREE_VIEW(tree));
	}
	else if (event->keyval == GDK_f && event->state&GDK_CONTROL_MASK)
	{
		treesearch_start(mt_tree_search);
		return TRUE;
	}
	else if((event->state&(GDK_CONTROL_MASK|GDK_MOD1_MASK)) == 0 && 
			((event->keyval >= GDK_space && event->keyval <= GDK_z)))
	{
		char data[2];
		data[0] = (char)gdk_keyval_to_unicode(event->keyval);
		data[1] = '\0';
		treesearch_start(TREESEARCH(mt_tree_search));
		gtk_entry_set_text(GTK_ENTRY(TREESEARCH(mt_tree_search)->entry),data);
		gtk_editable_set_position(GTK_EDITABLE(TREESEARCH(mt_tree_search)->entry),1);
		return TRUE;
	}
	return FALSE;
}

void magnatune_destroy(void)
{
    magnatune_db_destroy();
}

