#include <stdio.h>
#include <string.h>
#include <glib.h>
#include <libnotify/notify.h>
#include <gmpc/plugin.h>
#include <gmpc/metadata.h>
#include <gmpc/misc.h>
#include <config.h>

extern GtkStatusIcon *tray_icon2_gsi;
static NotifyNotification *not = NULL;
static guint timeout = 0;
static gulong data_changed = 0;
static void libnotify_update_cover(GmpcMetaWatcher *gmv, mpd_Song *song, MetaDataType type, MetaDataResult ret, char *path, gpointer data);

static void libnotify_plugin_destroy(void)
{
	if(timeout)
		g_source_remove(timeout);
	timeout = 0;
	if(not)
		notify_notification_close(not,NULL);
    if(data_changed) {
        g_signal_handler_disconnect(G_OBJECT(gmw), data_changed);
        data_changed = 0;
    }
    not = NULL;
}
static void libnotify_plugin_init(void)
{
	notify_init("gmpc");
	data_changed = g_signal_connect(G_OBJECT(gmw), "data-changed", G_CALLBACK(libnotify_update_cover), NULL);
}

static void libnotify_update_cover(GmpcMetaWatcher *gmv, mpd_Song *song, MetaDataType type, MetaDataResult ret, char *path, gpointer data)
{
	mpd_Song  *song2;
	if(!not) return;

	song2 = g_object_get_data(G_OBJECT(not), "mpd-song");
	if(!song2 || type != META_ALBUM_ART || !gmpc_meta_watcher_match_data(META_ALBUM_ART, song2, song))
		return;

	if(ret == META_DATA_AVAILABLE) {
		GdkPixbuf *pb = gdk_pixbuf_new_from_file_at_scale(path,64,64,TRUE,NULL);
		/* Default to gmpc icon when no icon is found */
		if(!pb) {
			pb = gtk_icon_theme_load_icon(gtk_icon_theme_get_default(),"gmpc" , 64, 0,NULL);
			if(!pb) return; /* should never happen, bail out */
		}
		screenshot_add_border(&pb);
		notify_notification_set_icon_from_pixbuf(not, pb);
		g_object_unref(pb);
		if(!notify_notification_show(not, NULL))printf("crap\n");
	} else if (ret == META_DATA_FETCHING) {
		GdkPixbuf *pb = gtk_icon_theme_load_icon(gtk_icon_theme_get_default(),"gmpc-loading-cover" , 64, 0,NULL);
		/* Default to gmpc icon when no icon is found */
		if(!pb) {
			pb = gtk_icon_theme_load_icon(gtk_icon_theme_get_default(),"gmpc" , 64, 0,NULL);
			if(!pb) return; /* should never happen, bail out */
		}
		notify_notification_set_icon_from_pixbuf(not, pb);
		g_object_unref(pb);
		if(!notify_notification_show(not, NULL))printf("crap\n");	
	} else if (ret == META_DATA_UNAVAILABLE) {
		GdkPixbuf *pb = gtk_icon_theme_load_icon(gtk_icon_theme_get_default(),"gmpc" , 64, 0,NULL);
		/* Default to gmpc icon when no icon is found */
		if(!pb) {
			pb = gtk_icon_theme_load_icon(gtk_icon_theme_get_default(),"gmpc" , 64, 0,NULL);
			if(!pb) return; /* should never happen, bail out */
		}

		notify_notification_set_icon_from_pixbuf(not, pb);
		g_object_unref(pb);
		if(!notify_notification_show(not, NULL))printf("crap\n");	
	}
}

static int libnotify_get_enabled(void)
{
	return cfg_get_single_value_as_int_with_default(config, "libnotify-plugin", "enable", TRUE);
}
static void libnotify_set_enabled(int enabled)
{
	cfg_set_single_value_as_int(config, "libnotify-plugin", "enable", enabled);
}

static gboolean timeout_callback(gpointer data)
{
	if(not)	{
		notify_notification_close(not,NULL);
		not = NULL;
		timeout = 0;
		return FALSE;
	}
	return TRUE;
}
static void libnotify_song_changed(MpdObj *mi)
{
    int tm = 5000;
	mpd_Song *song = NULL;
	if(!cfg_get_single_value_as_int_with_default(config, "libnotify-plugin", "enable", TRUE))
		return;
	song = mpd_playlist_get_current_song(connection);
	if(song) {
        MetaDataResult ret;
        gchar *path = NULL;
		gchar buffer[1024];
		gchar *summary;

		mpd_song_markup(buffer, 1024, "%title%|%name%|%shortfile%", song);
		summary = g_strdup(buffer);
		mpd_song_markup_escaped(buffer, 1024, "[<b>Artist:</b> %artist%\n][<b>Album:</b> %album% [(%date%)]\n][<b>Genre:</b> %genre%\n]", song);
		/* if notification exists update it, else create one */
        if(not != NULL)
        {
            notify_notification_close(not, NULL);
        }
        not = notify_notification_new(summary, buffer,NULL, NULL);

		if(cfg_get_single_value_as_int_with_default(config, "libnotify-plugin", "attach-to-tray", TRUE))
			notify_notification_attach_to_status_icon(not, tray_icon2_gsi);

		g_free(summary);
		/* Add the song to the widget */
		g_object_set_data_full(G_OBJECT(not), "mpd-song", mpd_songDup(song),  (GDestroyNotify)mpd_freeSong);
		
	
		/* set timeout */
		notify_notification_set_timeout(not, NOTIFY_EXPIRES_NEVER);
		if(timeout)
			g_source_remove(timeout);
        tm = cfg_get_single_value_as_int_with_default(config, "libnotify-plugin", "timeout", 5000);        
		timeout = g_timeout_add(tm,timeout_callback, not);

		ret = gmpc_meta_watcher_get_meta_path(gmw,song, META_ALBUM_ART,&path);
		libnotify_update_cover(gmw, song, META_ALBUM_ART, ret, path, NULL);
		if(path)
			g_free(path);

		if(!notify_notification_show(not, NULL))
        {
            g_source_remove(timeout);
            timeout = 0;
            notify_notification_close(not,NULL);
            not = NULL;
        }
	}
}

/* mpd changed */
static void   libnotify_mpd_status_changed(MpdObj *mi, ChangedStatusType what, void *data)
{
	if(what&(MPD_CST_SONGID))
		libnotify_song_changed(mi);
}

int plugin_api_version = PLUGIN_API_VERSION;
/* main plugin_osd info */
gmpcPlugin plugin = {
	.name 					= "Libnotify Plugin",
	.version                = {PLUGIN_MAJOR_VERSION,PLUGIN_MINOR_VERSION,PLUGIN_MICRO_VERSION},
	.plugin_type 			= GMPC_PLUGIN_NO_GUI,
	.init 					= libnotify_plugin_init,
  	.destroy 				= libnotify_plugin_destroy,
  	.mpd_status_changed 	= &libnotify_mpd_status_changed,
  	.get_enabled 			= libnotify_get_enabled,
	.set_enabled 			= libnotify_set_enabled 
};
