#include <stdio.h>
#include <string.h>
#include <gtk/gtk.h>
#include <libxml/parser.h>
#include <libxml/tree.h>
#include <libmpd/debug_printf.h>
#include <gmpc/plugin.h>
#include <gmpc/gmpc_easy_download.h>

#define AMAZONKEY "14TC04B24356BPHXW1R2"

void init();
static char * host = "http://webservices.amazon.com/onca/xml?Service=AWSECommerceService&Operation=ItemSearch&SearchIndex=Music&ResponseGroup=Images,EditorialReview&SubscriptionId=%s&Artist=%s&%s=%s";
static char* search_types[] = {"Title", "Keywords"};
void amazon_cover_art_pref_construct(GtkWidget *container);
void amazon_cover_art_pref_destroy(GtkWidget *container);
int fetch_cover_art(mpd_Song *song, GSourceFunc function);
int fetch_cover_priority();

int fetch_metadata(mpd_Song *song,MetaDataType type, char **path);

void amazon_set_enabled(int enabled);
int amazon_get_enabled();

static GtkWidget *wp_pref_vbox = NULL;
gmpcPrefPlugin cam_pref = {
	amazon_cover_art_pref_construct,
	amazon_cover_art_pref_destroy

};
typedef struct amazon_song_info {
	char *image_big;
	char *image_medium;
	char *image_small;
	char *album_info;

}amazon_song_info;

gmpcMetaDataPlugin cam_cover = {
	fetch_cover_priority,
	fetch_metadata
};

int plugin_api_version = PLUGIN_API_VERSION;
gmpcPlugin plugin = {
	"Amazon Cover Fetcher",
	{0,15,0},
	GMPC_PLUGIN_META_DATA,
	0,
	NULL, /* path  */
	init, /* init  */
        NULL,   /* Destroy */
	NULL, /* browser */
	NULL, /* status changed */
	NULL, /* connection changed */
	&cam_pref, /* preferences */
	&cam_cover, /** Metadata */
	amazon_get_enabled,
	amazon_set_enabled
};

/* what does this do? */
char * __cover_art_process_string(char *name)
{
	int i = 0;
	int j = 0;
	int depth = 0;
	int length = 0;
	char *result, *result2;
	/* only gonna be smaller */
	char *norm = NULL;
	norm = g_utf8_normalize(name, -1, G_NORMALIZE_ALL);
//	result2 = g_convert_with_fallback(norm, -1, "ISO8859-15", "utf-8", "",NULL,NULL,NULL);
	result2 = g_malloc0(strlen(norm)+2);
	if(norm)
	{
		gchar *normal;
		gchar *p;
		gunichar c;
		j=0;
		p = norm;
		c = g_utf8_get_char(norm);
		while(c) {
			switch(g_unichar_type(c)) {
				case G_UNICODE_COMBINING_MARK:
				case G_UNICODE_ENCLOSING_MARK:
				case G_UNICODE_NON_SPACING_MARK:
					break;
				default:
					switch(c) {
						case 0x00df:
							snprintf(&result2[j],3,"ss");
							j+=2;
							break;
						case 0x00c6:
							snprintf(&result2[j],3,"AE");
							j+=2;
							break;
						case 0x00e6:
							snprintf(&result2[j],3,"ae");
							j+=2;
							break;
						case 0x0152:
							snprintf(&result2[j],3,"OE");
							j+=2;
							break;
						case 0x0153:
							snprintf(&result2[j],3,"oe");
							j+=2;
							break;
						case 0x00d0:
						case 0x0110:
							snprintf(&result2[j],2,"D");
							j+=1;
							break;
						case 0x00f0:
						case 0x0111:
							snprintf(&result2[j],2,"d");
							j+=1;
							break;
						case 0x0126:
							snprintf(&result2[j],2,"H");
							j+=1;
							break;
						case 0x0127:
							snprintf(&result2[j],2,"h");
							j+=1;
							break;
						case 0x0131:
							snprintf(&result2[j],2,"i");
							j+=1;
							break;
						case 0x0138:
							snprintf(&result2[j],2,"k");
							j+=1;
							break;
						case 0x013f:
						case 0x0141:
							snprintf(&result2[j],2,"L");
							j+=1;
							break;
						case 0x0140:
						case 0x0142:
							snprintf(&result2[j],2,"l");
							j+=1;
							break;
						case 0x014a:
							snprintf(&result2[j],2,"N");
							j+=1;
							break;
						case 0x0149:
						case 0x014b:
							snprintf(&result2[j],2,"n");
							j+=1;
							break;
						case 0x00d8:
							snprintf(&result2[j],2,"O");
							j+=1;
							break;
						case 0x00f8:
							snprintf(&result2[j],2,"o");
							j+=1;
							break;
						case 0x017f:
							snprintf(&result2[j],2,"s");
							j+=1;
							break;
						case 0x00de:
						case 0x0166:
							snprintf(&result2[j],2,"T");
							j+=1;
							break;
						case 0x00fe:
						case 0x0167:
							snprintf(&result2[j],2,"t");
							j+=1;
							break;
						default:
							if (c >= 0 && c <= 0x80) {
								snprintf(&result2[j],2,"%c", c);
								j++;
							}
							break;
					}
					break;
			}
			p = g_utf8_next_char(p);
			c = g_utf8_get_char(p);
			if(j>strlen(norm))
			{
				printf("string to large\n");
			}
		}
	}

	g_free(norm);
	length = strlen(name);
	for(i=0; i<strlen(name);i++)
	{
		if(!(name[i] >= 'a' && name[i] <= 'z') &&
				!(name[i] >= 'A' && name[i] <= 'Z') &&
				!(name[i] >= '0' && name[i] <= '9'))
		{
			length+=2;
		}

	}
	/** allocate */
	/** TODO do this somewhere else */
	result = g_malloc0((length+1)*sizeof(char));
	j=0;
	depth = 0;
	for(i=0; i < strlen(result2);i++) {
		if(result2[i] == '(' || result2[i] == '[' || result2[i] == '{')
		{
			depth++;
		}
		else if(result2[i] == ')' || result2[i] == ']' || result2[i] == '}') {
			depth--;
		}
		else if(depth >0)
		{
			/* do nothing */
		}
		else if(!(result2[i] >= 'a' && result2[i] <= 'z') &&
				!(result2[i] >= 'A' && result2[i] <= 'Z') &&
				!(result2[i] >= '0' && result2[i] <= '9')) {
			snprintf(&result[j],4,"%%%02X", result2[i]);
			j+=3;
		} else {
			result[j] = result2[i];
			j++;
		}
	}
	g_free(result2);

	return result;
}

/**
 * Get Set enabled
 */
int amazon_get_enabled()
{
	return cfg_get_single_value_as_int_with_default(config, "cover-amazon", "enable", TRUE);
}
void amazon_set_enabled(int enabled)
{
	cfg_set_single_value_as_int(config, "cover-amazon", "enable", enabled);
}

void init()
{
	char *file = g_strdup_printf("%s/.covers/",g_get_home_dir());
	if(!g_file_test(file,G_FILE_TEST_EXISTS))
	{
		g_mkdir(file, 0755);
	}
	g_free(file);
}

int fetch_cover_priority(){
	return cfg_get_single_value_as_int_with_default(config, "cover-amazon", "priority", 80);

}

int fetch_metadata(mpd_Song *song,MetaDataType type, char **path)
{
	int j=2;
	gchar *url;

	if(song->artist == NULL || song->album == NULL)
	{
		return META_DATA_UNAVAILABLE;
	}
	if(type != META_ALBUM_ART && type != META_ALBUM_TXT) {
		return META_DATA_UNAVAILABLE;
	}
	
	gchar *artist = __cover_art_process_string(song->artist);
	gchar *album =  __cover_art_process_string(song->album);

	if(type == META_ALBUM_TXT)
		url = g_strdup_printf("%s/.covers/%s-%s.albuminfo", g_get_home_dir(), artist, album);
	else url = g_strdup_printf("%s/.covers/%s-%s.jpg", g_get_home_dir(), artist, album);

	/* need to loop twice, but only fetch once */
	while(j) {
		/* need to test in case it has been downloaded by the other type */
		if(g_file_test(url, G_FILE_TEST_EXISTS)) {
			*path = url;
			g_free(artist);
			g_free(album); 		
			return META_DATA_AVAILABLE;
		}

		/* trying to get info */
		if(--j) {
			fetch_cover_art(song, NULL);
		}
	}
	g_free(url);
	g_free(artist);
	g_free(album); 	

	if(*path)
		g_free(*path);
	return META_DATA_UNAVAILABLE; 
}	

amazon_song_info * amazon_song_info_new()
{
	amazon_song_info *asi = g_malloc(sizeof(amazon_song_info));
	asi->image_big = NULL;
	asi->image_medium = NULL;
	asi->image_small = NULL;
	asi->album_info = NULL;
	return asi;
}
void amazon_song_info_free(amazon_song_info *asi)
{
	if(asi->image_big != NULL) g_free(asi->image_big);
	if(asi->image_medium != NULL) g_free(asi->image_medium);
	if(asi->image_small != NULL) g_free(asi->image_small);
	if(asi->album_info != NULL) g_free(asi->album_info);
	g_free(asi);
	return;
}

xmlNodePtr get_first_node_by_name(xmlNodePtr xml, gchar *name) {
	if(xml) {
		xmlNodePtr c = xml->xmlChildrenNode;
		for(;c;c=c->next) {
			if(xmlStrEqual(c->name, (xmlChar *) name))
				return c;
		}
	}
	return NULL;
}

amazon_song_info *__cover_art_xml_get_image(char *data,int size)
{
	xmlDocPtr doc = xmlParseMemory(data,size);
	if(doc)
	{
		xmlNodePtr root = xmlDocGetRootElement(doc);
		xmlNodePtr cur = get_first_node_by_name(root, "Items");
		amazon_song_info *asi = NULL; 
		if(cur) {
			cur = get_first_node_by_name(cur, "Item");
			if(cur) {
				xmlNodePtr child = NULL;
				asi = amazon_song_info_new();
				if(child = get_first_node_by_name(cur, "LargeImage")) {
					xmlChar *temp = xmlNodeGetContent(get_first_node_by_name(child, "URL")); 
					/* copy it, so we can free it, and don't need xmlFree */
					asi->image_big = g_strdup((char *)temp);
					xmlFree(temp);
				}
				if(child = get_first_node_by_name(cur, "MediumImage")){
					xmlChar *temp = xmlNodeGetContent(get_first_node_by_name(child, "URL"));
					asi->image_medium = g_strdup((char *)temp);
					xmlFree(temp);
				}
				if(child = get_first_node_by_name(cur, "SmallImage")){
					xmlChar *temp = xmlNodeGetContent(get_first_node_by_name(child, "URL"));
					asi->image_small = g_strdup((char *)temp);
					xmlFree(temp);
				}	

				if (child = get_first_node_by_name(cur, "EditorialReviews")) { 
					child = get_first_node_by_name(child, "EditorialReview");
					if(child) {
						xmlChar *temp = xmlNodeGetContent(get_first_node_by_name(child, "Content")); /* ugy, lazy */
						asi->album_info = g_strdup((char *)temp);
						xmlFree(temp);
					}
				}
			}
		}
		xmlFreeDoc(doc);
		return asi;
	}
	xmlCleanupParser();
	return NULL;
}


int __fetch_metadata_amazon(char *stype, char *nartist, char *nalbum)
{

	gmpc_easy_download_struct data= {NULL, 0,-1, NULL, NULL};
	int found = 0;
	char furl[1024];

	//printf("search-type: %s\n", stype);
	snprintf(furl,1024, host, AMAZONKEY, nartist, stype, nalbum);
	if(gmpc_easy_download(furl, &data))
	{
		amazon_song_info *asi = __cover_art_xml_get_image(data.data, data.size);
		gmpc_easy_download_clean(&data);
		if(asi) 
		{
			gmpc_easy_download(asi->image_big, &data);
			if(data.size <= 900){
				gmpc_easy_download_clean(&data);
				gmpc_easy_download(asi->image_medium, &data);
				if(data.size <= 900){
					gmpc_easy_download_clean(&data);
					gmpc_easy_download(asi->image_small, &data);
					if(data.size <= 900)
					{
						gmpc_easy_download_clean(&data);
					}
				}
			}
			if(data.size){
				int i =0;
				FILE *fp = NULL;
				char *imgpath = NULL;
				imgpath = g_strdup_printf("%s/.covers/%s-%s.jpg",
						g_get_home_dir(),nartist,nalbum);
				fp = fopen(imgpath, "wb");
				if(fp)
				{
					fwrite(data.data, sizeof(char), data.size,fp);
					fclose(fp);
				}
				g_free(imgpath);
				if(asi->album_info)
				{
					imgpath = g_strdup_printf("%s/.covers/%s-%s.albuminfo",
							g_get_home_dir(),nartist,nalbum);


					fp = fopen(imgpath, "w");
					if(fp)
					{
						int j=0,depth=0;;
						/**
						 * Quick 'n Dirty html stripper
						 */
						for(j=0; j < strlen(asi->album_info);j++)
						{
							if((asi->album_info)[j]	 == '<') depth++;
							else if((asi->album_info)[j] == '>' && depth) depth--;
							else if(depth == 0)
							{
								fputc((asi->album_info)[j],fp);
							}
						}
						fclose(fp);
					}

					g_free(imgpath);
				}

				gmpc_easy_download_clean(&data);
				found = 1;
			}
			amazon_song_info_free(asi);
		}

	}

	return found;
}
int fetch_cover_art(mpd_Song *song, GSourceFunc function)
{
	int retval=0,i=0;
	gchar *artist = __cover_art_process_string(song->artist);
	gchar *album =  __cover_art_process_string(song->album);

	while(!retval&&i<2)
		retval = __fetch_metadata_amazon(search_types[i++], artist, album);

	g_free(artist);
	g_free(album);
	return retval;
}

/**
 * Preferences
 */

void amazon_cover_art_enable_toggle(GtkWidget *wid)
{
	int kk = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(wid));
	cfg_set_single_value_as_int(config, "cover-amazon", "enable", kk);
}
void amazon_cover_art_pref_destroy(GtkWidget *container)
{
	gtk_container_remove(GTK_CONTAINER(container), wp_pref_vbox);
}

void amazon_cover_art_pref_construct(GtkWidget *container)
{
	GtkWidget *enable_cg = gtk_check_button_new_with_mnemonic("_Enable amazon as cover art source");
	GtkWidget *label = NULL;
	GtkWidget *entry = NULL;
	wp_pref_vbox = gtk_vbox_new(FALSE,6);

	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(enable_cg), 	
			cfg_get_single_value_as_int_with_default(config, "cover-amazon", "enable", TRUE));

	g_signal_connect(G_OBJECT(enable_cg), "toggled", G_CALLBACK(amazon_cover_art_enable_toggle), NULL);
	gtk_box_pack_start(GTK_BOX(wp_pref_vbox), enable_cg, FALSE, FALSE, 0);
	gtk_container_add(GTK_CONTAINER(container), wp_pref_vbox);
	gtk_widget_show_all(container);
}
