/* Generated by GOB (v2.0.14)   (do not edit directly) */

/* End world hunger, donate to the World Food Programme, http://www.wfp.org */

#define GOB_VERSION_MAJOR 2
#define GOB_VERSION_MINOR 0
#define GOB_VERSION_PATCHLEVEL 14

#define selfp (self->_priv)

#include <string.h> /* memset() */

#include "gmpc-metaimage.h"

#include "gmpc-metaimage-private.h"

#ifdef G_LIKELY
#define ___GOB_LIKELY(expr) G_LIKELY(expr)
#define ___GOB_UNLIKELY(expr) G_UNLIKELY(expr)
#else /* ! G_LIKELY */
#define ___GOB_LIKELY(expr) (expr)
#define ___GOB_UNLIKELY(expr) (expr)
#endif /* G_LIKELY */
/* self casting macros */
#define SELF(x) GMPC_METAIMAGE(x)
#define SELF_CONST(x) GMPC_METAIMAGE_CONST(x)
#define IS_SELF(x) GMPC_IS_METAIMAGE(x)
#define TYPE_SELF GMPC_TYPE_METAIMAGE
#define SELF_CLASS(x) GMPC_METAIMAGE_CLASS(x)

#define SELF_GET_CLASS(x) GMPC_METAIMAGE_GET_CLASS(x)

/* self typedefs */
typedef GmpcMetaImage Self;
typedef GmpcMetaImageClass SelfClass;

/* here are local prototypes */
static void ___object_set_property (GObject *object, guint property_id, const GValue *value, GParamSpec *pspec);
static void ___object_get_property (GObject *object, guint property_id, GValue *value, GParamSpec *pspec);
static void gmpc_metaimage_class_init (GmpcMetaImageClass * c) G_GNUC_UNUSED;
static void gmpc_metaimage_init (GmpcMetaImage * self) G_GNUC_UNUSED;
static void ___14_gmpc_metaimage_finalize (GObject * obj) G_GNUC_UNUSED;
static void gmpc_metaimage_meta_callback (mpd_Song * song, MetaDataResult ret, char * path, gpointer data) G_GNUC_UNUSED;
static void ___real_gmpc_metaimage_image_changed (GmpcMetaImage * self, int type);

/*
 * Signal connection wrapper macro shortcuts
 */
#define self_connect__image_changed(object,func,data)	gmpc_metaimage_connect__image_changed((object),(func),(data))
#define self_connect_after__image_changed(object,func,data)	gmpc_metaimage_connect_after__image_changed((object),(func),(data))
#define self_connect_data__image_changed(object,func,data,destroy_data,flags)	gmpc_metaimage_connect_data__image_changed((object),(func),(data),(destroy_data),(flags))

typedef void  (*___Sig1) (GmpcMetaImage *, gint , gpointer);

static void
___marshal_Sig1 (GClosure *closure,
	GValue *return_value G_GNUC_UNUSED,
	guint n_param_values,
	const GValue *param_values,
	gpointer invocation_hint G_GNUC_UNUSED,
	gpointer marshal_data)
{
	register ___Sig1 callback;
	register GCClosure *cc = (GCClosure*) closure;
	register gpointer data1, data2;

	g_return_if_fail (n_param_values == 2);

	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = g_value_peek_pointer (param_values + 0);
	} else {
		data1 = g_value_peek_pointer (param_values + 0);
		data2 = closure->data;
	}

	callback = (___Sig1) (marshal_data != NULL ? marshal_data : cc->callback);

	callback ((GmpcMetaImage *)data1,
		(gint ) g_value_get_int (param_values + 1),
		data2);
}


enum {
	IMAGE_CHANGED_SIGNAL,
	LAST_SIGNAL
};

enum {
	PROP_0,
	PROP_LOADING_COVER_ICON,
	PROP_NO_COVER_ICON,
	PROP_IMAGE_TYPE,
	PROP_SIZE,
	PROP_HIDE_ON_NA,
	PROP_CONNECTION,
	PROP_DRAW_BORDER,
	PROP_DRAW_SHADOW,
	PROP_SQUARED
};

static guint object_signals[LAST_SIGNAL] = {0};

/* pointer to the class of our parent */
static GtkEventBoxClass *parent_class = NULL;

/* Short form macros */
#define self_get_loading_cover_icon gmpc_metaimage_get_loading_cover_icon
#define self_set_loading_cover_icon gmpc_metaimage_set_loading_cover_icon
#define self_get_no_cover_icon gmpc_metaimage_get_no_cover_icon
#define self_set_no_cover_icon gmpc_metaimage_set_no_cover_icon
#define self_get_image_type gmpc_metaimage_get_image_type
#define self_set_image_type gmpc_metaimage_set_image_type
#define self_get_size gmpc_metaimage_get_size
#define self_set_size gmpc_metaimage_set_size
#define self_get_hide_on_na gmpc_metaimage_get_hide_on_na
#define self_set_hide_on_na gmpc_metaimage_set_hide_on_na
#define self_get_connection gmpc_metaimage_get_connection
#define self_set_connection gmpc_metaimage_set_connection
#define self_get_draw_border gmpc_metaimage_get_draw_border
#define self_set_draw_border gmpc_metaimage_set_draw_border
#define self_get_draw_shadow gmpc_metaimage_get_draw_shadow
#define self_set_draw_shadow gmpc_metaimage_set_draw_shadow
#define self_get_squared gmpc_metaimage_get_squared
#define self_set_squared gmpc_metaimage_set_squared
#define self_new gmpc_metaimage_new
#define self_update_cover gmpc_metaimage_update_cover
#define self_connection_changed gmpc_metaimage_connection_changed
#define self_update_cover_from_song gmpc_metaimage_update_cover_from_song
#define self_meta_callback gmpc_metaimage_meta_callback
#define self_set_cover_na gmpc_metaimage_set_cover_na
#define self_set_cover_fetching gmpc_metaimage_set_cover_fetching
#define self_image_changed gmpc_metaimage_image_changed
#define self_set_cover_from_path gmpc_metaimage_set_cover_from_path
#define self_set_is_visible gmpc_metaimage_set_is_visible
#define self_get_is_visible gmpc_metaimage_get_is_visible
GType
gmpc_metaimage_get_type (void)
{
	static GType type = 0;

	if ___GOB_UNLIKELY(type == 0) {
		static const GTypeInfo info = {
			sizeof (GmpcMetaImageClass),
			(GBaseInitFunc) NULL,
			(GBaseFinalizeFunc) NULL,
			(GClassInitFunc) gmpc_metaimage_class_init,
			(GClassFinalizeFunc) NULL,
			NULL /* class_data */,
			sizeof (GmpcMetaImage),
			0 /* n_preallocs */,
			(GInstanceInitFunc) gmpc_metaimage_init,
			NULL
		};

		type = g_type_register_static (GTK_TYPE_EVENT_BOX, "GmpcMetaImage", &info, (GTypeFlags)0);
	}

	return type;
}

/* a macro for creating a new object of our type */
#define GET_NEW ((GmpcMetaImage *)g_object_new(gmpc_metaimage_get_type(), NULL))

/* a function for creating a new object of our type */
#include <stdarg.h>
static GmpcMetaImage * GET_NEW_VARG (const char *first, ...) G_GNUC_UNUSED;
static GmpcMetaImage *
GET_NEW_VARG (const char *first, ...)
{
	GmpcMetaImage *ret;
	va_list ap;
	va_start (ap, first);
	ret = (GmpcMetaImage *)g_object_new_valist (gmpc_metaimage_get_type (), first, ap);
	va_end (ap);
	return ret;
}


static void
___finalize(GObject *obj_self)
{
#define __GOB_FUNCTION__ "Gmpc:MetaImage::finalize"
	GmpcMetaImage *self G_GNUC_UNUSED = GMPC_METAIMAGE (obj_self);
	gpointer priv G_GNUC_UNUSED = self->_priv;
#line 111 "gmpc-metaimage.gob"
	___14_gmpc_metaimage_finalize(obj_self);
#line 190 "gmpc-metaimage.c"
#line 15 "gmpc-metaimage.gob"
	if(self->_priv->song) { mpd_freeSong ((gpointer) self->_priv->song); self->_priv->song = NULL; }
#line 193 "gmpc-metaimage.c"
#line 25 "gmpc-metaimage.gob"
	if(self->no_cover_icon) { g_free ((gpointer) self->no_cover_icon); self->no_cover_icon = NULL; }
#line 196 "gmpc-metaimage.c"
#line 26 "gmpc-metaimage.gob"
	if(self->loading_cover_icon) { g_free ((gpointer) self->loading_cover_icon); self->loading_cover_icon = NULL; }
#line 199 "gmpc-metaimage.c"
}
#undef __GOB_FUNCTION__

static void 
gmpc_metaimage_class_init (GmpcMetaImageClass * c G_GNUC_UNUSED)
{
#define __GOB_FUNCTION__ "Gmpc:MetaImage::class_init"
	GObjectClass *g_object_class G_GNUC_UNUSED = (GObjectClass*) c;

	g_type_class_add_private(c,sizeof(GmpcMetaImagePrivate));

	parent_class = g_type_class_ref (GTK_TYPE_EVENT_BOX);

	object_signals[IMAGE_CHANGED_SIGNAL] =
		g_signal_new ("image_changed",
			G_TYPE_FROM_CLASS (g_object_class),
			(GSignalFlags)(G_SIGNAL_RUN_LAST | G_SIGNAL_ACTION),
			G_STRUCT_OFFSET (GmpcMetaImageClass, image_changed),
			NULL, NULL,
			___marshal_Sig1,
			G_TYPE_NONE, 1,
			G_TYPE_INT);
	if ___GOB_UNLIKELY(sizeof(int ) != sizeof(gint ) || parent_class == NULL /* avoid warning */) {
		g_error("gmpc-metaimage.gob line 296: Type mismatch of \"image_changed\" signal signature");
	}

#line 111 "gmpc-metaimage.gob"
	g_object_class->finalize = ___finalize;
#line 296 "gmpc-metaimage.gob"
	c->image_changed = ___real_gmpc_metaimage_image_changed;
#line 230 "gmpc-metaimage.c"
	g_object_class->get_property = ___object_get_property;
	g_object_class->set_property = ___object_set_property;
    {
	GParamSpec   *param_spec;

	param_spec = g_param_spec_string
		("loading_cover_icon" /* name */,
		 _("Loading Cover Icon") /* nick */,
		 _("Stock icon to use when loading a cover") /* blurb */,
		 "media-loading-cover" /* default_value */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (g_object_class,
		PROP_LOADING_COVER_ICON,
		param_spec);
	param_spec = g_param_spec_string
		("no_cover_icon" /* name */,
		 _("No Cover Icon") /* nick */,
		 _("Stock icon to use when no cover is present") /* blurb */,
		 "media-no-cover" /* default_value */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (g_object_class,
		PROP_NO_COVER_ICON,
		param_spec);
	param_spec = g_param_spec_int
		("image_type" /* name */,
		 _("Image type") /* nick */,
		 _("Type of the image, like artist art") /* blurb */,
		 G_MININT /* minimum */,
		 G_MAXINT /* maximum */,
		 META_ALBUM_ART /* default_value */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (g_object_class,
		PROP_IMAGE_TYPE,
		param_spec);
	param_spec = g_param_spec_int
		("size" /* name */,
		 _("Size") /* nick */,
		 _("Size of the image") /* blurb */,
		 G_MININT /* minimum */,
		 G_MAXINT /* maximum */,
		 64 /* default_value */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (g_object_class,
		PROP_SIZE,
		param_spec);
	param_spec = g_param_spec_boolean
		("hide_on_na" /* name */,
		 _("HideOnNA") /* nick */,
		 _("Hide the image when not availibe") /* blurb */,
		 FALSE /* default_value */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (g_object_class,
		PROP_HIDE_ON_NA,
		param_spec);
	param_spec = g_param_spec_pointer
		("connection" /* name */,
		 _("Connection") /* nick */,
		 _("A mpdObj to check on") /* blurb */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (g_object_class,
		PROP_CONNECTION,
		param_spec);
	param_spec = g_param_spec_boolean
		("draw_border" /* name */,
		 _("DrawBorder") /* nick */,
		 _("Draw a border around the image") /* blurb */,
		 TRUE /* default_value */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (g_object_class,
		PROP_DRAW_BORDER,
		param_spec);
	param_spec = g_param_spec_boolean
		("draw_shadow" /* name */,
		 _("DrawShadow") /* nick */,
		 _("Draw a shadow under the image") /* blurb */,
		 FALSE /* default_value */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (g_object_class,
		PROP_DRAW_SHADOW,
		param_spec);
	param_spec = g_param_spec_boolean
		("squared" /* name */,
		 "Squared" /* nick */,
		 "Keep the widget squared" /* blurb */,
		 TRUE /* default_value */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (g_object_class,
		PROP_SQUARED,
		param_spec);
    }
}
#undef __GOB_FUNCTION__
#line 94 "gmpc-metaimage.gob"
static void 
gmpc_metaimage_init (GmpcMetaImage * self G_GNUC_UNUSED)
#line 326 "gmpc-metaimage.c"
{
#define __GOB_FUNCTION__ "Gmpc:MetaImage::init"
	self->_priv = G_TYPE_INSTANCE_GET_PRIVATE(self,GMPC_TYPE_METAIMAGE,GmpcMetaImagePrivate);
#line 12 "gmpc-metaimage.gob"
	self->_priv->status_signal = 0;
#line 332 "gmpc-metaimage.c"
#line 13 "gmpc-metaimage.gob"
	self->_priv->connect_signal = 0;
#line 335 "gmpc-metaimage.c"
#line 14 "gmpc-metaimage.gob"
	self->_priv->meta_id = 0;
#line 338 "gmpc-metaimage.c"
#line 15 "gmpc-metaimage.gob"
	self->_priv->song = NULL;
#line 341 "gmpc-metaimage.c"
#line 18 "gmpc-metaimage.gob"
	self->size = 64;
#line 344 "gmpc-metaimage.c"
#line 19 "gmpc-metaimage.gob"
	self->image_type = META_ALBUM_ART;
#line 347 "gmpc-metaimage.c"
#line 20 "gmpc-metaimage.gob"
	self->connection = NULL;
#line 350 "gmpc-metaimage.c"
#line 21 "gmpc-metaimage.gob"
	self->hide_on_na = FALSE;
#line 353 "gmpc-metaimage.c"
#line 22 "gmpc-metaimage.gob"
	self->draw_border = TRUE;
#line 356 "gmpc-metaimage.c"
#line 23 "gmpc-metaimage.gob"
	self->draw_shadow = FALSE;
#line 359 "gmpc-metaimage.c"
#line 24 "gmpc-metaimage.gob"
	self->squared = TRUE;
#line 362 "gmpc-metaimage.c"
#line 25 "gmpc-metaimage.gob"
	self->no_cover_icon = g_strdup("media-no-cover");
#line 365 "gmpc-metaimage.c"
#line 26 "gmpc-metaimage.gob"
	self->loading_cover_icon = g_strdup("media-loading-cover");
#line 368 "gmpc-metaimage.c"
#line 31 "gmpc-metaimage.gob"
	self->is_visible = TRUE;
#line 371 "gmpc-metaimage.c"
#line 93 "gmpc-metaimage.gob"
	self->_priv->image =  gtk_image_new();
#line 374 "gmpc-metaimage.c"
 {
#line 95 "gmpc-metaimage.gob"

		gtk_event_box_set_visible_window(GTK_EVENT_BOX(self), FALSE);
		gtk_container_add(GTK_CONTAINER(self), self->_priv->image);		
		gtk_container_set_resize_mode(GTK_CONTAINER(self), GTK_RESIZE_IMMEDIATE);
		gtk_widget_show_all(GTK_WIDGET(self));
		self_set_cover_na(self);
		self->_priv->status_signal = g_signal_connect_swapped(G_OBJECT(gmpcconn), "status_changed",
				G_CALLBACK(self_update_cover), G_OBJECT(self));
		self->_priv->connect_signal = g_signal_connect_swapped(G_OBJECT(gmpcconn), "connection_changed",
				G_CALLBACK(self_connection_changed), G_OBJECT(self));                            		


		self->_priv->meta_id =  0;
		gtk_widget_set_no_show_all(GTK_WIDGET(self),TRUE);
	
#line 392 "gmpc-metaimage.c"
 }
}
#undef __GOB_FUNCTION__

static void
___object_set_property (GObject *object,
	guint property_id,
	const GValue *VAL G_GNUC_UNUSED,
	GParamSpec *pspec G_GNUC_UNUSED)
#define __GOB_FUNCTION__ "Gmpc:MetaImage::set_property"
{
	GmpcMetaImage *self G_GNUC_UNUSED;

	self = GMPC_METAIMAGE (object);

	switch (property_id) {
	case PROP_LOADING_COVER_ICON:
		{
#line 33 "gmpc-metaimage.gob"
{ char *old = self->loading_cover_icon; self->loading_cover_icon = g_value_dup_string (VAL); g_free (old); }
#line 413 "gmpc-metaimage.c"
		}
		break;
	case PROP_NO_COVER_ICON:
		{
#line 42 "gmpc-metaimage.gob"
{ char *old = self->no_cover_icon; self->no_cover_icon = g_value_dup_string (VAL); g_free (old); }
#line 420 "gmpc-metaimage.c"
		}
		break;
	case PROP_IMAGE_TYPE:
		{
#line 48 "gmpc-metaimage.gob"
self->image_type = g_value_get_int (VAL);
#line 427 "gmpc-metaimage.c"
		}
		break;
	case PROP_SIZE:
		{
#line 55 "gmpc-metaimage.gob"
self->size = g_value_get_int (VAL);
#line 434 "gmpc-metaimage.c"
		}
		break;
	case PROP_HIDE_ON_NA:
		{
#line 62 "gmpc-metaimage.gob"
self->hide_on_na = g_value_get_boolean (VAL);
#line 441 "gmpc-metaimage.c"
		}
		break;
	case PROP_CONNECTION:
		{
#line 68 "gmpc-metaimage.gob"
self->connection = g_value_get_pointer (VAL);
#line 448 "gmpc-metaimage.c"
		}
		break;
	case PROP_DRAW_BORDER:
		{
#line 74 "gmpc-metaimage.gob"
self->draw_border = g_value_get_boolean (VAL);
#line 455 "gmpc-metaimage.c"
		}
		break;
	case PROP_DRAW_SHADOW:
		{
#line 80 "gmpc-metaimage.gob"
self->draw_shadow = g_value_get_boolean (VAL);
#line 462 "gmpc-metaimage.c"
		}
		break;
	case PROP_SQUARED:
		{
#line 86 "gmpc-metaimage.gob"
self->squared = g_value_get_boolean (VAL);
#line 469 "gmpc-metaimage.c"
		}
		break;
	default:
/* Apparently in g++ this is needed, glib is b0rk */
#ifndef __PRETTY_FUNCTION__
#  undef G_STRLOC
#  define G_STRLOC	__FILE__ ":" G_STRINGIFY (__LINE__)
#endif
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}
#undef __GOB_FUNCTION__

static void
___object_get_property (GObject *object,
	guint property_id,
	GValue *VAL G_GNUC_UNUSED,
	GParamSpec *pspec G_GNUC_UNUSED)
#define __GOB_FUNCTION__ "Gmpc:MetaImage::get_property"
{
	GmpcMetaImage *self G_GNUC_UNUSED;

	self = GMPC_METAIMAGE (object);

	switch (property_id) {
	case PROP_LOADING_COVER_ICON:
		{
#line 33 "gmpc-metaimage.gob"
g_value_set_string (VAL, self->loading_cover_icon);
#line 500 "gmpc-metaimage.c"
		}
		break;
	case PROP_NO_COVER_ICON:
		{
#line 42 "gmpc-metaimage.gob"
g_value_set_string (VAL, self->no_cover_icon);
#line 507 "gmpc-metaimage.c"
		}
		break;
	case PROP_IMAGE_TYPE:
		{
#line 48 "gmpc-metaimage.gob"
g_value_set_int (VAL, self->image_type);
#line 514 "gmpc-metaimage.c"
		}
		break;
	case PROP_SIZE:
		{
#line 55 "gmpc-metaimage.gob"
g_value_set_int (VAL, self->size);
#line 521 "gmpc-metaimage.c"
		}
		break;
	case PROP_HIDE_ON_NA:
		{
#line 62 "gmpc-metaimage.gob"
g_value_set_boolean (VAL, self->hide_on_na);
#line 528 "gmpc-metaimage.c"
		}
		break;
	case PROP_CONNECTION:
		{
#line 68 "gmpc-metaimage.gob"
g_value_set_pointer (VAL, self->connection);
#line 535 "gmpc-metaimage.c"
		}
		break;
	case PROP_DRAW_BORDER:
		{
#line 74 "gmpc-metaimage.gob"
g_value_set_boolean (VAL, self->draw_border);
#line 542 "gmpc-metaimage.c"
		}
		break;
	case PROP_DRAW_SHADOW:
		{
#line 80 "gmpc-metaimage.gob"
g_value_set_boolean (VAL, self->draw_shadow);
#line 549 "gmpc-metaimage.c"
		}
		break;
	case PROP_SQUARED:
		{
#line 86 "gmpc-metaimage.gob"
g_value_set_boolean (VAL, self->squared);
#line 556 "gmpc-metaimage.c"
		}
		break;
	default:
/* Apparently in g++ this is needed, glib is b0rk */
#ifndef __PRETTY_FUNCTION__
#  undef G_STRLOC
#  define G_STRLOC	__FILE__ ":" G_STRINGIFY (__LINE__)
#endif
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}
#undef __GOB_FUNCTION__


#line 33 "gmpc-metaimage.gob"
gchar * 
gmpc_metaimage_get_loading_cover_icon (GmpcMetaImage * self)
#line 575 "gmpc-metaimage.c"
{
#define __GOB_FUNCTION__ "Gmpc:MetaImage::get_loading_cover_icon"
{
#line 33 "gmpc-metaimage.gob"
		gchar* val; g_object_get (G_OBJECT (self), "loading_cover_icon", &val, NULL); return val;
}}
#line 582 "gmpc-metaimage.c"
#undef __GOB_FUNCTION__

#line 33 "gmpc-metaimage.gob"
void 
gmpc_metaimage_set_loading_cover_icon (GmpcMetaImage * self, gchar * val)
#line 588 "gmpc-metaimage.c"
{
#define __GOB_FUNCTION__ "Gmpc:MetaImage::set_loading_cover_icon"
{
#line 33 "gmpc-metaimage.gob"
		g_object_set (G_OBJECT (self), "loading_cover_icon", val, NULL);
}}
#line 595 "gmpc-metaimage.c"
#undef __GOB_FUNCTION__

#line 42 "gmpc-metaimage.gob"
gchar * 
gmpc_metaimage_get_no_cover_icon (GmpcMetaImage * self)
#line 601 "gmpc-metaimage.c"
{
#define __GOB_FUNCTION__ "Gmpc:MetaImage::get_no_cover_icon"
{
#line 42 "gmpc-metaimage.gob"
		gchar* val; g_object_get (G_OBJECT (self), "no_cover_icon", &val, NULL); return val;
}}
#line 608 "gmpc-metaimage.c"
#undef __GOB_FUNCTION__

#line 42 "gmpc-metaimage.gob"
void 
gmpc_metaimage_set_no_cover_icon (GmpcMetaImage * self, gchar * val)
#line 614 "gmpc-metaimage.c"
{
#define __GOB_FUNCTION__ "Gmpc:MetaImage::set_no_cover_icon"
{
#line 42 "gmpc-metaimage.gob"
		g_object_set (G_OBJECT (self), "no_cover_icon", val, NULL);
}}
#line 621 "gmpc-metaimage.c"
#undef __GOB_FUNCTION__

#line 48 "gmpc-metaimage.gob"
gint 
gmpc_metaimage_get_image_type (GmpcMetaImage * self)
#line 627 "gmpc-metaimage.c"
{
#define __GOB_FUNCTION__ "Gmpc:MetaImage::get_image_type"
{
#line 48 "gmpc-metaimage.gob"
		gint val; g_object_get (G_OBJECT (self), "image_type", &val, NULL); return val;
}}
#line 634 "gmpc-metaimage.c"
#undef __GOB_FUNCTION__

#line 48 "gmpc-metaimage.gob"
void 
gmpc_metaimage_set_image_type (GmpcMetaImage * self, gint val)
#line 640 "gmpc-metaimage.c"
{
#define __GOB_FUNCTION__ "Gmpc:MetaImage::set_image_type"
{
#line 48 "gmpc-metaimage.gob"
		g_object_set (G_OBJECT (self), "image_type", val, NULL);
}}
#line 647 "gmpc-metaimage.c"
#undef __GOB_FUNCTION__

#line 55 "gmpc-metaimage.gob"
gint 
gmpc_metaimage_get_size (GmpcMetaImage * self)
#line 653 "gmpc-metaimage.c"
{
#define __GOB_FUNCTION__ "Gmpc:MetaImage::get_size"
{
#line 55 "gmpc-metaimage.gob"
		gint val; g_object_get (G_OBJECT (self), "size", &val, NULL); return val;
}}
#line 660 "gmpc-metaimage.c"
#undef __GOB_FUNCTION__

#line 55 "gmpc-metaimage.gob"
void 
gmpc_metaimage_set_size (GmpcMetaImage * self, gint val)
#line 666 "gmpc-metaimage.c"
{
#define __GOB_FUNCTION__ "Gmpc:MetaImage::set_size"
{
#line 55 "gmpc-metaimage.gob"
		g_object_set (G_OBJECT (self), "size", val, NULL);
}}
#line 673 "gmpc-metaimage.c"
#undef __GOB_FUNCTION__

#line 62 "gmpc-metaimage.gob"
gboolean 
gmpc_metaimage_get_hide_on_na (GmpcMetaImage * self)
#line 679 "gmpc-metaimage.c"
{
#define __GOB_FUNCTION__ "Gmpc:MetaImage::get_hide_on_na"
{
#line 62 "gmpc-metaimage.gob"
		gboolean val; g_object_get (G_OBJECT (self), "hide_on_na", &val, NULL); return val;
}}
#line 686 "gmpc-metaimage.c"
#undef __GOB_FUNCTION__

#line 62 "gmpc-metaimage.gob"
void 
gmpc_metaimage_set_hide_on_na (GmpcMetaImage * self, gboolean val)
#line 692 "gmpc-metaimage.c"
{
#define __GOB_FUNCTION__ "Gmpc:MetaImage::set_hide_on_na"
{
#line 62 "gmpc-metaimage.gob"
		g_object_set (G_OBJECT (self), "hide_on_na", val, NULL);
}}
#line 699 "gmpc-metaimage.c"
#undef __GOB_FUNCTION__

#line 68 "gmpc-metaimage.gob"
gpointer 
gmpc_metaimage_get_connection (GmpcMetaImage * self)
#line 705 "gmpc-metaimage.c"
{
#define __GOB_FUNCTION__ "Gmpc:MetaImage::get_connection"
{
#line 68 "gmpc-metaimage.gob"
		gpointer val; g_object_get (G_OBJECT (self), "connection", &val, NULL); return val;
}}
#line 712 "gmpc-metaimage.c"
#undef __GOB_FUNCTION__

#line 68 "gmpc-metaimage.gob"
void 
gmpc_metaimage_set_connection (GmpcMetaImage * self, gpointer val)
#line 718 "gmpc-metaimage.c"
{
#define __GOB_FUNCTION__ "Gmpc:MetaImage::set_connection"
{
#line 68 "gmpc-metaimage.gob"
		g_object_set (G_OBJECT (self), "connection", val, NULL);
}}
#line 725 "gmpc-metaimage.c"
#undef __GOB_FUNCTION__

#line 74 "gmpc-metaimage.gob"
gboolean 
gmpc_metaimage_get_draw_border (GmpcMetaImage * self)
#line 731 "gmpc-metaimage.c"
{
#define __GOB_FUNCTION__ "Gmpc:MetaImage::get_draw_border"
{
#line 74 "gmpc-metaimage.gob"
		gboolean val; g_object_get (G_OBJECT (self), "draw_border", &val, NULL); return val;
}}
#line 738 "gmpc-metaimage.c"
#undef __GOB_FUNCTION__

#line 74 "gmpc-metaimage.gob"
void 
gmpc_metaimage_set_draw_border (GmpcMetaImage * self, gboolean val)
#line 744 "gmpc-metaimage.c"
{
#define __GOB_FUNCTION__ "Gmpc:MetaImage::set_draw_border"
{
#line 74 "gmpc-metaimage.gob"
		g_object_set (G_OBJECT (self), "draw_border", val, NULL);
}}
#line 751 "gmpc-metaimage.c"
#undef __GOB_FUNCTION__

#line 80 "gmpc-metaimage.gob"
gboolean 
gmpc_metaimage_get_draw_shadow (GmpcMetaImage * self)
#line 757 "gmpc-metaimage.c"
{
#define __GOB_FUNCTION__ "Gmpc:MetaImage::get_draw_shadow"
{
#line 80 "gmpc-metaimage.gob"
		gboolean val; g_object_get (G_OBJECT (self), "draw_shadow", &val, NULL); return val;
}}
#line 764 "gmpc-metaimage.c"
#undef __GOB_FUNCTION__

#line 80 "gmpc-metaimage.gob"
void 
gmpc_metaimage_set_draw_shadow (GmpcMetaImage * self, gboolean val)
#line 770 "gmpc-metaimage.c"
{
#define __GOB_FUNCTION__ "Gmpc:MetaImage::set_draw_shadow"
{
#line 80 "gmpc-metaimage.gob"
		g_object_set (G_OBJECT (self), "draw_shadow", val, NULL);
}}
#line 777 "gmpc-metaimage.c"
#undef __GOB_FUNCTION__

#line 86 "gmpc-metaimage.gob"
gboolean 
gmpc_metaimage_get_squared (GmpcMetaImage * self)
#line 783 "gmpc-metaimage.c"
{
#define __GOB_FUNCTION__ "Gmpc:MetaImage::get_squared"
{
#line 86 "gmpc-metaimage.gob"
		gboolean val; g_object_get (G_OBJECT (self), "squared", &val, NULL); return val;
}}
#line 790 "gmpc-metaimage.c"
#undef __GOB_FUNCTION__

#line 86 "gmpc-metaimage.gob"
void 
gmpc_metaimage_set_squared (GmpcMetaImage * self, gboolean val)
#line 796 "gmpc-metaimage.c"
{
#define __GOB_FUNCTION__ "Gmpc:MetaImage::set_squared"
{
#line 86 "gmpc-metaimage.gob"
		g_object_set (G_OBJECT (self), "squared", val, NULL);
}}
#line 803 "gmpc-metaimage.c"
#undef __GOB_FUNCTION__


#line 111 "gmpc-metaimage.gob"
static void 
___14_gmpc_metaimage_finalize (GObject * obj G_GNUC_UNUSED)
#line 810 "gmpc-metaimage.c"
#define PARENT_HANDLER(___obj) \
	{ if(G_OBJECT_CLASS(parent_class)->finalize) \
		(* G_OBJECT_CLASS(parent_class)->finalize)(___obj); }
{
#define __GOB_FUNCTION__ "Gmpc:MetaImage::finalize"
{
#line 114 "gmpc-metaimage.gob"
	
		Self *self = GMPC_METAIMAGE(obj); 
		if(self->_priv->meta_id)
		{
			meta_data_handle_remove_request(self->_priv->meta_id);
			self->_priv->meta_id =  0;
		}

		if(self->_priv->status_signal){
			g_signal_handler_disconnect(G_OBJECT(gmpcconn), self->_priv->status_signal);
		}
		if(self->_priv->connect_signal){
			g_signal_handler_disconnect(G_OBJECT(gmpcconn), self->_priv->connect_signal);
		}
		
	}}
#line 834 "gmpc-metaimage.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 131 "gmpc-metaimage.gob"
GtkWidget * 
gmpc_metaimage_new (int type)
#line 841 "gmpc-metaimage.c"
{
#define __GOB_FUNCTION__ "Gmpc:MetaImage::new"
{
#line 133 "gmpc-metaimage.gob"
	
		Self *gmi =  GET_NEW;
		gmi->image_type = type;
		return (GtkWidget *)gmi;
	}}
#line 851 "gmpc-metaimage.c"
#undef __GOB_FUNCTION__

#line 139 "gmpc-metaimage.gob"
void 
gmpc_metaimage_update_cover (GmpcMetaImage * self, MpdObj * mi, ChangedStatusType what, GmpcConnection * gmpcconn)
#line 857 "gmpc-metaimage.c"
{
#define __GOB_FUNCTION__ "Gmpc:MetaImage::update_cover"
#line 139 "gmpc-metaimage.gob"
	g_return_if_fail (self != NULL);
#line 139 "gmpc-metaimage.gob"
	g_return_if_fail (GMPC_IS_METAIMAGE (self));
#line 864 "gmpc-metaimage.c"
{
#line 142 "gmpc-metaimage.gob"
	
		if(self->connection && what&(MPD_CST_STATE) && self->is_visible)
		{
			int state = mpd_player_get_state(mi);
			if(state == MPD_PLAYER_STOP || state == MPD_PLAYER_UNKNOWN)
			{
				self_set_cover_na(self);
			}
			else {
				mpd_Song *song = mpd_playlist_get_current_song(mi);
				if(song)
				{
					self_update_cover_from_song(self, song);
				}
				else
				{
					self_set_cover_na(self);
				}
			}
			
		}
		else if(self->connection && what&(MPD_CST_SONGID|MPD_CST_SONGPOS|MPD_CST_PLAYLIST) && self->is_visible)
		{
			mpd_Song *song = mpd_playlist_get_current_song(mi);
			if(!song)
			{
				self_set_cover_na(self);
			}
			else
			{
				self_update_cover_from_song(self, song);
			}
		}

	}}
#line 902 "gmpc-metaimage.c"
#undef __GOB_FUNCTION__

#line 177 "gmpc-metaimage.gob"
void 
gmpc_metaimage_connection_changed (GmpcMetaImage * self, MpdObj * mi, int connect, GmpcConnection * gmpconn)
#line 908 "gmpc-metaimage.c"
{
#define __GOB_FUNCTION__ "Gmpc:MetaImage::connection_changed"
#line 177 "gmpc-metaimage.gob"
	g_return_if_fail (self != NULL);
#line 177 "gmpc-metaimage.gob"
	g_return_if_fail (GMPC_IS_METAIMAGE (self));
#line 915 "gmpc-metaimage.c"
{
#line 180 "gmpc-metaimage.gob"
	
		if(!connect)
		{
			self_set_cover_na(self);
		}

	}}
#line 925 "gmpc-metaimage.c"
#undef __GOB_FUNCTION__

#line 188 "gmpc-metaimage.gob"
void 
gmpc_metaimage_update_cover_from_song (GmpcMetaImage * self, mpd_Song * song)
#line 931 "gmpc-metaimage.c"
{
#define __GOB_FUNCTION__ "Gmpc:MetaImage::update_cover_from_song"
#line 188 "gmpc-metaimage.gob"
	g_return_if_fail (self != NULL);
#line 188 "gmpc-metaimage.gob"
	g_return_if_fail (GMPC_IS_METAIMAGE (self));
#line 938 "gmpc-metaimage.c"
{
#line 191 "gmpc-metaimage.gob"
	
		self_set_cover_na(self);
		if(self->_priv->song)
			mpd_freeSong(self->_priv->song);
		if(!song)
			return;
		if(self->_priv->status_signal)
		self->_priv->song = mpd_songDup(song);

		if(self->_priv->meta_id)
		{
			meta_data_handle_remove_request(self->_priv->meta_id);
			self->_priv->meta_id =  0;
		}
		self->_priv->meta_id = meta_data_get_path_callback(song, self->image_type, self_meta_callback, self);
			
	}}
#line 958 "gmpc-metaimage.c"
#undef __GOB_FUNCTION__

#line 209 "gmpc-metaimage.gob"
static void 
gmpc_metaimage_meta_callback (mpd_Song * song, MetaDataResult ret, char * path, gpointer data)
#line 964 "gmpc-metaimage.c"
{
#define __GOB_FUNCTION__ "Gmpc:MetaImage::meta_callback"
{
#line 212 "gmpc-metaimage.gob"
	
		Self *self = data;
		if(!song || !self || !self->_priv || !self->_priv->song)
			return;
		/**
		 * Check for fields
		 */
		if(song->artist == NULL || self->_priv->song->artist == NULL)
			return;
		if(self->image_type&META_ALBUM_ART && (song->album == NULL || self->_priv->song->album == NULL))
			return;
		/**
		 * match song
		 */
		if(strcmp(song->artist, self->_priv->song->artist))
			return;
		else if(self->image_type&META_ALBUM_ART && 
				strcmp(song->album, self->_priv->song->album))
			return;
		/**
		 * If mpd is stopped before the result is back, set the cover to na, and ignore the result
		 */
		else if(self->connection && mpd_player_get_state(self->connection) == MPD_PLAYER_STOP)
		{
			self_set_cover_na(self);
			if(ret != META_DATA_FETCHING)
			{
				self->_priv->meta_id = 0;
			}

		}
		else
		{
			if(ret == META_DATA_AVAILABLE) {
				self_set_cover_from_path(self,path); 
				self->_priv->meta_id = 0;
			} else if (ret == META_DATA_FETCHING) {
				self_set_cover_fetching(self);
			} else {
				self_set_cover_na(self);
				self->_priv->meta_id = 0;
			}
		}
	}}
#line 1013 "gmpc-metaimage.c"
#undef __GOB_FUNCTION__

#line 258 "gmpc-metaimage.gob"
void 
gmpc_metaimage_set_cover_na (GmpcMetaImage * self)
#line 1019 "gmpc-metaimage.c"
{
#define __GOB_FUNCTION__ "Gmpc:MetaImage::set_cover_na"
#line 258 "gmpc-metaimage.gob"
	g_return_if_fail (self != NULL);
#line 258 "gmpc-metaimage.gob"
	g_return_if_fail (GMPC_IS_METAIMAGE (self));
#line 1026 "gmpc-metaimage.c"
{
#line 261 "gmpc-metaimage.gob"
	
		GdkPixbuf *pb,*pb2; 
		if(self->hide_on_na)
		{		
			gtk_widget_hide(GTK_WIDGET(self));
			return;
		}
		pb = gtk_widget_render_icon(GTK_WIDGET(self), self->no_cover_icon, -1, NULL);
		pb2=gdk_pixbuf_scale_simple(pb, self->size, self->size, GDK_INTERP_BILINEAR);
		gtk_image_set_from_pixbuf(GTK_IMAGE(self->_priv->image), pb2);
		if(self->squared)
			gtk_widget_set_size_request(GTK_WIDGET(self), self->size, self->size);
		g_object_unref(pb);
		g_object_unref(pb2);
		self_image_changed(self,META_DATA_UNAVAILABLE);
	}}
#line 1045 "gmpc-metaimage.c"
#undef __GOB_FUNCTION__

#line 277 "gmpc-metaimage.gob"
void 
gmpc_metaimage_set_cover_fetching (GmpcMetaImage * self)
#line 1051 "gmpc-metaimage.c"
{
#define __GOB_FUNCTION__ "Gmpc:MetaImage::set_cover_fetching"
#line 277 "gmpc-metaimage.gob"
	g_return_if_fail (self != NULL);
#line 277 "gmpc-metaimage.gob"
	g_return_if_fail (GMPC_IS_METAIMAGE (self));
#line 1058 "gmpc-metaimage.c"
{
#line 280 "gmpc-metaimage.gob"
	
		GdkPixbuf *pb,*pb2; 
		if(self->hide_on_na)
		{		
			gtk_widget_hide(GTK_WIDGET(self));
		}
		pb = gtk_widget_render_icon(GTK_WIDGET(self), self->loading_cover_icon, -1, NULL);
		pb2=gdk_pixbuf_scale_simple(pb, self->size, self->size, GDK_INTERP_BILINEAR);
		gtk_image_set_from_pixbuf(GTK_IMAGE(self->_priv->image), pb2);
		if(self->squared)
			gtk_widget_set_size_request(GTK_WIDGET(self), self->size, self->size);
		g_object_unref(pb);
		g_object_unref(pb2);
		self_image_changed(self,META_DATA_FETCHING);
	}}
#line 1076 "gmpc-metaimage.c"
#undef __GOB_FUNCTION__

#line 296 "gmpc-metaimage.gob"
void 
gmpc_metaimage_image_changed (GmpcMetaImage * self, int type)
#line 1082 "gmpc-metaimage.c"
{
	GValue ___param_values[2];
	GValue ___return_val;

memset (&___return_val, 0, sizeof (___return_val));
memset (&___param_values, 0, sizeof (___param_values));

#line 296 "gmpc-metaimage.gob"
	g_return_if_fail (self != NULL);
#line 296 "gmpc-metaimage.gob"
	g_return_if_fail (GMPC_IS_METAIMAGE (self));
#line 1094 "gmpc-metaimage.c"

	___param_values[0].g_type = 0;
	g_value_init (&___param_values[0], G_TYPE_FROM_INSTANCE (self));
	g_value_set_instance (&___param_values[0], (gpointer) self);

	___param_values[1].g_type = 0;
	g_value_init (&___param_values[1], G_TYPE_INT);
	g_value_set_int (&___param_values[1], (gint ) type);

	g_signal_emitv (___param_values,
		object_signals[IMAGE_CHANGED_SIGNAL],
		0 /* detail */,
		&___return_val);

	g_value_unset (&___param_values[0]);
	g_value_unset (&___param_values[1]);
}
#line 296 "gmpc-metaimage.gob"
static void 
___real_gmpc_metaimage_image_changed (GmpcMetaImage * self G_GNUC_UNUSED, int type)
#line 1115 "gmpc-metaimage.c"
{
#define __GOB_FUNCTION__ "Gmpc:MetaImage::image_changed"
{
#line 299 "gmpc-metaimage.gob"
	
		/* do nothing */
	}}
#line 1123 "gmpc-metaimage.c"
#undef __GOB_FUNCTION__

#line 303 "gmpc-metaimage.gob"
void 
gmpc_metaimage_set_cover_from_path (GmpcMetaImage * self, gchar * path)
#line 1129 "gmpc-metaimage.c"
{
#define __GOB_FUNCTION__ "Gmpc:MetaImage::set_cover_from_path"
#line 303 "gmpc-metaimage.gob"
	g_return_if_fail (self != NULL);
#line 303 "gmpc-metaimage.gob"
	g_return_if_fail (GMPC_IS_METAIMAGE (self));
#line 1136 "gmpc-metaimage.c"
{
#line 306 "gmpc-metaimage.gob"
	
		GdkPixbuf *pb = NULL;
		pb = gdk_pixbuf_new_from_file_at_scale(path,self->size-self->draw_shadow*18-2,self->size-self->draw_shadow*18-2,TRUE,NULL);
		if(pb)
		{
			int width = 0; 
			int height = 0;

			if(self->draw_border)
				screenshot_add_border(&pb);	
			if(self->draw_shadow)
				screenshot_add_shadow(&pb);
			/** 
			 * Need to get pixbuf height/width before adding to image
			 * if added to image, somehow the returned values don't match anymore
			 */
			width = gdk_pixbuf_get_width(pb);			
			height = gdk_pixbuf_get_height(pb);
			gtk_image_set_from_pixbuf(GTK_IMAGE(self->_priv->image),pb);
			/**
			 * Set sizing, also set size on non-squared, so the widget resizes propperly
			 */
			if(self->squared)
			{
				gtk_widget_set_size_request(GTK_WIDGET(self), self->size, self->size);
			}
			else
			{
				gtk_widget_set_size_request(GTK_WIDGET(self), width+2, height+2);
			}
			g_object_unref(pb);
		}
		if(self->is_visible)
		{
			gtk_widget_show(GTK_WIDGET(self));
		}
		self_image_changed(self,META_DATA_AVAILABLE);
	}}
#line 1177 "gmpc-metaimage.c"
#undef __GOB_FUNCTION__

#line 345 "gmpc-metaimage.gob"
void 
gmpc_metaimage_set_is_visible (GmpcMetaImage * self, gboolean is_visible)
#line 1183 "gmpc-metaimage.c"
{
#define __GOB_FUNCTION__ "Gmpc:MetaImage::set_is_visible"
#line 345 "gmpc-metaimage.gob"
	g_return_if_fail (self != NULL);
#line 345 "gmpc-metaimage.gob"
	g_return_if_fail (GMPC_IS_METAIMAGE (self));
#line 1190 "gmpc-metaimage.c"
{
#line 348 "gmpc-metaimage.gob"
	
		self->is_visible = is_visible;
		if(self->is_visible)
		{
			if(self->connection)
			{
				self_update_cover(self,self->connection, MPD_CST_STATE, NULL);
			}
			
		} 
		else
		{
			gtk_widget_hide(GTK_WIDGET(self));
		}
	}}
#line 1208 "gmpc-metaimage.c"
#undef __GOB_FUNCTION__

#line 363 "gmpc-metaimage.gob"
gboolean 
gmpc_metaimage_get_is_visible (GmpcMetaImage * self)
#line 1214 "gmpc-metaimage.c"
{
#define __GOB_FUNCTION__ "Gmpc:MetaImage::get_is_visible"
#line 363 "gmpc-metaimage.gob"
	g_return_val_if_fail (self != NULL, (gboolean )0);
#line 363 "gmpc-metaimage.gob"
	g_return_val_if_fail (GMPC_IS_METAIMAGE (self), (gboolean )0);
#line 1221 "gmpc-metaimage.c"
{
#line 365 "gmpc-metaimage.gob"
	
		return self->is_visible;
	}}
#line 1227 "gmpc-metaimage.c"
#undef __GOB_FUNCTION__
