// Pac-Man clone SDLGlutton
// Version 0.0.3
// Phoenix Kokido 


/* Library Header Includes */

#include <stdlib.h>
#include <stdio.h>
#include <time.h>
#include <math.h>

#include "SDL.h"

#include "RS_gfx.h"

#if defined(PLAY_MOD)
#include "SDL_mixer.h"
#endif

/***************************/


/* Defines ****************/

#define FRAMES_PER_SEC 16


/* Ghost States */

#define NIL 0
#define DEAD 1
#define SPAWN 2
#define ATTACK 3
#define RETREAT 4


/* Game defines */

#define NEW_GAME 0
#define CONTINUE 1
#define LEVEL_CLEAR 2
#define END_GAME 3
#define SHOW_TITLE 4
#define QUIT 5
#define CUSTOM 6

/***************************/



/* Structures **************/

typedef struct {
  int x, y;
} camera;

typedef struct {
  int x, y, dir, newdir;
  int state;
  int counter;
  int count2;
  int lives;
  int score;
  int frame;
} sprite;

/***************************/


/* Gobal Variable Defines **/

sprite s_pac;
sprite s_ghost[4];
sprite s_fruit;

camera c;

int grid[32][32];
int f=0;
int cur_level=0;
int fullscreenflag=0;
int custom=0;

char *levels[3] = { "levels/1.map","levels/2.map","levels/3.map"};

char *musics[2] = { "glutton.it", "glutton.it"};

SDL_Surface *logo;
SDL_Surface *screen;
SDL_Surface *pac[4][16];
SDL_Surface *ghost[4][16];
SDL_Surface *pellet;
SDL_Surface *spellet;
SDL_Surface *live;
SDL_Surface *cont;
SDL_Surface *yes;
SDL_Surface *no;
SDL_Surface *numbers[10];
SDL_Surface *block[17];
SDL_Surface *clear;
SDL_Surface *x;
SDL_Surface *level;
SDL_Surface *start;
SDL_Surface *bg;
SDL_Surface *display;

#if defined(PLAY_MOD)
Mix_Music *music;
Mix_Chunk *sounds;
Mix_Chunk *bell;
Mix_Chunk *scream;
Mix_Chunk *choir;
#endif

/**************************/

/* Functions start here */

SDL_Rect blit_score(long score);




void Wait_Frame(void)
{
  static Uint32 next_tick = 0;
  Uint32 this_tick;

  /* Wait for the next frame */
  this_tick = SDL_GetTicks(); 

  if ( this_tick < next_tick ) {
    SDL_Delay(next_tick-this_tick);
  }

  next_tick = this_tick + (1000/FRAMES_PER_SEC);
}




int load_map(char *filename) {
  FILE *file;
  int x, y, pellets=0;
  int in;

  file=fopen(filename, "r");

    // Read from the file
    for(x=0; x<32; x++) {
      for(y=0; y<32; y++) {
	in=fgetc(file);
	if(in==EOF)in=0;
	grid[x][y]=in;
	if(grid[x][y]==1) pellets++;
      }
    }    
    fclose(file);
  return(pellets);
}




int load_data(void) {
  // This is a icky function
  int i, j;
  
  pac[0][0]=prep_image("data/eatem01.bmp");
  pac[0][1]=prep_image("data/eatem02.bmp");
  pac[0][2]=prep_image("data/eatem03.bmp");
  pac[0][3]=prep_image("data/eatem04.bmp");
  pac[0][4]=prep_image("data/eatem05.bmp");
  pac[0][5]=prep_image("data/eatem06.bmp");
  pac[0][6]=prep_image("data/eatem07.bmp");
  pac[0][7]=prep_image("data/eatem08.bmp");
  pac[0][8]=prep_image("data/eatem09.bmp");
  pac[0][9]=prep_image("data/eatem10.bmp");
  pac[0][10]=prep_image("data/eatem11.bmp");
  pac[0][11]=prep_image("data/eatem12.bmp");
  pac[0][12]=prep_image("data/eatem13.bmp");
  pac[0][13]=prep_image("data/eatem14.bmp");
  pac[0][14]=prep_image("data/eatem15.bmp");
  pac[0][15]=prep_image("data/eatem16.bmp");

  pac[2][0]=prep_image("data/eatem201.bmp");
  pac[2][1]=prep_image("data/eatem202.bmp");
  pac[2][2]=prep_image("data/eatem203.bmp");
  pac[2][3]=prep_image("data/eatem204.bmp");
  pac[2][4]=prep_image("data/eatem205.bmp");
  pac[2][5]=prep_image("data/eatem206.bmp");
  pac[2][6]=prep_image("data/eatem207.bmp");
  pac[2][7]=prep_image("data/eatem208.bmp");
  pac[2][8]=prep_image("data/eatem209.bmp");
  pac[2][9]=prep_image("data/eatem210.bmp");
  pac[2][10]=prep_image("data/eatem211.bmp");
  pac[2][11]=prep_image("data/eatem212.bmp");
  pac[2][12]=prep_image("data/eatem213.bmp");
  pac[2][13]=prep_image("data/eatem214.bmp");
  pac[2][14]=prep_image("data/eatem215.bmp");
  pac[2][15]=prep_image("data/eatem216.bmp");

  pac[3][0]=prep_image("data/eatem301.bmp");
  pac[3][1]=prep_image("data/eatem302.bmp");
  pac[3][2]=prep_image("data/eatem303.bmp");
  pac[3][3]=prep_image("data/eatem304.bmp");
  pac[3][4]=prep_image("data/eatem305.bmp");
  pac[3][5]=prep_image("data/eatem306.bmp");
  pac[3][6]=prep_image("data/eatem307.bmp");
  pac[3][7]=prep_image("data/eatem308.bmp");
  pac[3][8]=prep_image("data/eatem309.bmp");
  pac[3][9]=prep_image("data/eatem310.bmp");
  pac[3][10]=prep_image("data/eatem311.bmp");
  pac[3][11]=prep_image("data/eatem312.bmp");
  pac[3][12]=prep_image("data/eatem313.bmp");
  pac[3][13]=prep_image("data/eatem314.bmp");
  pac[3][14]=prep_image("data/eatem315.bmp");
  pac[3][15]=prep_image("data/eatem316.bmp");

  pac[1][0]=prep_image("data/eatem401.bmp");
  pac[1][1]=prep_image("data/eatem402.bmp");
  pac[1][2]=prep_image("data/eatem403.bmp");
  pac[1][3]=prep_image("data/eatem404.bmp");
  pac[1][4]=prep_image("data/eatem405.bmp");
  pac[1][5]=prep_image("data/eatem406.bmp");
  pac[1][6]=prep_image("data/eatem407.bmp");
  pac[1][7]=prep_image("data/eatem408.bmp");
  pac[1][8]=prep_image("data/eatem409.bmp");
  pac[1][9]=prep_image("data/eatem410.bmp");
  pac[1][10]=prep_image("data/eatem411.bmp");
  pac[1][11]=prep_image("data/eatem412.bmp");
  pac[1][12]=prep_image("data/eatem413.bmp");
  pac[1][13]=prep_image("data/eatem414.bmp");
  pac[1][14]=prep_image("data/eatem415.bmp");
  pac[1][15]=prep_image("data/eatem416.bmp");



  ghost[0][0]=prep_image("data/ghost01.bmp");
  ghost[0][1]=prep_image("data/ghost02.bmp");
  ghost[0][2]=prep_image("data/ghost03.bmp");
  ghost[0][3]=prep_image("data/ghost04.bmp");
  ghost[0][4]=prep_image("data/ghost05.bmp");
  ghost[0][5]=prep_image("data/ghost06.bmp");
  ghost[0][6]=prep_image("data/ghost07.bmp");
  ghost[0][7]=prep_image("data/ghost08.bmp");
  ghost[0][8]=prep_image("data/ghost09.bmp");
  ghost[0][9]=prep_image("data/ghost10.bmp");
  ghost[0][10]=prep_image("data/ghost11.bmp");
  ghost[0][11]=prep_image("data/ghost12.bmp");
  ghost[0][12]=prep_image("data/ghost13.bmp");
  ghost[0][13]=prep_image("data/ghost14.bmp");
  ghost[0][14]=prep_image("data/ghost15.bmp");
  ghost[0][15]=prep_image("data/ghost16.bmp");

  ghost[2][0]=prep_image("data/ghost201.bmp");
  ghost[2][1]=prep_image("data/ghost202.bmp");
  ghost[2][2]=prep_image("data/ghost203.bmp");
  ghost[2][3]=prep_image("data/ghost204.bmp");
  ghost[2][4]=prep_image("data/ghost205.bmp");
  ghost[2][5]=prep_image("data/ghost206.bmp");
  ghost[2][6]=prep_image("data/ghost207.bmp");
  ghost[2][7]=prep_image("data/ghost208.bmp");
  ghost[2][8]=prep_image("data/ghost209.bmp");
  ghost[2][9]=prep_image("data/ghost210.bmp");
  ghost[2][10]=prep_image("data/ghost211.bmp");
  ghost[2][11]=prep_image("data/ghost212.bmp");
  ghost[2][12]=prep_image("data/ghost213.bmp");
  ghost[2][13]=prep_image("data/ghost214.bmp");
  ghost[2][14]=prep_image("data/ghost215.bmp");
  ghost[2][15]=prep_image("data/ghost216.bmp");

  ghost[3][0]=prep_image("data/ghost301.bmp");
  ghost[3][1]=prep_image("data/ghost302.bmp");
  ghost[3][2]=prep_image("data/ghost303.bmp");
  ghost[3][3]=prep_image("data/ghost304.bmp");
  ghost[3][4]=prep_image("data/ghost305.bmp");
  ghost[3][5]=prep_image("data/ghost306.bmp");
  ghost[3][6]=prep_image("data/ghost307.bmp");
  ghost[3][7]=prep_image("data/ghost308.bmp");
  ghost[3][8]=prep_image("data/ghost309.bmp");
  ghost[3][9]=prep_image("data/ghost310.bmp");
  ghost[3][10]=prep_image("data/ghost311.bmp");
  ghost[3][11]=prep_image("data/ghost312.bmp");
  ghost[3][12]=prep_image("data/ghost313.bmp");
  ghost[3][13]=prep_image("data/ghost314.bmp");
  ghost[3][14]=prep_image("data/ghost315.bmp");
  ghost[3][15]=prep_image("data/ghost316.bmp");

  ghost[1][0]=prep_image("data/ghost401.bmp");
  ghost[1][1]=prep_image("data/ghost402.bmp");
  ghost[1][2]=prep_image("data/ghost403.bmp");
  ghost[1][3]=prep_image("data/ghost404.bmp");
  ghost[1][4]=prep_image("data/ghost405.bmp");
  ghost[1][5]=prep_image("data/ghost406.bmp");
  ghost[1][6]=prep_image("data/ghost407.bmp");
  ghost[1][7]=prep_image("data/ghost408.bmp");
  ghost[1][8]=prep_image("data/ghost409.bmp");
  ghost[1][9]=prep_image("data/ghost410.bmp");
  ghost[1][10]=prep_image("data/ghost411.bmp");
  ghost[1][11]=prep_image("data/ghost412.bmp");
  ghost[1][12]=prep_image("data/ghost413.bmp");
  ghost[1][13]=prep_image("data/ghost414.bmp");
  ghost[1][14]=prep_image("data/ghost415.bmp");
  ghost[1][15]=prep_image("data/ghost416.bmp");


  pellet=prep_image("data/pellet.bmp");
  spellet=prep_image("data/spellet.bmp");
  logo=prep_image("data/logo.bmp");
  live=prep_image("data/live.bmp");
  cont=prep_image("data/continue.bmp");
  yes=prep_image("data/yes.bmp");
  no=prep_image("data/no.bmp");
  x=prep_image("data/x.bmp");
  clear=prep_image("data/clear.bmp");
  level=prep_image("data/level.bmp");
  start=prep_image("data/start.bmp");
  bg=prep_image("data/bg.bmp");

  display=SDL_CreateRGBSurface(SDL_SWSURFACE, 64, 64, 16, screen->format->Rmask,
				screen->format->Gmask,
				screen->format->Bmask,
				screen->format->Amask);

  block[3]=prep_image("data/block3.bmp");
  block[12]=prep_image("data/block12.bmp");
  block[10]=prep_image("data/block10.bmp");
  block[16]=prep_image("data/block16.bmp");
  block[6]=prep_image("data/block6.bmp");
  block[5]=prep_image("data/block5.bmp");
  block[9]=prep_image("data/block9.bmp");

  numbers[0]=prep_image("data/0.bmp");
  numbers[1]=prep_image("data/1.bmp");
  numbers[2]=prep_image("data/2.bmp");
  numbers[3]=prep_image("data/3.bmp");
  numbers[4]=prep_image("data/4.bmp");
  numbers[5]=prep_image("data/5.bmp");
  numbers[6]=prep_image("data/6.bmp");
  numbers[7]=prep_image("data/7.bmp");
  numbers[8]=prep_image("data/8.bmp");
  numbers[9]=prep_image("data/9.bmp");


  for(i=0; i<4; i++){
    for(j=0; j<16; j++) {
	SDL_SetColorKey(pac[i][j], SDL_SRCCOLORKEY,  
		SDL_MapRGB(pac[i][j]->format, 0, 0, 0));	 
	SDL_SetColorKey(ghost[i][j], SDL_SRCCOLORKEY,  
		SDL_MapRGB(ghost[i][j]->format, 0, 0, 0));
	SDL_SetAlpha(ghost[i][j], SDL_SRCALPHA, 64);
	pac[i][j]=SDL_DisplayFormat(pac[i][j]);
	ghost[i][j]=SDL_DisplayFormat(ghost[i][j]);
    }
  }
	
  SDL_SetColorKey(pellet, SDL_SRCCOLORKEY,  
			SDL_MapRGB(pellet->format, 0, 0, 0));
	pellet=SDL_DisplayFormat(pellet);

	SDL_SetColorKey(spellet, SDL_SRCCOLORKEY,  
			SDL_MapRGB(spellet->format, 0, 0, 0));
	spellet=SDL_DisplayFormat(spellet);

	SDL_SetColorKey(logo, SDL_SRCCOLORKEY,  
			SDL_MapRGB(logo->format, 0, 0, 0));
	logo=SDL_DisplayFormat(logo);

	SDL_SetColorKey(live, SDL_SRCCOLORKEY,  
			SDL_MapRGB(live->format, 0, 0, 0));
	live=SDL_DisplayFormat(live);

	SDL_SetColorKey(cont, SDL_SRCCOLORKEY,  
			SDL_MapRGB(cont->format, 0, 0, 0));
	cont=SDL_DisplayFormat(cont);

	SDL_SetColorKey(yes, SDL_SRCCOLORKEY,  
			SDL_MapRGB(yes->format, 0, 0, 0));
	yes=SDL_DisplayFormat(yes);

	SDL_SetColorKey(no, SDL_SRCCOLORKEY,  
			SDL_MapRGB(no->format, 0, 0, 0));
	no=SDL_DisplayFormat(no);

	SDL_SetColorKey(block[3], SDL_SRCCOLORKEY,  
			SDL_MapRGB(block[3]->format, 0, 0, 0));
	block[3]=SDL_DisplayFormat(block[3]);

	SDL_SetColorKey(block[12], SDL_SRCCOLORKEY,  
			SDL_MapRGB(block[12]->format, 0, 0, 0));
	block[12]=SDL_DisplayFormat(block[12]);

	SDL_SetColorKey(block[16], SDL_SRCCOLORKEY,  
			SDL_MapRGB(block[16]->format, 0, 0, 0));
	block[16]=SDL_DisplayFormat(block[16]);

	SDL_SetColorKey(block[6], SDL_SRCCOLORKEY,  
			SDL_MapRGB(block[6]->format, 0, 0, 0));
	block[6]=SDL_DisplayFormat(block[6]);

	SDL_SetColorKey(block[10], SDL_SRCCOLORKEY,  
			SDL_MapRGB(block[10]->format, 0, 0, 0));
	block[10]=SDL_DisplayFormat(block[10]);

	SDL_SetColorKey(block[9], SDL_SRCCOLORKEY,  
			SDL_MapRGB(block[9]->format, 0, 0, 0));
	block[9]=SDL_DisplayFormat(block[9]);

	SDL_SetColorKey(block[5], SDL_SRCCOLORKEY,  
			SDL_MapRGB(block[5]->format, 0, 0, 0));
	block[5]=SDL_DisplayFormat(block[5]);

	SDL_SetColorKey(x, SDL_SRCCOLORKEY,  
			SDL_MapRGB(x->format, 0, 0, 0));
	x=SDL_DisplayFormat(x);

	SDL_SetColorKey(clear, SDL_SRCCOLORKEY,  
			SDL_MapRGB(clear->format, 0, 0, 0));
	clear=SDL_DisplayFormat(clear);

	SDL_SetColorKey(level, SDL_SRCCOLORKEY,  
			SDL_MapRGB(level->format, 0, 0, 0));
	level=SDL_DisplayFormat(level);

	SDL_SetColorKey(start, SDL_SRCCOLORKEY,  
			SDL_MapRGB(start->format, 0, 0, 0));
	start=SDL_DisplayFormat(start);

	bg=SDL_DisplayFormat(bg);

	SDL_SetAlpha(display, SDL_SRCALPHA, 96);
	display=SDL_DisplayFormat(display);


	for(i=0; i<10; i++) {
	  SDL_SetColorKey(numbers[i], SDL_SRCCOLORKEY,  
			  SDL_MapRGB(numbers[i]->format, 0, 0, 0));
	  numbers[i]=SDL_DisplayFormat(numbers[i]);
	}


#if defined(PLAY_MOD)
	sounds = Mix_LoadWAV("chime.wav");
	bell = Mix_LoadWAV("bell.wav");
	scream = Mix_LoadWAV("scream.wav");
	choir = Mix_LoadWAV("choir.wav");
#endif

  return 0;
}



void free_data(void) {
  int i,j;
  for(i=0;i<4;i++) {
    for(j=0; j<16; j++) {
      SDL_FreeSurface(pac[i][j]);
      SDL_FreeSurface(ghost[i][j]);
    }
  }
  SDL_FreeSurface(pellet);
}

void fill_bg(SDL_Surface *surf, int offx, int offy) {
  int x, y;
  SDL_Rect dst;

  for(x=0; x<11; x++) {
    for(y=0; y<8; y++) {
      dst.x=x*64-offx;
      dst.y=y*64-offy;
      dst.w=64;
      dst.h=64;
      SDL_BlitSurface(bg, NULL, surf, &dst);
      
    }
  }

}

void draw_grid_dec(int x, int y, int gx, int gy, SDL_Surface *surf) {
  int i;
  if((gx>=0)&&(gx<32)&&(gy>=0)&&(gy<32)) {
    switch(grid[gx][gy]) {
    case(0): 
      break;
    case(1):
      RS_Blit(pellet, screen, x-32, y-32);
      break;
    case(2):
      RS_Blit(spellet, screen, x-32, y-32);
      break;
    case(6):
      RS_Blit(block[3], screen, x-32, y-32);
      break;
    case(8):
      RS_Blit(block[5], screen, x-32, y-32);
      break;
    case(9):
      RS_Blit(block[6], screen, x-32, y-32);
      break;
    case(12):
      RS_Blit(block[9], screen, x-32, y-32);
      break;
    case(13):
      RS_Blit(block[10], screen, x-32, y-32);
      break;      
    case(15):
      RS_Blit(block[12], screen, x-32, y-32);
      break;
    case(19):
      RS_Blit(block[16], screen, x-32, y-32);
      break;
    default:
      DrawLine(x-32 ,y    ,x    ,y-32 ,0xff, 0,0, screen);
      DrawLine(x    ,y-32 ,x+32 ,y    ,0xff, 0,0, screen);
      DrawLine(x+32 ,y    ,x    ,y+32 ,0xff, 0,0, screen);
      DrawLine(x    ,y+32 ,x-32 ,y    ,0xff, 0,0, screen);
      break;
    }
    if((s_pac.x==gx)&&(s_pac.y==gy))
      RS_Blit(pac[s_pac.dir][s_pac.frame%16], screen, x-32, y-32);

    for(i=0; i<4; i++) {
      if((s_ghost[i].x==gx)&&(s_ghost[i].y==gy))
	RS_Blit(ghost[s_ghost[i].dir][0], screen, x-32, y-32+f);
    }
  }


}

void draw_map(int x, int y) {
  int tx, ty;
  tx=x; ty=y;

  fill_bg(screen, 0,0);
  for(ty=0; ty<9; ty++){
    for(tx=0; tx<12; tx++) {
      draw_grid_dec(tx * 64
		    ,ty * 64 - 34
		    ,tx+ty + s_pac.x -10
		    ,ty-tx + s_pac.y +2
		    ,screen);
    }
    for(tx=0; tx<12; tx++) {
      draw_grid_dec(tx*64-32,
		    (ty*64-34)+32,
		    tx+ty + s_pac.x -10,
		    ty-tx + s_pac.y +3,
		    screen);
    }
  }
}



void draw_display(void) {
  int x, y, i;
  SDL_Rect dst;
  
  for(x=0; x<64; x++) {
    for(y=0; y<64; y++) {
      switch(grid[x/2][y/2]) {
      case(0): 
	RS_Pset16(x, y, 0, 0, 0, display);
	break;
      case(1): 
	RS_Pset16(x, y, 0x88, 0x88, 0x88, display);
	break;
      case(2):
	RS_Pset16(x, y, 0xff, 0xff, 0xff, display);
	break;
      default:
	RS_Pset16(x, y, 0xff, 0, 0, display);
      }
    }
  }

  RS_Pset16(s_pac.x*2, s_pac.y*2, 0xff, 0xff, 0, display);
  RS_Pset16(s_pac.x*2+1, s_pac.y*2, 0xff, 0xff, 0, display);
  RS_Pset16(s_pac.x*2, s_pac.y*2+1, 0xff, 0xff, 0, display);
  RS_Pset16(s_pac.x*2+1, s_pac.y*2+1, 0xff, 0xff, 0, display);

  for(x=0; x<4; x++) {
    RS_Pset16(s_ghost[x].x*2, s_ghost[x].y*2, 0, 0, 0xff, display);
    RS_Pset16(s_ghost[x].x*2+1, s_ghost[x].y*2, 0, 0, 0xff, display);
    RS_Pset16(s_ghost[x].x*2, s_ghost[x].y*2+1, 0, 0, 0xff, display);
    RS_Pset16(s_ghost[x].x*2+1, s_ghost[x].y*2+1, 0, 0, 0xff, display);
  }

  dst.x=0;
  dst.y=0;
  dst.w=64;
  dst.h=64;
  SDL_BlitSurface(display, NULL, screen, &dst);

  for(i=0; i<s_pac.lives; i++) {
    dst.x=640-64*i-64;
    dst.y=0;
    dst.w=64;
    dst.h=64;
    SDL_BlitSurface(live, NULL, screen, &dst);
  }

  dst=blit_score(s_pac.score);
}



void handle_ghost(void) {
  int i, t;
  for(i=0; i<4; i++) {
    s_ghost[i].count2++;
    switch(s_ghost[i].state) {

    case(DEAD): 
      //s_ghost[i].counter--;
      if(s_ghost[i].counter==0)
	s_ghost[i].state=SPAWN;	 
      break;
    case(SPAWN):
      s_ghost[i].y-=2;
      s_ghost[i].state=ATTACK;
    break;
    case(ATTACK):
      switch(s_ghost[i].dir) {
      case(0):
	if(s_ghost[i].x<32) {
	  if(grid[s_ghost[i].x+1][s_ghost[i].y]<3) { 	  
	    s_ghost[i].x++;
	  }	  
	  else {
	    s_ghost[i].dir=2;
	  }	  
	}
	else 
	  s_ghost[i].x=0;
	break;
      case(1):
	if(s_ghost[i].y>0) {
	  if(grid[s_ghost[i].x][s_ghost[i].y-1]<3) {
	    s_ghost[i].y--;
	  }
	  else {
	    s_ghost[i].dir=3;
	  }
	}
	else
	  s_ghost[i].y=31;
	break;
      case(2):
	if(s_ghost[i].x>0) {
	  if(grid[s_ghost[i].x-1][s_ghost[i].y]<3) {
	    s_ghost[i].x--;
	  }
	  else {
	    s_ghost[i].dir=0;
	  }
	}
	else
	  s_ghost[i].x = 31;
	break;
      case(3):
	if(s_ghost[i].y<31) {
	  if(grid[s_ghost[i].x][s_ghost[i].y+1]<3) {
	    s_ghost[i].y++;
	  }
	  else {
	    s_ghost[i].dir=1;
	  }
	}
	else
	  s_ghost[i].y=0;
	break;
      }      
      break;
    }    
    // Do line of sight check here and decide if ghost wants to change direction
      switch(s_ghost[i].dir) {
      case(0):
      case(2):
	t=0;
	while(s_ghost[i].y-t>0) {
	  t++;
	  if(grid[s_ghost[i].x][s_ghost[i].y-t]<3) {
	    if((s_pac.x==s_ghost[i].x)&&(s_pac.y==s_ghost[i].y-t)) {
	      if(!(rand()%2)) s_ghost[i].dir=1;
	    }
	  }
	  else {
	    if(grid[s_ghost[i].x][s_ghost[i].y-1]<3) {
	      if(!(rand()%4)) 
	      s_ghost[i].dir=1;
	    }
	    t=1000;
	  }
	}
	t=0;
	while(s_ghost[i].y+t<(32)) {
	  t++;
	  if(grid[s_ghost[i].x][s_ghost[i].y+t]<3) {
	    if((s_pac.x==s_ghost[i].x)&&(s_pac.y==s_ghost[i].y+t)) {
	      if(!(rand()%2)) s_ghost[i].dir=3;
	    }
	  }
	  else {
	    if(grid[s_ghost[i].x][s_ghost[i].y+1]<3) {
	      if(!(rand()%4)) s_ghost[i].dir=3;
	    }
	    t=1000;
	  }
	}
	break;
      case(1):
      case(3):
	t=0;
	while(s_ghost[i].x-t>0) {
	  t++;
	  if(grid[s_ghost[i].x-t][s_ghost[i].y]<3) {
	    if((s_pac.x==s_ghost[i].x-t)&&(s_pac.y==s_ghost[i].y)) {
	      if(!(rand()%2)) s_ghost[i].dir=2;
	    }
	  }
	  else {
	    if(grid[s_ghost[i].x-1][s_ghost[i].y]<3) {
	      if(!(rand()%4)) 
	      s_ghost[i].dir=2;
	    }
	    t=1000;
	  }
	}
	t=0;
	while(s_ghost[i].x+t<(32)) {
	  t++;
	  if(grid[s_ghost[i].x+t][s_ghost[i].y]<3) {
	    if((s_pac.x==s_ghost[i].x+t)&&(s_pac.y==s_ghost[i].y)) {
	      if(!(rand()%2)) 
	      s_ghost[i].dir=0;
	    }
	  }
	  else {
	    if(grid[s_ghost[i].x+1][s_ghost[i].y]<3) {
	      if(!(rand()%4)) s_ghost[i].dir=0;
	    }
	    t=1000;
	  }
	}
	break;
      }
    }
}



SDL_Rect blit_score(long score) {
  SDL_Rect t_rect;
  int t=1, t_score=score, i;

  while(t_score>=10) {
    t++;
    t_score=(t_score-(t_score%10))/10;
  }

  t_score=score;
  for(i=0; i<t; i++) {
    t_rect.x=(32*t)-(32*i)-32;
    t_rect.y=480-32;
    t_rect.w=32;
    t_rect.h=32;
    SDL_BlitSurface(numbers[t_score%10], NULL, screen, &t_rect);
    t_score=(t_score-(t_score%10))/10;
  }

  t_rect.x=0;
  t_rect.y=480-32;
  t_rect.w=32*t;
  t_rect.h=32;
  SDL_BlitSurface(numbers[0], NULL, screen, &t_rect);
  return(t_rect);
}

void show_end_credits(void);

int title_screen(void) {
  SDL_Event event; 
  Uint8 *keys; 
  Uint8 done=0;
  int frames=0;
  SDL_Rect rects[3];
  int x, y;


  SDL_ShowCursor(1);

  while (!done) {
    while ( SDL_PollEvent(&event) ) {
      if ( event.type == SDL_QUIT )
	return(QUIT);
      }
 
    keys = SDL_GetKeyState(NULL); 
    SDL_GetMouseState(&x, &y);  

    if(keys[SDLK_ESCAPE] == SDL_PRESSED ) {
      done=1;
    }
    if(keys[SDLK_SPACE] == SDL_PRESSED ) {
      done=1;
    }

    if(keys[SDLK_RETURN] == SDL_PRESSED ) {
      SDL_SaveBMP(screen, "ss.bmp");
    }

    if ( event.type == SDL_MOUSEBUTTONDOWN ) {
      if((x>320-128)&&(x<320+128)&&(y>480-120)&&(y<480-40)) {
	done=1;
      }
    }


    ClearScreen(screen);

    rects[0].x=0;
    rects[0].y=0;
    rects[0].w=640;
    rects[0].h=120;
    SDL_BlitSurface(logo,NULL,screen,&rects[0]);

    rects[1].x=320-32;
    rects[1].y=240-32;
    rects[1].w=64;
    rects[1].h=64;
    SDL_BlitSurface(pac[0][frames%16],NULL,screen,&rects[1]);

    rects[2].x=320-128;
    rects[2].y=480-120;
    rects[2].w=256;
    rects[2].h=80;
    SDL_BlitSurface(start,NULL,screen,&rects[2]);

    SDL_UpdateRects(screen, 3, rects);

    frames++;
  }

  SDL_ShowCursor(0);
  ClearScreen(screen);
  SDL_UpdateRect(screen, 0,0,0,0);
  return(NEW_GAME);
}

void wait_till_ready(void) {
  //puts ready message on screen and counts down
  SDL_Surface *bgsave;
  SDL_Rect src,dst;
  int countdown=3;

  bgsave=SDL_CreateRGBSurface(SDL_SWSURFACE,32,32,16,
			      screen->format->Rmask,
			      screen->format->Gmask,
			      screen->format->Bmask,
			      screen->format->Amask);
 
  src.x=320-16;
  src.y=240-16;
  src.w=32;
  src.h=32;

  SDL_BlitSurface(screen, &src, bgsave, NULL);
  SDL_UpdateRect(bgsave, 0,0,0,0);
  dst.x=320-16;
  dst.y=240-16;
  dst.w=32;
  dst.h=32;

  while(countdown>0) {

#if defined(PLAY_MOD)
    Mix_PlayChannel(1,bell, 0);
#endif

    SDL_BlitSurface(bgsave, NULL, screen, &dst);
    SDL_UpdateRects(screen, 1,&dst);
    SDL_BlitSurface(numbers[countdown], NULL, screen, &dst);
    SDL_UpdateRects(screen, 1,&dst);
    SDL_Delay(1000);
    countdown--;
  }

#if defined(PLAY_MOD)
  Mix_PlayChannel(1,sounds, 0);
#endif

  SDL_BlitSurface(bgsave, NULL, screen, &dst);
  SDL_UpdateRects(screen, 1, &dst);
}

void show_end_credits(void) {
}



int do_continue(void) {
  int choice=NEW_GAME;
  SDL_Event event; 
  Uint8 *keys; 
  Uint8 done=0;
  int frames=0;
  SDL_Rect rects[4];
  int x,y;
  

  SDL_ShowCursor(1);
  ClearScreen(screen);
  SDL_UpdateRect(screen, 0,0,0,0);

  while (!done) {
    while ( SDL_PollEvent(&event) ) {
      if ( event.type == SDL_QUIT )
	return(QUIT);
      }
 
    keys = SDL_GetKeyState(NULL); 
    SDL_GetMouseState(&x, &y);  

    if(keys[SDLK_UP]==SDL_PRESSED || 
       keys[SDLK_DOWN]==SDL_PRESSED) {
      if(choice==NEW_GAME) choice=QUIT;
      else choice=NEW_GAME;
    }

    if(keys[SDLK_ESCAPE] == SDL_PRESSED ) {
      done=1;
      choice=QUIT;
    }
    if(keys[SDLK_SPACE] == SDL_PRESSED ) {
      done=1;
      s_pac.lives=3;
      s_pac.score=s_pac.score/2;
      choice=NEW_GAME;
    }

    if ( event.type == SDL_MOUSEBUTTONDOWN ) {
      if((x>320)&&(x<360+120)&&(y>120)&&(y<120+40)) {
	choice=NEW_GAME;
	done=1;
      }
      if((x>320)&&(x<360+120)&&(y>160)&&(y<160+40)) {
	choice=QUIT;
	done=1;
      }
    }

    rects[0].x=200;
    rects[0].y=60;
    rects[0].w=240;
    rects[0].h=40;
    SDL_BlitSurface(cont,NULL,screen,&rects[0]);

    if(choice==NEW_GAME)
      rects[1].x=320;
    else
      rects[1].x=360;

    rects[1].y=120;
    rects[1].w=120;
    rects[1].h=40;
    SDL_BlitSurface(yes,NULL,screen,&rects[1]);

    if(choice==QUIT)
      rects[2].x=320;
    else
      rects[2].x=360;

    rects[2].y=160;
    rects[2].w=120;
    rects[2].h=40;
    SDL_BlitSurface(no,NULL,screen,&rects[2]);

    SDL_UpdateRect(screen,0,0,0,0);
    ClearScreen(screen);

    frames++;
  }

  ClearScreen(screen);
  SDL_UpdateRect(screen, 0,0,0,0);

  SDL_ShowCursor(0);

  return(choice);
}

int run_game(char *level) {
  Uint32 i;
  SDL_Event event; 
  Uint8 *keys; 
  Uint8 done=0;
  int frames=0;
  int fd=1;
  int pellets=0;
  int restart_level=0;
  int return_value=NEW_GAME;
  Uint32 tick;

  pellets=load_map(level);
	
  s_pac.x=15; s_pac.y=17; s_pac.dir=0; s_pac.newdir=s_pac.dir;

  for(i=0; i<4; i++) {
    s_ghost[i].x=14+i; 
    s_ghost[i].y=15;
    s_ghost[i].dir=3; 
    s_ghost[i].newdir=s_ghost[i].newdir;
    s_ghost[i].state=DEAD; 
    s_ghost[i].counter=i*3+3;
    s_ghost[i].lives=-1;
  }
  
  
#if defined(PLAY_MOD)
  music = Mix_LoadMUS(musics[cur_level%2]);
#endif

  ClearScreen(screen);

  draw_map(s_pac.x, s_pac.y);
  draw_display();
  SDL_UpdateRect(screen,0,0,0,0);

#if defined(PLAY_MOD)
  Mix_PlayMusic(music,0);
#endif

  wait_till_ready();

  tick = SDL_GetTicks(); 
  
  while (!done) {
    if(restart_level) {
      restart_level=0;
      for(i=0; i<4; i++) {
	s_ghost[i].x=14+i;
	s_ghost[i].y=15;
	s_ghost[i].state=DEAD;
	s_ghost[i].counter=i*3+3;
	s_ghost[i].dir=3;

	s_pac.x=15;
	s_pac.y=17;
	s_pac.dir=0;
      }
     
      ClearScreen(screen);
      draw_map(s_pac.x, s_pac.y);
      draw_display();
      SDL_UpdateRect(screen,0,0,0,0);
      wait_till_ready();
    }
    
    while ( SDL_PollEvent(&event) ) {
      if ( event.type == SDL_QUIT )
	return(QUIT);
      }
 
    keys = SDL_GetKeyState(NULL); 

    if(keys[SDLK_SPACE] == SDL_PRESSED ) {
      // This will be the pause button
    }

    if(keys[SDLK_RETURN] == SDL_PRESSED ) {
      SDL_SaveBMP(screen, "ss.bmp");
    }
 
    if(keys[SDLK_ESCAPE] == SDL_PRESSED ) { 
      return_value=QUIT;
      done=1; 
    }

    if(keys[SDLK_LEFT] == SDL_PRESSED ) {
      s_pac.newdir=2;
    }			 

    if(keys[SDLK_RIGHT] == SDL_PRESSED ) {
      s_pac.newdir=0;
    }

    if(keys[SDLK_UP] == SDL_PRESSED ) {
      s_pac.newdir=1;
    }			 
			 
    if(keys[SDLK_DOWN] == SDL_PRESSED ) {
      s_pac.newdir=3;
    }

    s_pac.dir=s_pac.newdir;	
    switch(s_pac.dir) {
    case(0):
      if(s_pac.x==31) s_pac.x++;
      else
	if(grid[s_pac.x+1][s_pac.y]<3) s_pac.x+=1;
      break;
    case(2):
      if(s_pac.x==0) s_pac.x--;
      else
	if(grid[s_pac.x-1][s_pac.y]<3) s_pac.x-=1;
      break;
    case(1):
      if(s_pac.y==0) s_pac.y--;
      else
	if(grid[s_pac.x][s_pac.y-1]<3) s_pac.y-=1;
      break;
    case(3):
      if(s_pac.y==31) s_pac.y++;
      else
	if(grid[s_pac.x][s_pac.y+1]<3) s_pac.y+=1;
      break;
    }

    if(s_pac.x==-1) s_pac.x=31;
    if(s_pac.x==32) s_pac.x=0;
    if(s_pac.y==-1) s_pac.y=31;
    if(s_pac.y==32) s_pac.y=0;

    handle_ghost();		

    if(SDL_GetTicks()>(tick+1000)) {
      for(i=0; i<4; i++) {
	if(s_ghost[i].counter>0) s_ghost[i].counter--;
      }
      tick=SDL_GetTicks();
    }

    for(i=0; i<4; i++) {

      if((s_pac.x==s_ghost[i].x)&&(s_pac.y==s_ghost[i].y)) {
	if(!restart_level) {
	  if(s_pac.counter==0) {
	    s_pac.lives--;

#if defined(PLAY_MOD)
	    Mix_PlayChannel(1,scream, 0);
#endif
	    
	    SDL_Delay(1000);
	    if(s_pac.lives==0) {
	      done=1;
	      return_value=CONTINUE;
	    }
	    else {
	      restart_level=1;			
	    }
	  }
	}
	else {
	  s_ghost[i].x=13+i;
	  s_ghost[i].y=15;
	  s_ghost[i].state=DEAD;
	  s_ghost[i].counter=5;
	}
      }
    }		

    
    if(grid[s_pac.x][s_pac.y]==1) {
      grid[s_pac.x][s_pac.y]--;
      pellets--;
      s_pac.score+=10;
#if defined(PLAY_MOD)
      Mix_PlayChannel(1,sounds, 0);
#endif
    }

    if(s_pac.counter>0) s_pac.counter--;
    
    if(grid[s_pac.x][s_pac.y]==2) {
      grid[s_pac.x][s_pac.y]=0;
      s_pac.score+=50;
      s_pac.counter=5;
#if defined(PLAY_MOD)
      Mix_PlayChannel(2,choir, 0);
#endif
    }


    //Ghost float code
    f=f+fd;
    if(f>=4)fd=-1;
    if(f<=-4)fd=1;
    
    if(!restart_level) {
      ClearScreen(screen);
      
      draw_map(s_pac.x, s_pac.y);
      draw_display();
      
      SDL_UpdateRect(screen, 0,0,0,0);
    }
    
#if defined(PLAY_MOD)
    if ( ! Mix_PlayingMusic() ) {
      Mix_PlayMusic(music,0);
    }
#endif
		
    frames++;
    s_pac.frame++;
		
    if(pellets==0) {
      done=1;
      return_value=LEVEL_CLEAR;
      RS_Blit(clear, screen, 320-128, 200);
      SDL_UpdateRect(screen, 0,0,0,0);
      SDL_Delay(3000);
    }
  }
#if defined(PLAY_MOD)
  Mix_FreeMusic(music);
#endif
  return(return_value);
}


int parse_options(int argc, char *argv[]) {
  int i, returnvalue=SHOW_TITLE;

  for(i=1; i<argc; i++) {
    if(!strcmp(argv[i], "--fullscreen")) fullscreenflag=1;    

    if(!strcmp(argv[i], "-l")) {
      custom=i+1;
      returnvalue=CUSTOM;
    }
    
    
  }

  return(returnvalue);
}














int main(int argc, char *argv[])
{
  int game_type=NEW_GAME;

  /* Initialize the SDL library */
  if ( SDL_Init(SDL_INIT_VIDEO|SDL_INIT_AUDIO) < 0 ) {
    fprintf(stderr, "Couldn't initialize SDL: %s\n",SDL_GetError());
    return(1);
  }
  

#if defined(PLAY_MOD)
  /* Open the audio device Here if Using Audio */
  /* Open the audio device */
  if ( Mix_OpenAudio(22050, AUDIO_S16, 1, 512) < 0 ) {
    fprintf(stderr,
	    "Warning: Couldn't set 22050 Hz 16-bit audio\n- Reason: %s\n",
							SDL_GetError());
  }
#endif

  atexit(SDL_Quit);


  s_pac.lives=3;
  s_pac.score=0;

  game_type=parse_options(argc, argv);

  /* Open the display device */
  if(fullscreenflag) {
    screen = SDL_SetVideoMode(640, 480, 16, SDL_FULLSCREEN);   
  }
  else {
    screen = SDL_SetVideoMode(640, 480, 16, SDL_HWSURFACE);
  }		

  if ( screen == NULL ) {
    fprintf(stderr, "Couldn't set video mode: %s\n",
	    SDL_GetError());
    return(1);
  }

  load_data();

  // Get rid of the Mouse Pointer 
  SDL_ShowCursor(0);

  /* Initialize the random number generator */
  srand(time(NULL));
	




  while(game_type!=QUIT) {
    if(game_type==CUSTOM) {
      while(game_type!=QUIT) {
	game_type=run_game(argv[custom]);
      }
    }

    if(game_type==NEW_GAME) game_type = run_game(levels[cur_level%3]);

    if(game_type==CONTINUE) game_type = do_continue();
    if(game_type==LEVEL_CLEAR) { 
      cur_level++;
      game_type=NEW_GAME;
    }
    if(game_type==END_GAME) show_end_credits();
    if(game_type==SHOW_TITLE) game_type = title_screen();
  }

  free_data();

  /* Quit */

  /* Close Audio Here If Opened */
#if defined(PLAY_MOD)
	Mix_CloseAudio();
#endif
  return(0);
}








