/*  Glimmer - gnomegotoline.c
 *
 *  This library is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Library General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "gnomegotoline.h"

/* function declarations */
static void gnome_goto_line_dialog_class_init (GnomeGotoLineDialogClass *
                                               klass);
static void gnome_goto_line_dialog_init (GnomeGotoLineDialog * gtl);
GtkWidget *gnome_goto_line_dialog_new (void);
static void gnome_goto_line_dialog_destroy (GtkObject * object);
static gboolean check_glist_for_multiple_entries (GList * list,
                                                  gchar * new_entry);
static void kill_combo_history (GList * list);
static void click_button (GtkWidget * entry, GtkWidget * button);
static void check_enable_button (GtkWidget * entry, GtkWidget * button);

/* end function declarations */

static GtkWindowClass *parent_class = NULL;

GtkType
gnome_goto_line_dialog_get_type (void)
{
    static GtkType goto_line_type = 0;

    if (!goto_line_type) {
        static const GtkTypeInfo goto_line_info = {
            "GnomeGotoLineDialog",
            sizeof (GnomeGotoLineDialog),
            sizeof (GnomeGotoLineDialogClass),
            (GtkClassInitFunc) gnome_goto_line_dialog_class_init,
            (GtkObjectInitFunc) gnome_goto_line_dialog_init,
            NULL,
            NULL,
            (GtkClassInitFunc) NULL,
        };

        goto_line_type = gtk_type_unique (GTK_TYPE_WINDOW, &goto_line_info);
    }
    return (goto_line_type);
}

static void
gnome_goto_line_dialog_class_init (GnomeGotoLineDialogClass * klass)
{
    GtkObjectClass *object_class;

    object_class = (GtkObjectClass *) klass;
    parent_class = gtk_type_class (GTK_TYPE_WINDOW);
    object_class->destroy = gnome_goto_line_dialog_destroy;
}

static void
gnome_goto_line_dialog_init (GnomeGotoLineDialog * gtl)
{
    gtl->history = NULL;
}

GtkWidget *
gnome_goto_line_dialog_new ()
{
    GnomeGotoLineDialog *gtl;
    GtkWidget *main_box;
    GtkWidget *util_box;
    GtkWidget *label;
    GtkWidget *hsep;

    gtl = gtk_type_new (GNOME_TYPE_GOTO_LINE_DIALOG);
    gtk_container_set_border_width (GTK_CONTAINER (gtl), 5);
    gtk_window_set_title (GTK_WINDOW (gtl), "Goto Line...");

    main_box = gtk_vbox_new (FALSE, 0);
    gtk_container_add (GTK_CONTAINER (gtl), main_box);
    gtk_widget_show (main_box);

    util_box = gtk_hbox_new (FALSE, 0);
    gtk_box_pack_start (GTK_BOX (main_box), util_box, TRUE, TRUE, 0);
    gtk_widget_show (util_box);

    label = gtk_label_new ("Line #: ");
    gtk_box_pack_start (GTK_BOX (util_box), label, FALSE, FALSE, 0);
    gtk_widget_show (label);

    gtl->combo = gtk_combo_new ();
    gtl->line_entry = GTK_COMBO (gtl->combo)->entry;
    gtk_combo_disable_activate (GTK_COMBO (gtl->combo));
    gtk_box_pack_start (GTK_BOX (util_box), gtl->combo, TRUE, TRUE, 0);
    gtk_widget_show (gtl->combo);

    gtl->check_stay_open =
        gtk_check_button_new_with_label ("Keep window open?");
    gtk_box_pack_start (GTK_BOX (main_box), gtl->check_stay_open, FALSE, TRUE,
                        0);
    gtk_widget_show (gtl->check_stay_open);

    hsep = gtk_hseparator_new ();
    gtk_box_pack_start (GTK_BOX (main_box), hsep, TRUE, TRUE, 10);
    gtk_widget_show (hsep);

    util_box = gtk_hbutton_box_new ();
    gtk_box_pack_start (GTK_BOX (main_box), util_box, TRUE, TRUE, 0);
    gtk_button_box_set_layout (GTK_BUTTON_BOX (util_box),
                               gnome_preferences_get_button_layout ());
    gtk_button_box_set_spacing (GTK_BUTTON_BOX (util_box), GNOME_PAD);
    gtk_widget_show (util_box);

    gtl->goto_button =
        gnome_pixmap_button (gnome_stock_pixmap_widget_at_size
                             (GTK_WIDGET (gtl), GNOME_STOCK_PIXMAP_SEARCH, 20,
                              20), "Goto Line");
    gtk_box_pack_start (GTK_BOX (util_box), gtl->goto_button, FALSE, FALSE, 5);
    gtk_widget_show (gtl->goto_button);
    gtk_signal_connect (GTK_OBJECT (gtl->line_entry), "changed",
                        GTK_SIGNAL_FUNC (check_enable_button),
                        (gpointer) gtl->goto_button);
    gtk_signal_connect (GTK_OBJECT (gtl->line_entry), "activate",
                        GTK_SIGNAL_FUNC (click_button),
                        (gpointer) gtl->goto_button);
    GTK_WIDGET_SET_FLAGS (gtl->goto_button, GTK_CAN_DEFAULT);
    gtk_window_set_default (GTK_WINDOW (gtl), gtl->goto_button);
    gtk_widget_set_sensitive (gtl->goto_button, FALSE);

    gtl->cancel_button = gnome_stock_button (GNOME_STOCK_BUTTON_CANCEL);
    gtk_box_pack_start (GTK_BOX (util_box), gtl->cancel_button, FALSE, FALSE,
                        5);
    GTK_WIDGET_SET_FLAGS (gtl->cancel_button, GTK_CAN_DEFAULT);
    gtk_widget_show (gtl->cancel_button);

    return GTK_WIDGET (gtl);
}

static void
gnome_goto_line_dialog_destroy (GtkObject * object)
{
    GtkWidget *gtl;

    g_return_if_fail (object != NULL);
    g_return_if_fail (GNOME_IS_GOTO_LINE_DIALOG (object));
    gtl = GTK_WIDGET (object);
    if (GNOME_GOTO_LINE_DIALOG (gtl)->history)
        kill_combo_history (GNOME_GOTO_LINE_DIALOG (gtl)->history);
    gtk_widget_destroy (gtl);
}

gint
gnome_goto_line_dialog_get_line (GnomeGotoLineDialog * gtl)
{
    gint line_num;
    gchar *line_txt;

    g_return_val_if_fail (gtl != NULL, -1);
    g_return_val_if_fail (GNOME_IS_GOTO_LINE_DIALOG (gtl), -1);

    line_txt = gtk_entry_get_text (GTK_ENTRY (gtl->line_entry));
    if (!strlen (line_txt))
        return (-1);
    if (!sscanf (line_txt, "%d", &line_num))
        return (-1);
    if (line_num < 1)
        return (-1);
    return (line_num - 1);
}

void
gnome_goto_line_dialog_set_history (GnomeGotoLineDialog * gtl, GList * history)
{
    g_return_if_fail (gtl != NULL);
    g_return_if_fail (GNOME_IS_GOTO_LINE_DIALOG (gtl));
    if (history == NULL)
        return;
    gtl->history = history;
    gtk_combo_set_popdown_strings (GTK_COMBO (gtl->combo), gtl->history);
    gtk_entry_set_text (GTK_ENTRY (gtl->line_entry), "");
}

gboolean
gnome_goto_line_dialog_add_search_string (GnomeGotoLineDialog * gtl,
                                          gchar * string)
{
    gpointer temp;

    g_return_val_if_fail (gtl != NULL, FALSE);
    g_return_val_if_fail (GNOME_IS_GOTO_LINE_DIALOG (gtl), FALSE);
    if (check_glist_for_multiple_entries (gtl->history, string))
        return (FALSE);
    temp = g_new (char, strlen (string) + 1);
    strcpy ((gchar *) temp, string);
    gtl->history = g_list_prepend (gtl->history, temp);
    gtk_combo_set_popdown_strings (GTK_COMBO (gtl->combo), gtl->history);
    return (TRUE);
}

static gboolean
check_glist_for_multiple_entries (GList * list, gchar * new_entry)
{
    GList *temp;
    gchar *cmp_text;

    if (list == NULL)
        return (FALSE);
    temp = list;
    while (temp != NULL) {
        cmp_text = temp->data;
        if (!strcmp (cmp_text, new_entry)) {
            return (TRUE);
        }
        temp = g_list_next (temp);
    }
    return (FALSE);
}

static void
kill_combo_history (GList * list)
{
    GList *temp;

    if (list == NULL)
        return;

    temp = list;
    while (temp != NULL) {
        g_free (temp->data);
        temp = g_list_next (temp);
    }
    g_list_free (list);
}

static void
click_button (GtkWidget * entry, GtkWidget * button)
{
    gtk_signal_emit_by_name (GTK_OBJECT (button), "clicked", NULL);
}

static void
check_enable_button (GtkWidget * entry, GtkWidget * button)
{
    gchar *text;
    gint line_num;
    gboolean sensitive = FALSE;

    text = gtk_entry_get_text (GTK_ENTRY (entry));
    if (text && strlen (text) > 0 && sscanf (text, "%d", &line_num))
        sensitive = TRUE;
    gtk_widget_set_sensitive (button, sensitive);
}
