/*  Glimmer - gnome-vfs-remote-dialog.h
 *
 *  This library is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Library General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <gnome.h>
#include <libgnomevfs/gnome-vfs-types.h>
#include <libgnomevfs/gnome-vfs-uri.h>

#ifndef _GNOME_VFS_REMOTE_DIALOG_H_
#define _GNOME_VFS_REMOTE_DIALOG_H_

#ifdef __cplusplus
extern "C" {
#endif

#define GNOME_TYPE_VFS_REMOTE_DIALOG (gnome_vfs_remote_dialog_get_type())
#define GNOME_VFS_REMOTE_DIALOG(obj) (GTK_CHECK_CAST ((obj), GNOME_TYPE_VFS_REMOTE_DIALOG, GnomeVFSRemoteDialog))
#define GNOME_VFS_REMOTE_DIALOG_CLASS(klass) (GTK_CHECK_CLASS_CAST((klass), GNOME_TYPE_VFS_REMOTE_DIALOG, GnomeVFSRemoteDialogClass))
#define GNOME_IS_VFS_REMOTE_DIALOG(obj) (GTK_CHECK_TYPE((obj), GNOME_TYPE_VFS_REMOTE_DIALOG))
#define GNOME_IS_VFS_REMOTE_DIALOG_CLASS(klass) (GTK_CHECK_CLASS_TYPE((klass), GNOME_TYPE_VFS_REMOTE_DIALOG))

typedef struct _GnomeVFSRemoteDialog GnomeVFSRemoteDialog;
typedef struct _GnomeVFSRemoteDialogClass GnomeVFSRemoteDialogClass;

struct _GnomeVFSRemoteDialog {
    GtkWindow window;
    GtkWidget *history;
    GtkWidget *host_entry;
    GtkWidget *port_entry;
    GtkWidget *path_entry;
    GtkWidget *username_entry;
    GtkWidget *password_entry;
    GtkWidget *save_pass;
    GtkWidget *ok_button;
    GtkWidget *cancel_button;
    GList *history_list;
};

struct _GnomeVFSRemoteDialogClass {
    GtkWindowClass parent_class;
};

GtkType gnome_vfs_remote_dialog_get_type(void);

GtkWidget *gnome_vfs_remote_dialog_new(gchar *title, GList *history);
gboolean gnome_vfs_remote_dialog_add_history_string(GnomeVFSRemoteDialog *dialog, gchar *string);

gchar *gnome_vfs_remote_dialog_get_host(GnomeVFSRemoteDialog *dialog);
gint gnome_vfs_remote_dialog_get_port(GnomeVFSRemoteDialog *dialog);
gchar *gnome_vfs_remote_dialog_get_path(GnomeVFSRemoteDialog *dialog);
gchar *gnome_vfs_remote_dialog_get_username(GnomeVFSRemoteDialog *dialog);
gchar *gnome_vfs_remote_dialog_get_pasword(GnomeVFSRemoteDialog *dialog);
GnomeVFSURI* gnome_vfs_remote_dialog_get_uri(GnomeVFSRemoteDialog *dialog);

gboolean gnome_vfs_remote_dialog_save_pass(GnomeVFSRemoteDialog *dialog);

#ifdef __cplusplus /* cpp compatibility */
}
#endif

#endif
