/*  Glimmer - gdsmanpage.h
 *
 *  This library is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Library General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <stdio.h>
#include <gnome.h>
#include <dirent.h>
#include <sys/stat.h>
#include <unistd.h>

#ifndef _GDS_MANPAGE_H_
#define _GDS_MANPAGE_H_

#ifdef __cplusplus
extern "C" {
#endif

#define GDS_TYPE_MANPAGE (gds_manpage_get_type())
#define GDS_MANPAGE(obj) (GTK_CHECK_CAST ((obj), GDS_TYPE_MANPAGE, GdsManpage))
#define GDS_MANPAGE_CLASS(klass) (GTK_CHECK_CLASS_CAST((klass), GDS_TYPE_MANPAGE, GdsManpageClass))
#define GDS_IS_MANPAGE(obj) (GTK_CHECK_TYPE((obj), GDS_TYPE_MANPAGE))
#define GDS_IS_MANPAGE_CLASS(klass) (GTK_CHECK_CLASS_TYPE((klass), GDS_TYPE_MANPAGE))

typedef struct _GdsManpage GdsManpage;
typedef struct _GdsManpageClass GdsManpageClass;

struct _GdsManpage {
   GtkWindow top_level;
   GtkWidget *extext;
   GtkWidget *search_combo;
   GtkWidget *search_button;
   GtkWidget *close_button;
   GList *history;
};

struct _GdsManpageClass {
   GtkWindowClass parent_class;
};

GtkType gds_manpage_get_type(void);

GtkWidget *gds_manpage_new(void);

gboolean gds_manpage_change_page(GdsManpage *gds_manpage, gchar *manpage);

void gds_manpage_set_search_string(GdsManpage *gmp, gchar *string);
void gds_manpage_set_history(GdsManpage *gmp, GList *history);
gboolean gds_manpage_add_search_string(GdsManpage *gmp, gchar *string);

#ifdef __cplusplus /* cpp compatibility */
}
#endif
#endif
