/*  Glimmer - file-io.h
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef FILE_IO_H
#define FILE_IO_H

#ifdef __cplusplus
extern "C" {
#endif

#include <libgnomevfs/gnome-vfs-types.h>
#include <libgnomevfs/gnome-vfs-uri.h>

#include "declarations.h"
#include "widgets/gdsfile.h"
#include "widgets/gnome-file-selector.h"

void new_file_real (gchar * filename);
void new_file_cb (GtkWidget * widget, gpointer data);
void open_file_cb (GtkWidget * widget, gpointer data);
void open_file_cb_continue (GtkWidget * widget,
                            GnomeFileSelector * file_selector);
void open_file_error_cb (GtkWidget * widget, gchar * filename);
void open_file_real (gchar * filename);
void revert_file_cb (GtkWidget * widget, gpointer data);
void save_file_cb (GtkWidget * widget, gpointer data);
void save_file_error_cb (GtkWidget * widget, GdsFile * file);
void save_file_real (GdsFile * gds_file);
void save_file_as_cb (GtkWidget * widget, gpointer data);
void save_file_as_continue (GtkWidget * widget,
                            GnomeFileSelector * file_selector);
void save_file_as_error_cb (GtkWidget * widget, gchar * filename);
void save_file_as_real (GdsFile * gds_file, gchar * filename);
void save_all_files_cb (GtkWidget * widget, gpointer data);
void reload_file_cb (GtkWidget * widget, GdsFile * gds_file);
void save_file_or_dialog (GdsFile * gds_file);
void close_file_cb (GtkWidget * widget, gpointer data);
void close_file_error_cb (GtkWidget * widget, GdsFile * file);
void close_file_real (GdsFile * file);
void close_all_files_cb (GtkWidget * widget, gpointer data);
gboolean save_file_full (GdsFile * gds_file, GnomeVFSURI * uri);
gboolean open_file_full (GdsFile * gds_file, GnomeVFSURI * uri);
gboolean check_if_dir_exists (gchar * path);
gboolean check_if_file_exists (gchar * filename);
gboolean check_if_file_can_exist (gchar * filename);
gboolean check_if_read_only (GdsFile * gds_file, GnomeVFSURI * uri);
void file_create (GtkWidget * widget, gchar * filename);
gboolean create_file (gchar * filename);
gint get_modification_time (GnomeVFSURI * uri);
gboolean check_path_is_local (gchar * path);
gchar *gnome_vfs_uri_get_host_path (GnomeVFSURI * uri);
gboolean gds_file_is_untitled (GdsFile * file);
void save_file_directory_history (void);
void load_file_directory_history (void);

extern gchar *last_dir;
extern GList *recent_files;
extern GList *directory_history;

#ifdef __cplusplus
}
#endif
#endif
