/* GKrellMSS - GKrellM Sound Scope
|  Copyright (C) 2002 Bill Wilson
|
|  Author:  Bill Wilson    bill@gkrellm.net
|
|  This program is free software which I release under the GNU General Public
|  License. You may redistribute and/or modify this program under the terms
|  of that license as published by the Free Software Foundation; either
|  version 2 of the License, or (at your option) any later version.
|
|  This program is distributed in the hope that it will be useful,
|  but WITHOUT ANY WARRANTY; without even the implied warranty of
|  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
|  GNU General Public License for more details.
| 
|  To get a copy of the GNU General Puplic License, write to the Free Software
|  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <esd.h>

/* The format of the esd data to monitor.  STEREO is interleaved channels */
#define SOUND_FORMAT (ESD_BITS16 | ESD_STEREO | ESD_STREAM | ESD_PLAY)

static void
sound_input_read(gpointer data, gint source, GdkInputCondition condition)
	{
	gint	count;

	count = read(source, gkrellmss->buffer,
					gkrellmss->buf_len * sizeof(SoundSample));
	if (count > 0)
		process_sound_samples(count);
	else
		gkrellmss_sound_close_stream();
	}

void
gkrellmss_sound_open_stream(gchar *host)
	{
	gkrellmss->fd = esd_monitor_stream(SOUND_FORMAT, SAMPLE_RATE, host,
						"gkrellmss");
	if (gkrellmss->fd < 0)
		{
		gkrellmss->stream_open = FALSE;
		gkrellmss_sound_close_stream();
		return;
		}
	gkrellmss->stream_open = TRUE;
	gkrellmss->input_id = gdk_input_add(gkrellmss->fd, GDK_INPUT_READ,
						(GdkInputFunction) sound_input_read, NULL);
	}

void
gkrellmss_sound_close_stream(void)
	{
	if (gkrellmss->fd >= 0)
		esd_close(gkrellmss->fd);
	reset_sound_data();
	}
